// ---------------------------------------------------------------------------
// fire.cs -- Version 1.2 -- May 5, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\fire.cs", "1.2", "Lorne Laliberte", "- May 5, 1999 - adds fire button events - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");

function onFireButton()
{
    // Protect against mad-firing on respawn?
    postAction(2048, IDACTION_BREAK1, -0); 

    %weapon = getMountedItem(0);
    
    if(%weapon != -1) // Do we have a weapon in hand?
    {
        // Yeah, does it have ammo?
    	if((%ammo = $Inv::Ammo[%weapon]) != "")
    	{
        	if( (%ammocount = getItemCount(%ammo)) ) // it has ammo!
        	{
        	    Event::Trigger(eventWeaponFired, %weapon, %ammo, %ammocount);
        	}
        	else // it's out of ammo!
        	{
                Event::Trigger(eventNoAmmo, %weapon, %ammo);
        	}
        }
        else // It doesn't need ammo!
        {
        	Event::Trigger(eventWeaponFired, %weapon);
        }
    }

    Event::Trigger(eventFirePressed, %weapon); // %weapon will be -1 if no weapon mounted
    
    if(   !Event::Returned(eventWeaponFired, mute)
       && !Event::Returned(eventFirePressed, mute)
       && !Event::Returned(eventNoAmmo, mute)      )
        postAction(2048, IDACTION_FIRE1, -0);
    
}

function onFireButtonBreak()
{
    %weapon = getMountedItem(0);
    Event::Trigger(eventFireReleased, %weapon); // %weapon will be -1 if no weapon mounted

    if( !Event::Returned(eventFireReleased, mute) )
        postAction(2048, IDACTION_BREAK1, -0); 
}


    EditActionMap("playMap.sae"); 

    // Set this to your fire button!
    bindCommand(mouse0, make, button0, TO, "onFireButton();"); 
    bindCommand(mouse0, break, button0, TO, "onFireButtonBreak();");
