// ______________________________________________________
// A change armour notification script (based on Writer's
// am_Armour.cs - his didn't trigger events, though.)
// will trigger an eventarmor if your armor is changed
// when  you respawn.
// ______________________________________________________

//Events:
//	eventArmor(%type, %respawn)
//		%type is the name of the armour you switched to
//		%respawn is (true/false) whether the armor switch
//		 was forced by a respawn (don't just blindly assume
//		 light armor - because of the mods out there :)

include("presto\\inventory.cs");
include("presto\\event.cs");

// The stuff for Writer's respawn code.
include("Writer\\version.cs");
if (!included("Writer\\version.cs")) {
	echo("ALEHud Including version file");
	include("VeKToR\\Writer\\version.cs");
}	
include("Writer\\fire.cs");
if (!included("Writer\\fire.cs")) {
	echo("ALEHud Including fire.cs file");
	include("VeKToR\\Writer\\fire.cs");
}	
include("Writer\\respawn_event.cs");
if (!included("Writer\\respawn_event.cs")) {
	echo("ALEHud Including respawn_event file");
	include("VeKToR\\Writer\\respawn_event.cs");
}	

function CheckArmorType(%respawn) {

	// This is Writer's "check armor type" code
	for(%i = $Inv::ArmorCount; %i > 0; %i--)
	{
		if(getItemCount(%armorname = $Inv::Name[%armortype = $Inv::ArmorList[%i]]))
		break;
	}

	echo(%i);

	// we didn't find any matching armor strings - unknown armor type?
	if (%i == 0)
		%armorname = "unknown";

	if (%armorname == $ArmorEvent::LastArmor)
		return;

	$ArmorEvent::LastArmor = %armorname;

	echo("eventArmor type: " @ %armorname);
	event::Trigger(eventArmor, %armorname, %respawn);
}

Event::Attach(eventExitInventoryStation, "CheckArmorType(false);");

// if called immediately, will return armor type you died in!
event::attach(eventRespawned, "schedule(\"CheckArmorType(true);\", 1);");

// handles initial connection triggering a respawn event
// (since you do kinda respawn then...)
function scheduleeventrespawn() {
	if (getmounteditem(0) == -1) {

		schedule("scheduleeventrespawn();", 0.1);
		return;
	} else 
		event::trigger(eventRespawned);

}

event::attach(eventMissionInfo, "scheduleeventrespawn();");
event::attach(eventConnected, "scheduleeventrespawn();");
