function saveMission( %objName, %fileName )
{
   focusServer();
	exportObjectToScript( %objName, "base\\", %fileName);
   focusClient();
}

function missionSaveObject( %objName, %fileName )
{
	focusServer();
	exportObjectToScript( %objName, "temp\\", %fileName );
	focusClient();
}

function missionLoadObject( %objParentName, %fileName )
{
	focusServer();
	setInstantGroup( %objParentName );
	exec( %fileName ); // temp is in the path.
	focusClient();
}

function edit()
{
   GuiEditMode(MainWindow);
   GuiInspect(MainWindow);
   cursorOn(MainWindow);
}

function ObjectToCamera::onAction()
{
   ME::ObjectToCamera();
}

function CameraToObject::onAction()
{
   ME::CameraToObject();
}

function ObjectToScreenCenter::onAction()
{
   ME::ObjectToSC();
}

function MissionRegObject(%group, %name, %func, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
{
   if($ME::NumGroups == "")
      $ME::NumGroups = 0;

   for(%i = 0; %i < $ME::NumGroups; %i++)
      if($ME::Group[%i] == %group)
         break;
   if(%i == $ME::NumGroups)
   {
      $ME::Group[%i] = %group;
      $ME::NumGroups++;
   }
   $ME::GroupEC[%group]++;
   $ME::Group[%group, ($ME::GroupEC[%group] - 1)] = %name;

   %funcStr = %func @ "(";
   for(%j = 1; %a[%j] != ""; %j++)
   {
      if(%a[%j + 1] == "")
         %funcStr = %funcStr @ "\"" @ %a[%j] @ "\");";
      else
         %funcStr = %funcStr @ "\"" @ %a[%j] @ "\", ";
   }
   $ME::Func[%group, %name] = %funcStr;
}

function GroupList::onAction()
{
   TextList::clear("NameList");
   %group = Control::getValue("GroupList");
   $ME::curGroup = %group;

   for(%i = 0; %i < $ME::GroupEC[%group]; %i++)
      TextList::AddLine("NameList", $ME::Group[%group, %i]);
}

function NameList::onAction()
{
   %name = Control::getValue("NameList");
   %func = $ME::Func[$ME::curGroup, %name];
   eval(%func);
}

function MissionObjectList::onUnselected(%world, %obj)
{
   if(%obj == $ME::InspectObject && %world == $ME::InspectWorld)
   {
      MissionObjectList::Inspect(1, -1);
      $ME::InspectObject = "";
   }
   
   ME::onUnselected( %world, %obj );
}

function MissionObjectList::onSelectionCleared()
{
   MissionObjectList::Inspect(1, -1);
   $ME::InspectObject = "";
   
   ME::onSelectionCleared();
}

function MissionObjectList::onSelected(%world, %obj)
{
   if($ME::InspectObject == "")
   {
      $ME::InspectObject = %obj;
      $ME::InspectWorld = %world;
      MissionObjectList::Inspect($ME::InspectWorld, %obj);
      
      // it's on the server:
      focusServer();
      %locked = %obj.locked;
      focusClient();

      if(%locked)
         Control::setText("LockButton", "Unlock");
      else
         Control::setText("LockButton", "Lock");
   }
   
   ME::onSelected( %world, %obj );
}

function ApplyButton::onAction()
{
   MissionObjectList::Apply();
}

function LockButton::onAction()
{
   if($ME::InspectObject != "")
   {
      focusServer();
      %locked = !$ME::InspectObject.locked;
      $ME::InspectObject.locked = %locked;
      focusClient();
      if(%locked)
         Control::setText("LockButton", "Unlock");
      else
         Control::setText("LockButton", "Lock");
      MissionObjectList::Inspect($ME::InspectWorld, $ME::InspectObject);
   }
}

$ME::ShowEditObjects = true;
$ME::ShowGrabHandles = true;
$ME::SnapToGrid = false;

$ME::XGridSnap = 1;
$ME::YGridSnap = 1;
$ME::ZGridSnap = 0.001;

function ME::SnapToGrid()
{
   Control::setActive(XGridSnapCtrl, $ME::SnapToGrid);
   Control::setActive(YGridSnapCtrl, $ME::SnapToGrid);
   Control::setActive(ZGridSnapCtrl, $ME::SnapToGrid);
   Control::setActive(UseTerrainGrid, $ME::SnapToGrid);
}

$ME::ConstrainX = false;
$ME::ConstrainY = false;
$ME::ConstrainZ = false;

function UseTerrainGrid::onAction()
{
	ME::onUseTerrainGrid();
	Control::setValue(XGridSnapCtrl, $ME::XGridSnap);
	Control::setValue(YGridSnapCtrl, $ME::YGridSnap);
	Control::setValue(ZGridSnapCtrl, $ME::ZGridSnap);
}

$ME::RotateXAxis = false;
$ME::RotateYAxis = false;
$ME::RotateZAxis = true;
$ME::RotationSnap = 90.0;
$ME::SnapRotations = false;

function ME::SnapRotations()
{
   Control::setActive(RotationSnapCtrl, $ME::SnapRotations);
}

$ME::DropAtCamera = false;
$ME::DropWithRotAtCamera = false;
$ME::DropBelowCamera = false;
$ME::DropToScreenCenter = true;
$ME::DropToSelectedObject = false;

$ME::ObjectsSnapToTerrain = false;
$ME::UsePlaneMovement = false;

// just toggle the value for this flag variable
function METogglePlaneMovement()
{
	if( $ME::UsePlaneMovement == "true" )
    {
    	$ME::UsePlaneMovement = false;
    }
    else
    {
    	$ME::UsePlaneMovement = true;
    }
    ME::GetConsoleOptions();
}

function MEHideOptions()
{
   if( Control::getVisible("OptionsCtrl") )
   {
      Control::setVisible("OptionsCtrl", false);
      ME::GetConsoleOptions();
   }

   if( Control::getVisible("TedOptionsCtrl") )
   {
      Control::setVisible("TedOptionsCtrl", false );
      Ted::GetConsoleOptions();
   }
}

function MEShowOptions()
{
   if($ME::Loaded)
   {
      if( Control::getVisible("HelpCtrl"))
         return;
        
      if( Control::getVisible("MEObjectList") )
      {
         Control::setVisible("OptionsCtrl", true);
         Control::setValue( MEUsePlaneMovement, $ME::UsePlaneMovement );
         ME::SnapRotations();
         ME::SnapToGrid();
         return;
      }
      
      if( Control::getVisible("TedBar") )
      {
         Control::setVisible("TedOptionsCtrl", true );
         return;
      }
   }
}

function METoggleOptions()
{
   if( Control::getVisible("MEObjectList" ) )
      %optionName = "OptionsCtrl";
   if( Control::getVisible("TedBar" ) )
      %optionName = "TedOptionsCtrl";
      
   if( Control::getVisible( %optionName ) )
   {
      MEHideOptions();
   }
   else
   {
      MEShowOptions();
   }
}

//-----------------------------------------------------

function MEShowHelp()
{
   if($ME::Loaded)
   {
      if(Control::getVisible("OptionsCtrl"))
         return;
      if(Control::getVisible("TedOptionsCtrl"))
         return;
      Control::setVisible("HelpCtrl", true );
   }
}

function MEHideHelp()
{
   if($ME::Loaded)
      Control::setVisible("HelpCtrl", false );
}

function METoggleHelp()
{
   if( Control::getVisible("HelpCtrl"))
   {
      MEHideHelp();
   }
   else
   {
      MEShowHelp();
   }
}

//-----------------------------------------------------


function MEShowCreator()
{
   if(!$ME::Loaded)
      return;
   
   MEHideOptions();
   MEHideHelp();
   
   unfocus(TedObject);
   focus(MissionEditor);
   focus(editCamera);
   postAction(EditorGui, Attach, editCamera);
   cursorOn(MainWindow);

   Control::setVisible("MEObjectList", true);
   Control::setVisible("Inspector", false);
   Control::setVisible("Creator", true);
   Control::setVisible("TedBar", false);
   Control::setVisible("SaveBar", true);

   TextList::clear("GroupList");
   TextList::clear("NameList");

   for(%i = 0; %i < $ME::NumGroups; %i++)
      TextList::AddLine("GroupList", $ME::Group[%i]);
}

function MEShowInspector()
{
   if(!$ME::Loaded)
      return;

   MEHideOptions();
   MEHideHelp();

   unfocus(TedObject);
   focus(MissionEditor);
   focus(editCamera);
   postAction(EditorGui, Attach, editCamera);
   cursorOn(MainWindow);

   Control::setVisible("MEObjectList", true);
   Control::setVisible("Inspector", true);
   Control::setVisible("Creator", false);
   Control::setVisible("TedBar", false);
   Control::setVisible("SaveBar", true);
}

function MEShowTed()
{
   if(!$ME::Loaded)
      return;

   MEHideOptions();
   MEHideHelp();
   
   Control::setVisible("TedBar", true);
   Control::setVisible("SaveBar", true);
   Control::setVisible("MEObjectList", false);
   Control::setVisible("Inspector", false);
   Control::setVisible("Creator", false);
   unfocus(MissionEditor);
   focus(TedObject);
   focus(editCamera);
   postAction(EditorGui, Attach, editCamera);
   cursorOn(MainWindow);

   // set the right button to nothing
   TED::setRButtonAction( "" );
    
   // set the terrain type popup
   Popup::clear(TerrainTypes);
   %i = Ted::getNumTerrainTypes();
   if( $TED::success == true )
      for( %j = 0; %j < %i; %j++ )
     	Popup::addLine( TerrainTypes, Ted::getTerrainTypeName(%j), %j );
   Popup::setSelected(TerrainTypes, Ted::getTerrainType() );

   // set the detail level popup
   Popup::clear(BrushDetail);
   %i = Ted::getMaxBrushDetail();
   if( $TED::success == true )
      for( %j = 0; %j < %i; %j++ )
         Popup::addLine( BrushDetail, "Level " @ %j, %j );
   Popup::setSelected(BrushDetail, Ted::getBrushDetail() );

   // setup the buttons with default's if no pref
   MESetupTedButton( TEDModeOne, select, true );
   MESetupTedButton( TEDModeTwo, deselect, true );
   MESetupTedButton( TEDModeThree, raiseHeight, true );
   MESetupTedButton( TEDModeFour, lowerHeight, true );
   
   MESetupTedButton( TEDProcessAction, "" );
   Control::setText( TEDProcessAction, " -- Selection Action --" );
}

function MESetupTedButton( %button, %func, %usePref )
{   	
   if( %usePref == "true" )
   {
      if( $pref::[%button] == "" )
         $pref::[%button] = %func;
      else
         %func = $pref::[%button];
   }
   else if( %button != "TEDProcessAction" )
   {
      $pref::[%button] = %func;
   }
   
   // set the ted mouse buttons..
   Popup::clear(%button);
   %selItem = 0;
   %i = Ted::getNumActions();
   if( $TED::success == true )
   {
      for( %j = 0; %j < %i; %j++ )
      {
         if( Ted::isActionMouseable( %j ) )
         {
            Popup::addLine( %button, Ted::getActionName(%j), %j );
            if( Ted::getActionName(%j) == %func )
               %selItem = %j;
         }
      }
   }
   Popup::setSelected(%button, %selItem );
}

function MEMode()
{
   if (!isObject(editCamera))
      return;

   $Server::timeLimit = 0;
   if(!isObject(EditorGui))
      GuiLoadContentCtrl("MainWindow", "gui\\editor.gui");

   if(!$ME::Loaded)
      return;

   MEHideOptions();
   MEHideHelp();
   
   MissionObjectList::ClearDisplayGroups();
   MissionObjectList::AddDisplayGroup(1, "MissionGroup");
   MissionObjectList::AddDisplayGroup(1, "MissionCleanup");
   MissionObjectList::SetSelMode(1);
   MEShowInspector();
   ME::GetConsoleOptions();
}

function MEGameMode()
{
   unfocus(TedObject);
   unfocus(MissionEditor);
   unfocus(editCamera);
   GuiLoadContentCtrl(MainWindow, "gui\\play.gui");
   cursorOff(MainWindow);
   focus(playDelegate);
}

function MEHide()
{
   if(!isObject(EditorGui))
      GuiLoadContentCtrl("MainWindow", "gui\\editor.gui");

   focus(editCamera);
   postAction(EditorGui, Attach, editCamera);

   Control::setVisible("TedBar", false);
   Control::setVisible("MEObjectList", false);
   Control::setVisible("Inspector", false);
   Control::setVisible("Creator", false);
   Control::setVisible("SaveBar", false);
   MEHideOptions();
   MEHideHelp();
}

function MELSEdit()
{
   LSEditor( MainWindow );
   flushTextureCache();
}

//--------------------------------------------------------------
// generic callback functions to pass along to current control

function MEDeleteSelection()
{
   if( Control::getVisible("MEObjectList") )
      ME::DeleteSelection();
}

function MECopySelection()
{
   if( Control::getVisible("TedBar") )
      Ted::copy();
   if( Control::getVisible("MEObjectList") )
      ME::CopySelection();
}

function MECutSelection()
{
   if( Control::getVisible("MEObjectList") )
      ME::CutSelection();
}

function MEPasteSelection()
{
   if( Control::getVisible("TedBar") )
      Ted::floatPaste();
   if( Control::getVisible("MEObjectList") )
      ME::PasteSelection();
}

function MEDuplicateSelection()
{
   if( Control::getVisible("TedBar") )
      Ted::floatSelection();
   if( Control::getVisible("MEObjectList") )
      ME::DuplicateSelection();
}

function MEUndo()
{
   if( Control::getVisible("TedBar") )
      Ted::undo();
   if( Control::getVisible("MEObjectList") )
      ME::Undo();
}

function MERedo()
{
   if( Control::getVisible("TedBar") )
      Ted::redo();
   if( Control::getVisible("MEObjectList") )
      ME::Redo();
}

//--------------------------------------------------------------
// the popup buttons - right click brings up popup with functions

function TEDModeOne::onPressed()
{
   Ted::setLButtonAction( Ted::getActionName( Popup::getSelected( TEDModeOne ) ) );
   Ted::setRButtonAction( "" );
}
function TEDModeOne::onSelect( %string, %level )
{
   MESetupTedButton( TEDModeOne, %string );
   Ted::setLButtonAction( %string );
   Ted::setRButtonAction( "" );
}

function TEDModeTwo::onPressed()
{
   Ted::setLButtonAction( Ted::getActionName( Popup::getSelected( TEDModeTwo ) ) );
   Ted::setRButtonAction( "" );
}
function TEDModeTwo::onSelect( %string, %level )
{
   MESetupTedButton( TEDModeTwo, %string );
   Ted::setLButtonAction( %string );
   Ted::setRButtonAction( "" );
}

function TEDModeThree::onPressed()
{
   Ted::setLButtonAction( Ted::getActionName( Popup::getSelected( TEDModeThree ) ) );
   Ted::setRButtonAction( "" );
}
function TEDModeThree::onSelect( %string, %level )
{
   MESetupTedButton( TEDModeThree, %string );
   Ted::setLButtonAction( %string );
   Ted::setRButtonAction( "" );
}

function TEDModeFour::onPressed()
{
   Ted::setLButtonAction( Ted::getActionName( Popup::getSelected( TEDModeFour ) ) );
   Ted::setRButtonAction( "" );
}
function TEDModeFour::onSelect( %string, %level )
{
   MESetupTedButton( TEDModeFour, %string );
   Ted::setLButtonAction( %string );
   Ted::setRButtonAction( "" );
}

function TEDProcessAction::onSelect( %string, %level )
{
   Ted::processAction( Ted::getActionName( %level ) );
   Control::setText( TEDProcessAction, " -- Selection Action --" );
}

//--------------------------------------------------------------

function TerrainTypes::onSelect(%string, %level)
{								
	TED::setTerrainType( %level );
}

function BrushDetail::onSelect(%string, %level)
{
   Ted::setBrushDetail(%level);
}

if(focusServer())
{
   focusClient();
   if($ME::Loaded == "")
   {
      $Server::timeLimit = 0;
      $ME::Loaded = true;
      exec( "move.cs" );
      ME::Move();
      exec( "med.cs");
      exec( "ted.cs");
      exec( "RegisterObjects.cs");
      ted();
      MEMode();
   }
}
else
{
   if($ME::CamLoaded == "")
   {
      // just give us da edit cam
      $ME::CamLoaded = true;
      exec("move.cs");
      MEHide();
   }
}


