//----------------------------------------------------------------------------
// Client side convience scripts
//
function buy(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,buyItem,%type);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function markFavorites()
{
	// Currently done by the shell
}

function remoteSetInfoLine(%mgr, %lineNum, %text)
{
   if(%mgr != 2048)
      return;

	if (%lineNum == 1)
	{
		if (%text == "") Control::setVisible(InfoCtrlBox, FALSE);
		else Control::setVisible(InfoCtrlBox, TRUE);
	}

   Control::setText("InfoCtrlLine" @ %lineNum, %text);
}


function buyFavorites()
{
	// This function is invoked by the shell.
	for (%i = 0; %i < 100; %i = %i + 1) {
		if ($pref::itemFavorite[%i] != "") {
			%type = getItemType($pref::itemFavorite[%i]);
			if (%type != -1) {
				%list = %list @ "," @ %type;
			}
		}
	}
	if (%list != "") {
		eval("remoteEval(2048,buyFavorites" @ %list @ ");");
	}
}	

function sell(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,sellItem,%type);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function use(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		// The client useItem function will make sure the use is
		// sequenced correctly with trigger events.  The remoteEval
		// works fine but may be delivered out of order.
		// remoteEval(2048,useItem,%type);
		useItem(%type);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function drop(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,dropItem,%type);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function throwStart()
{
	$throwStartTime = getSimTime();
}

function throwRelease(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		%delta = getSimTime() - $throwStartTime;
		if (%delta > 1)
			%delta = 100;
		else
			%delta = floor(%delta * 100);
		remoteEval(2048,throwItem,%type,%delta);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function deploy(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,deployItem,%type);
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function nextWeapon()
{
	// Up to the server right now
	remoteEval(2048,nextWeapon);
}	

function prevWeapon()
{
	// Up to the server right now
	remoteEval(2048,prevWeapon);
}

function commandAck()
{
	// Placed here to avoid binding problems with gui.
	remoteEval(2048,CStatus,1,"Command Acknowledged~wacknow");
}

function commandDeclined()
{
	// Placed here to avoid binding problems with gui.
	remoteEval(2048,CStatus,0,"Unable to complete objective~wobjxcmp");
}

function CommandCompleted()
{
	// Placed here to avoid binding problems with gui.
	remoteEval(2048,CStatus,0,"Objective Completed~wobjcomp");
}

function targetClient()
{
   if($lastClientMessage)
   {
      if(Client::getTeam(getManagerId()) == Client::getTeam($lastClientMessage))
         %cmd = "Escort " @ Client::getName($lastClientMessage) @ ".~wescfr";
      else
         %cmd = "Attack " @ Client::getName($lastClientMessage) @ ".~wattway";
      remoteEval(2048, "IssueTargCommand", 0, %cmd, $lastClientMessage - 2048, getManagerId());
   }
}

function onClientMessage(%client, %msg)
{
   if(%client)
      $lastClientMessage = %client;

   // filter messages here
   return true;
}

function onTeamAdd(%team, %name)
{

}

function onClientJoin(%client)
{

}

function onClientDrop(%client)
{

}

function onClientChangeTeam(%client, %team)
{

}

function clearCenterPrint(%id)
{
   if(%id == $centerPrintId)
      Client::centerPrint("", 0);
}

function remoteITXT(%manager, %msg)
{
   if(%manager == 2048)
      Control::setValue(EnergyDisplayText, %msg);
}

function remoteCP(%manager, %msg, %timeout)
{
   if(%manager == 2048)
   {
      $centerPrintId++;
      if(%timeout)
         schedule("clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
      Client::centerPrint(%msg, 0);
   }
}

function remoteBP(%manager, %msg, %timeout)
{
   if(%manager == 2048)
   {
      $centerPrintId++;
      if(%timeout)
         schedule("clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
      Client::centerPrint(%msg, 1);
   }
}

function remoteTP(%manager, %msg, %timeout)
{
   if(%manager == 2048)
   {
      $centerPrintId++;
      if(%timeout)
         schedule("clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
      Client::centerPrint(%msg, 2);
   }
}

function kill()
{
	remoteEval(2048,kill);
}	

function giveall()
{
	remoteEval(2048,giveall);
}

// Fear aliases
function setTeam(%team)
{
   remoteEval(2048, setTeam, %team);
}

function say(%channel, %message)
{
   remoteEval(2048, say, %channel, %message);
}

function mute(%playerName)
{
   remoteEval(2048, mute, 1, getClientByName(%playerName));
}

function unmute(%playerName)
{
   remoteEval(2048, mute, 0, getClientByName(%playerName));
}

function show()
{
   // redefine end frame script
   function Game::EndFrame()
   {
   }
   $Console::LastLineTimeout = 0;
   $Console::updateMetrics = false;
}
show();

function showTime()
{
   function Game::EndFrame()
   {
      echo("C: " @ getIntegerTime(false) @ "   S: " @ getIntegerTime(true));
   }
   $Console::LastLineTimeout = 1000;
   $Console::updateMetrics = false;
}

function showFPS()
{
   function Game::EndFrame()
   {
	   echo($ConsoleWorld::FrameRate);
   }
   $Console::LastLineTimeout = 1000;
   $Console::updateMetrics = false;
}

function showGfxOGL()
{
   function Game::EndFrame()
   {
	   echo($ConsoleWorld::FrameRate  @
	   		" T: "   @ $OpenGL::TexDL @
	   		" L: "   @ $OpenGL::LMDL  @
	   		" LB: "  @ $OpenGL::LMB   @
	   		" E: "   @ $OpenGL::ET);
   }
   $Console::LastLineTimeout = 1000;
}

function showGfxSW()
{
   function Game::EndFrame()
   {
      echo($ConsoleWorld::FrameRate 
       @ " P:" @ $GFXMetrics::EmittedPolys
       @ ", " @ $GFXMetrics::RenderedPolys
       @ " TSU:", $GFXMetrics::textureSpaceUsed);
   }
   $Console::LastLineTimeout = 1000;
   $Console::updateMetrics = true;
}

function messageAndAnimate(%animSeq,%wav)
{ 
	remoteEval(2048,playAnimWav,%animSeq,%wav);
}

function remotePlayAnimWav(%cl, %anim, %wav)
{
   remotePlayAnim(%cl, %anim);
   playVoice(%cl, %wav);
}

function remoteLMSG(%cl, %wav)
{
   playVoice(%cl, %wav);
}

function localMessage(%wav)
{
   remoteEval(2048, LMSG, %wav);
}

function changeLevel(%newLevel)
{
   remoteEval(2048, changeLevel, %newLevel);
}

function setArmor(%armorType)
{
   remoteEval(2048, setArmor, %armorType);
}

function voteYes()
{
   remoteEval(2048, VoteYes);
}

function voteNo()
{
   remoteEval(2048, VoteNo);
}

//editing functions

function winMouse()
{
   inputDeactivate(mouse0);
   windowsMouseEnable(MainWindow);
}

function dirMouse()
{
   inputActivate(mouse0);
   windowsMouseDisable(MainWindow);
}

function editGui()
{
   winMouse();
   GuiInspect(MainWindow);
   GuiToolbar(MainWindow);
}

function tree()
{
	simTreeCreate(tree, MainWindow);
	simTreeAddSet(tree, manager);
}

function toggleMouse()
{
   if($flagMouseDirect = !$flagMouseDirect)
   {
      dirMouse();
   }
   else
   {
      winMouse();
   }
}

function remoteSetTime(%server, %time)
{
   if(%server == 2048)
      setHudTimer(%time);
}

function SAD(%password)
{
   remoteEval(2048, AdminPassword, %password);
}

function SADSetPassword(%password)
{
   remoteEval(2048, SetPassword, %password);
}

function ADSetTimeLimit(%time)
{
   remoteEval(2048, SetTimeLimit, %time);
}

function ADSetTeamInfo(%team, %teamName, %skinBase)
{
   remoteEval(2048, SetTeamInfo, %team, %teamName, %skinBase);
}

function remoteSVInfo(%server, %version, %hostname, %mod, %info, %favKey)
{
   if(%server == 2048)
   {
      $ServerVersion = %version;
      $ServerName = %hostname;
      $modList = %mod;
      $ServerMod = $modList;
      $ServerInfo = %info;
      $ServerFavoritesKey = %favKey;
      EvalSearchPath();
   }
}


function remoteMODInfo(%server, %modString)
{
   if(%server == 2048)
   {
      $ServerModInfo = %modString;
      // if it is not "", 
      // show it on the loading gui
      if($ServerModInfo != "true")
      {
         Control::setValue(ModTextString, "<jc>" @ %modString);
      }
   }
}

function remoteFileURL(%server, %url)
{
   if(%server == 2048)
   {
      $ServerFileURL = %url;
      // if a disconnect occurs, pop this string up instead of error message
   }
}

function remoteMInfo(%server, %missionName)
{
   if(%server == 2048)
   {
      %file = "missions\\" @ %missionName @ ".dsc";
      $MDESC::Type = "";
      $MDESC::Text = "";
      if(File::findFirst(%file) != "")
         exec(%file);
      $ServerMission = %missionName;
      $ServerText = $MDESC::Text;
      $ServerMissionType = $MDESC::Type;
		if(isObject(LobbyGui))
			LobbyGui::onOpen();  // update lobby screen text.
   }
}

function remoteMissionChangeNotify(%serverManagerId, %nextMission)
{
   if(%serverManagerId == 2048)
   {
      cls();
      echo("Server mission complete - changing to mission: ", %nextMission);
      echo("Flushing Texture Cache");
      flushTextureCache();
      schedule("purgeResources(true);", 3);
   }
}

function dataGotBlock(%blockName, %pctDone)
{
   if(%pctDone < 0.1)
      %text = "<jc><f1>Loading <f2>[10%]";
   else if(%pctDone < 0.2)
      %text = "<jc><f1>Loading <f2>[20%]";
   else if(%pctDone < 0.3)
      %text = "<jc><f1>Loading <f2>[30%]";
   else if(%pctDone < 0.4)
      %text = "<jc><f1>Loading <f2>[40%]";
   else if(%pctDone < 0.5)
      %text = "<jc><f1>Loading <f2>[50%]";
   else if(%pctDone < 0.6)
      %text = "<jc><f1>Loading <f2>[60%]";
   else if(%pctDone < 0.7)
      %text = "<jc><f1>Loading <f2>[70%]";
   else if(%pctDone < 0.8)
      %text = "<jc><f1>Loading <f2>[80%]";
   else
      %text = "<jc><f1>Loading <f2>[90%]";

   //Control::setText(ProgressText, "Loading " @ %blockName @ " data...");
   Control::setValue(ProgressText, "<jc><f1>" @ %text);
   Control::setValue(ProgressSlider, %pctDone * 0.75);
}

function dataFinished()
{
   // called on client when all the dynamic data has
   // finished transfer.

	if ($cdMusic && !$pref::userCDOverride)
	{
		rbSetPlayMode (CD, 0);
		rbStop (CD);
	}
   Control::setValue(ProgressText, "<jc><f1>Genocide Loaded!!!");
   Control::setValue(ProgressSlider, 0.9);

   $dataFinished = true;
   remoteEval(2048, dataFinished);

   echo("Flushing Texture Cache");
   flushTextureCache();
}

function onClientGhostAlwaysDone()
{
   // preload the commander gui if it's not already loaded
   if(!isObject("commandGui"))
      loadObject("commandGui", "gui\\command.gui");

   %temp = $pref::terrainTextureDetail;
   $pref::terrainTextureDetail = 1;
   rebuildCommandMap();
   $pref::terrainTextureDetail = %temp;
   flushTextureCache();
   purgeResources(true);
   remoteEval(2048, "CGADone");

//   echo("Registering Static Textures");
//   RegisterStaticTextures(MainWindow);
}

function remoteSetMusic (%player, %track, %mode)
{
	if(%player == 2048)
   {
	   $cdPlayMode = %mode;
	   $cdTrack = %track;
	   if (!$pref::userCDOverride)
	   {
		   if ($cdTrack == 0)
			{
				rbSetPlayMode (CD, 0);
				rbStop (CD);
			}
		   else
			   if ($cdTrack != "")
				{
					rbSetPlayMode (CD, 0);
					rbStop (CD);
					rbSetPlayMode (CD, $cdPlayMode);
					if ($pref::cdMusic)
						rbPlay (CD, $cdTrack);
				}
	   }
   }
}

function onConnectionError(%client, %manager, %errorString)
{
   if(%manager == 2048)
   {
   }
   else
   {
      Quickstart();
      GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
      $errorString = "Connection to server error:\n" @ %errorString;
		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
   }
}

function onConnection(%message)
{
   echo("Connection ", %message);
   $dataFinished = false;
   if(%message == "Accepted")
   {
      resetSimTime();
		//execute the custom script
		if ($PCFG::Script != "")
		{
			exec($PCFG::Script);
		}

      resetPlayDelegate();
      remoteEval(2048, "SetCLInfo", $PCFG::SkinBase, $PCFG::RealName, $PCFG::EMail, $PCFG::Tribe, $PCFG::URL, $PCFG::Info, $pref::autoWaypoint, $pref::noEnterInvStation, $pref::messageMask);

		if ($Pref::PlayGameMode == "JOIN")
		{
			cursorOn(MainWindow);
	      GuiLoadContentCtrl(MainWindow, "gui\\Loading.gui");
			renderCanvas(MainWindow);
		}

   }
   else if(%message == "Rejected")
   {
		Quickstart();
      $errorString = "Connection to server rejected:\n" @ $errorString;
      GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
   }
   else
   {
      //startMainMenuScreen();
		Quickstart();

      if(%message == "Dropped")
      {
         if($errorString == "")
            $errorString = "Connection to server lost:\nServer went down.";
         else
            $errorString = "Connection to server lost:\n" @ $errorString;

         GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		   schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      }
      else if(%message == "TimedOut")
      {
         $errorString = "Connection to server timed out.";
         GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		   schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      }
   }
}

function onPlaybackFinished()
{
   // called when a recording is done with playback.
	cursorOn(MainWindow);
   GuiLoadContentCtrl(MainWindow, "gui\\Recordings.gui");
}

function setupRecorderFile(%fileName)
{
	if(%fileName != "" && %fileName != "False") {
		if(isFile("recordings\\" @ %fileName)) 
			echo("Warning- " @ %fileName @ " File Already Exists");
		$recorderFileName = "recordings\\" @ %fileName;
		if($recorderFileName != "False") {
			echo("File is named: ",%fileName);
			return "True";
		}	
 	}
	else {
		for(%i = 0; %i < 500; %i++) {
			if(!isFile("recordings\\recording" @ %i @ ".rec")) {
			  $recorderFileName = "recordings\\recording" @ %i @ ".rec";
				if($recorderFileName != "False") {
					echo("File is named: recording",%i,".rec");
					return "True";
				}	
			}		
		}
	}
	echo("Couldn't setup File");
	return "False";	
}

function EnterLobbyMode()
{
   schedule("ELM();", 0);
}

function ELM()
{
   if($playingDemo)
   {
      setCursor(MainWindow, "Cur_Arrow.bmp");
      disconnect();
      startMainMenuScreen();
      GuiLoadContentCtrl(MainWindow, "gui\\Recordings.gui");
   }
   else
   {
	   $InLobbyMode = true;
      GuiLoadContentCtrl(MainWindow, "gui\\Lobby.gui");
      CursorOn(MainWindow);
   }
}















11111111111111111111111111111)OLMMMMMMMMMMMiiooooooooooo,ioooooooooooooooooooooTLyyyyyyyyyyyyyyyh,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,iiiiiiiiioooooooooooooooooooooMiiiiiiiioooooooooooooooooooiiiiiiiiiiiiiiiiiiiiicuuuuuuuuuuuuuuuuuuuu(/0wwwwwwwwwwwwwww1R)$$$$$$$$$$$$$$$$$$$$$$$$$$TLLLLLLLoooooooooooo,yyyyyyyiiiiiiiiiiiiiiioooooooMh>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>cccccccccccccccccciiiiiiiiiiiiiioooooooouiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii(C,,,,,,,,,,,,,,,SwOTLLLLLLLLLLLLLLLLcyMMMMMMMouuuuuuuuuuuuuuuuuiiiiiiiiiiiiiiiooooooooooooooooooooooooooooochuuuuuuuiiiiiiiiiiiiiiooooooooooooooooooiiiiiiiiiiiiiiiiiiiiiddddddddddddddddd1P2J777777777777777777777777777777777777*&[XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX999999999999999999999999999999999999999999999999999999999qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq(	/IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII]--------------------------+S>'@0R))))))))))))))))))))L,,,,,,,,,,,,,,,CCCCCCCCCCCCwO$hTTTTTTTTTTTTTTTTyyyyyyyoooooooooooccccccciiiiiiiiiiiiiiiouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuudddddddddddddddddduMiooooooooooooooocccccccooooooooiiiiiiiiiiiiiiiLLLLLLLLLLLLLLLLgggggggggggggggggSSSSSSSSSSSSSSSSSS((((((((((((((((((((	uwwwwwwwwwwwwwwwhC,,,,,,,,,,,,,,,,,,,,,,,,,,,,,ooooooooooodddddddiccccccccccccccccccccccccccccccccciiiiiiiiiiiiiioMTTTTTTTTTTTTTTTccccccccuuuuuuuuuuuuuuuuuydiooooooooooooooooooooooooooooooooooooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii/PPPPPPPPPPPPPPPPPPPPPPkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkIR1O0MMMMMMMMMMMMMMMMgggggggggggggggggSSSSSSSSSSSSSSSSSS(LywwwwwwwwwwwwwwwhC,,,,,,,,,,,,,,,,,,,,,,,,,,,,,)	ocuuuuuuuiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiioddddddddddddddddddddddddddTcccccccceeeeeeeduioooooooooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii":MMMMMMMMMMMMMMMMgTSSSSSSSSSSSSSSSSSS(Lywwwwwwwwwwwwwwwwwwwwwwwwwww$CCCCCCCCCCCCh,ocdddddddiiiiiiiieeeeeeeeeeeeeeeioooooooeuuuuuuuuuuuuuuuuuuuuuuiiiiiiiiiiiieccccccccccccccccccccccccou																						eeeeeeedioooooooooooooooRGUx2222222222222222222222222222222222222222222222222222222222222222222222222222fffffffffffffffffffffffffffffffffffffffffffffffffffffffffff<<<<<<<<<<<<<<<<<<<<<<</;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;NVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV-+>PkwwwwwwwwwwwwwwwwwwwwwwwwwwwwwI1OOOOOOOOOOOOOOOOOOOO":MMMMMMMMMMMMMMMccccccccccccccccccTLSg(((((((($0yhhhhhhhhhhhhhhhhhdddddddddddddddddddddduuuuuuuoeiiiiiiiiiiiiiiiooooooooooooooi	Ceeeeeeeeeeeeeeedddddddddolciiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeee,,,,,,,,,,,,,,,,,,,,,,,,,,eiiiiiiiuoooooooooooooooooooooogggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggwfffffffffffffffffffffffffffffffffff"ddddddddddddddddddMLLLLLLLLLLLLLLL:TTTTTTTTTTThS()	yeeeeeeeeelucccccccccc,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,iooooooooooooooooooooooeeeeeeeooooooooooooiiiiiiiiiiiiiiiuuuuuuuuuuuuuuuuuudddddddddoooooooooolllllllieeeeeeeeeeeecccccccccccccccioooooooCCCCCCCCeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeA/EEEEEEEEEEEEEEEEEEEEEE........................RPGGGGGGGGGGGGGGGGGGGGGGGGGGGGG6h$kI1111111111111111111111111111111111111111111111111111111111111wffffffffffffffffguLLLLLLLLLLLLLLLLLL:M""""""""""""""""""""""""	TS(,)OiiiiiiiiiiidCyyyyyyyyylllllllllllllllllleooooooooooooooooooooooeiiiiiiiiiiiiiicooooooooooooooooooooooooooooooooooooooooeuuuuuuuuuuuuuuuuuuldddddddoicccccccccccccccccccccccoooooooooooooooooooooooooeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiihmmmmmmmmmmmmmmmmmmmm	wfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffgLLLLLLLLLLLLLLLLLL:::::::::::::::::"""""""""""""""MTS(,l0CCCCCCCCCCuoooooooooooooooooooooooooooodccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeellllllyyyyyyyyyyidueooooooooooooooooooooooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiiiiiiicoooooooooooooooooooooN|zӳĽ㶯`^Zп?񷸹ް̕#}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}YHK34IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII {88888888888888888888888888888888888888888~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~jFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ_________________________________________________________________________________________________JX7*&q[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[9''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''x!!!!!!!!!!!!!!!!!!!!!!!!!!U<2;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;f/+++++++++++++++++++++++++++++++++++++++++++++++++++VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVEP.............................R$GA6]------------------------------hmmmmmmmmmmmmmmmmmmmm	w)kkkkkkkkkkkkkkkkkkkkkkkkkkkkkgggggggggggggggggLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL:d("MT01Sely,,,,,,,,,,,,,,,,,,,,,,,,,cuiiiiiiiiiiiiiiiiiiooooooooooooooooooooooooooooooooooooooeeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnnnnnnlCddddddddddddddddcoooooooooooooooooooeiiiiiiiiiiiiiiioooooooooooouuuuuuuiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeMhmmmmmmmmmmmmmmmmmmmm	wfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff(Lg:C"TOSyyyyyyyyyonnnnnnnnnnnnnnnnnnnnnnnnnliiiiiiiiiiiiieuddddddddddddddddddddddiiiiiieooooooooooooooooooooccccccccccccccccccccccccccccccccccc,iiiiiiiiineuuuuuuuuuuuuuuuuuuuuuuuuuuuuuclooooooooooooooooooooooooooooediiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooooooopDI//////////////////////////////////////////////////////////////////////FPPPPPPPPPPPPPPPPPPPf$E.............................)RGA0>>>>>>>>>>>>>>>MCmmmmmmmmmmmmmmmmmmmm	whhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhag(((((((((((((((((LuS:"TTTTTTTTTTTTTTTTT,Okkkkkkkkkdnnnnnnnnnnnccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiolllllllllllleiiiiiiiiiiiiiiiduuuuuuuuuuuuaaaaaaaaaaaaaaaayoooooooooooooooooooooooooooooooooooooilneeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeeccccccccccccccccccccccccccccccfpppppppppppppppppppppppppppppppp"Cmmmmmmmmmmmmmmmmmmmm	whMMMMMMMMMMMMMMMMMMMMMMMMMMMMgS(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((LLLLLLLLLLLdu,::::::aaaaaaaaaailyTeooooooocccccccccccccccccccccccccccccccccccceinnnnnnnnnnnnnnnnnnnooooooooooooooooooooollllllllllldueeeeeeeeeeeeannnnnnnnnn1cccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiiiiiiiii.v%BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\xNNNNNNNNNNNNNNNNNNNNNNNNNNW<!;UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU222222222222222222DVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV///////////////////////++++++++++++++++++++++IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIPPPPPPPPPPPPP$F@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@hGEEEEEEEEEEEEEEEEEEEEEEEEEEEEE)ORA0fpppppppppppppppp,"Cmmmmmmmmmmmmmmmmmmmm	wwwwwwwwwwwwwwwdSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSgM(nlllllllllllyLLLLLLLLuuuuuuuuuuuuuuuuuu1>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>:aoeeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccTnllllllllllloduuuuuuuuuuuuuuuuuuuuuuuuuiiiiiiiiiiiiicaaaaaaaaeeeeeeeeeeeeeeeiiiiiiiiiiiiiiioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeepwhfffffffffffffffffffffffffffffffff,"Cyyyyyyyyyyyyyyyyyyyy	mmmmmmmmmmmmmmmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSltsgMMMMMMMMMT(Lkniiiiiiiiiiidddddddddduuuuuuuuuuuuceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiiaaaaaaaaaaaaaaaaaaooooooooooooooo:tsssssssssssssssssslrennnnnnnnnnnnnnnnnnnnnnnnnnnnndddddddiiiiiiioauuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuoeeeeeeeeeeeeicccccccccccccccwD/%%%%%%%%%%%%%%%%%%%%%%bbbbbbbbbbbbbbbbbbbbbbbb.PI$$$$$$$$$$$$$$yGGGGGGGGGGGGGFvOOOOOOOOOOOOOOOOOOOEEEEEEEEEEEEEEEEEEEEEEEEEEEEE1)RApgfffffffffffffffffffffffffffffffff,"Chttttttttttttttt																	mmmmmmmmmmmmmmmmmmmmSlLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLMT:(((((((((((((((((((((((((((((sssssssrnoaaaaaaaaaaaaaaaaaaaaaaaaaaaaacdeiiiiiiiiiiiiiiiiiiiiouuuuuuuuuuuuuiiiiiiiieeeeeeeeeeeeeeeeeeeeeeetlaaaaaaaaaaaaaaaaaaaaak000000srunnnnnnnnnnncioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiieddddddddddddddoooooooooooooooooooooCwyLgfffffffffffffffffffffffffffffffff,"ptttttttttttttttttttttttttttttttttttttttttttttttttt	hmmmmmmmmmm:SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSMMMMMMMMMuaaaaaaaaaaaali-Tseeeeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrdnooooooooooooooooooooooeeeeeeeiiiiiiiooooooccccccccccccccccccccccccccccccccccct           uaaaaaaaaaaaaaaaal(((((((dsoeeeeeeecriiiiiiiiiiiiiiiiiiiiooooooonnnnnnnnnnnnnnnnnnneiiiiiiiiiiiiiii>>>>>>>>>>>>>>>>>>>>>>>>>355555555555555555555555555555555555555555






























88888888888888888888888888888888888888888888~
jO*444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444JXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX&qB[7777777777777777777779'\\\\\\\\\\\\\\\\\\\\\\\\\\\x=========================================================<N;WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW!VUUUUUUUUUUUUUUUUUUUUUUU2@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@6666666666666666666666666666666666+LLLLLLLLLLLLLLLLLLLLLL////////////////////////%Pb$.GIFFFFFFFFFFFFFFDDDDDDDDDDDDDDDDDDDDDDDDDDDDD1vvvvvvvvvvvvvvvvvvvEkkkkkkkkkkkkkkkkkkkkkkkkkkkkk)RwyCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCfffffffffffffffffffffffffffffffff,"pgthhhhhhhhhhhhhhhhhhhh:															maaaaaaaaaaaaaaaaaaaaa------------------------------ASdddddddddddu oooooooooln(Mscccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoirrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeeeeuaaaaaaaaaaaaaaaaaaaaandddddddddddtttttt         isleoooooooooooooorTTTTTTTTTTTTTTTTTTTTTeiiiiiiiiiiiiiiiiiiiiiiiiiocccccccccccccccpLLLLLLLLLLLLLLLLLwy0000000000000000000000000000000000000000000000000000000000000fffffffffffffffffffffffffffffffff,"CCCCCCCCCCCC:hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhg											ua(msnddddddddddet        rrrrrrrrrrrrrrriiiiiiicllllllooooooooooooooooooooooooooooTSeeeeeeeoiiiiiiiiiiiiiiiiiiiiddddddddddduarsnnnnnnnnnnnnnnnnnnnnnnnnnnntM         coooooooooooooooooooeiiiiiiiiiiiiiiioooooooooooollllllliiiiiiiieeeeeeeeeeeeeee1wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwP/$%GbF.DIOOOOOOOOOOOOOO"kkkkkkkkkkkkkvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvEEEEEEEEEEEEEEEEEEEEEEEEEEEEE)LLLLLLLLLLLLLLLLLp(0RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRfffffffffffffffffffffffffffffffff,yuuuuuuuuuuuuuuu:ghCCCCCCCCCCCCCCCCCCCCndddddddddddT	Mmrsaooooooooooooooooooooooooooooooooootiiiiiiiiiiiiiel                      iiiiiieoooooooooooooooooooocccccccccccccccsndddddddddddddddddddSruiaaaaaaaaaaaaellllllllllllllllllllllllllllctooooooooooooooooooooooooooooe iiiiiiiiiiiiiiiiiiooooooooooooooo,w"LLLLLLLLLLLLLLLLLT(AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAfffffffffffffffffffffffffffffffffpdgggggggggggggggC:yhrsnMMMMMMMMMMMMMMMMMMMMlllllllllS																		ua                     ccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiotttttttttttteiiiiiiiiiiiiiiimrsn lllllllllddddddddddddddddduooooooooooaaaaaaaaaaaaaaaaaaaitttttttttttteeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeeccccccccccccccckkkkkkkkkkkkkkkkkkkkk\>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<=;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;NVWWWWWWWWWWWWWWWWWWWWWWW!BUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU2-]LPPPPPPPPPPPPPPPPPPPPPPPP$$$$$$$$$$$$$$$$$$$$$$G/F%DbO.1IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII++++++++++++++++++++++++++v0000000000000000000EEEEEEEEEEEEEEEEEEEEEEEEEEEEEw",MT(A)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))ffffffffffffffffffffffffffffffffffsCgyyyyyyyyyyyyyyyp:::::::::mhhhhhhhhhhhhhhhhhhhhSrrrrrrrrrr lnnnnnnddddddddddditueooooooocaaaaaaaaaaaaaaaaaaaaaaaaaaaaeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiooooooooooooooooooooollllllllls	tttttttttt rendddddddddddddddddddddducccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeeaaaaaaaoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiLLLLLLLLLLLLLLLLw"mMT(RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRf,syCpggggggggggggggggggggggggggggggg llllllllllllllllllllllllllll::::::::::::tttttttttt	hhhhhhhhrnnnnnnnudoeeeeeeeeeeeeaaaaaaaaaaaiiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccccccccccc llllllllluuuuuuuuuuuutsoSrrrrrraniiiiiiiiiiiiicddddddddeeeeeeeeeeeeeeeiiiiiiiiiiiiiiiioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeew$PGGGGGGGGGGGGGGGGGGGGGGGGFFFFFFFFFFFFFFFFFFFFFFD/O%1bk.f0IIIIIIIIIIIIIIIIIIIIIIIIIIAvvvvvvvvvvvvvvvvvvvELLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLmMT(RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR"lpyyyyyyyyyyyyyyyyyC,gtttttttttt 															auuuuuuuuuuuuuuuuuuuuisS:::::::::::rnceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiiddddddddddddddddddooooooooooooooooooooooooootttttttttt           auleeeeeeeeessssssssnhhhhhhhiiiiiiiodrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrroeeeeeeeeeeeeicccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccwfLLLLLLLLLLLLLLLL																				mMT()))))))))))))))))))))))))))))))))))))))))))p,y"CuuuuuuuuuuuutSgnnnnnnnnnnna       lllllllllodssssssssssssssssssschhhhhhhhhhhhhhheiiiiiiiiiiiiiiiiiiiiorrrrrrrrrrrrriiiiiiiieeeeeeeeeeeeeeeauuuuuuuuuuuutdnnnnnnnnnnnnnnnnnnnnnnnnn lrrrrrrrrrscioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiie::::::::::::::oooooooooooooooooooooooooooooooooooooooooooooooooooooooooHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY_{K333333333333333333333333333333333333333333QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ55555555555555555555555555555555555555555555

8*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~j0&44444444444444444444444444444444444444444444444444444444444444444444449JXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXq[\777777777777777777777777777777777777777777777777777777777777777777777777777777x'@@@@@@@@@@@@@@@@@@@@@@@@@@><<<<<<<<<<<<<<<<<<<<<<<<<;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;=VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVNBWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW!-UUUUUUUUUUUUUUUUUUUUU2LG$FPDDDDDDDDDDDDDDDDDDDDDDDDOOOOOOOOOOOOOOOOOOOOOO1/k%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%]]]]]]]]]]]]]]]]]]]]]]]]]]]]b).IIIIIIIIIIIIIIIIIIIIIIIIIIAvvvvvvvvvvvvvvvvvvvERwfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffS																				mMT(((((((((((((((((((((((((((,,,,,,,,,,,,,,,,,"ppppppppppppppppppyyyyyyyyyyyauhCrdntiiiiiiiiii eslllllllllllllllllllllllll:gggggggggooooooooooooooooooooooeeeeeeeiiiiiiioooooocccccccccccccccnnnnnnnnnnnausrdddddddddddddddddddtttttttttttttttttttttttttttttt oeeeeeeecliiiiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiii(LLLLLLLLLLLLLLLLLLLLLLLLLLLLLwfhS																				mMTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTa",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,pdnnnnnnnnnnn:yyyyyyyyyyyyyyyCsruooooooooooootttttttttttttttttt cccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoillllllleeeeeeeeeeeeeeeeeeeeeeeeeeeerdnnnnnnnnnnnnnnnnnnngsaaaaaauuuuuuuuuuuui teoooooooooooooolllllllllllllllllllllllllllllleiiiiiiiiiiiiiiiiiiiiiiiiioccccccccccccccc)wFGD$OP111111111111111111111111kkkkkkkkkkkkkkkkkkkkkk+/0%TTTTTTTTTTTTTb.IEEEEEEEEEEEEEEAvLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL(:hS																				mMfnnnnnnnnnnnnnnnnnn"""""""""""""""",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,srdddddddddddddddp         gyyyyyyyyyyyeauuuuuuuulllllllllllllllllliiiiiiicttttttoooooooooooooooooooooooooooooooooooooeeeeeeeoiiiiiiiiiiiiiiiiiiiiCsrdl         nnnnnnnnnnnnnnnnnaaaaaaaaaauuuuuuuuuuuucoooooooooooooooooooeiiiiiiiiiiiiiiiooooooooooootttttttiiiiiiiieeeeeeeeeeeeeeeMwTLRRRRRRRRRRRRRRR:hS																				m(rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr"f,,,,,,,,,CCCCCCCCCCCCCCCCCpgssssssssssl donnnnnnnnnnnnnnnnnnnnnnnnnnnaiiiiiiiiiiiiietuuuuuuuuuuuuuuuuuuuuuuiiiiiieooooooooooooooooooooccccccccccccccc         ryyyyyyyyyyyyyyyyyyyyylsidnetttttttttttttttttttttttttttttcaooooooooooooooooooooooooooooeuiiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<\;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV=BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBN-WWWWWWWWWWWWWWWWWWWWW!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!ULDFOG1$kP+2222222222222222222222220000000000000000000000)/mE%b.............................IIIIIIIIIIIIIIAwTMCCCCCCCCCCCCCCC:hS																				Rvrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrffffffffffffffffff("l         p,tttttttttttttttttttttyyyyyyyyyyyyyyyyyyyyyyyysdunnnnnnnnnnnccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiioaaaaaaaaaaaaeiiiiiiiiiiiiiiiiiiiiiiiil         uttttttttttttrrrrrrrgsooooooooooodddddddddddddddddddianeeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeeccccccccccccccccccccccccccccccccccLmwTpCCCCCCCCCCCCCCC:hS	M fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((ly"""""""""""uttttttttttttttrg,iaseooooooocddddddddddddddddddddddddddddeinnnnnnnnnnnnnnnnnnnoooooooooooooooooooootttttttttttttttttttttlaaaaaaaaaaau eeeeeeeeernnnnnnnnnnnnnnnnnscccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeedddddddoiiiiiiiiiiiiiiiiiiiiEwOD1FkG6$0P)))))))))))))))))))))))))))))))))))))))))))))))))))))))))																													/%bR.IIIIIIIIIIIIIILmmmmmmmmmmmmmmmmmmmmypCCCCCCCCCCCCCCC:hSTTTTTTTTTT(fffffffffffffffffffAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMMMMMMMMMMMMMMMMuttttttttttttggggggggggggggggggnaaaaaaaaaaallllllll               sroeeeeeeeeeeeeddddddddddddddddd"iiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccccccccccccuttttttttttttsnaaaaaaaaaaol      dddddddddiiiiiiiiiiiiicrrrrrrrreeeeeeeeeeeeeeeiiiiii,oooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeSw	LmgypCCCCCCCCCCCCCCC:hhhhhhhhhhhhhhhhhhhhtv(MfTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTaaaaaaaaaaauuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuudsnnnnnnnnnnnniiiiiiiiiil,,,,,,,,,,,,,,,,,,         ceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiirrrrrrrrrrrrrrrrrrooooooooooooooonaaaaaaaaaaau"dsteeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeellllllliiiiiiior                                 oeeeeeeeeeeeeiccccccccccccccc+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++33333333333333333333333333333333333333333333
5*





































8&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~j44444444444444444444444444444444444479JX]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]qqqqqqqqqqqqqqqqqqqqqqqqqq[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\V>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB=----------------------------------------------------NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNWx!L1OkD6@UF0G)$$$$$$$$$$$$$PEEEEEEEEEEEEEEEEEEEEEEEEhRRRRRRRRRRRRRRRRRRRRRR/%%%%%%%%%%%%%%%%%%%b.Iw	SSSSSSSSSSSSSSSSSgypCCCCCCCCCCCCCCC:mmmmmmmmmmmMvvvvvvvvvvvvvvT((((((((((((((((((((fsna,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,""""""""""""""""duuuuuuuttttttttttttorrrrrrrrrrrrrrrrrrrrrrrrrrrrcleiiiiiiiiiiiiiiiiiiiio             iiiiiiiieeeeeeeeeeeeeeedsnarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrut                     cioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiiellllllllllllllooooooooooooooooooooo:Lhw	,,,,,,,,,,,,,,,,,gypCCCCCCCCCCCCCCCSnTMMMMMMMMMMMMMMMMMMMMAm((((((((((((((((((fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"sd rrrrrrrrraiiiiiiiiiiiueeeeeeeeeetttttttttttttttttttttttttllllllllllllooooooooooooooooooooooeeeeeeeiiiiiiioooooocccccccccccccccccccccccnnnnnnnnnnnnnnnnssssssssss rddddddddaaaaaaaaaaaaaaaaaluoeeeeeeectiiiiiiiiiiiiiiiiiiiiooooooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiiiRwk12O0D)FFFFFFFFFFFFFGE$$$$$$$$$$$$$$$$$$$$$$$$$$$$$PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP/v%b.Lh::::::::::::::::::,,,,,,,,,,,,,,,,,gypC																TMMMMMMMMMMMMMMMMMMMMAIm(Srrrrrrrrrnfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffllllllllll sodaaaaaaaaaaaaaaaaaaaaaaucccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoittttttteeeeeeeeeeeeeeeeeeeeeeeeeeee rrrrrrrrrnnnnnnnnnnnnllllllllll""""""sdiuaeoooooooooooooottttttttttttttttttttttttttttttteiiiiiiiiiiiiiiiiiiiiiiiiiocccccccccccccccCwwwwwwwwwwwwwwwLh((((((((((((((((((,,,,,,,,,,,,,,,,,gyp:::::::::MMMMMMMMMMMMMMMMMMMMMMMMMMMMMT																													 rfmuuuuuuuuuuuulne"Ssssssssstdddddddiiiiiiicaaaaaaooooooooooooooooooooooooooooooooooooooeeeeeeeoiiiiiiiiiiiiiiiiiiiillllllllll rtuuuuuuuuuuuuuuuuuuuuuuuuuunnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnsdcoooooooooooooooooooeiiiiiiiiiiiiiiiooooooooooooaaaaaaaiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee<;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\B>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>-----------------------------------------------=============================================================xNNNNNNNNNNNNNNNNNNNNNNNNNNNNWL2!k01)OOOOOOOOOOOOODEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFGR$pvPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPA/%bwwwwwwwwwwwwwwwCf((((((((((((((((((,,,,,,,,,,,,,,,,,gyh              .M																:TTTTTTTTTTTTllllllllll""""""""""""""""""""""""""""""turooooooooonnnnnndddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddmiiiiiiiiiiiiieassssssssssssssssssssssiiiiiieoooooooooooooooooooocccccccccccccccuuuuuuuuuuuulllllllllldddddddddddt irrrrrrrrreannnnnnnnnnnnnnnnnnncSooooooooooooooooooooooooooooesiiiiiiiiiiiiiiiiiioooooooooooooooyLpwwwwwwwwwwwwwww"f((((((((((((((((((,,,,,,,,,,,,,,,,,gCl	I:MhhhhhhhhhhhhhhhhtuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuTaddddddddddddddddddddddddddd rsssssssssnccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiioSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSeiiiiiiiiiiiiiiiiiiiiiiiiituuuuuuuuuuuusadllllllllllllllll onrrrrrrrrrrrrrrrrrrrimmmmmmmmmeeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeecccccccccccccccvw0U)kkkkkkkkkkkkk1EOOOOOOOOOOOOOOOOOOOOOOOOOOOOODRFFFFFFFFFFFFFFFFFFFGgA$PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP/%Lpyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"f((((((((((((((((((,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,u:	hIbCMdddddddddddtSSSSSSSSSSSSSSSSnsaaaaaaaaaaaaaaaaallllllllllimT eooooooocrrrrrrrrrrrrrrrrrrrrrrrrrrrreiiiiiiiiiiiiiiiiiiiiiiiiiiioooooooooooooooooooooadddddddddddttttttttttttttttttttnsueeeeeeeeeeeellllllllllllllllll cccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeerrrrrrroiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiwgLpSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS"f((((((((((((((((((,yyyyyyyyyyyh:C															.sadmMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMnttttttttuuuuuuuuuuuuuuuuuu loeeeeeeeeeeeerrrrrrrrrriiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccnsad         TTTTTTTTTTTotuuuuuurrrrrrrrrrrriiiiiiiiiiiiiclllllllleeeeeeeeeeeeeeeiiiiiiiiiiiiiiioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee2ۈ|z˯ÀӳĽ㶼լ^Z`й?߿ް# YH{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}_______________________________KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
3*5&








































8A]~j4[79J66666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;qXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXQV++++++++++++++++++++++++++++++++++++++++++++++++BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\->>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>x============================''''''''''''''''''''''''''''''''<NL)0000000000000UWEkkkkkkkkkkkkkkkkkkkkkkkkkkkkk1ROOOOOOOOOOOOOOOOOOODvF,,,,,,,,,,,,,,G$PIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII/wgggggggggggggggggmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS"f((((((((((((((((((paChhhhhhhhhhhhhhh:y	T.%MMMMMMMMMMMMMMMMMMMMsnr         diiiiiiiiiiittttttttttuuuuuuuuuuuuceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiilllllllllllllllllloooooooooooooooooooooooaaaaaaaaaaaaaaaassssssssssr nedddddddddddddddddddddddddddddtttttttiiiiiiioluuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuoeeeeeeeeeeeeiccccccccccccccccccccccccccccccccL,wgTmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS"f((((((((((((((((((((((((((((((((Chhhhhhhhhhhhhhh:y	p         abMMMMMMMMMMMMMMMMMMMMMrsssssssndolllllllllllllllllllllllllllllcteiiiiiiiiiiiiiiiiiiiiouuuuuuuuuuuuuiiiiiiiieeeeeeeeeeeeeeer         alllllllllllllllllllllllllllllllllllllllllllllsnudddddddddddcioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiiettttttttttttttoooooooooooooooooooooooooooooooooowwwwwwwwwwwww)E00000000000000000000000000000!Rkkkkkkkkkkkkkkkkkkk1vOAD(IFG$.PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPL,,,,,,,,,,,,,,,,,,	TmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS"fggggggggghhhhhhhhhhhhhhhh:CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCr b/yullllllllllllaiiiiiiiiiiiiiiiiiiiipseeeeeeeeeeennnnnnnnnnnnnnnnnnnnnnnnntdooooooooooooooooooooooeeeeeeeiiiiiiioooooocccccccccccccccccccccccccccccccccccr           ullllllllllllllllaMMMMMMMtsoeeeeeeecniiiiiiiiiiiiiiiiiiiiooooooodddddddddddddddddddeiiiiiiiiiiiiiiifw(L,%	TmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS""""""""""""""""""r:hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgClllllllllllllllllllllllllllllllllllllllllllllllllllllltttttttttttu oooooooooadMyscccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoinnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeullllllllllllllllllllldtttttttttttrrrrrr         isaeoooooooooooooonpppppppppppppppppppppeiiiiiiiiiiiiiiiiiiiiiiiiiocccccccccccccccIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIV22222222222222222222222;B+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++---------------------------------------------------------\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\>xxxxxxxxxxxxxxxxxxxxxxxxx@@@@@@@@@@@@@@@@@@@@@@@@@@@<=UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE)R0000000000000000000!NvkA11111111111111O".DFGb$PPPPPPPPPPPPPPPPPPPPPPPPw(ffffffffffffffffffff%%%%%%%%%%%%%%%%%%%%%%	TmSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS,,,,,,,,,,,,,,,,,,,,,,,,,,,,:ghhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhulMCsdtttttttttter        nnnnnnnnnnnnnnniiiiiiicaaaaaaoooooooooooooooooooooooooooopppppppppppppppeeeeeeeoiiiiiiiiiiiiiiiiiiiitttttttttttulnsdddddddddddddddddddddddddddry         coooooooooooooooooooeiiiiiiiiiiiiiiiooooooooooooaaaaaaaiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeL"w(MMMMMMMMMMMMMMMMMMMM/	TmSfugggggggggggggggggggggggggggggggggg:,hdtttttttttttppppppppppppppppyCnslooooooooooooooooooooooooooooooooooriiiiiiiiiiiiiea                      iiiiiieoooooooooooooooooooocccccccccccccccsdtttttttttttttttttttttttttttttttttnuilllllllllllleaaaaaaaaaaaaaaaaaaaaaaaaaaaacrooooooooooooooooooooooooooooe iiiiiiiiiiiiiiiiiiooooooooooooooo.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwERRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR)v0AWWWWWWWWWWWWWWkI1SbODF%G$PL"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""pMMMMMMMMMMMMMMMMMMMM////////////////////////	Tm(ttttttttttttttttttg,,,,,,,,,,,,,,,,,f:nsdyhaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaul                     ccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiorrrrrrrrrrrreiiiiiiiiiiiiiiiCnsd aaaaaaaaatttttttttttttttttuoooooooooolllllllllllllllllllirrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeecccccccccccccccmwSL"ypMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM	TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTs,,,,,,,,,,,,,,,,,,fg(((((((((((((((((((((((((C:hhhhhhhhhhhhhhhnnnnnnnnnn addddddtttttttttttirueoooooooclllllllllllllllllllllllllllleiiiiiiiiiiiiiiiiiiiiiiiiiiiiiioooooooooooooooooooooaaaaaaaaassssssssssssssssrrrrrrrrrr nedttttttttttttttttttttttucccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeellllllloiiiiiiiiiiiiiiiiiiii!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
































********************************************************************3&5]
b68~jq[799999999999999999999999999994444444444444444444444444444444444444444444444444444444444444444444444VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVJJJJJJJJJJJJJJJJJJJJJJJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXB2222222222222222222222222222222222;-+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++x\@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@><<<<<<<<<<<<<<<<<<<<<<<<<UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU=LRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRREvvvvvvvvvvvvvA))))))))))))))0IWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW.kT%1OD/FG$wSmCypMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMP	"sf,((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((g aaaaaaaaahhhhhhhhhhhhhhhhhhhhhhhhhhhhrrrrrrrrrrrrrrrrrrrrrrrrr::::::::ndddddddutoeeeeeeeeeeeellllllllllliiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccccccccccc aaaaaaaaauuuuuuuuuuuursooooooooooooooonnnnnnldiiiiiiiiiiiiictttttttteeeeeeeeeeeeeeeiiiiiiiiiiiiiiiioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee	LTwShCypMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMma(fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff,""""""""""""""""""rrrrrrrrrr                gluuuuuuuuuuuuuuuuuuuuisssssssssssssssssssssssssssssssssssssssssndceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiittttttttttttttttttoooooooooooooooooooooooooorrrrrrrrrr           luaeeeeeeeeessssssssd:::::::iiiiiiiotnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnoeeeeeeeeeeeeiccccccccccccccc%wwwwwwwwwwwwwwwwwwwRvvvvvvvvvvvvvvvvvvvvvvvvvvvvvAEEEEEEEEEEEEEEEEEEEEEEEEEEI).0bNNNNNNNNNNNNNNNNNNNNNNNNk1OD/FG$$$$$$$$$$$$$$$$$$$$$$LT																hCypMMMMMMMMMMMMMMMMMMMMSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS("fm,uuuuuuuuuuuurrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrdddddddddddl       aaaaaaaaaotsssssssssssssssssssc:geiiiiiiiiiiiiiiiiiiiionnnnnnnnnnnnniiiiiiiieeeeeeeeeeeeeeeluuuuuuuuuuuurtddddddddddddddddddddddddd annnnnnnnnscioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiieeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooooooooooooooooooooooooowPLTTTTTTTTTTTTTTTTTTTTTTTTTTTTTThCypM												"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""m(Sffffffffffflu:,ntdriiiiiiiiii esaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaooooooooooooooooooooooeeeeeeeiiiiiiioooooocccccccccccccccdddddddddddlusntttttttttttttttttttrrrrrrrrrrrrrrrrg oeeeeeeecaiiiiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiB!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!V-222222222222222222222;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;+xxxxxxxxxxxxxxxxxxxxxxxxxx'''''''''''''''''''''''''''''''''''''<\U>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>WWWWWWWWWWWWWWWWWWWWWWWWWWWLvvvvvvvvvvvvvvvvvvvARRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRIE.............b)%0MDN=k1$O/FwPGGGGGGGGGGGGGGGGGGGG::::::::::::::::::::::::::::::hCypTlm"SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS	(tdddddddddddddddddddddddddddfg,snuoooooooooooorrrrrrrrrrrrrrrrrr cccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoiaaaaaaaeeeeeeeeeeeeeeeeeeeeeeeeeeeentddddddddddddddddddddddddddddddddddddslllllluuuuuuuuuuuui reooooooooooooooaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeiiiiiiiiiiiiiiiiiiiiiiiiiocccccccccccccccpLMwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww::::::::::::::::::::::::::::::hCyyyyyyyyyyyyyyyyyyyydSm	"TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTsntg(                          fffffffffffeluuuuuuuuaaaaaaaaaaaaaaaaaaiiiiiiicrrrrrroooooooooooooooooooooooooooooooooooooeeeeeeeoiiiiiiiiiiiiiiiiiiii,snta         dddddddddddddddddlllllllllluuuuuuuuuuuucoooooooooooooooooooeiiiiiiiiiiiiiiioooooooooooorrrrrrriiiiiiiieeeeeeeeeeeeeeeDwAvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvIR.............................bE%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)y$00000000000000000000000000000000kP1O/LMpggggggggggggggggg::::::::::::::::::::::::::::::hCCCCCCCCCCCCCCCCCCCCCCFn	STmmmmmmmmmmmmmmmmmmmm""""""""",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,((((((((((((((((((ssssssssssa todddddddddddddddddddddddddddliiiiiiiiiiiiieruuuuuuuuuuuuuuuuuuuuuuiiiiiieooooooooooooooooooooccccccccccccccc         nfffffffffffffffffffffasitderrrrrrrrrrrrrrrrrrrrrrrrrrrrrclooooooooooooooooooooooooooooeuiiiiiiiiiiiiiiiiiioooooooooooooooCwyLM,ggggggggggggggggg::::::::::::::::::::::::::::::hpnT																				SGma         ("rrrrrrrrrrrrrrrrrrrrrffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffstudddddddddddccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiolllllllllllleiiiiiiiiiiiiiiiiiiiiiiiia         urrrrrrrrrrrrnnnnnnnnnnnnnnnnnnnnnnnnsoooooooooootttttttttttttttttttildeeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeecccccccccccccccNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNYH{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}_____________________________________________


























































K*****************************************************************************************************************&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&3]65$$$$$$$$$$$$$$$$$$$$$$$$$$$$
8~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~q[7@j444444444444444444444444444444444444BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB9999999999999999999999999999999999JX-!!!!!!!!!!!!!!!!!!!!!VVVVVVVVVVVVVVVVVVVVVVVVVVVVVV2x;'''''''''''''''''''''''''''''''''''''''''''''''''+<<<<<<<<<<<<<<<<<<<<<<<<<<UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU\W>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>LLLLLLLLLLLLLLAIv...................bR%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%EDDDDDDDDDDDDDhP)0000000000000000000000000000000000000000000000000000000000000000000000000000000k1OwyC(,ggggggggggggggggg::::::::::::::::::::::::::::::M                    TG/	pSSSSSSSSSSSSSSSSSSSSSafmmmmmmmmmmmurrrrrrrrrrrrrrnnnnnnnnnnnnnnnnnn"ilseoooooooctttttttttttttttttttttttttttteidddddddddddddddddddooooooooooooooooooooorrrrrrrrrrrrrrrrrrrrralllllllllllu eeeeeeeeendddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddscccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeetttttttoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiLhwyf(,ggggggggggggggggg:::::::::::::::CCCCCCCCCCFFFFFFFFFFFFFFFFFFFFpTM	urrrrrrrrrrrrrrrrrrrrrrrrrrrrrSdlllllllllllaaaaaaaa               snoeeeeeeeeeeeetttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttmiiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccccccccccccurrrrrrrrrrrrsdlllllllllloa      tttttttttiiiiiiiiiiiiicnnnnnnnneeeeeeeeeeeeeeeiiiiii"oooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeePwIIIIIIIIIIIIII.Abv%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%RDDDDDDDDDDDDDDDDDDDDDDDDDDDDD$EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE)0G=k1Lhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhf(,ggggggggggggggggg:yrpFOMMMMMMMMMMMMMMMMMMMMCTllllllllllluuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu	tsddddddddddddiiiiiiiiiia"S         ceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiinnnnnnnnnnnnnnnnnnooooooooooooooodlllllllllllumtsreeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaiiiiiiion                                 oeeeeeeeeeeeeiccccccccccccccc:wwwwwwwwwwwwwwwLhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhf(,ggggggggggggggggggggggggggggggggggggggggggMpC/yyyyyyyyyyyyyyyyyyyysdl"TTTTTTTTTm	tuuuuuuurrrrrrrrrrrronnnnnnnnnnnnnnnnnnnnnnnnnnnncaeiiiiiiiiiiiiiiiiiiiio             iiiiiiiieeeeeeeeeeeeeeetsdlnnnnnnnnnSSSSSSSSSSSSSSSSur                     cioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeiiiiiieaaaaaaaaaaaaaaooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo-NNNNNNNNNNNNNNNNNNNNNBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB!xVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV2<;U+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\>L.Ibbbbbbbbbbbbbb%AAAAAAAAAAAAAAAAAAAAAAAAvDDDDDDDDDDDDDDDDDDD$RPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPGEEEEEEEEEEEEE)F0=========================kwwwwwwwwwwwwwww:""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""f(,ghdCMypppppppppppppppp/1SSSSSSSSSSSSSSSSSSSSTmst nnnnnnnnnliiiiiiiiiiiueeeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrraaaaaaaaaaaaooooooooooooooooooooooeeeeeeeiiiiiiioooooocccccccccccccccccccccccd	ssssssssss nttttttttlllllllllllllllllauoeeeeeeecriiiiiiiiiiiiiiiiiiiiooooooooooooooooooooooooooooooooooooeiiiiiiiiiiiiiiigLLLLLLLLLLLLLLLLLwwwwwwwwwwwwwwwS""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""f(,:	CMyppppppppppppppppOhnnnnnnnnnddddddddddddddddddddTaaaaaaaaaa sotllllllllllllllllllllllucccccccccccccccccciiiiiiiieeeeeeeeeeeeeeeeeeeeoirrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeeee nnnnnnnnnddddddddddddaaaaaaaaaammmmmmstiuleoooooooooooooorrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreiiiiiiiiiiiiiiiiiiiiiiiiiocccccccccccccccGwb.%IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIDA$vPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPR,FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEEEEEEEEEEEE/)000000000000000000000000000LLLLLLLLLLLLLLLLLgOkS""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""f(((((((((((((((((((((((M	pC:yyyyyyyyyy nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnuuuuuuuuuuuuademhssssssssrtttttttiiiiiiicllllllooooooooooooooooooooooooooooooooooooooeeeeeeeoiiiiiiiiiiiiiiiiiiiiaaaaaaaaaa nruuuuuuuuuuuuuuuuuuuuuuuuuudTTTTTTTTTTTstcoooooooooooooooooooeiiiiiiiiiiiiiiioooooooooooollllllliiiiiiiieeeeeeeeeeeeeee(w,LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL1S""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""fg pM:															CCCCCCCCCCCCaaaaaaaaaamyyyyyyyyyyyrunoooooooooddddddtTTTTTTTTTTTTTTTTiiiiiiiiiiiiielssssssssssssssssssssssiiiiiieoooooooooooooooooooocccccccccccccccuuuuuuuuuuuuaaaaaaaaaatttttttttttr innnnnnnnneldddddddddddddddddddchooooooooooooooooooooooooooooesiiiiiiiiiiiiiiiiiiooooooooooooooo=**************************************
&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]63333333333333333333333333333F@5
888888888888888888888888888888888888888888888888888888888888888888888888888888888q['~j4------------------------------------7777777777777777777779JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJNxBQX!<VU222222222222222222222222222222222222222222222222;W++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\L%bbbbbbbbbbbbbbbbbbbbbbbb.DI$$$$$$$$$$$$$$PAAAAAAAAAAAAAAAAAAAAAAvGGGGGGGGGGGGGGGGGGGf/RRRRRRRRRRRRRRRRRRRRRRRRRRRRREOOOOOOOOOOOOO)0w,(mmmmmmmmmmmmmmmmmmmm111111111111111111111111111>S""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""a:pppppppppppppppMg	ruuuuuuuuuuuuTClttttttttttttttttttttttttttt nsssssssssdccccccceeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiohyyyyyyyyyyyyeiiiiiiiiiiiiiiiiiiiiiiiiiruuuuuuuuuuuusltaaaaaaaaaaaaaaaa odnnnnnnnnnnnnnnnnnnniiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiieeeeeeeeccccccccccccccccccccccccccccccccLfw,TmmmmmmmmmmmmmmmmmmmmkS"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""(uuuuuuuuuuuuuuu:gpppppppppppppppppMtttttttttttrh	dslllllllllllllllllaaaaaaaaaaiiiiiiiiiiiiiiiiC eooooooocnnnnnnnnnnnnnnnnnnnnnnnnnnnneiiiiiiiiiiiiiiiiiiiiiiiiiiioooooooooooooooooooooltttttttttttrydsueeeeeeeeeeeeaaaaaaaaaaaaaaaaaa cccccccciiiiiiiiiiiiiiiiiiooooooooooooooooooooooeeeeeeennnnnnnoiiiiiiiiiiiiiiiiiiii/wwwwwwwwwwwwwwwwwwwwwwww%Db$.PIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIGAFvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvOOOOOOOOOOOOOOOOOOORRRRRRRRRRRRRRRRRRRRRRRRRRRRR1EEEEEEEEEEEEE)LffffffffffffffffffhTmmmmmmmmmmmmmmmmmmmmk0S",,,,,,,,,,,ggggggggggggggggggggggggggggggg:(pslttttttttttttttttMMMMMMMMMy	drrrrrrrruuuuuuuuuuuuuuuuuu aoeeeeeeeeeeeennnnnnnnnniiiiiiiiiiiiiiioooooooooooooooooooooooooiecccccccccccccccdslt         CCCCCCCCCCCoruuuuuunnnnnnnnnnnniiiiiiiiiiiiicaaaaaaaaeeeeeeeeeeeeeeeiiiiiiiiiiiiiiioooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee"wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwLffffffffffffffffhTmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmSSSSSSSSSSSSSSSSSSlllllllllllllllllg(((((((((((((((,:CpMysdn         tiiiiiiiiiiirrrrrrrrrruuuuuuuuuuuuceeeeeeeeeeeeeeeeeeeoooooooooooooooooooooeiiiiiiiiaaaaaaaaaaaaaaaaaaoooooooooooooooooooooool	ssssssssssn detttttttttttttttttttttttttttttrrrrrrriiiiiiioauuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuoeeeeeeeeeeeeicccccccccccccccOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO=x-------------------------------------------------N<BU!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!VW