//------------------------------------
//
// GUI screen functions
//
//------------------------------------

//
// Create the default IRC channels
//
$IRC::ChannelName [0] = "#Tribes";
$IRC::ChannelTopic[0] = "General TRIBES discussion";

$IRC::ChannelName [1] = "#Tribes_Forum";
$IRC::ChannelTopic[1] = "";

$IRC::ChannelName [2] = "#Tribes_Beginner";
$IRC::ChannelTopic[2] = "";

$IRC::ChannelName [3] = "#Tribes_Expert";
$IRC::ChannelTopic[3] = "";

$IRC::ChannelName [4] = "#Tribes_Strategy";
$IRC::ChannelTopic[4] = "";

$IRC::ChannelName [5] = "#Tribes_Stories";
$IRC::ChannelTopic[5] = "";

$IRC::ChannelName [6] = "#Tribes_Opponents";
$IRC::ChannelTopic[6] = "";

$IRC::ChannelName [7] = "#Tribes";
$IRC::ChannelTopic[7] = "";


//------------------------------------
// LOGIN GUI
function IRCLoginGui::onOpen()
{
	//initialize the vars
	$IRCConnected = FALSE;
	$IRCJoinedRoom = FALSE;
	if ($IRC::ListenInSim == "")
	{
		$IRC::ListenInSim = "FALSE";
	}
	if ($IRC::lastServer == "")
	{
		$IRC::lastServer = -1;
	}
	if ($IRC::currentServer == "" || $IRC::currentServer > $IRC::lastServer)
	{
		if ($IRC::lastServer < 0)
		{
			$IRC::currentServer = -1;
		}
		else
		{
			$IRC::currentServer = 0;
		}
	}

	//clear the combo
	FGCombo::clear(IDCTG_IRC_SERVER_COMBO);

	//first add all the servers to the server list combo box
   for(%i = 0; $IRC::description[%i] != ""; %i++)
	{
		FGCombo::addEntry(IDCTG_IRC_SERVER_COMBO, $IRC::description[%i], %i);
	}

	//now set the console vars
	if ($IRC::currentServer >= 0)
	{
		FGCombo::setSelected(IDCTG_IRC_SERVER_COMBO, $IRC::currentServer);

		$IRC::server		= $IRC::server[$IRC::currentServer];
		$IRC::serverPort	= $IRC::serverPort[$IRC::currentServer];
		$IRC::room			= $IRC::room[$IRC::currentServer];
	}

	//verify the IRC connect button state
	IRCLoginGui::verifyConnect();
}

function IRCLoginGui::onClose()
{
   export("IRC::*", "config\\IRCServers.cs", False);
}

function IRCLoginGui::verifyConnect()
{
	if ($IRC::server != "" && $IRC::nickname != "")
	{
		Control::setActive(IDCTG_IRC_CONNECT, TRUE);
	}
	else
	{
		Control::setActive(IDCTG_IRC_CONNECT, FALSE);
	}
}

function IRCLoginGui::Select()
{
	IRCLoginGui::Read(FGCombo::getSelected(IDCTG_IRC_SERVER_COMBO));
}

function IRCLoginGui::read(%cfgNum)
{
	if (%cfgNum >= 0 && %cfgNum <= $IRC::lastServer)
	{
		$IRC::currentServer = %cfgNum;

		//copy the values into the current set used by IRCClient.cpp
		$IRC::server		= $IRC::server[%cfgNum];
		$IRC::serverPort	= $IRC::serverPort[%cfgNum];
		$IRC::room			= $IRC::room[%cfgNum];
	}

	//set the connect button
	if ($IRC::server != "" && $IRC::serverPort != "" && $IRC::nickname != "")
	{
		Control::setActive(IDCTG_IRC_CONNECT, TRUE);
	}
	else
	{
		Control::setActive(IDCTG_IRC_CONNECT, FALSE);
	}
}

function IRCLogin::AutoConnect()
{
	if ((! $IRCConnected) && $IRC::ConnectOnStartup && $IRC::nickname != "" && $IRC::server != "")
	{
		//set the real name
		if ($PCFG::RealName)
		{
			$IRC::realName = $PCFG::RealName;
		}
		if ($IRC::realName == "")
		{
			$IRC::realName = $IRC::nickname;
		}

		//connect to the IRC server
		ircConnect($IRC::server, $IRC::serverPort);

		//set the var
		$IRCConnected = TRUE;
	}
}

function ConnectToIRCServer()
{
	if ($IRC::nickname != "" && $IRC::server != "")
	{
		//validate the port
		if ($IRC::serverPort <= 0) $IRC::serverPort = 6667;

		//set the real name
		if ($PCFG::RealName)
		{
			$IRC::realName = $PCFG::RealName;
		}
		if ($IRC::realName == "")
		{
			$IRC::realName = $IRC::nickname;
		}

		//connect to the IRC server
		ircConnect($IRC::server, $IRC::serverPort);

		//set the var
		$IRCConnected = TRUE;

		//load the content ctrl
		GuiLoadContentCtrl(MainWindow, "gui\\IRCChat.gui");
	}
}

function DisconnectFromIRCServer()
{
	//disconnect
	ircDisconnect();

	//set the var
	$IRCConnected = FALSE;
	$IRCJoinedRoom = FALSE;

	//load the content ctrl
	GuiLoadContentCtrl(MainWindow, "gui\\IRCLogin.gui");
}

//--------------------------------------------------------------------------------------------------
// OPTIONS GUI

function IRCOptions::Clear()
{
	Control::setValue(IDCTG_IRC_SERVER_TEXT, "");
	Control::setValue(IDCTG_IRC_PORT_TEXT, "");
	Control::setValue(IDCTG_IRC_ROOM_TEXT, "");

	$IRC::server		= "";
	$IRC::serverPort	= "";
	$IRC::room			= ""; 
}

function IRCOptions::init()
{
	//init some vars
	if ($IRC::lastServer == "")
	{
		$IRC::lastServer = -1;
	}
	if ($IRC::currentServer == "" || $IRC::currentServer > $IRC::lastServer)
	{
		if ($IRC::lastServer < 0)
		{
			$IRC::currentServer = -1;
		}
		else
		{
			$IRC::currentServer = 0;
		}
	}
	if ($IRC::DisconnectInSim == "")
	{
		$IRC::DisconnectInSim = true;
	}

	if ($IRC::BroadcastIP == "")
	{
		$IRC::BroadcastIP = true;
	}

	if ($IRC::MsgHistory == "")
	{
		$IRC::MsgHistory = 500;
	}
	Control::setValue(OptionsIRCHistory, $IRC::MsgHistory);

	if ($IRC::UseLogFile == "") $IRC::UseLogFile = FALSE;
	Control::setValue(OptionsIRCCaptureToLogfile, $IRC::UseLogFile);

	if ($IRC::LogFile == "") $IRC::LogFile = "IRCLog.txt";
	Control::setValue(OptionsIRCLogfile, $IRC::LogFile);

	//set the other options
	Control::setValue("OptionsIRCDisconnectInSim", $IRC::DisconnectInSim);
	Control::setValue("OptionsIRCBroadcast", $IRC::BroadcastIP);

	//clear all the config controls to start
	IRCOptions::Clear();

	//clear the combo
	FGCombo::clear(IDCTG_IRC_OPTIONS_COMBO);

	//first add all the players to the player list combo box
   for(%i = 0; $IRC::description[%i] != ""; %i++)
	{
		FGCombo::addEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::description[%i], %i);
	}

	if ($IRC::currentServer >= 0)
	{
		IRCOptions::Read($IRC::currentServer);
		Control::setActive(IDCTG_IRC_REMOVE_SERVER, TRUE);

		//also activate the entry fields
		Control::setActive(IDCTG_IRC_SERVER_TEXT, true);
		Control::setActive(IDCTG_IRC_PORT_TEXT, true);
		Control::setActive(IDCTG_IRC_ROOM_TEXT, true);
	}
	else
	{
		//set the button
		Control::setActive(IDCTG_IRC_REMOVE_SERVER, FALSE);

		//also grey out the entry fields
		Control::setActive(IDCTG_IRC_SERVER_TEXT, false);
		Control::setActive(IDCTG_IRC_PORT_TEXT, false);
		Control::setActive(IDCTG_IRC_ROOM_TEXT, false);
	}
}

function IRCOptionsMsgHistory::validate()
{
	if ($IRC::MsgHistory < 50)
	{
		$IRC::MsgHistory = 50;
	}
	else if ($IRC::MsgHistory > 500)
	{
		$IRC::MsgHistory = 500;
	}
	Control::setValue(OptionsIRCHistory, $IRC::MsgHistory);
}

function IRCOptions::Shutdown()
{
	IRCOptions::Write();
   export("IRC::*", "config\\IRCServers.cs", False);
}

function IRCOptions::Select()
{
	IRCOptions::Write();
	IRCOptions::Read(FGCombo::getSelected(IDCTG_IRC_OPTIONS_COMBO));
}

function IRCOptions::New()
{
	//push the dialog
   GuiPushDialog(MainWindow, "gui\\NewIRCServer.gui");
}

function IRCOptions::Read(%cfgNum)
{
	if (%cfgNum >= 0 && %cfgNum <= $IRC::lastServer)
	{
		//load the values into the gui controls		
		Control::setValue(IDCTG_IRC_SERVER_TEXT,		$IRC::server[%cfgNum]);
		Control::setValue(IDCTG_IRC_PORT_TEXT,			$IRC::serverPort[%cfgNum]);
		Control::setValue(IDCTG_IRC_ROOM_TEXT,			$IRC::room[%cfgNum]);

		//copy the values into the current set used by IRCClient.cpp
		$IRC::server		= $IRC::server[%cfgNum];
		$IRC::serverPort	= $IRC::serverPort[%cfgNum];
		$IRC::room			= $IRC::room[%cfgNum];
		
		//set the selected server in the combo box
		$IRC::currentServer = %cfgNum;
		FGCombo::setSelected(IDCTG_IRC_OPTIONS_COMBO, $IRC::currentServer);

		//set the buttons
		Control::setActive(IDCTG_IRC_REMOVE_SERVER, TRUE);
	}
}
	
function IRCOptions::Write()
{
	if ($IRC::CurrentPlayer >= 0 && $IRC::CurrentPlayer <= $IRC::lastServer)
	{
		//get the values from the gui controls
		$IRC::server[$IRC::currentServer]		= Control::getValue(IDCTG_IRC_SERVER_TEXT);
		$IRC::serverPort[$IRC::currentServer]	= Control::getValue(IDCTG_IRC_PORT_TEXT);
		$IRC::room[$IRC::currentServer]			= Control::getValue(IDCTG_IRC_ROOM_TEXT);

		//update the set of vars used by IRCClient.cpp
		$IRC::server		= $IRC::server[$IRC::currentServer];
		$IRC::serverPort	= $IRC::serverPort[$IRC::currentServer];
		$IRC::room			= $IRC::room[$IRC::currentServer];
	}
}
	
function IRCOptions::Add(%newServerDescription)
{
	IRCOptions::Write();
	if (%newServerDescription != "")
	{
		//add it to the end
		$IRC::lastServer = $IRC::lastServer + 1;

		//create the vars
		$IRC::description[$IRC::lastServer]	= %newServerDescription;
		$IRC::server[$IRC::lastServer]		= "";
		$IRC::serverPort[$IRC::lastServer]	= "";
		$IRC::room[$IRC::lastServer]			= "";
		
		//add it to the list
		FGCombo::addEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::description[$IRC::lastServer], $IRC::lastServer);

		//set the button
		Control::setActive(IDCTG_IRC_REMOVE_SERVER, true);

		//activate the entry fields
		Control::setActive(IDCTG_IRC_SERVER_TEXT, true);
		Control::setActive(IDCTG_IRC_PORT_TEXT, true);
		Control::setActive(IDCTG_IRC_ROOM_TEXT, true);

		//set the added player as the current
		IRCOptions::Read($IRC::lastServer);
		IRCOptions::Write();


	}
}

function IRCOptions::Remove()
{
	if ($IRC::currentServer >= 0 && $IRC::currentServer <= $IRC::lastServer)
	{
		//copy the last player entries over top of the one being deleted
		if ($IRC::currentServer < $IRC::lastServer)
		{
			$IRC::description[$IRC::currentServer]	= $IRC::description[$IRC::lastServer];
			$IRC::server[$IRC::currentServer]		= $IRC::server[$IRC::lastServer];
			$IRC::serverPort[$IRC::currentServer]	= $IRC::serverPort[$IRC::lastServer];
			$IRC::room[$IRC::currentServer]			= $IRC::room[$IRC::lastServer];

			//delete it from the combo box
			FGCombo::deleteEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::currentServer);

			//delete the last entry, and re-add it with the new ID number
			FGCombo::deleteEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::lastServer);
			FGCombo::addEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::description[$IRC::currentServer], $IRC::currentServer);
		}
		else
		{
			//delete it from the combo box
			FGCombo::deleteEntry(IDCTG_IRC_OPTIONS_COMBO, $IRC::currentServer);
		}
		
		//erase the last player config
		$IRC::description[$IRC::lastServer]	= "";
		$IRC::server[$IRC::lastServer]		= "";
		$IRC::serverPort[$IRC::lastServer]	= "";
		$IRC::room[$IRC::lastServer]			= "";
		
		//decriment the last player index
		$IRC::lastServer = $IRC::lastServer - 1;

		//now set the current server to be the first
		if ($IRC::lastServer >= 0)
		{
			IRCOptions::Read(0);
		}
		else
		{
			IRCOptions::Clear();

			//set the button
			Control::setActive(IDCTG_IRC_REMOVE_SERVER, FALSE);

			//also grey out the entry fields
			Control::setActive(IDCTG_IRC_SERVER_TEXT, false);
			Control::setActive(IDCTG_IRC_PORT_TEXT, false);
			Control::setActive(IDCTG_IRC_ROOM_TEXT, false);
		}
	}
}




oiccccccccccccccoiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooooooooooo1111111111111111111111111111111111!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!D
)7|W*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++cdiiiiiiiiiiiiiiiiM&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&A
SSSSSSSSSSSSSoiiucccccccccccccdooiyy(((((((((((((((((((((((((((((((EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE55555555555555555555555555555555555555555555555555555555555uccccccccccccceoiideoocSidueeo iiiiiiiiiiiiiiiiiiiiiiiiig[0L.)xxxxxxxxxxxxxxxxxxxxxxxxxxxxxDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
,]A++++++++++++++++++++++++++++++++++++M((((((((((((((((((((EyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyycSSSSSSSSSSSSSSSSddddddddeo iiiiiiiiuuuuuuuueo  aaaaaaaaaaaaaaaaaaaaaaaa;wliiiiiiiucccccccceoo iiiiiiiddddddddeeEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEOS((((((((((((((((((((gggggggggggggyyyyyyyyyyyyyyyyyyy






























auuuuuuuuuuuuo iiiiiiidllllllllllllllleo iiiiiiicccccccccccccccccccccccccccccauuuuuuuuuuuuddddddddeo iiiiiiiiiiiiilllllllleo iiiiiiiiiiiiiiiiiiiiiiiiiiiii~ŸqȹjǺɻ`^ZYQտK$@?98PGk Ҵ'&}z>2X{HU===========================VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVJ3############################################################################################################################################################################################################################################################################################################################444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444417!WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW||||||||||||||||||||||||||||||||||||[0L.)x5******************,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,A
D]]]]]]]]]]]]]]]]]]]]EEEEEEEEEEEEEEE;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;+
MS(OOOOOOOOOOOOOgyacccccccccccccccccccccccccccccccccccccccccccccccccccluuuuuuuueo  iiiiiiiiiiiddddddddeooooooooooooooannnnnnnnnnnnslc iiiiiiiiiiiddddddddddddddddddddddddddddddddddddddeeo iiiiiiiiiiiuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuEEEEEEEEEEEEEEEEEEEEEEEEEE(wgSSSSSSSSSSSSSSSSSSOdannnnnnnnnnnnnoslieeeeeee            ucccccccioooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeey           sssssssssssstdiannnnnnnuuuuuuuuuuuuuuuuuuuuooooooooooooooooooolllllllllle                    ciiiiio      eeeeeee..........................CCCCCCCCCCCCCCPPPPPPPPPPPPPPPPPPPPPPPPPPPPN%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G0///////////////////////[[[[[[[[[[[[[[[[[[,L)xDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDA
]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]t(Eggggggggggggggggggggggggggggggggggw+ussssssssssssssssssssssssssssssssssssssssssSSSSSSSSdacnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnOOOOOOOOOOO ieooooooooooooooooooooooo leeeeeeeeeeeeiooooooocusssssssssssssssstd             aeeeeeeeeeeeeelnoooooooiiiiiiie          ooooooooiyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffCsg((((((((((((((((((((EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEcuuuuuuuuuuuuuuuuuuuMeeeeeeeeeeeettttttldo iiiiiiiiiiiiiiiiiiySaaaaaaaooooooieeeeeee nnnnnnnnnnnnnnnnnnulllllllllllllccccccccccossssssssssssiOttttttttttttndeeeeeeee                 iaoooooooooooooooooe                                        &_6h>>>>>>>>>>>>>>>>>>>>>>>FRIIIIIIIIIIIIIIIIIIIIIIII"""""""""""""""""""""""""b=vVUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU-<BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB777777777777777777777777777777777777777777777777777777777777777777777777777p;1!WPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPN|5555555555555555555555555555555555555555555555555555555555555550%.Gg)/[,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,LxD]]]]]]]]]]]]]]]]]]]]]]]]]]]]]A
w
yyyyyyyyyyyyyyfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffCCCCCCCCCCCCCCCCCCcccccccccccccccccccccccccccccccccccccccccccccccccccccE(((((((((((((((OMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM*llllllllllllluuuuuuuuuuuuuuuusaaaaaaaaaaaatnnnnnnnniiiiio      eeeeeeeeeeeeeeeeeeeeeeeed ieooooooooooooooooooooooooaSlccccccccuuuuuuuuuuuuuuts       edddddddddddddddddiooooooo     eeeeeeeeeeeeeeeeeeeoniiiiiiiCpgggggggggggggggggggggggggggggggyOfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffflllllllll((((((((((((((((((((((((((((((((((((((EtaSSSSSSSSSSSSSSSSSSSSSSSSSSS cuedddddddddddddddddddooooooooiiiiiiinsssssssssssseo iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii+++++++++++++++++++dtallllllllllllllllllconuieeeeeeeeeeeeeeeeeeeee                        iosssssssssssseeeeeeee                                                                      b:																					AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPN"mmmmmmmmmmmmmmmmmmmmmmmmmmmm0%.O[))))))))))))))))))))))))))))))))/x,]LGDwwwwwwwwwwwwwwwwwwwwwwwwwwwwwM
(pgggggggggggggggggggggggggggggggyCffffffffffffffffffffffffffffffrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrraSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
Endtttttttttttilllllllllllllscuuuuuuuuuuuuuuuuuuoooooooooooooooooe             iiiiiiiiiiiiiiiiiiiiio      eeeeeeetaaaaaaaaarsndddddddddddddddddddddddddddddddlllllllluuuuuuuuuuuuuuuuui          ceooooooooooooooooooooooo       eiiiiiiiiiiiiiiiiiooooooofffffffffffffffffff(pgggggggggggggggggggggggggggggggyCOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSdtaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaausnrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr          leeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiie          ooooooooccccccciiiiiiindtaaaaaaaaaaussssssssserEEEEEEEEEEEEEEEEEEEEEEEEEEEo cllllliiiiiiiiiiiiiiiiiiiiooooooooooooooooooei                        	$}{kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\#2XzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzJ3HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH__________________________________________________________________________h&=6V>%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<7-BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!4;|1WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWb::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPN"mmmmmmmmmmmmmmmmmmmmmmmmmmmm000000000000000000000CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC[x)]/G,wLMD....................................................................................5


















(pgggggggggggggggggggggggggggggggyftSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSOOOOOOOOOOOOOOOOOOOOOOOOOOsndddddddddddddddddddddddddddddddddddddddddddddddduaooooooooorrrrrrrrrrrrrEEEEEEEEEEEEEEEEEEEEEEEEEEciiiiiiiiiiiieeeeeeee           iooooooollllllllllllllllle       usndddddddddddddddddddddddddddddddddtiaaaaaaaaaaaaaaaaaaaaaaaaarrrrrrrrooooollllllllllllllllllll      eeeeeeeeeeeeeeeeeeeeeeeei oeccccccccccccyyyyyyyyyyyyyyy


















(pgggggggggggggggggggggggggggggggCnnnnnnnnnnnnnnnnnnnnnnSOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOfffffffffffffffffffffffffffusEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEddddddddtaaaaalllllllll       eiiiiiiocrrrrrrr     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeiooooooooooooooooooooooooooousllllllllllllllllllllllln dtecaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaoooooooiiiiiiiiiiiier oooooiiiiiiiiiiiiiiiiiiii0%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%b:*+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPN"mmmmmmmmmmmmmmmmmmmmmmmmmmmm																															xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx][G)w/M,.LLLLLLLLLLLLLLLLLLLLLDEEEEEEEEEEEEEEE














































(pgyuOOOOOOOOOOOOOOOOOOOOOOfSCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCclllllllllllssssssndrtaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaoei                        ooooooiiiiiiiiiiiiiiieeeeeeee                                                     rcluosniadddddddddddddddddddddddddddttttte             iiiiiiiioooooooooo              eeeeeeeggggggggggggggggggggEEEEEEEEEEEEEEE


















(ppppppppppppppppppppppppppppppppppppppppppfOCCCCCCCCCCCCCCCCCCCCCCySllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllarccccccccccccccccussssssssssssssssnnnnni oeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedddddddddddddddddd       eitooooooooooooclllllllllllllllllllllllllllllllarrrrrrrrrrrrrrrrrrrrrrrrru                          seeeeeeeetnnnnnnnnnnnnioooooooe dddddddddddddddddoooooooiiiiiiibh_==================================V&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&6666666666666666666666666666<>vU77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!-B||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||;1W0%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
******************************************+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPN"m:p]xGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGw[M)./////////////////////,	LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLEEEEEEEEEEEEEEE
DDDDDDDDDDDDDDDDDDD(gggggggggggCfyOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOrcllllllllllllllSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeeedustttttt oooooiiiiiiiiiiiiiiiiiiiiiiiiieoni                        arclddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddossssssssssieeeeeeenuuuuuuuu           ioooooooooooooooooooeeeeet       ((((((((((((((((((((((((((((((((((((((((((((((((EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEpcyCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCfgOOOOOOOOOarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrsddddddddddddddddddSliiiiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnnnoooooooooo ettttttttttttttttttttttttttttttttti ouuuuuueeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeearnsdcccccccclllllllllllllllttttttttttttt       uuuuuuuuuuuuieoooooooooooo                     eeeeeeeeeeeeiooooooommmmmmmmmmmmmmmmmmmmmmmmmmmm0%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
5+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPN"bbbbbbbbbbbbbbbbbbbG]wxMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM.[[[[[[[[[[[[[[[[[[[[[)	/:,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEL(aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaygCpfdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOtnsr cllllllllllllllllllllllllllllllllueeeeeeeeeeeeeeeeeoooooooiiiiiiie                 oooooiiiiiiiiiiiiiiiiiiiisdaSSSSSSSSSStnnnnnnnnnercccccccccccccccccclo iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiooooooieeeeeee        uuuuuuuuuuuDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEagggggggggggggggggggggggggggggggpy(CnsddddddddddddddddddddddfffffffffffffffffffffftSOoooooooooriiiiiiiiiiiiccccccccccccccccccceeeee ullllllllllllliiiiiiiiooooooooooooooooooooe       tnsdddddddddddddddddddddddddddddddddaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaurrrrriiiiiiiiiiico      eeeeeeeeeeeeeeeeeelllllll ieoooooooooooo <郂~qŸjͻɺY^`````````````````````````````````````````````````````ZQK9?@8Ҵ'ܶ$XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX}{3\######################################kzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzhJ2=HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHV____________________________________________________________________________________________________________________________________________________________________&"76>v!UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||-----------------------------------------------------------BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB;1mmmmmmmmmmmmmmmmmmmmmmmmmmmm0%*WWWWWWWWWWWWWWWWWWWWWWWWWWWWW
55555555555555555555555555555555555555555+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNwGM].xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	[:)b//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////ED,spg(((((((((((((((((((((((((((((((((((((((((((((((((yyyyyyyyyytnSCuuuuuuuuuuuuuuuuuuuuuuuudddddaaaaaaaaaaaaaaaaaaflllllllllrrrrrrrrrrr        eeeeeeeeeeeeiooooooo     ecccccccccccccoooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiitnluuuuuuuuuuuus daerOOOOOOOOOOoccccccccciiiiiiiiiiiiiiiiiiiiiiiiieo iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiESSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSt(pppppppppppppppppppgLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLyrlunnnnnnsdocaieeeeeee                      OCCCCCCCioooooooooooooooooooeeeeeeeee           uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuucrltinsssssssssssssssssddddddddoooooooooaaaaaaaaaae                    fiiiiio      eeeeeeeN"mmmmmmmmmmmmmmmmmmmmmmmmmmmm0%DDDDDDDDDDDDDDDDDDDDDDDDDDDDD









































+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPMw.GGGGGGGGGGGGGGGGGGGGG]	x::::::::::::::::::::::::::::::::b[[[[[[[[[[[[[[[[[[[[[[[[[))))))))))))))))))SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE(L/pppppppppppppppgluuuuuuuuuuuuOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOcrrrrrrrrrrrrrrrrrtnfysddddddddddddddddddd ieooooooooooooooooooooooo aeeeeeeeeeeeeiooooooorluuuuuuuuuuuuCCCCCCCCCCCcccccccccccccccccccccccccct dneeeeeeeeeeeeeasoooooooiiiiiiie          ooooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSu,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,(EpcrlfgdCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCeeeeeeeeeeeeeeeeeeeeeeeeeeeato iiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnnooooooieeeeeee sssssssssssssssssssssssssssscrladyuooooooooooooooooooooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiisteeeeeeee                 inoooooooooooooooooe       0V=======================================h<_777777777777777777777777777777777777777777777777777777777!&6>|vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU-BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB********************************************4;N"mmmmmmmmmmmmmmmmmmmmmmmmmmmm51LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD









































W+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRIP%%%%%%%%%%%%%%.MMMMMMMMMMMMMMMMMMMMMw	G:]bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[fOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSrrrrrrrrrrrrrrr,)EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE(ypgCcccccccccccccccccccadllllllluuuuuuuuuuuunnnnnnnnnnnnnnnnnnnnnnssssssssiiiiio      eeeeeeeeeeeeeeeeeeeeeeeet ieoooooooooooodrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrcnnnnnnnnnaaaaaaaaaaaaaaaaaaluuuuuuuuuuuuuuuuuuuuuuuuu       ettttttttttttttttttiooooooo     eeeeeeeeeeeeeeeeeeeosiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiyfOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS/EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE((((((((((((((((adrpggggggggggnnnnnnnnnc           letuuuuuuuuuuooooooooiiiiiiissssssssssssssssssssssseo iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiadrttttttttttnCCCCCCcccccccccccoslieeeeeeeeeeeeeu                        ioooooooooooooooooooooooeeeeeeee           PPPPPPPPPPPPPPPPPPPPPPPPN"mmmmmmmmmmmmmmmmmmmmmmmmmmmm,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD








































+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRI000000000000000000000000000000000000000000000000000000000000000000000000000000000.	M:wbGGGGGGGGGGGGGGGGGGGGGGGGG]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]x%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(yfOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSd/[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[EnnnnnnnnnappppppppppppppppppppsttttttttttriCCCCCCCCCCCCCCCCccccccccccccccccccccccllllllllllllllllllloooooooooooooooooe             iiiiiiiiuuuuuo      eeeeeeeeeeeeeeeennnnnnnnnaaaaaaaaaaaastdddddddrgggggggglccccci uuuuuuuuuuueooooooooooooooooooooooo       eiiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooop(yfOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))ttttttttttnCEllllllllllllsaaaaadr uggggggggggggggggggggeeeeeeeeeeeeeeeeeeeoiiiiiiiiiiiiiccccccce          ooooooooooooooooooooooooiiiiiiisttttttttttnulllllllllllllllllllleaddddddddddddddddddro                              iiiiiiiiiiiiiiiiiiiioooooocei                        m3333333333333333333333333333333333333333333333$XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{J\#zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzkV2HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH<=7h!_I||||||||||||||||||||||||||||||||||&66666666666666666666666666666666666666666666666666666666666>vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU***********************************-B55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444444PPPPPPPPPPPPPPPPPPPPPPPPN"""""""""""""""""""""""""""""""""""""""""";/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD








































1+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFRRRRRRRRRRRRRRRRRRRRRRRRRRRRS																					:.bMMMMMMMMMMMMMMMMMMMMMMMMMwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwG%]0xCp(yfOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))stgggggggggggggggggggggggggggulnoooooooooacdrrrrrrrrrrriiiiiiiiiiiieeeeeeee           iooooooooooooooooooooooEEEEEEEEEEEEEEEEEe       llllllllllllstcccccccccccccuuuuuuuuuuinnnnnnnnnnnnnnnraaaaaaaaooooooooooooooooooooooood      eeeeeeeeeeeeeeeeeeeeeeeei oeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeegCp(yfOSssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss[ulllllllllllllllllllllllllllllllllllllllllllllllllllllllllrccccccccccccctttttttttttttttttnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn       eiiiiiioooooooooooaaaaaaa     eeeeeeeeeeeeeeeeeeedioooooooooooooooooooullllllllllllErcs tttttttttteeeeeeeeeeennnnnnnnnnddddddddddddddddoooooooiiiiiiiiiiiiea oooooiiiiiiiiiiiiiiiiiiiiRIPPPPPPPPPPPPPPPPPPPPPPPPN")/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
W+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFmO:	bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb....................................M%w0GGGGGGGGGGGGGGGGGGGGGGGGGGGG]]]]]]]]]]]]]]]]gCp(yffffffffffffffffffllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllSSSSSSSSSSSSSSSSSSScccccccccccccuuuuuuuuuuuuuuuuuuuu[xxxxxxxxxxxEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEErrrrrrrrrrrrrrrrrstaaaaaaaaaandoei                        ooooooiiiiiiiiiiiiiiieeeeeeee           rcccccccccccccuaaaaaaaaaaaaaaaaaaaaaaaaaloooooooooooosintttttttttttttttttttttttttttttttttttttttte             iiiiiiiioooooooooo deeeeeeefffffffffffffffffffffffffffffffffffgCp(yOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSEcrnaaaaaaaaaaauuuuuuulllllllllllllllllllllllllllsssssi oeeeeeedtttttttttttttttttt       eiiiiiiiiiioooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooocccccccccnarrrrrul ddddddddddddeeeeeeeeeeeeeeeeessssssssssssioooooooe tttttttttttttttttoooooooiiiiiiiN<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<7V!=|hFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF__________________________________&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&6>v*UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU5555555555555555555555555555555555555555555555555555555555555555555------------------------------------------BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBRIPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
W;+AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTT"yb:::::::::::::::::::::::::																																																								%.0MMMMMMMMMMMMMMMMMMMMMMMMMMMMwmGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGgCp(ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSOaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]dddddddddncerutllllllllllllllllllllllllll oooooiiiiiiiiiiiiiiiiiiiiiiiiieosi                        naaaaaaaaaaaaaaaaaaaaaaatdddddddddEEEEEEcroooooooooooouieeeeeeesllllllll           ioooooooooooooooooooeeeeeeeeeeeeee       ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((gCpyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyfSSSSSSSSSnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaatdddddddddddddiEOcccccccsrrrrrrrroooooooooo eeeeeeeeeeuuuuuuuuuuuuuuuuuuuuuuuui olllllleeeeeeedddddddddnassssssssssssttttttttttttttttttttttttttttttxxxxxxxxxxxxxxc       lrieoooooooooooo     uuuuuuuueeeeeeeeeeeeioooooooooooooooooooooooooooooFRIPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
1+AAAAAAAAAAAAAAAAATNpppppppppppppppppppppppppbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb:%	000000000000000000000000000000000000000000000000.mM"wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwgC(nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnfffffffffffffffffffffffffffffffyyyyyyyyyyyyyyyyyyyyyytdddddddddESSSSSSSSSSssssssssssssa                       uxGGGGGGGGGGGGGGGGGGcleeeeeeeeeeeeeeeeeoooooooiiiiiiie      roooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiitddddddddduuuuuuuuuusneaaaaaaaaaaaaaaaaccccccccccccco irOOOOOOOOOOOOOOOOOOOOOOOOooooooieeeeeee        lllllllllllCEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEgpdffffffffffffffffffffffffffyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy(((((((((((((((((((((((((((((((sssssssssssst]]]]]]]]]]]]]]]]]]]]]]cuuuuuuuuuuuuuuuuuuonairrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeee llllllllllllllllllllllllliiiiiiiiooooooooooOSe                sssssssssssstrcudddddddddddddddnnnnnnnnlaaaaaiiiiiiiiiiiiiiiiiiiiiiiiiiiio      eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee ieoooooooooooo~郈qjϽɻ^ټZY׺`QK9? @P8Ҵ'${3#XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ}<z\7k2!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!|V4H=TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTh__________________________________*&6>5vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU-BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBFRIWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
111111111111111111111111111111111111111111111111111111111111111111111111111111111111111+AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg%b0::::::::::::::::::::::::::::	mmmmmmmmmmmmmmmmmmmmm".NM]wEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEECCCCCCCCCCCCyf((((((((((((((((((((((((((pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppuuuuuuuuuusOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOlrctttttdddddddddddddddddddddnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa        eeeeeeeeeeeeiooooooo     eeeeeeeeeeeeeeeeeeeeeeeoooooooiiiiiiicuuuuuuuuuussssssssssssslrrrrrrrrrrrr tdeaaaaaaaaaaaaaaaaaaoooooooooooniiiiiiiiiiiiiiiiiiiiiiiiieo iiiiiiiiiiiSSSSSSSSSSSSSSSSSSSSSSSSSSSSSOGEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEgggggggggg(ypfCCCCCCCCCCCCCCCCCCCCCCCCCCrcuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuaaaaaaaaaaaaalssssssssssssssssstooooooooooodieeeeeee            SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSioooooooooooooooooooen           lrcuuuuuuuuuuuaaaaaaaaaaaaaaaaaaaaaaisssssssssssssssssssssssssssssssssssssssttttttttondddddddddde                            iiiiio      eeeeeeeeeeeeeeeeeeeeeeeTTTTTTTTTTTTTTTTTTTTTTTFRI]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
;+APPPPPPPPPPPPPPPPPPPP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0000000000000000000000000000000000000000000000000000bm:"	NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN..................OGMEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEcp(CygffffffffffffflrSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSauuuuuuuuuuuuuuuuusssssssssssssssssssstnnnnnnnnnnn ieooooooooooooooooooooooo deeeeeeeeeeeeioooooooaaaaaaaaaaaaalrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrcccccuuuuuuuuuu tseeeeeeeeeeeeeddddddddddddoooooooiiiiiiie          ooooooooinnnnnnnnnnnnnnnnnnnnnnnnnnnSSSSSSSSSSSSSSSSSSOwEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEElCpg((((((((((((((((yyyyyyyyyyyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaafttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttrecuuuuuuddddddddddo iiiiiiiiiiiiiiiiiinsssssssooooooieeeeeee                                                                                                   aaaaaaaaaaaaadtttttttttlorcinuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeee                 isoooooooooooooooooe       R!7|<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<VA*=h_5555555555555555555555555555555555&666666666666666666666666666666666666666666>vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW-BBBBBBBBBBBBBBBBBTTTTTTTTTTTTTTTTTTTTTTTF111111111111111111111111111111111111111111111111G]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;+IIIIIIIIIIIIII0%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mmmmmmmmmmmmmmmmmmmmmmmmm"bN::::::::::::::::::::::::	PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPSSSSSSSSSSSSSSSSSSOw.EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEagCCCCCCCCCCCCCCCCpppppppppppppppppppp(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((yfffffffffffffffffffffffffffffffffffffffffndtttttttttttttttttttlrscuuuuuuuuuuuuuuuuuuuiiiiio      eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee ieooooooooooootttttttttaaaaaaaaaaaaaaaaaaaaaaaaaasnddddddddddddddddddddddddddddddlllllur       eeeeeeeeeecccccciooooooo     eeeeeeeeeeeeeeeeeeeooooooooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiSSSSSSSSSSSSSSSSSSOMEEEEEEEEEEEEEEaaaaaaaaaaaaaaaaggggggggggggggggggggCCCCCCCCCCCCCCCpdtttttttttf(usnnnnnnnnnnnnnnnnnnnnnnnnnny                       eeeeeeeeeellllllllllooooooooiiiiiiiiiiiiiiiiiirrrrrrrrrrrreo iiiiiccccccccccccccccccccndttttttttttttttttttusaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaooooooooooooooooooooooooiecl                        iorrrrrrrrrrrreeeeeeee           +AAAAAAAAAAAAAAAAATTTTTTTTTTTTTTTTTTTTTTTFwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
















































REEEEEEEEEEEEEEEEEEEEEEEEEEEE0m%""""""""""""""""""""""""""""""""""""NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNbP:I	ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSSSSSSSSSSSSSSSSSSOMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMtttttttttttttttttttttttttttttttttttttttttttttttttggggggggggggggCsnddddddddddddddddddddddddddpppppppppppppppppppppuuuuuuuuuiaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa(rrrrrrrrrrrrrrrrrrrrrrrcccccccoooooooooooooooooe             iiiiiiiilllllo      eeeeeeeusndrrrrrrrrrrrrrrrrrrrrrtttttttttttttttaaaaaaaaaaaaaaaaaaaayyyyyi llllllllllleooooooooooooooooooooooo       eiiiiiicooooooo..........................ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSSSSSSSSSSSSSSSSSSOEnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnggggggggggusssssssssssssssssssssssssssssssCCCCCCCCCCCCCrrrrrrrrrrrrdddddttttttttt laeeeeeeeeeeeeeeeeeeeoicypppppppe          ooooooooooooooooooooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiuslllllllllllllrnedttttttccccccccco           aaaaaiiiiiiiiiiiiiiiiiiiioooooo(ei                                                                                                         {3##########################################################XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX$zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ4}!\k|||||||||||||||||||||||||||||||||||||2222222222222222222222222222222222222222222222222222222222277777777777777777777777777777777777777777777777777777777<***************************************************************************************HV=h_5555555555555555555555555555555555&666666666666666666666666666666666666666666>vUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW-B111111111111111111111111111111111111111111111111;AAAAAAAAAAAAAAAAAT+MwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
FOmmmmmmmmmmmmmmmmmmmmmmmmmmmm"0N%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%PPPPPPPPPPPPPPPPPPPPPPPPPIbR::::::::::::::::::::::::::::::::::::::::::::::::::::::::ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSSSSSSSSSSSSSSSSSS.	uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuEEEEEEEEEEEEEEEErrrrrrrrrrrrrrrrrrrrrygclllllllllllllsond(Ctttttttttttttttttttiiiiiiiiiiiieeeeeeee           ioooooooaaaaaaaaaaaaaaaaae                   rrrrrrrrrrrrrrrrrrrrrpcluisnnnnnnnnnnnnnnnddddddddoooooat      eeeeeeeeeeeeeeeeeeeeeeeei oeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEElllllllllllllr((((((((((((((((((((((((pgcccccccccccccccccusssssan       eiiiiiioooooooooooddddddd     eeeeeeeeeeeeeeeeeeetioooooooclllllllllllllraaaaaaaaaCCCCCCCCCCCC          ueeeeeeeeeeesssssssssstnnnnnnnnoooooooiiiiiiiiiiiied oooooiiiiiiiiiiiiiiiiiiii

































































AAAAAAAAAAAAAAAAAT.MwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
+S"mNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN0P%IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIRRRRRRRRRRRRRRRRRRRRRRRRRFb(yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE::::::::::::::OOOOOOOOOOOOOOOCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCplcccccccccccaaaaaaaaarrrrrrrrrrrrrrrrrrrrrrrrrrdustoei                        ooooooinnnnnnneeeeeeee                               gldddddddddddacorrrrrrrrrrrrissssssssssssssssssssssssssssnuuuuue             iiiiiiiioooooooooo teeeeeeeeeeeeeeeeeeeeeeeeeeeeC(yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSgEEEEEEEEEEEEEEEEEEE														OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasdddddddddddlllllllcrrrrrrrrnnnnnnnnnnnnnnnni oeeeeeettttttttttttttttttttttttttt       eiuooooooooooooooooooooooaaaaaaaaaaaaaaaaaaaaansdppppplc treeeeeeeeuuuuuuuuuuuuuuuuuuuuuuuioooooooe                          oooooooiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii||||||||||||||||||||||||||||||||||||||||||||||||||||||||!*777777777777777777777777777777777777777777777777777<
_______________________________________V=6h5555555555555555555555555555555555U&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW

































































-111111111111111111111111111111111111111111111111AAAAAAAAAAAAAAAAAAAAA.MwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDDDDDDDDDDDDDDDDDDDDDDDDDDDDDTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTN""""""""""""""""""""""""mPPPPPPPPPPPPPPPPPPPPPPPPPPPPI0R%FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF+++++++++++++++++++++++++++++++++++++++C(yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyffffffffffffffffffffffffffffffffffffffffffffffffggggggggggggggES	bdddddddddddaaaaaaaaaaaaaaaaaaaaOtnssssssssssssseppppppppppppppppppllllllllllcruuuuuu oooooiiiiiiiiiiiiiiiiiiiiiiiiieooooooooooooi                        sdddddddddddaaaaaaaaaatnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnorlieeeeeeeeeeeeeeeeeecccccccc           ioooooooooooooooooooeeeeeu       ffffffffffffffffffffffffffffffffffC(yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyySggggggggggggggggggggggEnsdp:rrrrrrrrrrtaiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiOOOOOOOOoooooooooo eulllllllllllllllllllllllli occcccceeeeeeetnsddddddddddddrrrrrrrrrrrrrrrrrrrrrrrrrrraaaaaaaaaaaaauuuuuuuuuuuuu       ccccccccccccccccccieoooooooooooo     lllllllleeeeeeeeeeeeiooooooooooooooooooooooooooooooooooo






































;																					.MwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,LDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANP"ImRRRRRRRRRRRRRRRRRRRRRRRRRRRRF0+%TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTppppppppppppppppppppppppppppppppppC(yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyfsSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSggggggggggtnnnnnnnnnnnnnnnnEuuuuuuuuuuuurd           alllllllllllllllllllllceeeeeeeeeeeeeeeeeoooooooiiiiiiie                       :::::::::::::::::::::::::oooooiiiiiiiiiiiiiiiiiiiirrrrrrrrrrtnluuuuuuuuuuuuseddddddddddddddddddddddddddddao iOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOooooooieeeeeee        ccccccccccccccccccccccccccccccccccccccccccccccccccccccccppppppppppppppppppppppppppppppppppC(yyyyyyyyyyyyyyyyyyyyyyyyyyttttttttttttttttttttttSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSffffffffffffffffffffffffffffffrrrrrrrrrrrrrrrrrrrrrrrrrrrggggggggggggglunosdiOEEEEEEEEEEEEEEEEEEEEEEEEEEEEEeeeee caaaaaaaaaaaaaiiiiiiiiooooooooooooooooooe       uuuuuuuuuuuurrrrrrrrrrbbbbbbbbbbbbbltttttttnsssssssscdddddiiiiiiiiiiiiiiiiiiio      eeeeeeeeeeeeeeeeeeaaaaaaa ieoooooooooooo_~Ÿqjɻ^ZYQ`K?9 '@8Ҵ3J######################################################################################################{$zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX44444444444444444444444444444444444444444444444444444444444}\*|||||||||||||||||||||||||||||||||||||||||||||||||||k2222222222222222222222222222222222222222222222222!7D6<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<VU=h555555555555555555555555555555555555555555555555555555555555555555&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&B>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvWWWWWWWWWWWWWWWWWWWWWWWWWWWWW






















11111111111111111111111111111111111:																					.MwG]xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[)/,L;-yPPPPPPPPPPPPPPPPPPPPPPPPINR"Fm++++++++++++++++++++++++++++T0A%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ppppppppppppppppppppppppppppppppppC(((((((((((((((((((((((((((((((rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrfSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSluuuuuuuuuuuuOOOOOOOOOOOOOOOOOOOcbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbggggggggggggggggggggggggggtnasddddddddd        eeeeeeeeeeeeiooooo