//---------------------------------------------------------------------

function NewMission::setValues()
{
   // fill in 'Number of Teams'   
   Popup::clear(NumTeams);
   for(%i = $missionTypes[$NM::missionIndex, minTeams];
      %i <= $missionTypes[$NM::missionIndex, maxTeams]; %i++)
      Popup::addLine(NumTeams, %i @ " teams", %i);
   Popup::setSelected(NumTeams, $NM::numTeams);
      
   // do 'missiontype'
   Popup::clear(MissionType);
   for(%i = 0; $missionTypes[%i, type] != ""; %i++)
      Popup::addLine(MissionType, $missionTypes[%i, description], %i);
   Popup::setSelected(MissionType, $NM::missionIndex);

   // do 'WorldType'
   Popup::clear(WorldType);
   for(%i = 0; $worldTypes[%i, type] != ""; %i++)
      Popup::addLine(WorldType, $worldTypes[%i, type], %i);
   Popup::setSelected(WorldType, $NM::worldIndex);
   
   // do 'skytype'
   Popup::clear(SkyType);
   %wi = $NM::worldIndex;
   for(%i = 0; $worldTypes[%wi, skyname, %i] != ""; %i++)
      Popup::addLine(SkyType, $worldTypes[%wi, skyname, %i], %i);
   Popup::setSelected(SkyType, $NM::skyIndex);
   
   // do 'terraintype'
   Popup::clear(TerrainType);
   for(%i = 0; $terrainTypes[%i, type] != ""; %i++)
      Popup::addLine(TerrainType, $terrainTypes[%i, description], %i);
   Popup::setSelected(TerrainType, $NM::terrainIndex);

   // do 'terrainsize'
   Popup::clear(TerrainSize);
   for(%i = 0; $terrainSizes[%i, name] != ""; %i++)
      Popup::addLine(TerrainSize, $terrainSizes[%i, name], %i);
   Popup::setSelected(TerrainSize, $NM::terrainSizeIndex);
   
   Control::setValue(MissionName, $NM::MissionName);
   
   // setup the variables
   %mi = $NM::missionIndex;
   Popup::clear(varSelect);
   for(%i = 0; $missionTypes[%mi, varName, %i] != ""; %i++)
      Popup::addLine(varSelect, $missionTypes[%mi, varDesc, %i], %i);
   Popup::setSelected(varSelect, $NM::varIndex);
      
   eval("%i = $" @ $missionTypes[%mi, type] @ "::" @ $missionTypes[%mi, varName, $NM::varIndex] @ ";" );
   Control::setValue(varValue, %i);
}

//---------------------------------------------------------------------
// callbacks

function NumTeams::onSelect(%string, %level)
{								
   $NM::numTeams = %level;
   NewMission::setValues();
}

function MissionType::onSelect(%string, %level)
{		
   if(%level != $NM::missionIndex)
   {
      // check if need to select a new number of teams
      if(($NM::numTeams < $missionTypes[%level, minTeams]) ||
         ($NM::numTeams > $missionTypes[%level, maxTeams]))
         $NM::numTeams = $missionTypes[%level, minTeams];
         
      $NM::missionIndex = %level;
      $NM::varIndex = 0;
   }					
   NewMission::setValues();
}

function WorldType::onSelect(%string, %level)
{
   if($NM::worldIndex != %level)
   {
      $NM::worldIndex = %level;
      $NM::skyIndex = 0;
   }
   
   NewMission::setValues();
}

function SkyType::onSelect(%string, %level)
{
   $NM::skyIndex = %level;
   NewMission::setValues();
}

function TerrainType::onSelect(%string, %level)
{
   $NM::terrainIndex = %level;
   NewMission::setValues();
}

function TerrainSize::onSelect(%string, %level)
{
   $NM::terrainSizeIndex = %level;
   NewMission::setValues();
}

function varSelect::onSelect(%string, %level)
{
   $NM::varIndex = %level;
   NewMission::setValues();
}

function varValue::onAction()
{
   %val = Control::getValue(varValue);
   %mi = $NM::missionIndex;
   eval("$" @ $missionTypes[%mi, type] @ "::" @ $missionTypes[%mi, varName, $NM::varIndex] @ " = " @ %val @ ";" );
}

//-----------------------------------------------------------------------

function NewMission::create()
{
   focusClient();
   disconnect();
   
   NewMission::createServer();

   %mi = $NM::missionIndex;
   %si = $NM::skyIndex;
   %wi = $NM::worldIndex;
   %ti = $NM::terrainIndex;
   %missionName = String::convertSpaces($NM::missionName);
   %worldName = $worldTypes[%wi, type];
   %timeOfDay = $worldTypes[%wi, time, %si];
   %worldVolName = strcat(%worldName, "World", ".vol");
   %terrVolName = strcat(%worldName, "Terrain", ".vol");
   %terrFileName = strcat(%missionName, ".dtf");
   %dmlName = strcat(%worldName, ".dml");
   %palName = strcat(%worldName, ".", %timeOfDay, ".ppl");
   %tedFileName = strcat(%missionName, ".ted");
   %dscName = "base\\missions\\" @ %missionName @ ".dsc";
   %missionName = strcat("base\\missions\\", %missionName, ".mis");
   %rulesName = strcat(%worldName, ".rules.dat");
   %gridName = strcat(%worldName, ".grid.dat");

   // Default groups
   newObject("MissionGroup", SimGroup);
   newObject("Volumes", SimGroup);
   newObject("World", SimGroup);
   newObject("Landscape", SimGroup);
   newObject("Lights", SimGroup);
   addToSet("MissionGroup", "Volumes", "World", "Landscape", "Lights" );

   // Default volumes
   newObject("World", SimVolume , %worldVolName);
   newObject("WorldTerrain", SimVolume , %terrVolName);
   newObject("InterfaceVol", SimVolume, "interface.vol");
   newObject("Entities", SimVolume, "entities.vol");
   addToSet("MissionGroup\\Volumes", "InterfaceVol", "Entities", "World", "WorldTerrain");

   // Register the world's DML volumes (Contained in %terrVolName)
   exec("createWorldVolumes.cs");

   // World palette
   newObject("Palette", SimPalette, %palName, true);
   addToSet("MissionGroup\\World", "Palette");

   // add the sky
   %skydmlName = $worldTypes[%wi, skydml, %si];
   if(%skydmlname == "starfield")
   {
      newObject(Stars, StarField);
      addToSet("MissionGroup\\Landscape", Stars);
      %skydmlName = "";
   }
      
   newObject(Sky, Sky, 0, 0, 0, %skydmlName, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
   addToSet("MissionGroup\\Landscape", Sky);

   // Default sun light
   if(%timeOfDay == Night)
      newObject("Sun", Planet, 0, 0, 60, T, F, 0.4, 0.4, 0.4, 0.15, 0.15, 0.15);
   else 
      newObject("Sun", Planet, 0, 0, 60, T, F, 0.7, 0.7, 0.7, 0.3, 0.3, 0.3);
   addToSet("MissionGroup\\Landscape", "Sun");

   // create the teams
   newObject("Teams", SimGroup);
   addToSet(MissionGroup, Teams);
   for(%i = 0; %i < $NM::numTeams; %i++)
   {
      newObject("Team" @ %i, TeamGroup);
      addToSet("MissionGroup\\Teams", "Team" @ %i);

      // Default team setup      
      newObject("DropPoints", SimGroup);
	   newObject("Start", SimGroup);
	   newObject("Random", SimGroup);
	   addToSet("DropPoints", "Start", "Random");
	   addToSet("MissionGroup\\Teams\\team" @ %i, DropPoints);
   }

   // create the mission....
   flushExportText();
   eval(Mission:: @ $missionTypes[$NM::missionIndex, type] @ "::create($NM::numTeams);");
   eval( "%i = $" @ $missionTypes[$NM::missionIndex, type] @ "::" @ "cdTrack;");
   addExportText("$cdTrack = " @ %i @ ";");
   eval( "%i = $" @ $missionTypes[$NM::missionIndex, type] @ "::" @ "cdMode;");
   addExportText("$cdPlayMode = " @ %i @ ";");

   // get the size
   %ts = $terrainSizes[$NM::terrainSizeIndex, size];

   // ground scale (1 << n ) meters per block
   %gs = 3;

   // width in meters
   %tw = %ts * (1 << %gs);

   // create the simterrain obj
   %terrain = newObject("Terrain", SimTerrain, Create, %terrFileName, 3, %gs, %ts, 0, 0, -(3 * %tw / 2), -(3 * %tw / 2), 0, 0, 0, 0);
	newObject("MissionCenter", MissionCenterPos, -(%tw / 2), -(%tw / 2), %tw, %tw);

   // set the detail (perspective distance, screensize)   
   setTerrainDetail(Terrain, 100, $terrainTypes[%ti, screenSize]);
   setTerrainVisibility(Terrain, $terrainTypes[%ti, visDistance], $terrainTypes[%ti, hazeDistance]);
   SetTerrainContainer(Terrain,"0 0 -20.0",0,10000);  //  (Terrain,Gravity,Drag,Height)

   // apply the terrains
   LS::Create(1);
   LS::Textures(%dmlName, %gridName);

   // execute the terrain file and apply the rules
   exec(%worldname @ ".terrain.cs");
   eval(Terrain:: @ %worldname @ "::setRules();");
   
   // process the terrain commands for this type
   LS::flushCommands();
   eval(Terrain:: @ $terrainTypes[%ti, type] @ "::create(" @ %ts @ ");");
   %terrain.terrainType = $terrainTypes[%ti, type];
   LS::parseCommands();
   
   LS::ApplyLandscape();
   LS::ApplyTextures();

   // save off the terrain   
   saveTerrain(Terrain, "base\\missions\\" @ %tedFileName);
   
   // reevaluate the path
   $ConsoleWorld::DefaultSearchPath = $ConsoleWorld::DefaultSearchPath;
   
   newObject("TedFile", SimVolume, "missions\\" @ %tedFileName);
   addToSet("MissionGroup\\Volumes", "TedFile");
   addToSet("MissionGroup\\Landscape", "Terrain");
   addToSet("MissionGroup\\World", "MissionCenter");

   // fill out the mission description
   $MDESC::Type         = $missionTypes[%mi, description];
   $MDESC::Text         = "<s3><f1>Mission Type: <f0> " @ $MDESC::Type @
      "\n<f1>Planet: <f0> UberPrime" @
      "\n<f1>Weather: <f0> Not Too Bad" @
      "\n<f1>Time of Day: <f0> " @ %timeOfDay @
      "\n<f1># of Teams: <f0> " @ $NM::numTeams @
      "\n\n<f1>Briefing:<f0> The greater the difficulty, the more the glory in surmounting it.";
   export("$MDESC::*", %dscName);

   // save the mission - toss the old stuff
	exportObjectToScript(MissionGroup, %missionName, true);
   flushExportText();
   
   // reevaluate the path
   $ConsoleWorld::DefaultSearchPath = $ConsoleWorld::DefaultSearchPath;
   MissionList::build();
   
   NewMission::exit($NM::missionName);
}

//-----------------------------------------------------------------------

function NewMission::exit(%mission)
{
   focusClient();

   // get rid of the dialog and do mouse things
   if(!$NM::cursorOn)
      cursorOff(MainWindow);
   
   // check if hit cancel
   if(%mission != "")
      schedule("NewMission::doCreate(\"" @ %mission @ "\");", 1); 
   else
      GuiPopDialog(MainWindow, 0);
}

//-----------------------------------------------------------------------
// this needs to be scheduled because the create is called through
// a buttons onaction (the button gets destroyed by this function)
function NewMission::doCreate(%mission)
{
   $ConnectedToServer = false;
   deleteServer();
   purgeResources();
   deleteObject(ConsoleScheduler);
   newObject(ConsoleScheduler, SimConsoleScheduler);
   exec(editor);  // pre-load the editor
   createServer(%mission, false);
}

//-----------------------------------------------------------------------

function NewMission::reset()
{
   // initialize all the tables...
   exec(missiontypes);
   exec(worlds);
   exec(terrains);

   // set the defaults 'NM for NewMission'
   if($NewMissionName != "")
   {
      $NM::missionName = $NewMissionName;
      $NewMissionName = "";
   }
   else
      $NM::missionName        = "NewMission";
   $NM::missionIndex       = 0;
   $NM::numTeams           = $missionTypes[$NM::missionIndex, minTeams];
   $NM::worldIndex         = 0;
   $NM::skyIndex           = 0;
   $NM::terrainIndex       = 0;
   $NM::terrainSizeIndex   = 0;
   $NM::terrainSeed        = 0;
   $NM::varIndex           = 0;

   NewMission::setValues();

   // get the mouse setup
   $NM::cursorOn = isCursorOn(MainWindow);
   if(!$NM::cursorOn)
      cursorOn(MainWindow);
}

//-----------------------------------------------------------------------
// initialization

GuiPushDialog(MainWindow, "gui\\newmission.gui");
NewMission::reset();
   
// end initialization
//-----------------------------------------------------------------------

// grabbed from server.cs
function NewMission::createServer()
{
   deleteServer();
   purgeResources();
   newServer();
   focusServer();

   newObject(serverDelegate, FearCSDelegate, true, "LOOPBACK", $Server::Port);

   exec(admin);
   exec(Marker);
   exec(Trigger);
   exec(NSound);
   exec(BaseExpData);
   exec(BaseDebrisData);
   exec(BaseProjData);
   exec(ArmorData);
   exec(Mission);
   exec(Item);
   exec(Player);
   exec(Vehicle);
   exec(Turret);
   exec(Beacon);
   exec(StaticShape);
   exec(Station);
   exec(Moveable);
   exec(Sensor);
   exec(Mine);
   exec(AI);
   exec(InteriorLight);
   preloadServerDataBlocks();
}
h~qݷ`_^ZYXẺQѶJ&?ؽ[׸{!22222222222222222222222222222222222222222222EEEEEEE84 #79999999999999999999999999999999999999999HUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG----------------------------<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjWWWWWWWuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuc'''''''hhhhhhhhhhhhhhhhhhhhhhhhhuuuuuuubnnnnnnnccccccccccccccccccccccccc'wwwwwwwbbbbbbbbbbbbbbbbbbbbbbbb))))))))))))))))))))))-<cccccccunnnnnnnnnnnnnnnnnnnnnnnnnnnnnnncnhhhhhhhuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu(Sbnluccccccccccccccccccccccccccccccccccccccc             hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhnuuuuuuuuuuue             KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKlllllllcccccccccccccccccceeeeeee                      FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFR!222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222-NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN>IE3G+jjjjjjjjjjjjjjjjjjjjjjjjjjjjjhg)''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwSb(nuccccccccccccccccccccccccce                       llllllllllllllleeeeeeeeeeeeeeeeeccccccccccccccccccn             luuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue                                      bg,,,,,,,,,,,h<ccccccccccccccccccSnllllllllleeeeeee                                   uuuuuuuuuuuuuuue              ccccccccccc                nnnnnnnnnnnnu(((((((((((((((eeeeeeee                             lllllllllllllllnmC-NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNhhhhhhhhhhhhhhh........................)Pc1MW''''''''''''''''''g,bbbbbbbbbe uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuullllllllllllllllll(<wwwwwwwwwe                                   enuuuuuuuuuuuuuuuuuuuuSccccccccccclllllllll                                            eeeeeeeeeeeeeeeeeeeeeeeeee             SSSSSSSSSSSSSSSme((((((((((((((((hhhhhhhhhhhhhhhhhhug,:bnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnccccccccccccccc                              eeeeeeellllllllllllllllllllllllllllllllllllllllllllllllllllllluuuuuuuuu                  nnnnnnnnnnnnnnelllllllllllllllllllccccccccc                             eeeeeeeeeeeeeeeeeeeeepv
AB]]]]]]]]]]]]]]]]]]]]];
//////////////////////////////////////////////////////////////////////////////////////////////6																																																																																																				OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO|@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@5z*#[{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}844444444444444444444444444444444444444tGV9H7KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFRCTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT2>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>.!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!IEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE31111111111111111111111111111111111111111111111Ujjjjjjjjjjjjjjjjjjjjjjjjjjjjj+N<------------------------)WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWPM :Sm((((((((((((((((((((((((((hhhhhhhhhhhhhhhhhhhhhh'g,,,,,,,,,,,,,,,,,,ecunlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllle                                         nnnnnnnnnnnn aaaaaaaaaaacstbbbbbbbbbbbbbbbbbeeeeeeeeeeeeeuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeeeeeeee llllllllllllllllllllllllllllllllllllll:::::::::::::::mppppppppppppppppSw(,hnnnnnnnncattttttttttttttttttttttsssssssssssssssssssssssse       lbgggggggggggggggggggggggggggggggggggggggggggggggeeeeeee uuuuuuullllllllllllllllllltccccccccccccannnnnnnnnnnusssssssssssssssssssssssssssssssssssse                                                                  eeeeeeelllllllllllllllll%v.............................................................kC111111111111111111111111TN<u:""""""""""""""""""""""""""-P)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))m,pSwMb(((((((((((((((((tncccccccccccccae                  hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhsssssssse                                         gu nnnnnnnnnnnnnnnnnnnnnnnntlcccccccccccccccccesaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeeeee                                    gggggggggggggggggsrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr,"Smbpppppppppppppppppp':((((((((((((((((((((nllllllllllllutttttttttttttttttttttttte                 ccccccccccccccccccccccccccccccccccccccccccccccceeeeeee aaaaaaaaaaaaaaaaarossssssslllllllllllllunhhhhhhhhhhhhatttttttttttttttttttttttttttttttttttte                      cccccccccccccccccccccccccccccccceeeeeeeS00000000000000000000\yyyyyyyyyyyyyyyyyyyyyyyyy===================x$OOOOOOOOOOOOOOOOOOOOOOO]]]]]]]]]]]]]]]]]]]]]]]]]]]]
A;BBBBBBBBBBBBBBBBBBBBBGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGV
/>FRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRI22222222222222222222222222222222222222222222!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEW3jjjjjjjjjjjjjjjjjjjjjjjjjjjjjllllllllllllllllllllllllD%vvvvvvvvvvvvvvvvvvvvvvvvvv+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++kCCCCCCCCCCCCCCCCCCCCCC.TNg<111111111111111-P,,,,,,,,,,,,,,,,,w)))))))))))))))))))))))))))))))))))))))))))))))))))"omb:prrrrrrh'''''''''''''''''''''''''''''''sssssssssssssuane ccccccccccccccccccccccccccccccccccccccccccccccccccttttttttttttte                                        tooooooooooolr( aaaaaaaaaaaaacusnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                               rrrrrrrrrrrrrrr,Sggggggggggggggggggggggggggggggggggggggggggggggget::::::::::::::::::::::::::"mhboooooooocl(passssssssssssssssssssssssssssssss            uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       nnnnnnnnnnnnnnnnnnnnnrrrrrrrrrrrctttttsolMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeee nnnnnnnnnnnnnnnnnnnnnnnnnnnnnuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       :dfyyyyyyyyyyyyyyyyyyy\\\\\\\\\\\\\\\\\\\\\\\\0%%%%%%%%%%%%%%%%%%%%sTDvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv-kCCCCCCCCCCCCCCCCCCCCCC'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''N<,1.gPwwwwwwwwwwwwwwwwwwSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSrhhhhhhhhhhhhhhhhhcccccccccccccccc"(mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmtolnM)b uaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeee                                                        sccccccccccccrrrrrrrrrrrrrrrrrrrrrrrtolnpuuuuuuuue                                                              eaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaai,g::::::::::::::::::dddddddddddddddfhS s(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("celrrrrrrrrrrrtpmooooooooooooooooooooooooooannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeee            uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuusillllllllllllllllllllllbcrrrrrrrrrrrattttttttttttttttttte            uoooooooooooooooooooonnnnnnnnnnnnnnnnnnnnnneeeeeee            x'މ~q`_^YXZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ&QƶJ?ٹҽż׸666666666666666666666666666666666666 	#|@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@z*59{}[K4444444444444444444444444448888888888888888888888888HLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL77777777777777777;=$OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO]]]]]]]]]]]]]]]]]]]]]]]]]]]]
>>>>>>>>>>>>>>>>>>>>>>>BBBBBBBBBBBBBBBBBBBBBIAV







































































GFRW/2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE!!!!!!!!!!!!!!!!!!!!!!!!3j%\T0vvvvvvvvvvvvvvvvvvvv-DCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCykb1111111111111111111111111111111111111111111111111111111111111111111111111111111111NM<.Pg::::::::::::::::::dddddddddddddddfhS((((((((((((((,,,,,spppppppppppppppppppppppppppppppwlllllllllllllllllllllllllll"iiiiiiiaaaaaaaaaaaaacruuuuuuuuuuuuuuuunttttttttttttttttttttttttttttttte                           oooooooooooooooooooooooooooeeeeeeeeeeeeeeelmsaaaaaaaaaaaaoiiiiiiiiiiiiicruuuuuuuuuuune                                                                e ttttttttttttttttttttttttttttttttob:::::::::::::::::dgffffffffffffffffffSSSSSSSSSSSSSSSSSSSSSSSSSSSShhhhhhm(,pa))))))))))))))))ls rrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiccccccccccccccccceeeeeeeeetuuuuuuuuuuuuuuuuuuuuuuue                                        nnnnnnnnnnnnnealor""""""""""""""""""ssssssssssssitttttttttttttttttttttttttttttttt                    ncccccccccccccccccccccccuuuuuuuuuuue                          mmmmmmmmmmmmmmmmmmmmmmmm%'TTTTTTTTTTTTTTTTTTTv\-0CCCCCCCCCCCCCCCCCCCCyD1+++++++++++++++++++++++++++++++++++++++++kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk:NMd<.fffffffffffffffffSgggggggggggggggggggggggggggggggbbbbbbbbbbbbbbbbbbbbbbbbl)Phr(,aooooot"pssssssssssssniiiiiiiiiuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeee                                   ccccccccccccccccccccccce             raaaaaaaaaaatlcoooooooooooooooossssssssssssniu                                        eeeeeeeeeeeeeeeeeeeeee                                                  cdfmS::::::::::::::::::::::::::::::bgwwwwwwwwwwwwwwwwwwwwwwwwwwa"""""""""""""""th(rrrrrrrrrrrrrrrrrrrrrrrrrrrloooooooooooooooo,isssssssse                   nnnnnnnnnnnnnnnnnnnnnnnnnn                      eeeeeeeeeeeeeeeeeeeeeuuuuuuuuuuu trccccccccccccaeiiiiiiiiiiiloooooooooooooppppppppppppppppppppppppppppppppppppppppppppppussssssssssssssennnnnnnnnnnnnn                                                              L;x">>>>>>>>>>>>>>>>>>>>>>>>>=$IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII]]]]]]]]]]]]]]]]]]]]]]]]]]]]UOOOOOOOOOOOOOOOOOOOOOOOBW
AVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
/222222222222222222222222222222222222222222222222RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR%EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEET!3v'-------------------C\y01111111111111111111111111111111111111111111Di)+jkkkkkkkkkkkkkkkkkkkkkkfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffNSM<<<<<<<<<<<<<<mb:w.................dggggggggrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrhtccccccccccccccccccccccaaaaaaaaaaaluooooooonp(((((e                                                     sssssssseeeeeee                           tiiiiiiiiiiiiirscaaaaaaaaaaaluonnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnne                               ,,,,,,,,,,,,,,,,,,,,,,,eeeeeeesSSSSSSSSSSSSSS"bfPmd::::::::::::::::::::::::::::::::::::::tpgggggggggggggggggggggggggggggggggggggggggggggggggggggggiiiiiiiiilrcaoooooooooooe          ,huuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue                 nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnslt oirc(aaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnnnnnnnnnne uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuupTvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv-%C'yyyyyyyyyyyyyyyyyyy1\\\\\\\\\\\\\\\\\\\\\\\\0))))))))))))))))))))owDDDDDDDDDDDDDDDDDDDDDDDDDDDDDkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkbNMP<"dffffffffffffffffmS:eeeeeeeeeeee,,,,,,,,,,,,,,,,,lggggggggggggggggggggggggggggggssssssss(((((((((((((((tirncccccuaaaaaaaaaa                                                                    e                                   lllllllllllllohhhhhhhhhhhhhhhhhhhhhhstirncuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeee                                            aaaaaaaaaaaaaae                 b.pddddddddddddddddddddddddddddd"Sf,mmmmmmmmmmmmmmmmm(:hgggggggggggggggggggggggggggggggggglooooooorrrrrrrrrrrrstci                       annnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeee                         uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuulllllllllllrrrrrrrrrrrrrrrrrrrrcoooooooooooosatttttttte                          uiiiiiii      nnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeewwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww###########################################6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666																																																								9@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@|K*5z}[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{84;HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH>L(U7xxxxxxxxxxxxxxxxxxxxxxxxx=WIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII]]]]]]]]]]]]]]]]]]]]]]]]]]$OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBGEV
/+FRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv2--------------------------------------------!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCy%1'''''''''''''''''''''''''''''''''''''''''')\T0cPPPPPPPPPPPPPPPPPPPPDDDDDDDDDDDDDDDDDDDDDDDDDDDDD3..................................................................................NdMkkkkkkkkkkkkkkkkpSSSSSSSSSSSSSS,"bf llllllllllllllllllmr:hhhhhhhhhhhhhhhhhhhhhhheaaaaaaaaaaaaaaagooooooooooooussssssssssntttttttttttttttttttttttttttttttttttttttttttttttttteeeeeeeeeeeeeei                                       rrrrrrrrrrrrrcaliiiiiiiiiiiiiiiiiiiiiiiiiiioooooooooooousnnnnnnnnnnnnnnnnnnnne                                                            teeeeeee            idddddddddddddddd(S<,pbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb""""""""""""""""""""""""""""""""""""fam:rcccccccccccccccclllllllllllllllllllllllllllhsoooooooooooooooooooooooooootuuuuuuue                                                     neeeeeeeeeeeeeariiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiscllllllllllltge                                nooooooooooooooooooooue                                                     -Cwyv111111111111111111111111111111111111111111111111111111%)'TTTTTTTTTTTTTTTTTTTP\sM00000000000000000000DDDDDDDDDDDDDDDDj.SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS,(b<NNNNNNNNNNNNNNNNNNpdddddddddddddddddddrrrrrrrrrrrrrrrrr""""""""""""fmai tttttttttttttclnnnnnnnnnnnnnnnnnnug:eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 ooooooooooooooooooooooooooooooooooooeeeeeeeeeeeeastroiiiiiiiiiiiiiclnnnnnnnnnnnuuuuuuuuuuuuuuuuuuuuu                                       eeeeeeeeeeeeeeeeeeeeh                          oS,,,,,,,,,,,,,,,bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb(dkkkkkkkkkkkkkkkkkppppppppaggggggggggggggt"ffffffffffffsssssssssslriiiiiiiiiiiiiiiiiiiiiiicccccccccccccccccccehmnnnnnnn                                                   eeeeeeeu           ttttttttttttolaaaaaaaaaaaaaaaaasri:::::::::::::                                    eucccccccccccccccccccccn                                eeeeeeeM>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>;ggggggggggggggggggggggggggLxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII=$OE]]]]]]]]]]]]]]]]]]]]]]]]]]]]
+++++++++++++++++++++++BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBAV




























GFRCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC/y222222222222222222222222222222222222222222221wwwwwwwwwwwwwwwwwwwwwwwwv)))))))))))))))))))))))))))))))T%P'-----------------------------<\00000000000000000000,Dj!b.....................................................dddddddddddddddddddddddddddddddd(Skkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkhpllllllllllllll"toooooo:fasruiennnnnnnnnnnnn                                                    ecccccccccccccccccccccccccccccccccccccccc ltttttttttttmmmmmmmmmmmmcoasruinnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                cbbbbbbbbbbbbbbbbbbgd,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,SSSSSSSSSSSSSSSSh(et:Nmmmmmmmmmmmmmm"pllllllllllllllllllrrrrrrrrrrrroaissssssssssssssssssss             uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       nnnnnnnnnnnnnnnnnnnnntlcrfffffiiiiiiiiiiiiiiiiiiiiiioooooooooooooaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeee nsssssssssssssssssuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       :y1MMMMMMMMMMMMMMMMMMMMMMMMC)wTvPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP-%<'ikkkkkkkkkkkkkkkkkkk\0000000000000000000000000000000000000Dd3.................gS,hhhhhhhhhhhhhhhbbbbbbbbbbbbbbbbbbbbbbl"(rNNNNNNNNNNNNNNNNNNNNNNmtcccccccccccccccccccccfffffffffffffffffffffffffffffffffffno uaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeee ssssssssssssssssssssssssssssssssssssssssssssrtiiiiiiiiiiiiilscppppppppppppppppppppppnouuuuuuuue                                                              eaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasddddddddddddddddd:SSSSSSSSSSSSSSSSSShgb,""""""""""""""" tffffffffffffffffffffffffffff(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((rieeeeeeeeeeeelcpmooooooooooooooooooooooooooooooooooooannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeee            uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuurssssssssssssttttttttttoilcaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaae            uuuuuuuuuuuuuuuuuuuuuuuuuuuuuunnnnnnnnnnnnnnnnnnnnnneeeeeee                                     kމȁ~`qX_^YZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ&QƾJԶ?ٹ߽ż6																																																																			#####################################                                                                                                        555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555559[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[|K8@zU*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}4H>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>ffffffffffffffffffffffffffffffffffffffffffffffff;LxEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEWI+++++++++++++++++++++++++=$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]OOOOOOOOOOOOOOOOOOOOOOOBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
AVjjjjjjjjjjjjjjjjjjjjjGF1R























/2)MTCPw-v<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<y%oN'''''''''''''''''''\\\\\\\\\\\\\\\\\00000000000000000000SD33333333333333333333333333333333333333333333h:bbbbbbbbbbbbbbbbbb"gd,,,,,rppppppppppppppppppppppppppppppppppppppppp(((((((((((((sssssssatiluccccccnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn...............................e                                                               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoarrrrrrrrrrrstilucne                                                                e mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmShfbbbbbbbbbbbbbbbbb":ddddddddddddddddddpggggggggggggggggggggggggggggggg,aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaao lrstciiiiiiiiiiiiiiiiieeeeeeeeem(uuuuuuuuuuuuuuuuuuuuuuue                                        nnnnnnnnnnnnneaaaaaaaaaaaaaaaaaaaaaallllllllllllllllllllcorsssssssssssssssssssssstttttttttttttttttttt                    niiiiiiiiiiiiiiiiiiiiiiiuuuuuuuuuuue                                                              )kT1PM-C<wyvNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc%'''''''''''''''''''h\0bbbbbbbbbbbbbbbbbbbbD"fdddddddddddddddddp:SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSmgl,,,,,,,,,,,,,,,aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!!!!!!!!!!!!!!!!!!!!!!!!!!!!ornsssssssssutttttttttttttteeeeeee                                   iiiiiiiiiiiiiiiiiiiiiiie             lac((((((((((((iiiiiiiiiiiiiiiiiiiiiiiornsu                                        eeeeeeeeeeeeeeeeeeeeee      tttttttttttttttttttttttttttttttttib""""""""""""""dhpfSSSSSSSSSSSSSSSSSm:::::::::a..................(,,,,,,,,,,,,,,,glccccccrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrsooooooooe       tnnnnnnnnnnnnnnnnnnnnnnnnnn                      eeeeeeeeeeeeeeeeeeeeeuuuuuuuuuuu alirrrrrrrrrrrrrrrresccccccccccccccccccccccttttttttttttttttttttttttttttttttttttttttttttttttttttttttttuooooooooooooooennnnnnnnnnnnnn                                                                                            >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>.E7;L+xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWIIIIIIIIIIIIIIIIIIIIIIIII=============================$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]OOOOOOOOOOOOOOOOOOOOOOOjB
ARVVVVVVVVVVVVVVVVVVVVVG3F
/)kT1PM-C<wyvNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNssssssssssssssssssssss'''''''''''''''''''\"00000000000000000000dbppppppppppppppShmf%DDDDDDDDDDDDDDDDDDDDDDDDlllllllllllllll:rrrrrrrrrrrrrrrrrr(aiiiiiiiiiitttttttttttttttt,ccccccccccccuuuuuuuuuuuuuuuuunnnnnnnnnnnnnnnnne                                                     ooooooooeeeeeee                rastloigccccccccccccuuuuuuuuuuunnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnne                                                                 eeeeeeeodp"Sbmmmmmmmmmmmmmm!2hhhhhhhhhhhhhhhfffffffaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaat::::::::::::::::::rsssssssssssssssssssslig(((((((((((ce                      uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue                 nnnnnnnnnnnnnnnnnnnnntrooooooooooooa           sliiiiiiiiiiiii,,,,,,,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeenccccccce uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu.kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk1)MTCPw-v<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<yyyyyyyyyyy%NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNp'''''''''''''''''''S\0m"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""bbbbbbbbbbbbbbbbbbbbbbbbbbbbdhergffffffffffffffffffffffffffff:tooooooooooooooooooooaslniiiiiu,,,,,,,,,,,,,,,,,,,,,,,,,,,                                                          ce                                              tttttttttttttttttttttttrcoaslniuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeee                                            ((((((((((((((e       cSmmmmmmmmmmmmmmmmDppppppppppppppp"dbggggggggggggggggggt,hhhhhhhhhhhhhfffffffffffffffffffffffffffffffffffffffffffflroais                       (:nnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeee                         uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuclttttttiiiiiiiiiiirooooooooooooooooooaaaaaaaae                          usssssss      nnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	555555555555555555555555555555######################################[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[6888888888888888888888888888888888888888888888888888888889999999999999999999999999999999999999999999U|KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKz@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{************************************************}4E>,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7H;;;;;;;;;;;;;;;;;;;;;;;;;;;;;+xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxLIIIIIIIIIIIIIIIIIIIIIIIIIjW$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$R============================O3]B
!!!!!!!!!!!!!!!!!!!!!!!VVVVVVVVVVVVVVVVVVVVVkGA1F
MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMC)wTvPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP-.<iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii/yNNNNNNNNNNNNNNNNNNNNNNNNmmmmmmmmmmmmmmmmmmmmmm'D\000000000000000000000000000000000000000000000000dpg"Sb            ((((((((((((((lhfffffffffffffceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetttttttttttruoooooooooonaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeees                                       llllllllllllli::::::::::::sctttttttttttruonnnnnnnnnnnnnnnnnnnne                                                            aeeeeeee            smmmmmmmmmmmmmmm,ddddddddddddddddddddggggggggggggggggSp("""""""""""""""""""""""""""""""""""""""b:hffffffffffffffliiiiirrrrrrrrrrrrctoooooooooooooooooooooooooooooooooooooauuuuuuue                                                     neeeeeeeeeeeeeeeeeeeeeeeeelsrrrrrrrrrrrrrrrrrrrrrrrrroiiiiiiiiiiiicate                                nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnue                                                        1M%Ckwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwv)))))))))))))))))))))))))))))))T.P2-o0<yNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNd'Dg,SSSSSSSSSSSSSSSSSSSS\((((((((((((((((mpppppplf"rb:::::::::::::s aaaaaaaaaaaaaaaaahiiiiiiiiiiiinccccccccuteeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                              errrrrrrrrrrrroalllllllllllssssssssssssssiiiiiiiiiiiincuuuuuuuuuuuuuuuuuuuuu                                       eeeeeeeeeeeeeeeeeeeet                                    dggggggggggggggggggSSSSSSSSSSSSSSS(,mmmmmmmmmmmmmmmmmmmfffffffffffffffffffffffffffffffffffffffffffffffffffpa"brooooooooooooooooooooolssssssssssssss:ciiiiiiiiiiiiiiiiiiietnnnnnnn                                                   eeeeeeeu           arrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrcolsth                                    euiiiiiiiiiiiiiiiiiiiiin                                eeeeeee0EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>jjjjjjjjjjjjjjjjjjjjjjjjjjjjj+xR;LI33333333333333333333333333333333333W$!!!!!!!!!!!!!!!!!!!!!!!!!============================GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG]BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBOOOOOOOOOOOOOOOOOOOOOOOVMMMMMMMMMMMMMMMMMMMMM
CAFw%vkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk.)2
T1Pcccccccccccccccccccc-<ygNNNNNNNNNNNNNNNNNNNNNNNNSSSSSSSSSSSSSSSSSSSSSS'((((((((((((((((((mmmmmmmmmmmmmmmf,dddddddddddddddddddDDDDDDDDDrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrp"aaaaaaaaaaaaaaaatttttttttttttolusenhb                                                    eiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii            actriiiiiiiiiiiiiiiiiiiiiiiolusnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                     ::::::::::::::::::::::::::::::::iS(((((((((((((((((mgffffffffffffffffffdddddddddddddddddddddddddddd,eah\ttttttttttttttttppppppppppppcccccccclrrrrrrrrrrrrrrrrrrrrrrrsoooooooooooooooooooo :"uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       nnnnnnnnnnnnnnnnnnnnnttttttttttttilaaaaascrrrrrrrrrrrbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbeeeeeee nooooooooooooooooouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue       hCw0vMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM%.k/////////////////////////////////////////////////////////////1))))))))))))))))))))TsssssssssssssssssssP-<(yNmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmfffffffffffffffffdgggggggggggggggggggggggggggggggSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS:,l\''''''''''''''''tiiiiiiiiibpacrnnnnnnnnnnn uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooooooooooooooooooooooooolts""""""""""""oiacrnnnnnnnnnnnuuuuuuuue                                                              eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeomfhd((((((((((((((((((((((((((((((Sg:::::::::::::::::: tbbbbbbbbbbbbbbb"DDDDDDDDDDDDDDDD,lserrrrrrrrrrrriaaaaaaaaaaaccccccccccccccccccccccccccccccccccccccnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeee            uuuuuuuuuuuuuuuuuuuuuutlorppppppppppppppppppppssssssssssssiiiiiiiiiiiiiaaaaaaaaaaaaaaaaaaae            uccccccccccccccccccccnnnnnnnnnnnnnnnnnnnnnneeeeeee                                                             ޔqȌ~`YXQ_^Z&ƽJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ?ٹż׸##################################################	59[KKKKKKKKKKKKKKKKKKKKKKKKKKKKKK68                                                                                              UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU7|@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@{zE*}bRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR>>>>>>>>>>>>>>>>>>>>>>>>>>3jjjjjjjjjjjjjjjjjjjjjjjjjjjjj+!!!!!!!!!!!!!!!!!!!!!!!!!!!4;LGxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWIIIIIIIIIIIIIIIIIIIIIIIII=====================$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$]2222222222222222222222222222OOOOOOOOOOOOOOOOOOOOOOOwVBv
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA0.M/F%1kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkC)))))))))))\TP-f<ydNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNhS(:::::::::::::::::mggggglllllllllllllllllllllllllllllllllrrrrrrrrrrrrrrr"tooooooooooooooooooopDDDDDDDDDDDDDDDDDDDDDDssssssssssssuiiiiiinaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaae                           ccccccccccccccccccccccccccceeeeeeeeeeeeeeertttttttttttttttttttttttlco,ssssssssssssuine                                                                e aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaacddddddddddddddbSf:hm(((((((((((((((((((((((((((((((((((((tpggggggggggggggggggggggggggggggggggggggggggggrrrrrrrrrrr            lo,"issssssssssssssssseeeeeeeeeauuuuuuuuuuuuuuuuuuuuuuue                                        nnnnnnnnnnnnneeeeeeeeeeeeerccccccccccccttttttttiiiiiiiiiiiloa''''''''''''''''''''                    nsssssssssssssssssssssssuuuuuuuuuuue                          pvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv.w
01MMMMMMMMMMMMMMMMMMMM%Ck\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\iD)TPPPPPPPPPPPPPP-<SyN:bmffffffffffffffffhd((((((((((r,,,,,,,,,,,,,,,,,,,,,,,,,,,,ggggggggggggggggggggggggggggggcccccatttttttttttlnooooooooou'''''''''''''''''''''''''''''''''''''''''''''''''''eeeeeee                                   ssssssssssssssssssssssse                                    iarsctttttttttttlnou                                        eeeeeeeeeeeeeeeeeeeeee      """""""""""""""""""""""""""""""""sS:pmmmmmmmmmmmmmmmmmmmmmmmmmmmmmbdf,hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh(aaaaaaaaaaaaaaaaaggggggggggggiiiiiilrctooooooooooooooooooe       """"""""""""""""""nnnnnnnnnnnnnnnnnnnnnnnnnn                      eeeeeeeeeeeeeeeeeeeeeuuuuuuuuuuu aaaaaaaaaaaasllllllllllllleoircccccccccccccccttttttttttttttttttttttttttttttttttttttttttttttuuuuuuuuuuuuuuuuuuuuuuuuennnnnnnnnnnnnn                                DERRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR333333333333333333333333333333333333333333333333333333333333333333333333333333333>!!!!!!!!!!!!!!!!!!!!!!!!!!jjjjjjjjjjjjjjjjjjjjjjjjjjjjjG+H;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;LxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWIIIIIIIIIIIIIIIIIIIIIIIII2=$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$V]]]]]]]]]]]]]]]]]]]]]]]]]]]]O///////////////////////B
















































.w
A01MMMMMMMMMMMMMMMMMMMM%Ck\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\vo'TP-:<ymSSSSSSSSSSSSSSSSpdddddddddddddd,b)Nfffffffffffffffffff"hl(((((((((((((((((assssssssssssssssssssssssgggggggggggggirucccccccnttttte                                                                      eeeeeee                laooooooooooooooooooooooooooooooooooooooosssssssssssssirucnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnne                               ttttttttttttttttttttttteeeeeeeeeeeeeeeeemmmmmmmmmmmmmmmm:dS,ppppppppppppppppppppppppppppppppppppp"bbbbbbbaaaaaaaaaaaaaaaffffffffffffffffff(((((((((((((((((hlooooooooorrrrrrrrrrrrssssssssssssscie          tuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuue                 nnnnnnnnnnnnnnnnnnnnnalllllllllllrg coooooooooooosttttttttttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeniiiiiiie uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuDwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww0.MF%1kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkCc)\v''''''''''''''''TPd-<,::::::::::::::::::::::::yS"pmmmmmmmmmmmmmmelllllllllllllllllbrffffffffffffffffffaaaaaaaaaaaaaaaaaatg(oooooooooooonsssssuuuuuuuuuuuuuuuuuuuuuu                                                          ie                                   ractliiiiiiiiiiihoooooooooooonsuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeee                                                                     e       id,,,,,,,,,,,,,,,NNNNNNNNNNNNNNNN":mSSSSSSSSSSSSSSSSSpppppag