$PlayerAnim::Crouching = 25;
$PlayerAnim::DieChest = 26;
$PlayerAnim::DieHead = 27;
$PlayerAnim::DieGrabBack = 28;
$PlayerAnim::DieRightSide = 29;
$PlayerAnim::DieLeftSide = 30;
$PlayerAnim::DieLegLeft = 31;
$PlayerAnim::DieLegRight = 32;
$PlayerAnim::DieBlownBack = 33;
$PlayerAnim::DieSpin = 34;
$PlayerAnim::DieForward = 35;
$PlayerAnim::DieForwardKneel = 36;
$PlayerAnim::DieBack = 37;

//----------------------------------------------------------------------------
$CorpseTimeoutValue = 10;
//----------------------------------------------------------------------------

// Player & Armor data block callbacks

function Player::onAdd(%this)
{
	GameBase::setRechargeRate(%this,8);
}

function Player::onRemove(%this)
{
	// Drop anything left at the players pos
	for (%i = 0; %i < 8; %i = %i + 1) {
		%type = Player::getMountedItem(%this,%i);
		if (%type != -1) {
			// Note: Player::dropItem is not called here.
			%item = newObject("","Item",%type,1,false);
         schedule("Item::Pop(" @ %item @ ");", $ItemPopTime, %item);

         addToSet("MissionCleanup", %item);
			GameBase::setPosition(%item,GameBase::getPosition(%this));
		}
	}
}

function Player::onNoAmmo(%player,%imageSlot,%itemType)
{
	//echo("No ammo for ",%itemType.description," slot(",%imageSlot,")");
}

function Player::onKilled(%this)
{
	%cl = GameBase::getOwnerClient(%this);
	%cl.dead = 1;
	if($AutoRespawn > 0)
		schedule("Game::autoRespawn(" @ %cl @ ");",$AutoRespawn,%cl);
	if(%this.outArea==1)	
		leaveMissionAreaDamage(%cl);
	Player::setDamageFlash(%this,0.75);
	for (%i = 0; %i < 8; %i = %i + 1) {
		%type = Player::getMountedItem(%this,%i);
		if (%type != -1) {
			if (%i != $WeaponSlot || !Player::isTriggered(%this,%i) || getRandom() > "0.2") 
				Player::dropItem(%this,%type);
		}
	}

   if(%cl != -1)
   {
		if(%this.vehicle != "")	{
			if(%this.driver != "") {
				%this.driver = "";
        	 	Client::setControlObject(Player::getClient(%this), %this);
        	 	Player::setMountObject(%this, -1, 0);
			}
			else {
				%this.vehicle.Seat[%this.vehicleSlot-2] = "";
				%this.vehicleSlot = "";
			}
			%this.vehicle = "";		
		}
      schedule("GameBase::startFadeOut(" @ %this @ ");", $CorpseTimeoutValue, %this);
      Client::setOwnedObject(%cl, -1);
      Client::setControlObject(%cl, Client::getObserverCamera(%cl));
      Observer::setOrbitObject(%cl, %this, 5, 5, 5);
      schedule("deleteObject(" @ %this @ ");", $CorpseTimeoutValue + 2.5, %this);
      %cl.observerMode = "dead";
      %cl.dieTime = getSimTime();
   }
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object)
{
	if (Player::isExposed(%this)) {
      %damagedClient = Player::getClient(%this);
      %shooterClient = %object;
      Player::applyImpulse(%this,%mom);

                        if (%type == $Kickback)
			return; 
			%armor = Player::getArmor(%this); 		
			if(%shooterTeam != %targetTeam || $Server::TeamDamageScale || Player::getClient(%this) == %object)
			{	
				if(%type == $BioShrapnelDamageType)
					eval(%armor @ "::OnBio(" @ %damagedClient @ ", " @ %this @ ");");
				else if(%type == $EMPDamageType)
					eval(%armor @ "::onShock(" @ %damagedClient @ ", " @ %this @ ");");
                                else if(%type == $SludgeDamageType)
					eval(%armor @ "::onSludge(" @ %damagedClient @ ", " @ %this @ ");");
}


  if(%this.invulnerable || $NoDamage)
      {     
         // no damage, just play a shield.
		   %thisPos = getBoxCenter(%this);
		   %offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
		   GameBase::activateShield(%this,%vec,%offsetZ);
         return;
      }

		if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) {
			if (%shooterClient != -1) {
				%curTime = getSimTime();
			   if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) {
					if(%type != $MineDamageType) {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ "!");
						Client::sendMessage(%damagedClient,0,"You took Friendly Fire from " @ Client::getName(%shooterClient) @ "!");
					}
					else {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ " with your mine!");
						Client::sendMessage(%damagedClient,0,"You just stepped on Teamate " @ Client::getName(%shooterClient) @ "'s mine!");
					}
					%this.LastHarm = %shooterClient;
					%this.DamageStamp = %curTime;
				}
			}
			%friendFire = $Server::TeamDamageScale;
		}
		else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) 
			%friendFire = $Server::TeamDamageScale;
		else  
			%friendFire = 1.0;	

		if (!Player::isDead(%this)) {
			%armor = Player::getArmor(%this);
			//More damage applyed to head shots
			if(%vertPos == "head" && %type == $LazerexDamageType) {
				if(%armor == "harmor") { 
					if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") {
						%value += (%value * 0.3);
					}
				}
				else {
					%value += (%value * 0.3);
				}
			}
			//If Shield Pack is on
			if (%type != -1 && %this.shieldStrength) {
				%energy = GameBase::getEnergy(%this);
				%strength = %this.shieldStrength;
				if (%type == $BioShrapnelDamageType || %type == $SplitMortarDamageType)
					%strength *= 0.75;
				%absorb = %energy * %strength;
				if (%value < %absorb) {
					GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
					%thisPos = getBoxCenter(%this);
					%offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
					GameBase::activateShield(%this,%vec,%offsetZ);
					%value = 0;
				}
				else {
					GameBase::setEnergy(%this,0);
					%value = %value - %absorb;
				}
			}
                          if (%value) 
			{
				%value = $DamageScale[%armor, %type] * %value * %friendFire;
	        	   	%dlevel = GameBase::getDamageLevel(%this) + %value;
				%spillOver = %dlevel - %armor.maxDamage;
				if(%dlevel >= %armor.maxDamage)
				{
					%flag = Player::getMountedItem(%this,$FlagSlot);
					if(%flag == "flag") 
					{
						if(%damagedClient != %shooterClient)
						{
							if(%damagedTeam != %shooterTeam)
							{
								%shooterClient.score+=1;
								Game::refreshClientScore(%shooterClient);
								schedule("Client::sendMessage(" @ %shooterClient @ ", 0, \"You Recieve 2 Points for Killing the Enemy Flag Carrier!\");",1);
							}
							else
							{
								%shooterClient.score-=1;
								Game::refreshClientScore(%shooterClient);
								schedule("Client::sendMessage(" @ %shooterClient @ ", 0, \"You Lose 2 Points for Killing your own Flag Carrier!\");",1);
							}
						}
					}
				}




if ( %type == $BioShrapnelDamageType && %friendFire){
					//echo("friendFire "@%friendFire);
					startPoison(%damagedClient, %this);
					return;}



  			if (%value) {
				%value = $DamageScale[%armor, %type] * %value * %friendFire;
            %dlevel = GameBase::getDamageLevel(%this) + %value;
            %spillOver = %dlevel - %armor.maxDamage;
				GameBase::setDamageLevel(%this,%dlevel);
				%flash = Player::getDamageFlash(%this) + %value * 2;
				if (%flash > 0.75) 
					%flash = 0.75;
				Player::setDamageFlash(%this,%flash);
				//If player not dead then play a random hurt sound
				if(!Player::isDead(%this)) { 
					if(%damagedClient.lastDamage < getSimTime()) {
						%sound = radnomItems(3,injure1,injure2,injure3);
						playVoice(%damagedClient,%sound);
						%damagedClient.lastdamage = getSimTime() + 1.5;
					}
				}
				else {
               if(%spillOver > 0.5 && (%type== $StormHammerDamageType || %type == $BioShrapnelDamageType || %type== $SplitMortarDamageType|| %type == $MissileDamageType)) {
		 				Player::trigger(%this, $WeaponSlot, false);
						%weaponType = Player::getMountedItem(%this,$WeaponSlot);
						if(%weaponType != -1)
							Player::dropItem(%this,%weaponType);
                	Player::blowUp(%this);
					}
					else
					{
						if ((%value > 0.40 && (%type== $StormHammerDamageType || %type == $BioShrapnelDamageType || %type== $SplitMortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) {
					  		if(%quadrant == "front_left" || %quadrant == "front_right") 
								%curDie = $PlayerAnim::DieBlownBack;
							else
								%curDie = $PlayerAnim::DieBlownBack;
						}
						else if( Player::isCrouching(%this) ) 
							%curDie = $PlayerAnim::Crouching;							
						else if(%vertPos=="head") {
							if(%quadrant == "front_left" ||	%quadrant == "front_right"	) 
								%curDie = radnomItems(2, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
						  	else 
								%curDie = radnomItems(2, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
						}
						else if (%vertPos == "torso") {
							if(%quadrant == "front_left" ) 
								%curDie = radnomItems(3, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
							else if(%quadrant == "front_right") 
								%curDie = radnomItems(3, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
							else if(%quadrant == "back_left" ) 
								%curDie = radnomItems(4, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
							else if(%quadrant == "back_right") 
								%curDie = radnomItems(4, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack, $PlayerAnim::DieBlownBack);
						}
						else if (%vertPos == "legs") {
							if(%quadrant == "front_left" ||	%quadrant == "back_left") 
								%curDie = $PlayerAnim::DieBlownBack;
							if(%quadrant == "front_right" ||	%quadrant == "back_right") 
								%curDie = $PlayerAnim::DieBlownBack;
						}
						Player::setAnimation(%this, %curDie);
					}
					if(%type == $ImpactDamageType && %object.clLastMount != "")  
						%shooterClient = %object.clLastMount;
					Client::onKilled(%damagedClient,%shooterClient, %type);
				}
			}
		}
	}
}

function radnomItems(%num, %an0, %an1, %an2, %an3, %an4, %an5, %an6)
{
	return %an[floor(getRandom() * (%num - 0.01))];
}

function Player::onCollision(%this,%object)
{
	if (Player::isDead(%this)) {
		if (getObjectType(%object) == "Player") {
			// Transfer all our items to the player
			%sound = false;
			%max = getNumItems();
			for (%i = 0; %i < %max; %i = %i + 1) {
				%count = Player::getItemCount(%this,%i);
				if (%count) {
					%delta = Item::giveItem(%object,getItemData(%i),%count);
					if (%delta > 0) {
						Player::decItemCount(%this,%i,%delta);
						%sound = true;
					}
				}
			}
			if (%sound) {
				// Play pickup if we gave him anything
				playSound(SoundPickupItem,GameBase::getPosition(%this));
			}
		}
	}
}

 function Player::getHeatFactor(%this)
 {
   %client = Player::getClient(%this);
   if (Client::getControlObject(%client) != %this) return 1.0;
   if(Player::getMountedItem(%this,$BackpackSlot) == "StealthShieldPack") return 0.0;
 %time = getIntegerTime(true) >> 5;
 %lastTime = Player::lastJetTime(%this) >> 10;
   if ((%lastTime + 1.5) < %time) {
   return 0.0;
 }
   else
 {
 %diff = %time - %lastTime;
 %heat = 1.0 - (%diff / 1.5);
 return %heat;
   }
 }

function Player::jump(%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1)
   {
      %vehicle = Player::getMountObject (%this);
		%this.lastMount = %vehicle;
		%this.newMountTime = getSimTime() + 3.0;
		Player::setMountObject(%this, %vehicle, 0);
		Player::setMountObject(%this, -1, 0);
		Player::applyImpulse(%pl,%mom);
		playSound (GameBase::getDataName(%this).dismountSound, GameBase::getPosition(%this));
   }
}


//----------------------------------------------------------------------------

function remoteKill(%client)
{
   if(!$matchStarted)
      return;

   %player = Client::getOwnedObject(%client);
   if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player))
   {
		playNextAnim(%client);
	   Player::kill(%client);
	   Client::onKilled(%client,%client);
   }
}

$animNumber = 25;	 
function playNextAnim(%client)
{
	if($animNumber > 36) 
		$animNumber = 25;		
	Player::setAnimation(%client,$animNumber++);
}
function Client::takeControl(%clientId, %objectId)
{
   // remote control
   if(%objectId == -1)
   {
      //echo("objectId = " @ %objectId);
      return;
   }

	%pl = Client::getOwnedObject(%clientId);
	// If mounted to a vehicle then can't mount any other objects
	if(%pl.driver != "" || %pl.vehicleSlot != "")
		return;

   if(GameBase::getTeam(%objectId) != Client::getTeam(%clientId))
   {
      //echo(GameBase::getTeam(%objectId) @ " " @ Client::getTeam(%clientId));
      return;
   }
   if(GameBase::getControlClient(%objectId) != -1)
   {
      echo("Ctrl Client = " @ GameBase::getControlClient(%objectId));
      return;
   }
	%name = GameBase::getDataName(%objectId);
	if(%name != CameraTurret && %name != DeployableTurret)
   {
	   if(!GameBase::isPowered(%objectId)) 
		{
	      // echo("Turret " @ %objectId @ " not powered.");
	      return;
		}
   }
   if(!(Client::getOwnedObject(%clientId)).CommandTag && GameBase::getDataName(%objectId) != CameraTurret &&
      !$TestCheats) {
		Client::SendMessage(%clientId,0,"Must be at a Command Station to control turrets");
   		return;
   }
   if(GameBase::getDamageState(%objectId) == "Enabled") {
   	Client::setControlObject(%clientId, %objectId);
   	Client::setGuiMode(%clientId, $GuiModePlay);
	}
}

function remoteCmdrMountObject(%clientId, %objectIdx)
{
   Client::takeControl(%clientId, getObjectByTargetIndex(%objectIdx));
}

function checkControlUnmount(%clientId)
{
   %ownedObject = Client::getOwnedObject(%clientId);
   %ctrlObject = Client::getControlObject(%clientId);
   if(%ownedObject != %ctrlObject)
   {
      if(%ownedObject == -1 || %ctrlObject == -1)
         return;
      if(getObjectType(%ownedObject) == "Player" && Player::getMountObject(%ownedObject) == %ctrlObject)
         return;
      Client::setControlObject(%clientId, %ownedObject);
   }
}

function startPoison(%clientId, %player) { 
	Client::sendMessage(%clientId,1,"You Got Hit With a Bio/Chem CockTail!!!"); 
	%drrate = GameBase::getDamageLevel(%player) + 0.05; 
	GameBase::setDamageLevel(%player, %drrate);
	Player::setDamageFlash(%player,0.5);
			if (Player::isDead(%player)) {
			messageall(0, Client::getName(%clientId) @ " Died from a Toxic CockTail."); 
			%clientId.scoreDeaths++;

 		playNextAnim(%player); 
		Player::blowUp(%player); 
		Player::kill(%player); 
 
			%clientId.score--; 
			Game::refreshClientScore(%clientId); 
			$poisonTime[%clientId] = 0; } 

		if($poisonTime[%clientId] == 0) { 
		Player::setDamageFlash(%player,0.75); 
		$poisonTime[%clientId] = 30; 
		checkPoison(%clientId, %player); 
		} 
	else $poisonTime[%clientId] = 30; 
	} 

function checkPoison(%clientId, %player) { 
	if($poisonTime[%clientId] > 0) { $poisonTime[%clientId] -= 2; 
	%drrate = GameBase::getDamageLevel(%player) + 0.05; 
		if (!Player::isDead(%player)) { GameBase::setDamageLevel(%player, %drrate); 
		Player::setDamageFlash(%player,0.25); 
			if (Player::isDead(%player)) {
			messageall(0, Client::getName(%clientId) @ " Died from a Toxic CockTail."); 
			%clientId.scoreDeaths++;

 		playNextAnim(%player); 
		Player::blowUp(%player); 
		Player::kill(%player); 
 
			%clientId.score--; 
			Game::refreshClientScore(%clientId); 
			$poisonTime[%clientId] = 0; } 
			} 
		else { $poisonTime[%clientId] = 0; 
		} 
		schedule("checkPoison(" @ %clientId @ ", " @ %player @ ");",1,%player); } 
	else { Client::sendMessage(%clientId,3,"The effects of the Bio/Chem CockTail wear off."); 
	} 
} 

function Arms_AntiGrav(%clientId, %player)
{
	if ($antigrav[%clientId])
	{
		%velocity = 0.5;
		%zVec = 1.80;
		%jumpDir = Vector::getFromRot(GameBase::getRotation(%player),%velocity,%zVec);
		Player::applyImpulse(%player,%jumpDir);
		schedule("Arms_AntiGrav(" @ %clientId @ ", " @ %player @");",0.01,%player);
	}
    }
}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}AkkkkkkkW6666666KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKE,,,,,,,,mmmmmmm[]ggggggg,mmmmmmmmmmmmmmmmmmmmmmmm;AkkkkkkkgSSSSSSS,oooooooo,,,,,,,mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmPPPPPPPPPPPPPPPoooooooo,,,,,,,IIIIIIIIIIIIIIIIIIIIIIIgggggggggggggggggggggggooooooommmmmmmm,,,,,,,,,,,,,,,ooooooooSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\|'*
MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}GW6KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKE[!m;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoS)))))))Ikkkkkkkkkkkkkkkkk,,,,,,,,,,,,,,,oooooooommmmmmm,dddddddddddddddddddddddddddddoggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggS)Pmmmmmmm,,,,,,,,,,,,,,,oooooooodddddddddddddddddddddddmmmmmmmoddddddddddddddddddddddd,,,,,,,,,,,,,,,ooooooooIMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM=2)]]]]]]]]]]]]]]]]]]]]]]];v3!dggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg,mmmmmmmmmmmmmmmmmmmmmmmmmmmmmoooooooooooooooooSSSSSSSPAddddddd,,,,,,,,,,,,,,,oooooooommmmmmmmmmmmmmmmmmmmmmm                 )d	gggggggomkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk,                      oooooooom,d                                    oSSSSSSS                      K*













































jHL@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@GW-]6666666666666666666666666666666EyIMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM========k22222222222222222222222;v3!P.................)	,loooooooSgm                             odddddddd,lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll                      ooooooooem                            e)f(((((((((lA.SSSSSSSSSSSSSSSSSdom,                                                                                    					eeeeeeeeeeeeeeeeooooooo                  lmnnnnngde               ooooooooooo            ,oeeeeeeeeeeeeeeeeeeeeeeeeeg"Ty-M[[[[[[[[[[[[[[[[[[[[[Ikkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk=v2!;)foooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooA3.Sms(((((((((((((((((lllll                ,nnnnnnneeeeeeeeeeeeeeeeeeeeeeeo eeeeeeeeeeeeeedddddddddddem												,sssssssssssssodl                        nnnnneeeeeeeeeeeeeeeeooooooo           dg%)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))""""""""	fP.,S(mmmmmmmmmmmmmmmmnse               ooooooooooo            loeeeeeeeeeeeeeeeeeeeeeeeeeo,mdnnnnnnnnnnnnnnnnnnnnn                lllllllllllllllllleeeeeeeeeeeeeeeeeeeeeeeo eeeeeeeeeeeeeesssssssssss	&~ʯӻ9޲`^պXQδ˸?ܹݼ$#OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOwqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444J<U77777777777777777777777777777777777VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV_\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
































Y||||||||||||||||||||||||||||||||||||'HK***************************************************************G
jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjlllllllllllllllllllllL@]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]WWWWWWWWWWWWWWWWWWWWWWWy-M!TIkgggggggggggggggggggggg[6)=vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv%A222222222222222emS"nfP;,dddddddddddddosssssssssssssssss.                                       eeeeeeeeeeeeeeeeooooooo                  nm,lssssssssssssssssssssssssssde               ooooooooooo            (oeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr)	gS%fffffffffffffffo,nsmmmmmmmmmmmmmmmmm"lllll                (33333333333333333eeeeeeeeeeeeeeeeeeeeeeeo eeeeeeeeeeeeeeddddddddddd.es,,,,,,,,,,,,nrmmmmmmmmmmmmmodl                                      eeeeeeeeeeeeeeeeooooooo           (111111111111111111111bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbw-$!yIMMMMMMMMMMMMMMMMMMMMMMT=kAEd																																																													S)fggggggggggggggggg%Pvvvvvvvvvvvvvvv."ssssssssssssssrrrrrrrrrrrr,nnnnnnnnnnnnnnnme               ooooooooooo                  loeeeeeeeeeeeeeeeeeeeeeeeee 32do,tsrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrlnnnnnnneeeeeeeeeeeeeeeeeeeooooo        eeeeeeeeeeeeemmmmmmmmmmm,																					(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((S;fggggggggggggggggg.)%%%%%%%%%%%%%%%eeeeeeeeeeedtslrrrrro mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmneeeeeeeeeeeeeooooooo                        n,"""""""""""""""""ltmsdrrrrreeeeeeeeeeeeeeeeooooooo                                       e               oooooooooooooooooooooooup/>xxxxxxxxxxxxxxxxxxxxxxxxxOBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
**********************************************************H"]KNG
jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjLLLLLLLLLLLLLLLLLLLLLCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC@[}}}}}}}}}}}}}}}}}}}}}}}1bbbbbbbbbbbbbbbbbbb!!!!!!!!!!!!!!!!!!w----------------------$yIAMT=3kEWP								.............................................................S;vnfg((((((((((((((((()% m,,,,,,,,,,,ldttttttttttttttttttttttsoeeeeeeeeeeeeeeeeeeeeeeeeeo                          rrrrrrreeeeeeeeeeeomnnnnnnnnnddddddddddddddd,,,,,,,,,,,,,,,,,,,,,,lllll        eeeeeeeeeeeeerttttttttttteeeeeeeeeeeeeo ssssssssssssssssssssssssssssssd"pppppppppppppe(u	.mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmS)fg2snnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn,,,,,,,,,,,,,,,,,,,,,,lrrrrrrrrrrrrrooooooo                              eeeeettttttttttttttttooooooo                 dsssssssssssssssssssssssssssmn%l,,,,,etttttttttttt               ooooooooooo                  eorrrrrrrrrrrrrrrrrrrrrrrrr	hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh000000000000000000000000000000000000000000000000000000000Cb/!11111111111iAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAw3333333333333333333333$y;-MTp=I(k6"""""""""""""               u.............................................................sS)dfgollllllllllmnt%2PPPPPPPPPPPPPPPPPPPPPPPPPPeeeeeeer,,,,,,,,,,,,,,,,,,,ooooo                               eeeeeeeeeeeeeeeeeeesdddddddddddliiiiiiiiiiiiaaaaaaaaaamntttttttttttttttttrrrrro eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee,ooooooo                                   p(h""""""""""""""""""""""""""""	.............Sued%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l)fsssssssssssssssssniaaaaaaaaaaaaaaaaaaaaaaaaaagmmmmmmmmmmmmm,ttttttttooooooo                            eeeeeeeee rrrrrrrooooooooooonnnnnnnnnnnnnslllllllllllld vvvvvvvvvvvia,,,,,,,,,,,,,,,,,,,,eooooooooooooooormmmmmmmmmmmooooooooooooooooo       teeeeeeeeeeeeeeeeeeeeeeeee2:F5DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{ 444444444444444444444444444444444448<UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU7VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY_\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\||||||||||||||||||||||||||||||||||||>++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'BxxxxxxxxxxxxxxxxxxxxxxxxO****************************************************
]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]NH
KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKGGGGGGGGGGGGGGGGGccccccccccccccccccccc[jjjjjjjjjjjjjjjjjjjjLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL0bbbbbbbbbbbbbbbb!CA//////////////////13333333333333333333$w;;;;;;;;;;;;;;;;;;;;;;My=-kTE@Ii"(((((((((((((((h..............S	%%%%%%%%%%%%%)upppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppsv6}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}flndttttttttttta,,,,,,,,,,roooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       ttttttttggggggggggggnsileeeeeeeeeedddddddddddaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeer ooooooooooooooooooooooPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP".(Sh%%%%%%%%%%%%%%)	pppppppppppppcuuuuuuuungggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggiiiiiiiiiiiits mldddddddddddddddddddddeeeeeeeeeeeeeeraaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmmintffffffffffffffffffffforsldddddddddd       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeegggggggggggggggggggggggggggggggggggggggggg:b2!0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC3/$1;;;;;;;;;;;;;;;;;;;Mw======================kyyyyyyyyyyyyyyyyyyyyy-vTPIr...............S"%()hppppppppppppppc																																				tiiiiiiiiiinmfuuuuuuuuu,,,,,,,,,,,,sladddddooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,,,,,,,,,,tmirnnnnnnnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaseeeeeeeeeeeeeeeeeeeeeeel oooooooooooooooooooooo                  eeeeeeeeeeeeeedddddddooooooooooofgaS.%%%%%%%%%%%%%%%)"p(chhhhhhhhhhhhhhhhhhhhhhhhhhhhhhW								mmmmmmmmmmrt,iiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn           eooooooooooooooodsssssssssssooooooooooooooooo       leeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerm,,,,,,,,,,atlinuuuuuuuuuuuudoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       fffffffffffffffffffffffffDFFFFFFFFFFFFFFFFFFFFFFFF>+RRRRRRRRRRRRRRRRRRRRRRRRRRBx5N***************************OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
L
KHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHG[Ej6666666666666666666666666666666!!!!!!!!!!!!!!!!!!!!:bbbbbbbbbbbbbbbbbb20A$$$$$$$$$$$$$$$$C3M/1;kkkkkkkkkkkkkkkkkkkw=vvvvvvvvvvvvvvvvvvvvvvyyyyyyyyyyyyyyyyyyyyyP-l%S).pppppppppppppppc"""""""""""""""""(W@Thggggggggggggggggggggg,rammmmmmmmmmmmmmmmmmmmeeeeeeeeeeeetinnnnnnnnnnnnnsu	oooooooooooooooooo                        eeeeeeeeeeeeed ooooooooooooooooooooooooooooooooooooooooa,,,,,,,,,,,rlm sssssssssstiiiiiiiiiiieeeeeeeeeeeeeednnnnnnnooooooooooooooooooooooo           eooooooooooooooooooooooooooooooooooooouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuus)%pSc...............................I"g(fhhhhhhhhhhhhhhhhhhal,,,,,,,,,,,,rodmmmmmmmmmmtttttttttt                                ieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeeddddddddllllllllllllllllllllllas,,,,,,,,,	rmmmmmmmmmmntttttooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo                       !:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::0b$2CAMMMMMMMMMMMMMMMM13k/w;vvvvvvvvvvvvvvvvvvvy=PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPu	)%pSc...............................I-"g(fhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhlsssssssssssdaaaaaaan,rmeeeeeeeeeeeeeiiiiiiiiii oooooooooooooooooooooo                  eeeeeeeeeeeeeetttttttooooooooooonnnnnnnnssssssssssssdlllllllllllllllllllllllllllllia,r           eoooooooooooooootmmmmmmmmmmmooooooooooooooooo                eeeeeeeeeeeeeeeeeeeeeeeeehhhhhhhhhhhhhi%	S).pppppppppppppppc"""""""""""""""""(Tuggggggggdssssssssssssssffffffffffffnlllllllllllllllllllla,rtoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                                                                                                   dnsiiiiiiiiiiiierlllllllllllaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeet oooooooooooooooooooooohhhhhhhhhhhhhhhhhhhhhhhhhhhhq99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzZVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{|||||||||||||||||||||||||||||||||||8<UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU74D_YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY\+}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}xxxxxxxxxxxxxxxxxxxxxxxx>FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRN*5KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK]OEL














:HG6[Wj0!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!CCCCCCCCCCCCCCCCCCCCb$12AMwwwwwwwwwwwwwwww3ky/;vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'''''''''''''''''''''''''''''''''''''''''''''''''=PIIIIIIIIIIIIIIIIIIIIIIrS%.															)"p(cuuuuuuuuuuuuuuuuuuuuuuuuuuuuuTTTTTTTTTTTTTTTTTTTTTTTTTTTTnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnngidddddddddds mmmmmmmmmmmmllllllllllllllllllllleeeeeeeeeeeeeetaaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmminnnnnnnnnnfrdotssssssssssssllllllllll       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeet.SSSSSSSSSSSSSSS%"	()upppppppppppppchhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhirnmf---------,dssssssssssssalllllooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,rrrrrrrrrrmitnnnnnnnagdseeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooo                  eeeeeeeeeeeeeelllllllooooooooooof00000000000000000000000:C!bbbbbbbbbbbbbbbbbb11111111111111111111A$w23Myyyyyyyyyyyyyyyy;k@/=vIIIIIIIIIIIIIIIIIIITPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPaaaaaaaaaaaaaaa."S(%u													)hppppppppppppppccccccccmrtttttttttt,iiiiiiiiiiiiiiiingggggggggggggggggd           eooooooooooooooolsssssssssssooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetm,raaaaaaaaaaaaaaaaaaaaain----------------------dloooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       gffffffffffff"""""""""""""""(.uSSSSSSSSSSSSS%h														)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))pppppppp,tammmmmmmmmmmreddddddddddinnnnnnnnnnnnnssssssssssssssssssssscoooooooooooooooooo                        eeeeeeeeeeeeel oooooooooooooooooooooodddddddda,,,,,,,,,,,ttttttttttttm srrrrrrrrrriiiiiiiiiiieeeeeeeeeeeeeelnnnnnnnooooooooooooooooooooooo           eooooooooooooooooooooooooooooooooooooooooog>D+Bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx****************************************************F]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]NR
KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK56ELOOOOOOOOOOOOOOOOOOOOO
HWGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG[00000000000000000000000:C!bbbbbbbbbbbbbbbbbb11111111111111111111A$w23Myyyyyyyyyyyyyyyy;k@j/=vIIIIIIIIIIIIIIIIIIITP-s("uuuuuuuuuuuuuuuuuuuuuuuuuuu.hSSSSSSSSSSSSSS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	f))))))))))))))))))aaaaaaaaaaaa,dtolmrrrrrrrrrrrrrrrrrrr                       pieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeellllllllllllllllllllllllllllldas,,,,,,,,,ctmrnnnnnnnnnnnnnnooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo                           gc("uuuuuuuuuuuuuuuuuuuuuuuuuuu.hSSSSSSSSSSSSSS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	f)))))))))))))))))))))))))))))ddddddddddddssssssssssslaaaaaaan,tmeeeeeeeeeeeeeir oooooooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooonnnnnnnnsdllllllllllllppppppppppppppppia,t           eoooooooooooooooooooooooommmmmmmmmmmooooooooooooooooo       reeeeeeeeeeeeeeeeeeeeeeeee)0:::::::::::::::::::::!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!CCCCCCCCCCCCCCCCCCCCb$12AMwwwwwwwwwwwwwwww3ky/;vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv=PIIIIIIIIIIIIIIIIIi"ccccccccccccccc(.uSSSSSSSSSSSSS%h														gggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggglspfdnnnnnnnnnnnnrrrrrrrrrrra,ttttttttttoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       rrrrrrrrrrrrrrrrrrrrrrrrrrrrrTlnsidettttttttttttttttttttttaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooop)ttttttttttttttt".cS(%u													ghhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhn-------------------------------------------------------------ilrs mddddddddddddddddddddddddddddddddeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmminrftloooooooooosddddddddddddddddddddd       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeppppppppppppppppppppppppppppppppppppppppp7VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{JJJJJJJJJJJJJJJJJJJJJJJJJJJJ}|||||||||||||||||||||||||||||||||||8<UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD________________________________Y44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\>>>>>>>>>>>>>>>>>>>>>>>>>>Bx+N************************************************************************************************]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]FL
KRW6E5-O








































































H@G0:::::::::::::::::::::!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!CCCCCCCCCCCCCCCCCCCCb$12AMwwwwwwwwwwwwwwww3ky/;vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv[[[[[[[[[[[[[[[[[[[=PIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII...............S"%c	(guuuuuuuuuuuuuuuuuuuuuuuuuuuuu)hhhhhhhhritnmffffffffffffffffffffff,lsdaaaaaaaaaaaaaaaaooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,trmiiiiiiiiiinnnnnnnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaalseeeeeeeeeeeeeeeeeeeeeeed oooooooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooofpaS.%%%%%%%%%%%%%%%	"gccccccccccccccccc()uTTTTTTTTTTTTTTTTTTTTmttttttttttr,iiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnhl           eoooooooooooooooooooooooooosssssssssssooooooooooooooooo       deeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeem,tardinnnnnnnnnnnnnnlllllllllllloooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                                                                                   000000000000000000000-----------------------:C!bbbbbbbbbbbbbbbbbb11111111111111111111A$w23Myyyyyyyyyyyyyyyy;kj/=vIIIIIIIIIIIIIIIIIIIfd%S	.ggggggggggggggggggggggggggggggg")cTP(puuuuuuuu,,,,,,,,,,ammmmmmmmmmmtelrinnnnnnnnnnnnnssssssssssssssssssssssssssoooooooooooooooooo                        eeeeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooolllllllla,,,,,,,,,,,,,,,,,,,,dm striiiiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnooooooooooooooooooooooo           eooooooooooooooohhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhs	%gSSSSSSSSSSSSSSSSS.))))))))))))))))))))))))))))))))))))"pcf((((((((((((((((((ad,lllllllllloooooooooooomtrrrrrrrrrr       huieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeedddddddddddlas,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,mtnrrrrrooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo                        xDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDB>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>N*+KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK]]]]]]]]]]]]]]]]]]]]]]]]]EL
F'W6Rhhhhhhhhhhhhhhhhhhhhh5O@






























HC0-----------------------1:!bwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwAy$23jGMMMMMMMMMMMMMMMM;Ik/=Tvvvvvvvvvvvvv	%gSSSSSSSSSSSSSSSSS.))))))))))))))))))))))))))))))))))))))))))))))))))))))"pcf((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((ldssssssssssssssssssssssaaaaaaan,,,,,,,,,,meeeeeeeeeeeeeit oooooooooooooooooooooo                  eeeeeeeeeeeeeerrrrrrrooooooooooonnnnnnnnsllllllllllllduuuuuuuuuuuuuuuuia,,,,,,,,,,           eooooooooooooooormmmmmmmmmmmooooooooooooooooo       teeeeeeeeeeeeeeeeeeeeeeeee(hi%%%%%%%%%%%%%S	.ggggggggggggggggggggggggggggggg")cPPPPPPPPPPPPPPpppppppppppppppppppsuflndttttttttttta,,,,,,,,,,roooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttnsileeeeeeeeeedddddddddddaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeer oooooooooooooooooooooouC---------------------10!!!!!!!!!!!!!!!!!!!!!!!w::::::::::::::::::::byyyyyyyyyyyyyyyyyy2A[$$$$$$$$$$$$$$$$3IM/;Tkkkkkkkkkkkkkkkkkkkkkk=((((((((((S%...........................	"gcccccccccccccccccccccccccccccc)hPvvvvvvvvnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnpiiiiiiiiiiiits mldddddddddddddddddddddeeeeeeeeeeeeeeraaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmmintffffffffffffffffffffforsldddddddddd       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeur.SSSSSSSSSSSSSSS%"""""""""""""c														ghhhhhhhhhhhhhhhhh())))))))tiiiiiiiiiinmfffffffffffffffffffffffffff,,,,,,,,,,,,sladddddooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,,,,,,,,,,tmirnnnnnnnappppppppppppseeeeeeeeeeeeeeeeeeeeeeel oooooooooooooooooooooo                  eeeeeeeeeeeeeedddddddooooooooooo@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@䕔~ʯӻн޲`^պXQδ˸?ܹ#JҶ q99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999997VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{zZZZZZZZZZZZZZZZZZZZZZZZZZZZZ}|||||||||||||||||||||||||||||||||||8<DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDU_BBBBBBBBBBBBBBBBBBBBBBBBBBBBBB4444444444444444444444444444444444444444444444444444444Y\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\***************************************************************************]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]N>
KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK+6ELLLLLLLLLLLLLLLLLLLLLLLLLx''''''''''''''''''''''''''''''''''''WFf-R5555555555555555555555555555555Oj
!CCCCCCCCCCCCCCCCCCCCC1111111111111111111100000000000000000000000w2:byyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyA[H/$3IIIIIIIIIIIIIIIIIIIIIIM;TPkaaaaaaaaaaaaaaa."Sc%%%%%%%%%%%%%%%%%%%%%%%%%%h	(guuuuuuuuuuuuuuuuuuuuuuuummmmmmmmmmrt,iiiiiiiiiiiiiiiinp))))))))))))           eooooooooooooooodsssssssssssooooooooooooooooo       leeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerm,,,,,,,,,,atlinnnnnnnnnnnnnnnnnnn============doooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       pfl"""""""""""""""c..............Sh%(((((((((((((u																																																													gggggggg,rammmmmmmmmmmmmmmmmmmmeeeeeeeeeeeetinnnnnnnnnnnnnsvvvvvvvvvvvvvvvvvoooooooooooooooooo                        eeeeeeeeeeeeed ooooooooooooooooooooooooooooooooooooooooa,,,,,,,,,,,rlm sssssssssstiiiiiiiiiiieeeeeeeeeeeeeednnnnnnnooooooooooooooooooooooo           eooooooooooooooo)))))))))))v-!CCCCCCCCCCCCCCCCCCCCC1111111111111111111100000000000000000000000w2:byyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyAG/$3IIIIIIIIIIIIIIIIIIIIIIM;TPkkkkkkkkkkkkkkkkkkkpsc""""""""""""""""""""""""""""h.(Su%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f																		al,,,,,,,,,,,,rodmmmmmmmmmmtttttttttt       )gieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeeddddddddllllllllllllllllllllllas,,,,,,,,,,,,,,,,,,,,,,,,,rmmmmmmmmmmntttttooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo           )=================c""""""""""""""""""""""""""""h.(Su%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f	ppppppppppppppppppplsssssssssssdaaaaaaan,rmeeeeeeeeeeeeeiiiiiiiiii oooooooooooooooooooooo                  eeeeeeeeeeeeeetttttttooooooooooonnnnnnnnssssssssssssdlggggggggggggggggia,r           eoooooooooooooootmmmmmmmmmmmooooooooooooooooo                eeeeeeeeeeeeeeeeeeeeeeeee))))))))))))))))))))))))))D@N***************************BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]L
K>W6E+++++++++++++++++++++++++++++++xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	-FRj5[O1v!Cwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww0yyyyyyyyyyyyyyyyyyyyyyy2:G
bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbIA/$T3333333333333333333333Mk;i"""""""""""""""""""""""""""""""c..............Sh%(((((((((((((u=PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPdsgffffffffffffnlllllllllllllllllllla,rtoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                                       pdnsiiiiiiiiiiiierlllllllllllaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeet oooooooooooooooooooooog	rrrrrrrrrrrrrrr".................Sc%%%%%%%%%%%%%%%%%%%%%%%%%%hhhhhhhhhhhhhhhhhhh()uuuuuuuunpppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppidddddddddds mmmmmmmmmmmmllllllllllllllllllllleeeeeeeeeeeeeetaaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmminnnnnnnnnnfrdotssssssssssssllllllllll       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeep1!-wvvvvvvvvvvvvvvvvvvvvCyyyyyyyyyyyyyyyyyyyyy20HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH:Ib//////////////////TAAAAAAAAAAAAAAAAAAAAAA$k3=Mgt...............S"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ccccccccccccccccccc;;;;;;;;;;;;;;)h	(((((((((((((((((irnmfuuuuuuuuu,dssssssssssssalllllooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,rrrrrrrrrrmitnnnnnnnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaadseeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooo                  eeeeeeeeeeeeeelllllllooooooooooofpaS.%%%%%%%%%%%%%%%%%%%%%%%%%%%"PPPPPPPPPPPPPPPPP)c														ghhhhhhhhmrtttttttttt,iiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn(d           eooooooooooooooolsssssssssssooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetm,raaaaaaaaaaaaaaaaaaaaainudloooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff7VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}|||||||||||||||||||||||||||||||||||8<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<DUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU___________________________'4Y\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\N*@KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK]BEL






































































































W6>jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjx+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++!!!!!!!!!!!!!!!!!!!!!!!!!F[RG555555555555555555551-w2vCyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy0HO///////////////////////:IIIIIIIIIIIIIIIIIIIIIIbbbbbbbbbbbbbbbbbbT=A$kkkkkkkkkkkkkkkkkkk333333333333%SSSSSSSSSSSSS.PMMMMMMMMMMMMMMM)"																	gcppppppppppppppppppppp,tammmmmmmmmmmreddddddddddinnnnnnnnnnnnnsuhoooooooooooooooooo                        eeeeeeeeeeeeel oooooooooooooooooooooodddddddda,,,,,,,,,,,ttttttttttttm srrrrrrrrrriiiiiiiiiiieeeeeeeeeeeeeelnnnnnnnooooooooooooooooooooooo           eooooooooooooooo(((((((((((uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuusssssssssssss%;S).															g"pppppppppppppppppfccccccccccccccccccaaaaaaaaaaaa,dtolmrrrrrrrrrrrrrrrrrrr       ((((((((((((((ieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeellllllllllllllllllllllllllllldas,,,,,,,,,htmrnnnnnnnnnnnnnnooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo           ((((((((((((((((((((-!21Cwwwwwwwwwwwwwwwwv0y/////////////////////:




























































I=b$TTTTTTTTTTTTTTTTTTTAPkuhhhhhhhhhhhhh%;3S).															g"pppppppppppppppppfccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccddddddddddddssssssssssslaaaaaaan,tmeeeeeeeeeeeeeir oooooooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooonnnnnnnnsdllllllllllllllllllllllllllllllllllllllllia,t           eoooooooooooooooooooooooommmmmmmmmmmooooooooooooooooo       reeeeeeeeeeeeeeeeeeeeeeeeec(i%hSSSSSSSSSSSSS.MMMMMMMMMMMMMMM)"																	gupppppppplssssssssssssssfdnnnnnnnnnnnnrrrrrrrrrrra,ttttttttttoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrlnsidettttttttttttttttttttttaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeeeeeeeeeee ooooooooooooooooooooooc*DDDDDDDDDDDDDDDDDDDDDDDDDDD]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]NNNNNNNNNNNNNNNNNNNNNNNNNN
KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK@6ELBxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWWWWWWWWWWWWWWWWWWWWWWWW[jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj>>>>>>>>>>>>>>-+++++++++++++++++++++++++GFHRCCCCCCCCCCCCCCCCCCCC!201wwwwwwwwwwwwwwww:vy//////////////////////////////////////
5555555555555555555555$$$$$$$$$$$$$$$$$$$$$$$I=PbTTTTTTTTTTTTTTTTTTT;AtS%.hhhhhhhhhhhhhhhhhhhhhhhhhhh"Mkkkkkkkkkkkkkkkkk)u	(ggggggggnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnpilrs mddddddddddddddddddddddddddddddddeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmminrftloooooooooosddddddddddddddddddddd       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee.SSSSSSSSSSSSSSS%"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhu3()c								ritnmfggggggggg,lsdaaaaaaaaaaaaaaaaooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,trmiiiiiiiiiinnnnnnnaplseeeeeeeeeeeeeeeeeeeeeeed oooooooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooofC!-00000000000000000000w2:1yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyvO/$$$$$$$$$$$$$$$$$$$$$IIIIIIIIIIIIIIIIIIIIIIPPPPPPPPPPPPPPPPPPPPPPPT=;bMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaa."SSSSSSSSSSSSSSSSS%uh(((((((((((((c3AAAAAAAAAAAAAA))))))))mttttttttttr,iiiiiiiiiiiiiiiinp	l           eoooooooooooooooooooooooooosssssssssssooooooooooooooooo       deeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeem,tardinglllllllllllloooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       pfd""""""""""""""""""""""""""""""".uS(%chhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhkkkkkkkk,,,,,,,,,,ammmmmmmmmmmtelrinnnnnnnnnnnnnsg)oooooooooooooooooo                        eeeeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooolllllllla,,,,,,,,,,,,,,,,,,,,dm striiiiiiiiiiieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnooooooooooooooooooooooo           eooooooooooooooo											p{qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ9zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<7VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''}|||||||||||||||||||||||||||||||||||888888888888888888888888888888888888888888888888DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN_4Y**********************************************]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]L
KKKKKKKKKKKKKKKKKKKKKKKKKKW6E@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\BG[jjjjjjjjjjjjjjjjjjjjjjjjg!>+HHHHHHHHHHHHHHHHHHHHHHHHH
FwC-0yyyyyyyyyyyyyyyyyyyy2:OR111111111111111111111111111111111Iv/$TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTPMMMMMMMMMMMMMMMMMMMMMMM=;3bsssssssssssssssss"uuuuuuuuuuuuuuu(.cSSSSSSSSSSSSSS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hffffffffffffffffffffffffffffffad,lllllllllloooooooooooomtrrrrrrrrrr       	kkkkkkkkkkkkkkkkkkkieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeedddddddddddlas,,,,,,,,,))))))))))mtnrrrrrooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo           	g)))))))))))))))))"uuuuuuuuuuuuuuu(.cSSSSSSSSSSSSSS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hfffffffffffffppppppppldssssssssssssssssssssssaaaaaaan,,,,,,,,,,meeeeeeeeeeeeeit oooooooooooooooooooooo                  eeeeeeeeeeeeeerrrrrrrooooooooooonnnnnnnnslllllllllllldAAAAAAAAAAAAAAAAia,,,,,,,,,,           eooooooooooooooormmmmmmmmmmmooooooooooooooooo       teeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeew-!yC2055555555555555555555555555555555555:I1//////////////////Tvvvvvvvvvvvvvvvvvvvvvv$MMMMMMMMMMMMMMMMMMMMM=P33333333333333333333333k;	i"))))))))))))))))))))))))))))))).uS(%chhhhhhhhhhhhhhgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggsAbflndttttttttttta,,,,,,,,,,roooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       ttttttttppppppppppppnsileeeeeeeeeedddddddddddaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeer ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo".)SSSSSSSSSSSSSSSSS%uh(gc																					npppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppiiiiiiiiiiiits mldddddddddddddddddddddeeeeeeeeeeeeeeraaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmmintffffffffffffffffffffforsldddddddddd       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD*L]KKKKKKKKKKKKKKKKKKKKKKKKKKKW
EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE6666666666666666666666666666666666666@GxjB>[HHHHHHHHHHHHHHHHHHHHHHHHp-O+yyyyyyyyyyyyyyyyyyyyyyyyy
2!5FCCCCCCCCCCCCCCCC0IIIIIIIIIIIIIIIIIIII/:T111111111111111111111111111111111111111Mv=$333333333333333333333kPAAAAAAAAAAAAAAAAAAAAAAAw;r...............S"%)hhhhhhhhhhhhhhhhhgu	(((((((((((((cccccccctiiiiiiiiiinmffffffffffffffffffffff,,,,,,,,,,,,sladddddooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,,,,,,,,,,tmirnnnnnnnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaseeeeeeeeeeeeeeeeeeeeeeel oooooooooooooooooooooo                  eeeeeeeeeeeeeedddddddooooooooooofpaS.%%%%%%%%%%%%%%%h"g)																													ub((((((((mmmmmmmmmmrt,iiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnncccccccccccc           eooooooooooooooodsssssssssssooooooooooooooooo       leeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerm,,,,,,,,,,atlinnnnnnnnnnnnnnnnnnnnnnnnndoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                                                                                   y2222222222222222222R----------------!IC/0TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT:M1==================3vk$AAAAAAAAAAAAAAAAAAAAAwPfl%Sh.ggggggggggggggg	""""""""""""")bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbpuuuuuuuu,rammmmmmmmmmmmmmmmmmmmeeeeeeeeeeeetinnnnnnnnnnnnnssssssssssssss(oooooooooooooooooo                        eeeeeeeeeeeeed ooooooooooooooooooooooooooooooooooooooooa,,,,,,,,,,,rlm sssssssssstiiiiiiiiiiieeeeeeeeeeeeeednnnnnnnooooooooooooooooooooooo           eoooooooooooooooccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccsh%gS	...........................;"p)ffffffffffffffffffffffffffffffffffal,,,,,,,,,,,,rodmmmmmmmmmmtttttttttt       cuieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeeddddddddllllllllllllllllllllllas,,,,,,,,,(rmmmmmmmmmmntttttooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo                        &8<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<7VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''}|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||ZUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL_4NWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW*DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDKKKKKKKKKKKKKKKKKKKKKKKKKKK]GEEEEEEEEEEEEEEEEEEEEEEEEEE
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>Y@6OjBxc2[HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH5++++++++++++++++yyyyyyyyyyyyyyyyyyyR
/-!IIIIIIIIIIIIIIIIIIIIIIC0T====================:Mk1111111111111111113wv$Abbbbbbbbbbbbbbbbbbbbb(h%gS	...........................;P"p)ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffflsssssssssssdaaaaaaan,rmeeeeeeeeeeeeeiiiiiiiiii oooooooooooooooooooooo                  eeeeeeeeeeeeeetttttttooooooooooonnnnnnnnssssssssssssdluuuuuuuuuuuuuuuuia,r           eoooooooooooooootmmmmmmmmmmmooooooooooooooooo                eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeci%(Sh.ggggggggggggggg	"""""""""""""))))))))))))))))))))))))))))))))))))ppppppppdsuffffffffffffnlllllllllllllllllllla,rtoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                                                                                                   dnsiiiiiiiiiiiierlllllllllllaaaaaaaaaaaaam,oooooooooooooooooo                        eeeeeeeeeeeeet oooooooooooooooooooooouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu2/y!FFFFFFFFFFFFFFFFFFFFFF-0I=C:TkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkMw1$3bv;AAAAAAAAAAAAAAAAArS%.(((((((((((((((h"g)																										ccccccccccccccccccccccccccccccccccccccccccccccccccnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnpidddddddddds mmmmmmmmmmmmllllllllllllllllllllleeeeeeeeeeeeeetaaaaaaaooooooooooooooooooooooo           eooooooooooooooo,,,,,,,,,,,mmmmmmmminnnnnnnnnnfrdotssssssssssssllllllllll       ,,,,,,,,,,,eeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeut.SSSSSSSSSSSSSSS%"()hhhhhhhhhhhhhhgc																																													irnmfPPPPPPPPP,dssssssssssssalllllooooooe                       eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoooooooooooooooooo           ,,,,,,,,rrrrrrrrrrmitnnnnnnnapdseeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee oooooooooooooooooooooo                  eeeeeeeeeeeeeelllllllooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo**********************************************LLLLLLLLLLLLLLLLLLLLLLLLLLLWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNKD@GE]B>\
























Oj6fffffffffffffffffffx[5HRRRRRRRRRRRRRRRRRRRRRRRR!!!!!!!!!!!!!!!!2/0yF++++++++++++++++++++++:-I==================CTk$$$$$$$$$$$$$$$$$$$$Mw;13bbbbbbbbbbbbbbbbbbbbbbbvaaaaaaaaaaaaaaa."S)%%%%%%%%%%%%%%(chhhhhhhhhhhhhhhhhgu								mrtttttttttt,iiiiiiiiiiiiiiiinpppppppppppppd           eooooooooooooooolsssssssssssooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetm,raaaaaaaaaaaaaaaaaaaaainPAdloooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeesssssooooooe                       pffffffffffff""""""""""""""")..............Sc%%%%%%%%%%%%%%%%%(uhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgggggggg,tammmmmmmmmmmreddddddddddinnnnnnnnnnnnnsssssssssssssssssssss	oooooooooooooooooo                        eeeeeeeeeeeeel oooooooooooooooooooooodddddddda,,,,,,,,,,,ttttttttttttm srrrrrrrrrriiiiiiiiiiieeeeeeeeeeeeeelnnnnnnnooooooooooooooooooooooo           eooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo!!!!!!!!!!!!!!!!2/0y





















:-I==================CTk$$$$$$$$$$$$$$$$$$$$Mw;13bbbbbbbbbbbbbbbbbbbbbbbvPps)""""""""""""""""""""""""""""c.................Su%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(fhhhhhhhhhhhhhhhhhhaaaaaaaaaaaa,dtolmrrrrrrrrrrrrrrrrrrr                   gieeeeeeeeeeeeeeeeeeeeeeeeennnnnnnnoooooooooo                     eeeeeeeeeeellllllllllllllllllllllllllllldas,,,,,,,,,	tmrnnnnnnnnnnnnnnooooooe                       eeeeeeeeeeeeeeeeeeeeioooooooooooooooooo                       A	)""""""""""""""""""""""""""""c.................Su%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(fhppppppppddddddddddddssssssssssslaaaaaaan,tmeeeeeeeeeeeeeir oooooooooooooooooooooo                  eeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooonnnnnnnnsdllllllllllllggggggggggggggggia,t           eoooooooooooooooooooooooommmmmmmmmmmooooooooooooooooo       reeeeeeeeeeeeeeeeeeeeeeeee5555555555555䕔~ʯϗӻн޲`^պXQδ˸?ܹǮ# JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJq9999999999999999999999999999999999999999999z8<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<777777777777777777777777777777777777&{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU_KKKKKKKKKKKKKKKKKKKKKKKKKKKWLEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEN\4@GDjB>]*************************O
hhhhhhhhhhhhhhhhhhh6xR[FH/////////////////////!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!20y=























:-kIIIIIIIIIIIIIIIIIICwT$$$$$$$$$$$$$$$$$$$$bM;1v3i"															)..............Sc%%%%%%%%%%%%%%%%%(uAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlsgfdnnnnnnnnnnnnrrrrrrrrrrra,ttttttttttoooooooooo                     eeeeeeeeeeeeeeeeeeeeeeeeeemmmmmooooooe                       rrrrrrrrplnsidett