// putting a global variable in the argument list means:
// if an argument is passed for that parameter it gets
// assigned to the global scope, not the scope of the function
$console::logmode=2;
echo("-=Now Loading +Hybrid+ Server.cs=-" );

function createTrainingServer()
{
   $SinglePlayer = true;
   createServer($pref::lastTrainingMission, false);
}

function remoteSetCLInfo(%clientId, %skin, %name, %email, %tribe, %url, %info, %autowp, %enterInv, %msgMask)
{
   $Client::info[%clientId, 0] = %skin;
   $Client::info[%clientId, 1] = %name;
   $Client::info[%clientId, 2] = %email;
   $Client::info[%clientId, 3] = %tribe;
   $Client::info[%clientId, 4] = %url;
   $Client::info[%clientId, 5] = %info;
   if(%autowp)
      %clientId.autoWaypoint = true;
   if(%enterInv)
      %clientId.noEnterInventory = true;
   if(%msgMask != "")
      %clientId.messageFilter = %msgMask;
}

function Server::storeData()
{
   $ServerDataFile = "serverTempData" @ $Server::Port @ ".cs";

   export("Server::*", "temp\\" @ $ServerDataFile, False);
   export("pref::lastMission", "temp\\" @ $ServerDataFile, true);

   EvalSearchPath();
}

function Server::refreshData()
{
   exec($ServerDataFile);  // reload prefs.
   checkMasterTranslation();
   Server::nextMission(false);
}

function Server::onClientDisconnect(%clientId)
{
   // Need to kill the player off here to make sure everything
   // is cleaned up properly.
   %clientId.SADAttempt = 0;
   %clientId.tk = 0;
   %clientId.bk = 0;

   %player = Client::getOwnedObject(%clientId);
   if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) {
       playNextAnim(%player);
       Player::kill(%player);
   }

   Client::setControlObject(%clientId, -1);
   Client::leaveGame(%clientId);
   Game::CheckTourneyMatchStart();
   if(getNumClients() == 1) // this is the last client.
      Server::refreshData();
}

function KickSmallName(%clientId)
{
   Net::kick(%clientId, "You have an illegal name.");
}

function Server::onClientConnect(%clientId)
{
   %clientId.isAdmin = false;
   %clientId.isSuperAdmin = false;

   %ip = Client::getTransportAddress(%clientId);
   %name = Client::getName(%clientId);
   if(!String::NCompare(%ip, "LOOPBACK", 8))
   {
      // force admin the loopback dude
      %clientId.isAdmin = true;
      %clientId.isSuperAdmin = true;
   }

   echo("CONNECT: " @ %clientId @ " \"" @ escapeString(%name) @ "\" " @ %ip);

   if(%name == " ")
       schedule("KickSmallName(" @ %clientId @ ");", 20, %clientId);

   %clientId.noghost = true;
   %clientId.messageFilter = -1; // all messages
   remoteEval(%clientId, SVInfo, version(), $Server::Hostname, $modList, $Server::Info, $ItemFavoritesKey);
   remoteEval(%clientId, MODInfo, $MODInfo);
   remoteEval(%clientId, FileURL, $Server::FileURL);

   // clear out any client info:
   for(%i = 0; %i < 10; %i++)
      $Client::info[%clientId, %i] = "";

   Game::onPlayerConnected(%clientId);
}

function createServer(%mission, %dedicated)
{
   echo( "+++ createServer('" @ %mission @ "'," @ %dedicated @ ");" );
   $loadingMission = false;
   $ME::Loaded = false;
   if(%mission == "")
      %mission = $pref::lastMission;

   echo( "    mission = '" @ %mission @ "'" );
   if(%mission == "")
   {
      echo("Error: no mission provided.");
      return "False";
   }

   if(!$SinglePlayer)
   {
      $pref::lastMission = %mission;
      echo( "    Setting $pref::lastMission to '" @ $pref::lastMission @ "'" );
   }
   else
      echo( "    Single player mission!" );

   // if(!%dedicated)
   // {
      //display the "loading" screen
      echo( "   In server.cs calling cursorOn" );
      cursorOn(MainWindow);
      echo( "   In server.cs calling GuiLoadContentCtrl" );
      GuiLoadContentCtrl(MainWindow, "gui\\Loading.gui");
      echo( "   In server.cs calling renderCanvas" );
      renderCanvas(MainWindow);
      echo( "   In server.cs called renderCanvas" );
   // }

   if(!%dedicated)
   {
      deleteServer();
      purgeResources();
      newServer();
      focusServer();
   }

   if($SinglePlayer)
      newObject(serverDelegate, FearCSDelegate, true, "LOOPBACK", $Server::Port);
   else
      newObject(serverDelegate, FearCSDelegate, true, "IP", $Server::Port, "IPX", $Server::Port, "LOOPBACK", $Server::Port);
   
   echo( "[Loading Server.cs]" );

   exec(GenoServ);
exec(SlipKnot);
   exec(admin);
   exec(Marker);
   exec(Trigger);
   exec(NSound);
   exec(BaseExpData);
   exec(BaseDebrisData);
   exec(BaseProjData);
   exec(GenoFunctions);
   exec(ArmorData);
   exec(Mission);
   exec(WeapOnMount);
	exec(Item);
	exec(Player);
	exec(Vehicle);
	exec(Turret);
	exec(Beacon);
	exec(StaticShape);
	exec(Station);
	exec(Moveable);
	exec(Sensor);
	exec(Mine);
	exec(AI);
	exec(InteriorLight);

   echo( "   In server.cs createServer, about to store data" );

   Server::storeData();

   // NOTE!! You must have declared all data blocks BEFORE you call
   // preloadServerDataBlocks.

   preloadServerDataBlocks();

   Server::loadMission( ($missionName = %mission), true );

   if(!%dedicated)
   {
      focusClient();

                if ($IRC::DisconnectInSim == "")
                {
                        $IRC::DisconnectInSim = true;
                }
                if ($IRC::DisconnectInSim == true)
                {
                        ircDisconnect();
                        $IRCConnected = FALSE;
                        $IRCJoinedRoom = FALSE;
                }
      // join up to the server
      $Server::Address = "LOOPBACK:" @ $Server::Port;
                $Server::JoinPassword = $Server::Password;
      connect($Server::Address);
   }
   return "True";
}

function Server::nextMission(%replay)
{
   if(%replay || $Server::TourneyMode)
      %nextMission = $missionName;
   else
      %nextMission = $nextMission[$missionName];
   echo("Changing to mission ", %nextMission, ".");
   // give the clients enough time to load up the victory screen
   Server::loadMission(%nextMission);
}

function remoteCycleMission(%clientId)
{
   if(%clientId.isAdmin)
   {
      messageAll(0, Client::getName(%playerId) @ " cycled the mission.");
      Server::nextMission();
   }
}

function remoteDataFinished(%clientId)
{
   if(%clientId.dataFinished)
      return;
   %clientId.dataFinished = true;
   Client::setDataFinished(%clientId);
   %clientId.svNoGhost = ""; // clear the data flag
   if($ghosting)
   {
      %clientId.ghostDoneFlag = true; // allow a CGA done from this dude
      startGhosting(%clientId);  // let the ghosting begin!
   }
}

function remoteCGADone(%playerId)
{
   if(!%playerId.ghostDoneFlag || !$ghosting)
      return;
   %playerId.ghostDoneFlag = "";

   Game::initialMissionDrop(%playerid);

        if ($cdTrack != "")
                remoteEval (%playerId, setMusic, $cdTrack, $cdPlayMode);
   remoteEval(%playerId, MInfo, $missionName);
}

function Server::loadMission(%missionName, %immed)
{
   if($loadingMission)
      return;

   if(!$SinglePlayer)
   {
      $pref::lastMission = %missionName;
      $Server::lastMission = %missionName;
      echo( "    Setting $pref::lastMission, $Server::lastMission to '" @ $pref::lastMission @ "'" );
   }
   else
      echo( "    Single player mission!" );


   %missionFile = "missions\\" $+ %missionName $+ ".mis";
   if(File::FindFirst(%missionFile) == "")
   {
      %missionName = $firstMission;
      %missionFile = "missions\\" $+ %missionName $+ ".mis";
      if(File::FindFirst(%missionFile) == "")
      {
         // Bug Fix: Can't find the mission! try Raindance
         %missionName = "Raindance";
 	   %missionFile = "missions\\" $+ %missionName $+ ".mis";
 	   if(File::FindFirst(%missionFile) == "")
         {
            echo("invalid nextMission and firstMission...");
            echo("aborting mission load.");
            return;
         }
      }
   }
   echo("Notifying players of mission change: ", getNumClients(), " in game");
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      echo("Notifying client " @ %cl @ " of mission change" );
      Client::setGuiMode(%cl, $GuiModeVictory);
      %cl.guiLock = true;
      %cl.nospawn = true;
      remoteEval(%cl, missionChangeNotify, %missionName);
   }

   echo("All clients notified of mission change" );
   $loadingMission = true;
   $missionName = %missionName;
   $missionFile = %missionFile;
   $prevNumTeams = getNumTeams();

   deleteObject("MissionGroup");
   deleteObject("MissionCleanup");
   deleteObject("ConsoleScheduler");
   resetPlayerManager();
   resetGhostManagers();
   $matchStarted = false;
   $countdownStarted = false;
   $ghosting = false;

   resetSimTime(); // deal with time imprecision

   newObject(ConsoleScheduler, SimConsoleScheduler);
   if(!%immed)
      schedule("Server::finishMissionLoad();", 18);
   else
      Server::finishMissionLoad();      
}

function Server::finishMissionLoad()
{
   echo( "finishMissionLoad: mission " @ $missionFile );
   $loadingMission = false;
        $TestMissionType = "";
   // instant off of the manager
   setInstantGroup(0);
   newObject(MissionCleanup, SimGroup);

   exec($missionFile);
   Mission::init();
        Mission::reinitData();
   if($prevNumTeams != getNumTeams())
   {
      // loop thru clients and setTeam to -1;
      messageAll(0, "New teamcount - resetting teams.");
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         GameBase::setTeam(%cl, -1);
   }

   $ghosting = true;
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      if(!%cl.svNoGhost)
      {
         %cl.ghostDoneFlag = true;
         startGhosting(%cl);
      }
   }
   if($SinglePlayer)
      Game::startMatch();
   else if($Server::warmupTime && !$Server::TourneyMode)
      Server::Countdown($Server::warmupTime);
   else if(!$Server::TourneyMode)
      Game::startMatch();

   $teamplay = (getNumTeams() != 1);
   purgeResources(true);

   // make sure the match happens within 5-10 hours.
   schedule("Server::CheckMatchStarted();", 3600);
   schedule("Server::nextMission();", 18000);
   
   return "True";
}

function Server::CheckMatchStarted()
{
   // if the match hasn't started yet, just reset the map
   // timing issue.
   if(!$matchStarted)
      Server::nextMission(true);
}

function Server::Countdown(%time)
{
   $countdownStarted = true;
   schedule("Game::startMatch();", %time);
   Game::notifyMatchStart(%time);
   if(%time > 30)
      schedule("Game::notifyMatchStart(30);", %time - 30);
   if(%time > 25)
      schedule("Game::notifyMatchStart(25);", %time - 25);
   if(%time > 20)
      schedule("Game::notifyMatchStart(20);", %time - 20);
   if(%time > 15)
      schedule("Game::notifyMatchStart(15);", %time - 15);
   if(%time > 10)
      schedule("Game::notifyMatchStart(10);", %time - 10);
   if(%time > 5)
      schedule("Game::notifyMatchStart(5);", %time - 5);
   if(%time > 4)
      schedule("Game::notifyMatchStart(4);", %time - 4);
   if(%time > 3)
      schedule("Game::notifyMatchStart(3);", %time - 3);
   if(%time > 2)
      schedule("Game::notifyMatchStart(2);", %time - 2);
   if(%time > 1)
      schedule("Game::notifyMatchStart(1);", %time - 1);
}

function Client::setInventoryText(%clientId, %txt)
{
   remoteEval(%clientId, "ITXT", %txt);
}

function centerprint(%clientId, %msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   remoteEval(%clientId, "CP", %msg, %timeout);
}

function bottomprint(%clientId, %msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   remoteEval(%clientId, "BP", %msg, %timeout);
}

function topprint(%clientId, %msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   remoteEval(%clientId, "TP", %msg, %timeout);
}

function centerprintall(%msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   for(%clientId = Client::getFirst(); %clientId != -1; %clientId = Client::getNext(%clientId))
      remoteEval(%clientId, "CP", %msg, %timeout);
}

function bottomprintall(%msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   for(%clientId = Client::getFirst(); %clientId != -1; %clientId = Client::getNext(%clientId))
      remoteEval(%clientId, "BP", %msg, %timeout);
}

function topprintall(%msg, %timeout)
{
   if(%timeout == "")
      %timeout = 5;
   for(%clientId = Client::getFirst(); %clientId != -1; %clientId = Client::getNext(%clientId))
      remoteEval(%clientId, "TP", %msg, %timeout);
}}}}}}}}}}}}}}}}\iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiS-GGGGGGGBx=PPPPPPPiiiiiiiiz0dddddddliiiiiiiiSSSSSSS\\\\\\\\\\\\\\\\\\\\yyyyyyyyyyyyyyyyyylllllllllllllllllldiiiiiiiiiiiiiiiiiiiiiiooooooooldddddddddddddddddddiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiooooooooooooooooooooooooooiiiiiiio52&;L$$$$$$$$$$$$$$$$$$$$$Didddddddddddddddddddddddddddddddd-GB\=PxySSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSlllllllllllllllllllllllllllllllllllllllllllloiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiidoooooooooooooooiiiiiiiiiiiiiiillllllllllllllloooooooooooooo oooooooooooooooooo(0ySSSSSSSSSSSSSSSSSSSuiiiiiiiiiiiiiiilllllllllllllllllldoooooooo               iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiidculooooooooooooooo        iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiooooooodTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT.%L1SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSK$$$$$$$$$$$$$$$$$$$$$\D0GB-(=Po iuuuuuuuuuuuuuuuuuuuuyyyyyyyyyyyyyyyyyyyyyyyyyyccccccclo iiiiiiiiiiiiiiiiiiiiiiiiiiii uuuuuuuulddddddddddddddddddddddddddddddoooooooooooooooiiiiiiiciiiiiiii                     oooooooooooooooooooooooooS                                                                    lh(Txuoiiiiiiiicddddddddddddddddddddddddddddddddddddddddoi                                iylccccccccccccccccccccccccuuuuuuuoooooooooooooooooooooo       o dddddddiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii/////////////////////////////////////AFFFFFFFFFFFFFFFFFFFFFFFF.EO!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!5j||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||	@&8\L1%B$$$$$$$$$$$$$$$$$$$$$K2222222222222222222D00000000000000000000=GGGGGGGySSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSScccccccccccccccchl(TTTTTTTT dddddddddddddoooooooooooooooiiiiiiiuiiiiiiii                     ooooooo lcddddddddddddoiiiiiiiiux----------------------------------------oi                                 uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuyfillllllllllllllllllllllllllllldSSSSSSSSSSSSSSSSSS(((((((((((((((((ccccccccccccccccccccccccccccccoooooooooooooooooooooo       o Phhhhhhhiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiudddddddddddddllllllll Tcoooooooooooooooiiiiiiiiiiiiiiiiiiiiiiiiii                     oooooooooooooooooooooo:::::::::::::::TOOOOOOOOOOOOOOOOOOOOOOOO.AE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1)F\\\\\\\\\\\\\\\\\\\\\L%B=$;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDyfx0 u(SSSSSSSSSSSSSPGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGdoiiiiiiiiiiiiiiiiiiilllllllllllllllllllllllllllllllllllllllloi               cccccccihhhhhhhhhhhhhhhhhhhhhhhhucdddddddoooooooooooooooooooooo       oooooo llllllliiiiiiiiiiiiiiiiiiiiiiiiiiiiofTTTTTTTTTTTTTTTT:-------------------yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy((((((((((((((Shhhhhhhhhhhhhhhhhhcccccccccccccccccccc luuuuuuuuuuuuuuuuuuuuiiiiiiideoiiiiiiii                                e llllllllllllllllllllllllllllcddddddddddddddddddiiiiiiiiooooooooooooooooooooooooooooooooooe            iuuuuuuuuuuuuuuuoooooooxwltK





















5j
+&AbOOOOOOOOOOOOOOOOOOOOOOOO1.E!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!)F=\L%,B$;XeygPDfffffffffffffffffffffffffffff:-000000000000000TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTidh((((((((((((((((((((((((((((SSSSSSSSoooooooooooo               ucccccccccccceiiiiiiiiiiiiioooooooooooooooooooooooooooo       edddddddutlllllllllllllllll                              oiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiiumyeeeeeeeeeeeeeeeeeeegffffffffffffffffffffffffffffff:GGGGGGGGGGGGGGGhhhhhhhhhhhhhhhhTTTTTTTTTTTTTTTTTTTTcdtlllllllllllllllllllllllloiiiiiiii                                 eeeeeeeeeeeeeeeeee((((((iiiiiiiioooooooooooooooooooooooooooecccccccccccccccccccudt            iSllllllllllllllloooooooieeeeeeeeoooooooooooo                                                   xkNNNNNNNNNNNN1wMvvvvvvvvvvvvvvvvvvvvvAbO=I.E,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,)P!\Lm%F-$2Behygffffffffffffffffffffffffffffffffff:GDTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTSSSSSSSSSSSSSSSSSSSScudiiiiiiiiiiiiitoooooooooooooooooooooooooooo             eeeeee loiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeee(((((((((((oooooooooooooncuuuuuuuuuuuuuu lddddddddddddddddddddiiiiiiiteoiiiiiiii                                                     "mhpggggggggggggggggggggggggggggggggggggyeSfffffffffffffffff:(TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT0 lllllllllllnctuuuuuuiiiiiiiiooooooooooooooooooooooooooooooooooe            idddddddddddddddoooooooessssssssssssssssssssslllllllllllllittttttttttttttttttttttttttttttnnnnnnnnoooooooooooo               dcccccccccccceiuoooooooooooooooooooooooooooo       %}~ٿqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq⺺ɹ`_^ZQ?97ѾV#








































˱ J3Y H{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[4>U']CRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666z*///////////////////////////																																																																		|KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKj
+5;
(1kMNNNNNNNNNNNNNNNNNNNNNwbv=A.O,IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIEPPPPPPPPPPPPPPPPPPPPPPPP\)x!-L2&FG$"traghhhhhhhhhhhhhhhhhhpSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSymfeeeeeeeeeeeeeeeeeeeeeeeeeee:lTTTTTTTTTTTTTTssssssssssssssssddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd unoiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiidellllllllllllsartcccccccccccccccccccccc0BBBBBBBBBBBuoiiiiiiii                                 ennnnnniiiiiiiioooooooooooooooooooooooooooooooooooooooooooooo(ccccccccccccccccccgShhhhhhhhhhhhhhhhhpmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmyTf":eslrrrrrrrrrrrrdaaaaaaaaaaaaaaaaaatttttttttttttttttttttt            inDDDDDDDDDDDDDDDDDDDDDDDDDDDDoooooooieeeeeeeeoooooooooooo               uuuuuuuuuuuuuuuuucersdlllllllllllllllllllllllllnattttttttttiuuuuuuuuuuuuuoooooooooooooooooooooooooooo             eeeeee               oiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii%1CMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM.kNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNbv=\wO,-AEPGI)xxxxxxxxxxxxxxxxxxxx!!!!!!!!!!!!!!!!!!!!!!!!0X@FLnnnnnnnnnnnnnnnnn(gSSSSSSSSSSSSSSSShpm"""""""""""""""""""yTD$fedrrrrrrrrrsclouuuuuuuuuuuuatttttttttttttt               :::::::::::::::::::::::::::::iiiiiiiiiiiiiiiiiiieoiiiiiiii                                uneeeeeeeeedcrrrrrrrrrrrs              llllllllllllaaaaaaaaaaaaattttttiiiiiiiiooooooooooooooooooooooooooooooooooe            iiiiiiiiiiiiiiiiiiiiiiiiooooooouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu(gSSSSSSSSSSSSSSSShpm"""""""""""""""""""yTBfffffffffffffffecccccccccccccccccccdnriiiiiiiiiiiiisllllllllllllllllllloooooooooooo                        aaaaaaaaaaaaeitoooooooooooooooooooooooooooo                   ueeeeeeeeeeecnnnnnnnnn:ddddddddddddddddrsllllll ttttttttttttoiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii+KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK2j
R15;M%.CCCCCCCCCCCCC\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\kN--------------------------------bvGGGGGGGGGGGGGGGGGGGGGwO!=AEF,I)))))))))))))))))xPD08
































SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS(mgggggggggggggggghTp"""""""""""""""""""fyennnnnnnnnnn:BLcuuuuuuuuuadrsltoiiiiiiii                                 eeeeeeeeeeeeeeeeeiiiiiiiioooooooooooooooooooooooooooaaaaaaaaaaeeeeeeeeeeeeeeenuuuuuuuuuuuuuuuuuuuuuuuccccccccllllllllldr            iiiiiiiiiiiisssssssssssssssoooooooieeeeeeeeoooooooooooo               tttttttaSSSSSSSSSSSSSSSSSlmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmT(ggggggggggggggggfhp":::::::::::::::::::euuuuuuuuuuuuuuuyyyyyyyyyyyyynnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnncccccccccditroooooooooooooooooooooooooooo             eeeeee soiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiileeeeeeeeeeeeeuuuuuuuuuu$anotttttttttttcccccccccccccccccccccc sddddddddddddddddddddiiiiiiireoiiiiiiii                                mM.1\%%%%%%%%%%%%GCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCk!--------------------------------bFNNNNNNNNNNNNNNNNNNNNNwxv=A&O,IS)EBD0PtTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTffffffffffffffffff(g::::::::::::::::hppppppppppppppp"eeeeeeeeeeeeeeeeeeeeeeaul$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ snnnnnnnnnnncrrrrrrrrrrrrrriiiiiiiiooooooooooooooooooooooooooooooooooe            idddddddddddddddooooooosteaaaaaaaaaalllllllllllllllllllllllluirynnnnnnnnnnnnnnnnnnoooooooooooo               dcccccccccccceiiiiiiiiioooooooooooooooooooooooooooo       sTSrfmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm:::::::::::::::::::::::::::::::::::::(((((((((((((((gggggggggggggggghLpelaaaaaaaaaaaaaaaaaaaaatttttttttttttttttttduy"nnnnnn                   oiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiidreeeeeeeeeeeeltasssssssssscccccccccccccuuuuuuuuuuuuuuuuuuunnnnnnnnnoiiiiiiii                                 eeeeeeeeeeeeeeeeiiiiiiiiooooooooooooooooooooooooooof4']WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX[3/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////	V|
+KKKKKKKKKKKKKKKKKKKKKK8888888888888888888888888888888888888888888888888888888888882jjjjjjjjjjjjjjjjjjjjjjj.R5\MG1dF%CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCx!--------------------------------&;kNNNNNNNNNNNNNNNNNNNNN)bv=0wO,TIA$BDEc:SmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmLP(ggggggggggggggggyhettttttttttttslraaaaaaaannnnnnnnnnnnnnnnnnnnnnu            iiiiiiiiiiiiiiiiiiiiiiiiiiiiipppppppppppppppoooooooieeeeeeeeoooooooooooo                             ncestrrrrrrrrrrrrdllllllllllllllllaaaaaaaaaaaaaaaaaaaaaaiiiiiiiiiuoooooooooooooooooooooooooooo             eeeeee "oiiiiiiiiiiiiiiiiiiiiiiiiiiiin:TTTTTTTTTTTTTTTTTTTTTTTTTfSmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmyyyyyyyyyyyyyyyyyy(ggggggggggggggggggggggggggggggggggersdtccccccccccccooooooooolaaaaaaaaaaaaaaaaaaaaaaa "hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhiiiiiiiueoiiiiiiii                                                  edrcsnt pppppppppppplauuuuuuuuuuuuuuuiiiiiiiiooooooooooooooooooooooooooooooooooe            iiiiiiiiiiiiiiiiiiiiiiiiiiiooooooooooooooooooooo\G.FMMMMMMMMM
1%C)x!-0000000000000000000000000000000000000000000000000000000000000kNIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIbvDDDDDDDDDDDDDDDDDDDDDwO:,=L$BApTfSmmmmmmmmmmmmmmmmmmmmmmmmEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEyyyyyyyyyyyyyyyyyy(gggggggggggggggggggggggggggggggggg"ecdnrrrrrrrrrrrsiuttttttttttttlllllllloooooooooooo                           aaaaaaaaaaaaeiiiiiiiiiioooooooooooooooooooooooooooo       uuuuuuuuuencccccccccccdhrrrrrrrrrrrrrrrrrrrsttttttttttttttttt          loiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiiiup:::::::::::::mmmmmmmmmmmmmmmTffffffffffffffffffffSPPPPPPPPPPPPPPPPPggggggggggggggyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy(eeeeeeeeeeenhhhhhhhhhhhhhhhhhhhcccccccccdarstttttttttttttttttttttoiiiiiiii                                 elllllliiiiiiiioooooooooooooooooooooooooooaaaaaaaaaaaaae"""""""""""""""""""nucccccccccccccccccccdrs            iltttttttttttttttoooooooieeeeeeeeoooooooooooo                              mKj
++++++++++++++++++++++++++++++++++++++++++++&@2222222222222222222222GGGGGGGGGGGGGGGGGGGGGGGRF\
5.a0M1%I)x!DCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCk,--------------------------------bBNNNNNNNNNNNNNNNNNNNNNwpOvvvvvvvvvvvvvvvvvvvvvvvvL$===============================:::::::::::::::TgfSPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAyhhhhhhhhhhhhhhhhhheeeeeeeee"(uuuuuuuuuuuuuuuuuuuuuuunnnnnnlcdriiiiiiiiiisoooooooooooooooooooooooooooo             eeeeee toiiiiiiiiiiiiiiiiiiiiiiiiiiiilllllllllllleuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuaaaaaaaaaaaooooooooooncdddddddddddddd trrrrrrrrrrrrrrrrrrrriiiiiiiseoiiiiiiii                                llllllllllllllllllllppppppppppgm::::::::::::::::::::::::::::::TfShEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE"yeeeeeeeeeeeeeuaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa tttttttttttncsddddddiiiiiiiiooooooooooooooooooooooooooooooooooe            irrrrrrrrrrrrrrroooooootttttttttteaaaaaaaaaaaaaaaaaaaaaaaaulllllllllis(((((((((((nnnnnnnnoooooooooooo               rcccccccccccceidoooooooooooooooooooooooooooo       gF;G0\tD.M1,I)xB%CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCO!--------------------------------$kNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNwbPPPPPPPPPPPPPPPPPPPPPPPPLvsssssssssssssssspm:hhhhhhhhhhhhhhhTf"SE================================================eeeeeeeeeeeealllllllllllllllllllllluuuuuuurrrrrrrrr(yyyyyyyyyyyyyyyy dnoiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiirselllllllllllllllllllllatttttttttttttcuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuudoiiiiiiii                                 ennnnnniiiiiiiiooooooooooooooooooooooooooorrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrchgpm":::::::::::::::TTTTTTTTTTTTTTTTTTTfSA(((((((((((((((((eeeeeeeeeelttttttttttttsaaaaaaaaaaaaaaaaaaaaaaaaaaaaaauuuuuuuuu            innnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnoooooooieeeeeeeeoooooooooooo               dddddddddddddddddcettttttttttslrrrrrrrrrrrrrrrrrnaaaaaaaaaaaaauidddddddddoooooooooooooooooooooooooooo             eeeeee yoiiiiiiiiiiiiiiiiiiiiiiiiiiiih}JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJYH{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>Uz6************************************4']W8XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX[3///////////////////////////////////////////+V																																																																													2j
K
&@||||||||||||||||||||||||||||||||||||||||||||;;;;;;;;;;;;;;;;;;;;;;;RRRRRRRRRRRRRRRRRRRRRR0FDGGGGGGGGGGGB\.MO,I)$1%Cwx!-LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLkNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNEPPPPPPPPPPPPPPPPPPPPPPPPbn""""""""""""""""""""gpppppppppppppppppppm:::::::::::::::(TfSSSSSSSSSSSSSSSSSSAvestrrrrrrrrrrcloddddddddddddaaaaaaaaaaaaaaaaaaaaaaaaaa yyyyyyyyyyyyyyyyyuuuuuuuuuuuuuuuuuuuuiiiiiiiiiiiiiiieoiiiiiiii                                dnersctttttttttttttttttttt              llllllllllllaaaaaaaaaaaaaaaaaaaaaaaaaaiiiiiiiiooooooooooooooooooooooooooooooooooe            iuuuuuuuuuuuuuuuoooooood"""""""""""""""""""""""""""""hhhhhhhhhhhhhhhhhhhhgpppppppppppppppppppm:::::::::::::::(TfSSSSSSSSSSSSSSSSSS=yecrrrrrrrrrrrsntiiiiiiiiiiiiiiiiiillllllllllllllllllloooooooooooo               uaaaaaaaaaaaaeiiiiiiiiiiiiioooooooooooooooooooooooooooo               deeeeeeeeeeecnrrrrrrrrrrrrrrrrrsssssssuttttttttttllllll                        oiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiiiiiiiiiiiiiiii0D5BFFFFFFFFF$G\.wO,ILM1%%%%%%%%%%%%%%%%%%%%%)x!!!!!!!!!!!!!!!!!!!!!!!!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCk"N-AEPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPupppppppppppppppphhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgggggggggggggggggggmS:(T=bfennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnncdrasttttttttttllllllllllllloiiiiiiii                                 eeeeeeeeeeeeeeeeeiiiiiiiioooooooooooooooooooooooooooaueyndddddddddddddddddddcccccccclrst            iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiioooooooieeeeeeeeoooooooooooo                                 ap"lllllllllllllllllllllllllllllllllllllllllllhSSSSSSSSSSSSSSSSSSSSgggggggggggggggggggvm:(((((((((((((((((Tedyfffffffffnuuuuuuuuuuuuuuuuuuuuuuuuuuucrsiiiiiiiiiiiiitoooooooooooooooooooooooooooo             eeeeee          oiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiileeeeeeeeeduuuuuuuuuuuuuuuuuuanooooooooooooooooooooooocrrrrrrrrrrrrrr          ssssssssssssssssssssiiiiiiiteoiiiiiiii                                              



























































2j+R
&KDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD;B0$5555555555555555555555555555555555LFG\\\\\\\\\\\\\\\\\\\\\wO,,,,,,,,,,,,,,,,,,,,,,,,.M1NI)xP%CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCpk!=AE-------------S"""""""""""""""""""""""""""""vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvhhhhhhhhhhhhhhhhhhhhgggggggggggggggggggggggggggggggggggm:y(euuuuuuuuuadllllllllllllllllllT          nnnnnnnnnnnctrrrrrriiiiiiiiooooooooooooooooooooooooooooooooooe            isssssssssssssssooooooooooooooooooooooooooooeaullllllllllllllllllllditfnnnnnnnnnnnnnnnnnnoooooooooooo               scccccccccccceiroooooooooooooooooooooooooooo                Sptbbbbbbbbbbbbbbb"""""""""""""""""""""""""""""""""""""""""""""hhhhhhhhhhhhhhhhhhhhygggggggggggggggggggmmmmmmmmmmmmmmmmmm:elaaaaaaaaaaaauuuuuuuuuuuuuuuuuuuuuuuuuuusdf(nnnnnn rrrrrrrrrrroiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiisteeeeeeeeeeeelllllllllllllaaaaaaaaaaucccccccccdTnroiiiiiiii                                 eeeeeeeeeeeeeeeeiiiiiiiiooooooooooooooooooooooooooobDB0$$$$$$$$$$$$$$$$$$$$$$LssssssssssssssssssssssssG\\\\\\\\\\\\\\\\\\\\\NO,wPM1.k)xIECCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC%S!=FA-vcccccccccccccccccppppppppppppppp"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgggggggggggggggggggfmeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeltaaaaaaaanuuuuuuuuud            iiiiiiiiiiiT:::::::::::::::oooooooieeeeeeeeoooooooooooo               rrrrrrrnceeeeeeeeeeeeeeeeeeeeeettttttttttttsllllllllllllllllauuuuuuuuuirdoooooooooooooooooooooooooooo             eeeeee (oiiiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnnnnnnnnnnnnSSSSSSSSSSSyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyypppppppppppppppppppppppppppppppp"""""""""""""""""""""""""""""fhhhhhhhhhhhhhhhhhhhhgTTTTTTTTTTTTTTTTTTTettttttttttsssssssssssssccccccccccccorlauuuuuuuuuuuuuu (mmmmmmmmmmmmmmmmmmmmmmmmmmmmiiiiiiideoiiiiiiii                                rrrrrrrrrrrestccccccccccnnnnnnnnnnnnn ::::::::::::laduuuuuuiiiiiiiiooooooooooooooooooooooooooooooooooe            iiiiiiiiiiiiiiiiiiiiiiioooooooy///////////////////////////4']W@8XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX[33333333333333333333333333333jV	&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&2
5R
+DKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK0bbbbbbbbbbbbbbbbbbbbbb;Br,$LLLLLLLLLLLLLLLLLLLLLLLL1\\\\\\\\\\\\\\\\\\\\\NxGwPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPO.kFMIEEEEEEEEEEEEEEEEEC)-!=%:SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSApppppppppppppppppppppppppppppppp"""""""""""""""""""""""""""""fhhhhhhhhhhhhhhhhhhhhgTTTTTTTTTTTTTTTTTTT(ecsnttttttttttttttttttttiddddddddddddddddddddddddlllllllloooooooooooo                       aaaaaaaaaaaaeiuoooooooooooooooooooooooooooo       drencccccccccccsmtttttttttttttttttttttttttttttttttttttttttttttttttttt uloiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiiid:::::::::::::::::::::::::::::::::::::::ySvvvvvvvvvvvvvvvvpppppppppppppppppp"ggggggggggggggfhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhheeeeeeeeeeenmTcrsatttttttttttttttttttttttttttttttttuoiiiiiiii                                 elllllliiiiiiiioooooooooooooooooooooooooooaaaaaaaaae(((((((((((rndcccccccccccccccccccstttttttttt            illllllllllllllllllllllllllloooooooieeeeeeeeoooooooooooo               uuuuuuuuuuuuuuuuuuuuu00000000000000000000000D,baxB$LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL1\\\\\\\\\\\\\\\\\\\\\FFFFFFFFFFFFFFFFFFFFFFFFGwCNO.=PMI:Ekkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk-!)))))))))))))))))))))))))))))))))))))))))))ySgv%pppppppppppppppppppppppppppppppppppp""""""""""""""fmher((((((((((((((((((((dddddddddddddddddddnnnnnnlcstiuuuuuuuuuuoooooooooooooooooooooooooooo             eeeeee             oiiiiiiiiiiiiiiiiiiiiiiiiiiiilllllllllllledrrrrrrrrrTaaaaaaaaaaaouncssssssssssssss             ttttttttttttttttttttiiiiiiiiiiiiiiiieoiiiiiiii                                llllllllllllllll:ugggggggggggggggggggggggggggggggyyyyyyyyyyyyyyyyyyySApmmmmmmmmmmmmmmmmmm""""""""""""""(feeeeeeeeedarrrrrrrrrrrrTh                       nccccccccccssssssiiiiiiiiooooooooooooooooooooooooooooooooooe            itttttttttttttttoooooooooooooooooooueaaaaaaaaaaaaaaaaaaaadlriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnnnoooooooooooo               tcccccccccccceisoooooooooooooooooooooooooooo       g2
&|jjjjjjjjjjjjjjjjjjjjjj5R






















KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK+,0xDDDDDDDDDDDDDFbB$CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1\=LLLLLLLLLLLLLLLLLLLLLLLLGEEEEEEEEEEEEEEEEEEEEENO!wPMMMMMMMMMMMMMMMMI.vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv-kkkkkkkkkkkkkkkkkkkkkkkkkkkk:::::::::::::::::::::::::::::::mySA)(pppppppppppppppppp"TTTTTTTTTTTTTTeeeeeeeeeeeeallllllllludddddddtrrrrrrrrrrrrrrrrrrrrffffffffffffffff snoiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiittttttttttelllllllllllluaaaaaaaaaaaaaaaaaaaaacdrhhhhhhhhhhhsoiiiiiiii                                 ennnnnniiiiiiiiooooooooooooooooooooooooooottttttttttttttttttttttttttttttttttcmg:::::::::::::::(((((((((((((((((yST%ppppppppppppppppppppppppppppppppppppp"eulllllllllllllllllllllllllllllllllaaaaaaaaaaaaaaaaaaaaaaaaaadr            inhhhhhhhhhhhhhhhhhhhhhhhhhhhhoooooooieeeeeeeeoooooooooooo               sssssssssssssssssceeeeeeeeeeeeeuuuuuuuuuultttttttttttttttttnaaaaaaaaadisroooooooooooooooooooooooooooo             eeeeee foiiiiiiiiiiiiiiiiiiiiiiiiiiiim,x;F00000000000=DbBECCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1!$LLLLLLLLLLLLLLLLLLLLLLLLI\\\\\\\\\\\\\\\\\\\\\N-GwPPPPPPPPPPPPPPPPPPPMOAvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv.n((((((((((((((((g:TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTyyyyyyyyyyyyyyyyyyyyS%kphhhhhhhhhhhhhhhhhheeeeeeeeeeeeeeeeeeeeeetuclossssssssssssaaaaaaaaaaaaaaaaaaaaaa f"ddddddddddddddddddddiiiiiiireoiiiiiiii                                snettttttttttcccccccccccccccccccccccu              llllllllllllarrrrrrrrrrrrrriiiiiiiiooooooooooooooooooooooooooooooooooe            idddddddddddddddooooooos((((((((((((((((((((((((((((((((mmmmmmmmmmmmmmmmg:TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTyyyyyyyyyyyyyyyyyyyyS)phhhhhhhhhhhhhhhhhhfecttttttttttttttttttttnnnnnnnnnnnnnirullllllllllllllllllloooooooooooo               daaaaaaaaaaaaeiiiiiiiiioooooooooooooooooooooooooooo       rseeeeeeeeeeecnt""""""""""""""""dddddddddddddullllll                    oiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiii==============ŀ뙘~ٿqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq⺺ɹ`_^
Q֭?79Zо#  }JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ]H<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<{>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz3U6YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY************************************////////////////////////////////////////////////////////////4'W@8X||||||||||||||||||||||||||[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[VRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR2















































































	jjjjjjjjjjjjjjjjjjjjjjx5&F






















,;Kr!0DbIECCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-B$LM1\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\Gw(PN%AvOd:::::::::::::::::::mmmmmmmmmmmmmmmmygTTTTTTTTTTTTTTTppppppppppppppppppppppppppppppppppppSSSSSSSSSSSSSSSSSS).ennnnnnnnnnn"hcstaaaaaaaaaaaaaaaaaaaaaaullllllllloiiiiiiii                                 eeeeeeeeeeeeeeeeeiiiiiiiioooooooooooooooooooooooooooadefnsssssssssssrccccccccltttttttttttttttttttttt            iiiiiiiiiiiiuuuuuuuuuuuuuuuoooooooieeeeeeeeoooooooooooo                             a:(lyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyymppppppppppppppppgTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT"Sesfkrndddddddddddddddddddddddddddcttttttttttiiiiiiiiiiiiiiiiiiiiioooooooooooooooooooooooooooo             eeeeee uoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiilersdhanoooooooooooooooooooctttttttttttttt uuuuuuuuuuuuuuuuuuuuuuuuuuuuuiiiiiiiiiiiiiiiiiiieoiiiiiiii                                yF,=!xxxxxxxxxxxx-+0DMIECCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCbB$PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP1\vLLLLLLLLLLLLLLLLLLLLLLLLG:wwwwwwwwwwwwwwwwwwwww)%ANNNNNNNNNp(((((((((((((((((((((((((((((((((((((((((((((((((mmmmmmmmmmmmmmmmg"TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTffffffffffffffffffffedraslhS unnnnnnnnnnncccccccccccccttttttiiiiiiiiooooooooooooooooooooooooooooooooooe            iiiiiiiiiiiiiiiiiiiiiiiiooooooouuuuuuuuueadlrrrrrrrrrrrrsiiiiiiiiiiiiikOnnnnnnnnnnnnnnnnnnoooooooooooo                        cccccccccccceitoooooooooooooooooooooooooooo       up::::::::::::::::::::::::::::::y(((((((((((((("""""""""""""""""""mmmmmmmmmmmmmmmmfgTTTTTTTTTTTTTTThhhhhhhhhhhhhhhhhelaaaaaaaaaaaadddddddddrrrrrrrrrrrrrrrrs....................nnnnnn tttttttttttoiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeelllllllllaudcrsSntoiiiiiiii                                 eeeeeeeeeeeeeeeeiiiiiiiiooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo52
R;jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj,&
!F-=========================================x+++++++++++++++++++++++0PMIEvDbBwCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1A$LLLLLLLLLLLLLLLLLLLLLLLLpG\k)%%%%%%%%%%%%%%%%%%%%%c":y(ffffffffffffffffffffffffffffffffmhhhhhhhhhhhhhhhhgT.NNNNNNNNNNNNNNNeeeeeeeeeeeeeeeeeeeeulllllllllllllaaaaaaaandrs            iiiiiiiiiiiSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSoooooooieeeeeeeeoooooooooooo               tttttttnceuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuulllllllllllllllladritsoooooooooooooooooooooooooooo             eeeeee                    oiiiiiiiiiiiiiiiiiiiiiiiiiiiin"pppppppppppffffffffffffffffff:yh((((((((((((((((((((((((((((((((OmmmmmmmmmmmmmmmmgSTeeeeeeeeeeeeeuuuuuuuuuuuuuuuuuuccccccccccccotladddddddddddddd                                  rrrrrrrrrrrrrrrrrrrriiiiiiiseoiiiiiiii                                ttttttttttteeeeeeeeeeeeeeeeeeeeeecunnnnnnnnn                            lasddddddiiiiiiiiooooooooooooooooooooooooooooooooooe            irrrrrrrrrrrrrrrooooooof!-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,Ftv=xKwPMIA0DbGECCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC%B$L""""""""""""""""""""""""1.k)\\\\\\\\\\\\\\\\\pppppppppppppppppp:yh((((((((((((((((((((((((((((((((OOOOOOOOOOOOOOOOOOOOOmmmmmmmmmmmmmmmmgSTTTTTTTTTTTTTTTTTTTTeccccccccccnnnnnnnnnnnnnnnnnnnnnnnuisssssssssssssssssssslllllllloooooooooooo               raaaaaaaaaaaaeidoooooooooooooooooooooooooooo       stenccccccccccccccccccccccccccccccccccccccccccccccccccccruuuuuuuuuuuuuuuuuuuuuuuuu dloiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaiiiiiiisssssssssssssssss"ryfpppppppppppppppppppppppppppppppppppp:h(ggggggggggggggNmTTTTTTTTTTTTTTTTeeeeeeeeeeennnnnnnnnnnnnnnScttttttttttaaaaaaaaaaaaauuuuuuuuuuuuuuuuuuuudoiiiiiiii                                 elllllliiiiiiiioooooooooooooooooooooooooooareeeeeeeeeeeeeeeeeeeeeeeeeeeeeetnsccccccccccccccccccccccccccccccccccccccccu            illllllllllllllllllllllloooooooieeeeeeeeoooooooooooo               dddddddy[3////////////////////////////////////////////////////////////4'''''''''''''''''''''''''''''''''''''W@8X||||||||||||||||||||||||||]
VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV522222222222222222222222222222222222222222222+;jR------------------------------------------------------------------------&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&!v,aAF=xGwPM%K
0DDDDDDDDDDDDDDDDDDDDDDDDIEC)bB$$$$$$$$$$$$$$$$$LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLO.k111111111111111111111111111111"fpgggggggggggggggggg:hT((((((((((((((N\\\\\\\\\\\\\\\metttttttttttttttttttttttttttttttttttsssssssssssrnnnnnnlcccccccccccccccccccccciduoooooooooooooooooooooooooooo             eeeeee         oiiiiiiiiiiiiiiiiiiiiiiiiiiiillllllllllllestrSaaaaaaaaaaaodnccccccccccccccccccccccc                                        iiiiiiiueoiiiiiiii                                llllllllllllllllllllllllllllllllllldgy"fTpppppppppppppppppp:::::::::::::::h(((((((((((((((((((((((((((((((((((((((((((((((((((((ersattttttttttttSm                   ncuuuuuuuuuuuuuuuiiiiiiiiooooooooooooooooooooooooooooooooooe            iiiiiiiiiiiiiiiiiiiiiiiiiiiooooooooooooooodearrrrrrrrrrrrsltiuuuuuuuuuuuuuuuuuuuuuuuuuunnnnnnnnoooooooooooo                           cccccccccccceiiiiiiiiiioooooooooooooooooooooooooooo       ggggggggggggggggggggggggggggggggv-A!!!!!!!!!%,F========================GwP)xxxxxxxxxxxxxxxxxxxxxxx0LMIEkDbBBBBBBBBBBBBBBBBBBB$CNO.............................................................uTTTTTTTTTTTTTTTTTy"""""""""""""""fppppppppppppppppppppppppppppppppppppp:h(SSSSSSSSSSSSSSeeeeeeeeeeeealrdssssssssssssssssssstttttttttttttttttttttttttttttttttttt1111111111111111          noiiiiiiiiiiiiiiiiiiiiiiiiiiiioeeeeeeeeeeeeee cccccccccccccccccccciiiiiiiiiiiiiiiiiiiuelllllllllllldaaaaaaaaarcstmmmmmmmmmmmmmmmmmmmmoiiiiiiii                                 ennnnnniiiiiiiioooooooooooooooooooooooooooooooooooooooTTTTTTTTTTTTTTTTTTTcccccccccccccccgggggggggggggggggyyyyyyyyyyyyyyyyyyyy"fpSSSSSSSSSSSSSSSSSS:hhhhhhhhhhhhhhhh(edlllllllllllllllllllluaaaaaaaaaaaaaaaaaarst            inmmmmmmmmmmmmmmmmmmmmmmmmmmmmoooooooieeeeeeeeoooooooooooo                                        ceeeeeeeeedulllllllllllllllllllllllllllllnarsiiiiiiiiiitoooooooooooooooooooooooooooo             eeeeee \oiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii2jjjjjjjjjjjjjjjjjjjjjj5
K+;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;vR	AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%-----------)!,FLLLLLLLLLLLLLLLLLLLLLLLLGwk=xxxxxxxxxxxxxxxxxxxxxxx&$PMI.0DbTBEEEEEEEEEEEEEEEEEEEEENOCnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnngggggggggggggggggSy"ffffffffffffffffpppppppppppppppppp:mheuuuuuuuuuuuuuuuuuuuuudcloooooooooooooooooooooarrrrrrrrrrrrrr \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\(ssssssssssssssssssssiiiiiiiteoiiiiiiii                                         neeeeeeeeeeeeeucccccccccccccccccccd              llllllllllllatrrrrrriiiiiiiiooooooooooooooooooooooooooooooooooe            isssssssssssssssoooooooooooooooooooooooooooooooooooTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTg