// -------------------------------------------------
// declare the terrain types here
// -------------------------------------------------
$terrainTypes[0, type]           = "flat";
$terrainTypes[0, description]    = "Flat terrain";
$terrainTypes[0, visDistance]    = 900;
$terrainTypes[0, hazeDistance]   = 600;
$terrainTypes[0, screenSize]     = 90;

$terrainTypes[1, type]           = "rolplains";
$terrainTypes[1, description]    = "Rolling plains";
$terrainTypes[1, visDistance]    = 600;
$terrainTypes[1, hazeDistance]   = 400;
$terrainTypes[1, screenSize]     = 70;

$terrainTypes[2, type]           = "rolhills";
$terrainTypes[2, description]    = "Rolling hills";
$terrainTypes[2, visDistance]    = 500;
$terrainTypes[2, hazeDistance]   = 400;
$terrainTypes[2, screenSize]     = 70;

$terrainTypes[3, type]           = "modhills";
$terrainTypes[3, description]    = "Moderately hilly";
$terrainTypes[3, visDistance]    = 500;
$terrainTypes[3, hazeDistance]   = 400;
$terrainTypes[3, screenSize]     = 70;

$terrainTypes[4, type]           = "bighills";
$terrainTypes[4, description]    = "Large hills";
$terrainTypes[4, visDistance]    = 500;
$terrainTypes[4, hazeDistance]   = 400;
$terrainTypes[4, screenSize]     = 55;

$terrainTypes[5, type]           = "rughills";
$terrainTypes[5, description]    = "Rugged hills";
$terrainTypes[5, visDistance]    = 300;
$terrainTypes[5, hazeDistance]   = 200;
$terrainTypes[5, screenSize]     = 40;

// -------------------------------------------------
// the different terrain sizes
// -------------------------------------------------
$terrainSizes[0, size]            = 64;
$terrainSizes[0, name]            = "Small";
$terrainSizes[1, size]            = 128;
$terrainSizes[1, name]            = "Medium";
$terrainSizes[2, size]            = 256;
$terrainSizes[2, name]            = "Large";

// -------------------------------------------------
// pretty flat terrain
// -------------------------------------------------
function Terrain::flat::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
   
   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain " @ %size @ " .9");
   LS::addCommand("normalize 0 15");
}

// -------------------------------------------------
// rolling plains
// -------------------------------------------------
function Terrain::rolplains::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain " @ %size @ " .95");
   
   if(%size == 64)
   {
      LS::addCommand("normalize 0 49");
   }
   else if(%size == 128)
   {
      LS::addCommand("normalize 0 59");
   }
   else if(%size == 256)
   {
      LS::addCommand("normalize 0 59");
      LS::addCommand("terrain 64 .96");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 24");
      LS::addCommand("add_stack 1");
   }
}

// -------------------------------------------------
// rolling hills
// -------------------------------------------------
function Terrain::rolhills::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
 
   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain " @ %size @ " .95");
   
   if(%size == 64)
   {
      LS::addCommand("normalize 0 59");
      LS::addCommand("smooth .3 .4");
   }
   else if(%size == 128)
   {
      LS::addCommand("normalize 0 109");
      LS::addCommand("smooth .3 .4");
   }
   else if(%size == 256)
   {
      LS::addCommand("normalize 0 109");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 64 .95");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 50");
      LS::addCommand("add_stack 1");
   }
}

// -------------------------------------------------
// moderately hilly
// -------------------------------------------------
function Terrain::modhills::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain " @ %size @ " .95");
   
   if(%size == 64)
   {
      LS::addCommand("normalize 0 109");
      LS::addCommand("smooth .3 .4");
   }
   else if(%size == 128)
   {
      LS::addCommand("normalize 0 169");
      LS::addCommand("smooth .3 .4");
   }
   else if(%size == 256)
   {
      LS::addCommand("normalize 0 239");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 64 .9");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 37");
      LS::addCommand("add_stack 1");
   }
}

// -------------------------------------------------
// really hilly
// -------------------------------------------------
function Terrain::bighills::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain " @ %size @ " .95");
   
   if(%size == 64)
   {
      LS::addCommand("normalize 0 125");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 16 .7");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 6");
      LS::addCommand("add_stack 1");
   }
   else if(%size == 128)
   {
      LS::addCommand("normalize 0 225");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 32 .7");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 6");
      LS::addCommand("add_stack 1");
   }
   else if(%size == 256)
   {
      LS::addCommand("normalize 0 325");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 32 .7");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize 0 12");
      LS::addCommand("add_stack 1");
   }
}

// -------------------------------------------------
// rugged hills
// -------------------------------------------------
function Terrain::rughills::create(%size, %seed)
{
   if(%seed == "")
      %seed = 0;
   LS::addCommand("terrain " @ %size @ " .95");

   if(%size == 64)
   {
      LS::addCommand("normalize 0 99");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 32.7");
      LS::addCommand("tile");
      LS::addCommand("normalize  0 13");
      LS::addCommand("add_stack 1");
   }
   else if(%size == 128)
   {
      LS::addCommand("normalize 0 140");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 32 .7");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize  0 26");
      LS::addCommand("add_stack 1");
   }
   else if(%size == 256)
   {
      LS::addCommand("normalize 20 259");
      LS::addCommand("smooth .3 .4");
      LS::addCommand("terrain 32 .8");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("tile");
      LS::addCommand("normalize  0 43");
      LS::addCommand("add_stack 1");
   }
}
ss}
ss}
ss}
ss}
ssnr24.28)
   {
      LS::addCen3sehhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh/add_stack 1");
   }
}
ss}
ss}
ss}
ss}
ssnr24L,c.fic.f128)
   {
      LS::addCommand("normalilililillz7T ommand("tile");
      LS::addCommand("mand("tile");
      L#dddddd4a1212121212121212121212  LS::addCommand("add_stack 1");
   }
}

// --------------------------------------------------     LS::addCommand("normammand("normammand("normammand(______________________________________________________________________________________________________________________                      (__________________________________________________d(___________8rrrrrr.eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedmalilililillz7T 2 c_______8rrrrrr.eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaeeeeee4esnnFrrrrrrrrrrrrrrrrrrrrr7aali                                                                                                                     e                                                                                                                            2ds e Br                                                                 uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu____i4d1111111h:::::::::::::::::::9zeeedddde hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhuuuuuuu uuuuuuuuuuuuuuuuuuuuuuuuuuuuxeuuuuuuuuuuuuuuuuuuuuuuuuu2nauu2ngrluuuuu2nauu2ngrluuuddde hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh4("nnnnnnnsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
     5 ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssdeeeemanľiiiiiehhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh
    A߳Appppppppppppppppppppppd  {
      LS::addCommand("normalize 0 99");
      L6 2ngrluuuddde hhhhhhlPPPPPiiiiehhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh]rҜ.["ppp?       r͏b    r͏b    r͏b     r͏b     r͏b     r͏b     r͏b  @ @ @ @ @ @    5 ssssssssssssssssssssssssssssssssssssssssssssssssssssss5hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh|l1~ sssssssssssssssssss---------------------- hhhhhhhhhhhh@    5 sssssssssssssssssssssssssssss "rrr.eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeԁ.s}
ss}
ssnr24.28)
   {
      LS::addCen3sehhhhhhhhhhhhhqsaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaacccccccccccccccccccccccccccccccccccccccccaaaaaaaaa?  eeesssssssssssssssssss "rrr.eeeeeeeeeeeeeeeeeeeeeeeeee{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\V\\\ssnr24.28)
   {
      LS::addCen3sehhhhhhhhh}ZYXeW)s}
ss}
ssnr24.28)
   {
        e>`yQjssssssssuONhhhhhhhhhhhhhhhhh%%%%%%%%%%%%%%%%%%JeeeI @ @ @ @ aaLS::adeHGE0eJeeeI @ @ @ aaLS::adeHGE0eJeeeI @ K2摖nd("normammand("normammand("normammand(__________________________________________________leeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeB<6
2摖nd("normammand("normaΓ2摖nd("nodF2摖nd("norma2摖nd("nodF999999hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhHhnhhhhhhhhhhhhHhnhhhhhhhhhhhhHhnhhhhhhhhhhhhHhnhhhhhh+ ' 4, PPPPvU\E\E\E\E\E\E!s^k-8nd("no{@ &&&&*&&&&*&&&&*&&&&*&&&&*&&&&*&&&&*&&;\E\E                                          TW2TW2TW2TW2TW2 Ǹ#neeeeeeeeeeeeeeeeeeeeeeeeeeS9\E Lnd("norma2摖nd("nodFDm2222222222222222222NTW2/("nod(w	(((((((((((((((((((((((((((((((((((((((((((((((((((((:(((esssssssssssssss "rrr.eeeeeeeeeeeeeeeeeeeeeeeeee{\\\\\\\\\eee4iiiiiiiiisra4\E\E\E\E\E\E!s^k-8nmr9((((((((((((((((((0JeeeI @ e1:cgDm2222222222222222222NTW2/("nod(w	 u22222222TW2/iisssssssa42                             nd4e2           ssa42                             5l5ldvldvldvldvldvldvldvldvldvldvldvldvldvldvldvldv$LdF     5    .od(w	 u22222r2r2r2r2r2r2r2r2r2r2r2r2r2r2r2r2r2r2r2r22r22r22r22r22r22r22r3tmooooooooooooooooooooooooooooooooooooooooooooooooogd'/ldvldvld8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d88d8d8d8d88d8d8d8d88d8d8d8d88d8=
lT2::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::1lllllllllllllllllllllllll%2Soz.od(w	 u22222r2r2r2r,r,r,r,r,r,7c4nnnnnnnnn0:::::::::::::::::::1lllllllllllllllllllllllll%2%2%2%2%2%2%2(w	%2(w	%2(1a :::::::::::1lllllllllllllllllllllllll%2nooooosllllllllll%2  iler  ileaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa                                                             4hhhhhhhhHhnhhhhhhhhhhhhHhnhhhhhhhhhhhhHhnhhhhhhhhhhhh46eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
"8d8d8d8nseeee444444444444444444444444444444444442ad3g:9h
9h
9h

9h

9h

9h

9h

4:::1lllllllllllllll.ch
9h

9h

9h

9h

rrrrrr::::::1lllllllllllmitT2:44444 qqqqqqqqqqqqqqqqqqq44444                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeei   eeeei   eeeei   eeeei   eeeei   eeeei   eeeei   eeeei                     s  s GGGGGGGGGGGGGGGGGGlnnnnnnnnn0:::::::::::::::::::1lllllllllllllllllllllllll4eeeeeeeeeeeeeeeeeeeeeeeeeeeeee2arrrrrrreeeeeeee2arrrrrrreeeeeeee2arrrrrrreeeeeeee2arrrrrrreeeeeeee2ddddddddddddddddddd GGGGGGGGGGGGGGGGleeennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnlll4nnnlll      ee2dddddddddddd(H::::::::::::::::1lllllllllllllllllllbE\:reeeeeeeeeeeeeeeeeeeiPkp8]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]d@ng                     s  s GGGGGGGGGGGGGGGGGGlnnnnnnnnn0F_mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmM-[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[;}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}WB##########################D)6$N//////////////////////////////////////////////////////////////////LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL=

















































































TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTS1c'z,yyyyyyyyyyyyy7""""""""33333333333333333333333333333333333333333333333333333333333333333333333333333555555555555555555555sssssl2a.......................h                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerdniiiiiiiiiiiiiiiiiiiiisssssl2aaaaaaa                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeet                                                                                                                            ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccooooooooooooooooooooooooooooo16:gggggggggggggggggggggggg3"mmmmmmmmiqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq5ldnreeeeeeeeeeeeeeeeeeeees aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaat.2222222                                                                                                                            eeeeeeennnnnnnnnnnnnnnnnnnnnnnnaldiiiiiiiiiiiiiiiiiiiiiiiiiiisrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeh                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee2244444444444444444444444444444444448888888888888888888888888888888888888888888888888888888888p/(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((LLLLLLLLLLLLS































=,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTfzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzyyyyyyyyyyyyyoc11111111111111111111:::::::::::::::::::::::::::::36mg7"""""""""""""""""""""""""""""""""""""""""""""""ttttttttttttttttttttttnnnnnnnnnnnnnnnnnnnnnnnnaldiiiiiiiiiiiiiiiiiiiiiiiiiiisrrrrr                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeh5                                                                                                                            l24nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnaaaaaaedi rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr.sssss                                                                                                                            eeeeeeemmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmot11111111111111111111:::::::::::::::::::::::::::::36c444444444






















"ggggggggal2hhhhhhhhhhrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnndiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeee......................                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeessal24rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnndiiiiiiiiiiii                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee5                                                                                                                            ߳Ҝ?͏稹xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|~ԁVZYXR>`QjOJICK<+ U!{&^*A9v	EHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHbk\\\\\\\\\\\\\\\\\\\\\\\\\\\P@]____________________________________________________________M------------------------------------------------[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[;}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}WB$#D)NwǓ'88888888888888888888888888888888888888888888888888888888888888888888888888888888888///////////////////////////////((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSpppppppppppp66666666666666
=,zzzzzzzzzzzzzzzzzzzzzzzzzTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTfffffffffffymht11111111111111111111:::::::::::::::::::::::::::::3olllllllllllllllllllllllllllllllg












c"""""""""""""""""""""sa........d4r2eeeeeeeeeeeeeeeeeeen                                                                            5555555555iiiiiii                                                                                                                            eeeeeeerrrrrrrrrrrrrrrrrrrrrsaaaaaad4llllllllllllllllllllllllln2222222222222222222222222222222222222222222222222222222222222eeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeii6hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh1m:t3333333333333333333333333333333333333333333333333333333333333333333333goccccccccc.75"rrrrrrrrrrrrrrrrrrrrrsaaaaaad4llllllllllllllllllllllllln22222                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                            dirrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrraaaaaase4l 2222222222222222222222222222222222222222222222222222222222222222222222222222222222nnnnn                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee9999999999999999999999999999999999999999999999998hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh///////////////////////////////////////////////////(LLLLLLLLLLLLLLLSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppzzzzzzzzzzzz
=q,,,,,,,,,,,,,,,,,,,,,,,,,T


































fffffffffff651m:t3333333333333333333333333333333333333333333333333333333333rcg.oooooooooooooooooooooooooooooooooooooooooodiiiiiiiiiiiiiiiiiiiiii7y2222222222222222222aaaaaaaaaaaaaaaaaaaaaaaaa4lssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeeeee"                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeennnnnnndir2222222222222222222aaaaaaaaaaaaaaaaaaaaaaaaa4lsssssss                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                                               hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh51m:t36d.cccccccccccccccccccccccccccccgggggggggggggggggggggggggggggggggggggggooooooooooooooooooonnnnnnnnnnnnnnnnnnnnnnn4r2ieaaaaaaaaaaaaaaaaaaaaa sssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssslllllll                                                                                                                            eeeeeee2222222222222222222nnnnnns4rdddddddaaaaaaaaaaaaaaaaaaaaaiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeee"                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeellllllllllllllllllllllllllllllllllllll%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{vvvvvvvvvvvvvvvvvvvvvvvvvvvEbk\HP@____________________________________________________________M]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD[;-}}}}}}}}}}}}}}}}}}}}}}}}}}WB$###########################################################)uNǓ''''''''''''''''''''''''''''''''''''''''99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL8ppppppppppppppppppppppppppppppppppppppppppppppppppp(/zSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSq
============7777777777777777777777777T,hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhfffffffffffffffffffffffffffffffffffffffff11111111111111111111111:53m.ttttttttttttttttttttttttttttt666666666666666666666666666666666666666ccccccccccggggggggo2222222222222222222nnnnnns4rdddddddaaaaaaaaaaaaaaaaaaaaaiiiii                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee"""""""""                                                                                                                            4l2222222222222222222aaaaaasnerd iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii                                                                                                                            eeeeeee.hhhhhhhhhhhhhhhhhhhhhhhhhhhhh11111111111111111111111:53mmmmmmmmmmmmmmmmmmmm22222222222222222222222222222222222222222222222222222222222222222222222222226tcs4l"giaaaaaaaaaaaaaaaaaaaaaaaaaaaardnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeyo                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeees4l2iaaaaaaaaaaaaaaaaaaaaaaaaaaaardnnnnnnn                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                                                                                                  u0000000000000000000000000000000000000000000000000000099999999999999999999999999999999hhhhhhhhhhhhhhhhhhhhhhhhhhhhLppppppppppppppppppppppppppppppp(8zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz/SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSm==================================================
T











7777777777777777777777777777777777777,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,.""""""""11111111111111111111111:53333333333333333333333444444444444444444444444444444444444444444444444tttttttttttttttttttttttttttttttttttttttttttttttt6aaaaaaaaaaaaaaaaaaaaasyfcr2ileeeeeeeeeeeeeeeeeeeeeeee nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnngddddddd                                                                                                                            eeeeeeeiaaaaaaaaaaaaaaaaaaaaasnr2444444444444444444444444444444llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllleeeeeo                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeddm"h1.::::::::333333333333333333333333333333335ttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt6iaaaaaaaaaaaaaaaaaaaaasnr2444444444444444444444444444444lllll                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeoc                                                                                                                            rdiaaaaaasnnnnnnnnnnnnnnnnnnnnne24 lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllggggggggggggggggggggggg                                                                                                                            eeeeeeeεG߳Ҝ?͏稹xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|~~~~~~~~~~~~~~~~~~~~~~~~~~~VZXY>Rj`QOJCIK<+ &U!^*A																																					%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{v999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999bE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\PkHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH@______________________________________________________MD][[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;}-=##########################WB$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$)Nu00000000000000000000000000000000000000000000000000000q"pppppppppppppppppppppppppppp(Lzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz8''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''////////////////////////////////SSSSSSSSSSTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT











y7777777777777777777777777,mmmmmmmmm1.::::::::33333333333333333333333hiiiiiiiiiiiiiiiiiiiitttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt555555555555555555555555555555555555555nrdooooooooooooooooooooooooooooollllllsaaaaa2444444444444444444444444444444444444444444444444444444444444444444444444444444444eeeeeeeg6                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeenrdillllllsaaaaa2444444444444444444444444444                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeec                                                                                                                                                  """"""""""ooooooooo1.::::::::3mrffffffffffffffffffff5thhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhnggggggggggggggggggggggggggggggggggggggg2ildesa                                                                                           ccccccccccccccccccccccccccccc4444444                                                                                                                            eeeeeeellllllllllllllllllllllllnnnnnnnnnnnnnnnnnnnnn2irrrrrrrsadddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddeeeee6                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee44444444444444444444444444444444444444444=======================================================================(00000000000000uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuupppppppppppppppppppppppppppp9999999999999999999999999999999999999999999999999999999999zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzLT88888888888888888888888888888888888888888888S/yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy












"7777777777777777777777777ooooooooooooooooooooooo1111111111:::::::::3.f,,,,,,,,5mhhhhhhhhhhhhhhhhhhhhgtccccccccccccccccccccccllllllllllllllllllllllllnnnnnnnnnnnnnnnnnnnnn2irrrrrrrsaddddd                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee666666666666666666666666666666666666666                                                                                                                            24llllllsnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneir dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddaaaaa                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee"oc1111111111:::::::::3.......................lh5gmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm246tdsnnnnnnnnnnirrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaaaaaaaaaaaaaaa24ldsnnnnnnnnnnirrrrrrrrrrrrrrrrrrrrrrrrr                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                            #%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{vvvvvvvvvvvvvvbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb\\\\\\\\\\\\\\\\\\\\\\\\PEkHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH@D_[M;]}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}S--------------------------WB$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$)Nqw=======================================================================(0"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""ppppppppppppppppppppppppppppppp9TzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzLLLLLLLLLLLLLu8................................................................/yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyf

777777777777777777777777777777777777777777777777777777777776c1111111111:::::::::3o2ghhhhhhhh55555555555555555555555msaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaild4ennnnnn                                                                                                                               trrrrrrr                                                                                                                            eeeeeeedsaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaail2222222nnnnnn4444444444444444444444444444444444444444444444444444444444444eeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeerr.6"1,:c3333333333ggggggggggggggggooooooooooooooooooooooohhhhhhhhhhhhhhhhhhhhhhhhhhhhh555555555555555555555555555555555555555mdsaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaail2222222nnnnnn44444                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                            irdsnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnael2 4444444444444444444444444444444444444444444444444444444444444444444444444tttttttttt                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS=======================================================================(066666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666Tppppppppppppppppppppppppppppppppppppppppppppppppppp9999999999999zuLLLLLLLLLLLLLL'gggggggggggg88888888888888888888888888888888/fyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy

.......................................1,7:c3333333333"ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddooooooooohhhhhhhhhhhhhhhhhhhirrrrrrrrrrrrrrrrrrrrrr54nnnnnnnnnnnnnnnnnnnnnsssssl2aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeetm                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeird4nnnnnnnnnnnnnnnnnnnnnsssssl2aaaaaaa                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                                     6gggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg1111111111111111111111111:c3.iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"onnnnnnnnnnnnnnnnnnnnnnnnthld4reeeeeeeeeeeeeeeeeeeees aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa52222222                                                                                                                            eeeeeee4nnnnnnnnnnnnnnnnnnnnnnnnaldiiiiiiiiiiiiiiiiiiiiiiiiiiisrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeem                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee22굷G߳΄Ҝ?͏稹xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|~VZX>Rj`QOJCYK<I#& !U^+A*	\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F{܅bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbv;PEkkkkkkkkkkkkkkkkkkkkkkkk@D_[MH}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}]WB$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$----------------------------------------qwN)(((((((((((((((((((((((((((((((((S=======================================================================================================================================0uTppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppz9ffffffffffffff'LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL/8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,y66666666666






























1g:::::::::::::::::::::::::::::::::::::::3333333333333333333333333




























ccccccccc."""""""""""""""""""""""ttttttttttttttttttttttttttto4nnnnnnnnnnnnnnnnnnnnnnnnaldiiiiiiiiiiiiiiiiiiiiiiiiiiisrrrrr                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeemh                                                                                                                            l24nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnaaaaaaedi rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr5sssss                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee666666666666666666666666666666666666666661g:::::::::::::::::::::::::::::::::::::::377777777774"""""""""t.cccccccccccccccccccccccal2mmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnndiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeee5o                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeessal24rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnndiiiiiiiiiiii                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeh                                                                                                                            (((((((((((((((((((((((((((((((((SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS666666666666666666666666666666666666666666666666666666666666666666666666666666uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuup000000000000Tzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzfffffffffffff=977777777777777LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL/8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,yyyyyyyyyyy




















































mmmmmmmmmmmmmmmmmmmm1g:::::::::::::::::::::::::::::::::::::::3333333333333333333333lt"cccccccccccccccccc.....................sa55555555555555555555555d4r2eeeeeeeeeeeeeeeeeeen                                                                            hhhhhhhhiiiiiii                                                                                                                            eeeeeeerrrrrrrrrrrrrrrrrrrrrsaaaaaad4llllllllllllllllllllllllln2222222222222222222222222222222222222222222222222222222222222eeeeeo                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeii
m611111111111111111111111111111::::::::::::::::::::3gtttttttttttttttttttttttttttttttttttttttccccccccccccccccccccccccccccccc"555555555h.rrrrrrrrrrrrrrrrrrrrrsaaaaaad4llllllllllllllllllllllllln22222                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooooooooooooooo                                                                                                                            dirrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrraaaaaase4l 22222222222222222222222222222222222222222222222222222222222222222222222222222222nnnnn                                                                                                                            eeeeeee#\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{܅;bEvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvPk@@@@@@@@@@@@@@@@@@@@@@@@______________________________________________________MD[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH}7WWWWWWWWWWWWWWWWWWWWWWWWWWW]B$-qN)'''''''''''''''''''''''''''''''''SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS(muuuuuuuuuuuuuuuuuuuuuuuuuuuupppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppz0fT=================================================================================tttttttttttttttttttttttttttttttt99999999999999LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL/8
,,,,,,,,,,,,,,,y










h11111111111111111111111111111::::::::::::::::::::3g6rrrrrrrrrrc555555555555555555555555555555555555555555555555555555555555""""""diooooooooo2222222222222222222aaaaaaaaaaaaaaaaaaaaaaaaa4lssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeee.                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeennnnnnndir2222222222222222222aaaaaaaaaaaaaaaaaaaaaaaaa4lsssssss                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                            gmtoh11111111111111111111111111111::::::::::::::::::::3333333333333333333333333d555555555555555555555555555555555555555555555555c6666666666666666666666666666666666666666nnnnnnnnnnnnn"4r2ieaaaaaaaaaaaaaaaaaaaaa ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssslllllll                                                                                                                            eeeeeee2222222222222222222nnnnnns4rdddddddaaaaaaaaaaaaaaaaaaaaaiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeee.                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeellllllllllllllllllllllllllllllll7777777777777777777777777777777777777777777777777777777pSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSzuuuuuuuuuuuuuuuuuuuuuuuuuuuu(======================================================================================================================================================fT00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000













L9
/88888888888888888888888888888888888m,,,,,,,,,,,,,,,og1t:h333333333333333333333333333335555555555555555555555555555555555555555555555555555555555555555555555555555555555y66666666666666666cccccccccccccccccccccccccccccccccccccccccccc2222222222222222222nnnnnns4rdddddddaaaaaaaaaaaaaaaaaaaaaiiiii                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee."                                                                                                                            4l2222222222222222222aaaaaasnerd iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii                                                                                                                            eeeeeee5mooooooooooooooooooooooo1t:h33333333333333333333333333333g2666666666666666666666666666666666666666666666666666666666666666666666666666666666666s4l.ciaaaaaaaaaaaaaaaaaaaaaaaaaaaardnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeees4l2iaaaaaaaaaaaaaaaaaaaaaaaaaaaardnnnnnnn                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee"                                                                                                                            ֩G߳΄Ҝ?͏稹xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|Fԁײ~VZXR>`QjOJCYK<WIك!&^ AU+*#\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%w;EbkvP@____________________________________________________________MMMMMMMMMMMMMMMMMMMMMMMMDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD[H{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}]	B$-qNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN7777777777777777777777777777777777777777777777777777777)Spmmmmmmmmmmmmmmmmmmmmmmmmmmmmz=uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu(((((((((((((((((((((((((((((((((((((((((((TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTfffffffffffffffffffffffffffffffff00000000000000000000000000000LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL
888888888888889
























///////////////////////////////////,5.......................1t:h3o444444446666666666666666666666666666666666666666666666666666666666gggggggggggggggggggggggggaaaaaaaaaaaaaaaaaaaaassssssssssssssssssr2ileeeeeeeeeeeeeeeeeeeeeeee nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn"cddddddd                                                                                                                            eeeeeeeiaaaaaaaaaaaaaaaaaaaaasnr2444444444444444444444444444444llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedddddddddddddddddddddddddddddd.m15:::::::::::::::::::::::3tttttttthhhhhhhhhhhhhhhhhhhhog66666666666666666666666666666666666666666666666"yiaaaaaaaaaaaaaaaaaaaaasnr2444444444444444444444444444444lllll                                                                                                                            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                                                                                            rdiaaaaaasnnnnnnnnnnnnnnnnnnnnne24 lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllccccccccccccccccccccccc                                                                                                                            eeeeeeeLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL7777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777'S.=====================================================================================zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzuT(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((pffffffff800