//
// AI support functions.
//

//
// This function creates an AI player using the supplied group of markers 
//    for locations.  The first marker in the group gives the starting location 
//    of the the AI, and the remaining markers specify the path to follow.  
//
// Example call:  
// 
//    createAI( guardNumberOne, "MissionGroup\\Teams\\team0\\guardPath", larmor );
//

//globals
//--------
// path type
// 0 = circular
// 1 = oneWay
// 2 = twoWay
$AI::defaultPathType = 2; //run twoWay paths

//armor types
//light = larmor
//medium = marmor
//heavy = harmor
$AI::defaultArmorType = "larmor";



//---------------------------------
//createAI()
//---------------------------------
function createAI( %aiName, %markerGroup, %armorType, %name )
{
   %group = nameToID( %markerGroup );
   
   if( %group == -1 || Group::objectCount(%group) == 0 )
   {
      dbecho(1, %aiName @ "Couldn't create AI: " @ %markerGroup @ " empty or not found." );
      return -1;
   }
   else
   {
      %spawnMarker = Group::getObject(%group, 0);
      %spawnPos = GameBase::getPosition(%spawnMarker);
      %spawnRot = GameBase::getRotation(%spawnMarker);

      if( AI::spawn( %aiName, %armorType, %spawnPos, %spawnRot, %name, "male2" ) != "false" )
      {
         // The order number is used for sorting waypoints, and other directives.  
         %orderNumber = 100;
         
         for(%i = 1; %i < Group::objectCount(%group); %i = %i + 1)
         {
             
            %spawnMarker = Group::getObject(%group, %i);
            %spawnPos = GameBase::getPosition(%spawnMarker);
            
            AI::DirectiveWaypoint( %aiName, %spawnPos, %orderNumber );
            
            %orderNumber += 100;
         }
      }
      else{
         dbecho( 1, "Failure spawning: " @ %aiName );
      }
   }
}

//----------------------------------
// AI::setupAI()
//
// Called from Mission::init() which is defined in Objectives.cs (or Dm.cs for
//    deathmatch missions).  
//----------------------------------   
function AI::setupAI(%key, %team)
{
   //if there is no key then they don't exist yet
   if(%key == "")
   {
      %aiFound = 0;
      for( %T = 0; %T < 8; %T++ )
      {
         %groupId = nameToID("MissionGroup\\Teams\\team" @ %T @ "\\AI" );
         if( %groupId != -1 )
         {
            %teamItemCount = Group::objectCount(%groupId);
            if( %teamItemCount > 0 )
            {
               AI::initDrones(%T, %teamItemCount);
               %aiFound += %teamItemCount;
            }
         }
      }
      //check for Graph information
      if(nameToId("MissionGroup\\AIGraph") != -1)
      	AI::buildGraph();
      else
         echo("No Graph info to build AI Graph!");
      
      if( %aiFound == 0 )
         dbecho(1, "No drones exist...");
      else
         dbecho(1, %aiFound @ " drones installed..." );
   }
   else     //respawning dead AI with original name and path
   {
      %group = nameToID("MissionGroup\\Teams\\team" @ %team @ "\\AI\\" @ %key);
      %num = Group::objectCount(%group);
      createAI(%key, %group, $AI::defaultArmorType, %key);
      %aiId = AI::getId(%key);
      GameBase::setTeam(%aiId, %team);
      AI::setVar(%key, pathType, $AI::defaultPathType);
      AI::setWeapons(%key);
      
   }		
}

//------------------------------
// AI::setWeapons()
//------------------------------
function AI::setWeapons(%aiName)
{
	%aiId = AI::getId(%aiName);
	
   if(Game::missionType == "DM")
   {	
      dbecho(2, "giving DM weapon select...");
      Player::setItemCount(%aiId, blaster, 1);
   }
   else
   {
      dbecho(2, "giving normal weapon select...");
      Player::setItemCount(%aiId, blaster, 1);
	   Player::setItemCount(%aiId, disclauncher, 1);
	   Player::setItemCount(%aiId, chaingun, 1);
	   Player::setItemCount(%aiId, discammo, 500);
	   Player::setItemCount(%aiId, bulletAmmo, 50000);
   }
   
   Player::mountItem(%aiId, blaster, 0);
   AI::SetVar(%aiName, triggerPct, 0.03 );
   AI::setVar(%aiName, iq, 70 );
   AI::setVar(%aiName, attackMode, 1);
   AI::setAutomaticTargets( %aiName );
   ai::callbackPeriodic(%aiName, 5, ai::periodicWeaponChange);
}


//-----------------------------------
// AI::periodicWeaponChange()
//-----------------------------------
function ai::periodicWeaponChange(%aiName)
{
	dbecho(2, %aiName @ " thinking....");
   %aiId = AI::getId(%aiName);
   %curTarget = ai::getTarget( %aiName );
   
   if(%curTarget == -1)
   {
   	return;
   }
      
   dbecho(1, %aiName @ " target: " @ %curTarget);	
   
   %targLoc = GameBase::getPosition(Client::getOwnedObject(%curTarget));
   %aiLoc = GameBase::getPosition(Client::getOwnedObject(%aiId));
   %targetDist = Vector::getDistance(%aiLoc, %targLoc);
   dbecho(2, "distance to target: " @ %targetDist @ 
                  " targetPosition: " @ targLoc @ " aiLocation: " @ %aiLoc);
                  
   if(%targetDist > 100)
   {
   	Player::mountItem(%aiId, blaster, 0);
      AI::SetVar(%aiName, triggerPct, 0.03 );
   }   
   else
   {
      dbecho(2, "checking for target jet...");
      dbecho(2, "jetting? " @ Player::isJetting(%curTarget));
      if(Player::isJetting(%curTarget))
      {	
         Player::mountItem(%aiId, Chaingun, 0);
         AI::SetVar(%aiName, triggerPct, 0.6 );
      }
      else
      {
         Player::mountItem(%aiId, disclauncher, 0);  
         AI::SetVar(%aiName, triggerPct, 0.03 );
      }   
   }
}

//-----------------------------------
// AI::initDrones()
//-----------------------------------
function AI::initDrones(%team, %numAi)
{
	dbecho(1, "spawning team " @ %team @ " ai...");
   for(%guard = 0; %guard < %numAi; %guard++)
   {
      //check for internal data
      %tempSet = 	nameToID("MissionGroup\\Teams\\team" @ %team @ "\\AI");
      %tempItem = Group::getObject(%tempSet, %guard);
      %aiName = Object::getName(%tempItem);
      
      %set = nameToID("MissionGroup\\Teams\\team" @ %team @ "\\AI\\" @ %aiName);
      %numPts = Group::objectCount(%set);
      
      if(%numPts > 0)
      {
         createAI(%aiName, %set, $AI::defaultArmorType, %aiName);
         %aiId = AI::getId( %aiName );
         GameBase::setTeam(%aiId, %team);
         AI::setVar( %aiName,  iq,  60 );
         AI::setVar( %aiName,  attackMode, 1);
         AI::setVar( %aiName,  pathType, $AI::defaultPathType);
      	schedule("AI::setWeapons(" @ %aiName @ ");", 1);
      }
      else
         dbecho(1, "no info to spawn ai...");
   }
}


//------------------------------------------------------------------
//functions to test and move AI players.
//
//------------------------------------------------------------------

//
//This function will spawn an AI player about 5 units away from the 
//player that is passed to the function(%commandIssuer).
//
//
$numAI = 0;
function AI::helper(%aiName, %armorType, %commandIssuer)
{
   %spawnMarker = GameBase::getPosition(%commandIssuer);
   %xPos = getWord(%spawnMarker, 0) + floor(getRandom() * 15);
   %yPos = getword(%spawnMarker, 1) + floor(getRandom() * 10);
   %zPos = getWord(%spawnMarker, 2) + 2;
   %rPos = GameBase::getRotation(%commandIssuer);
   
   dbecho(2, "Spawning AI helper at position " @ %xPos @ " " @ %yPos @ " " @ %zPos);
   dbecho(2, "Current Issuer rotation: " @ %rPos);
      
   %aiSpawnPos = %xPos @ "  " @ %yPos @ "  " @ %zPos;
   %newName = %aiName @ $numAI;
   $numAI++;
   Ai::spawn(%newName, %armorType, %aiSpawnPos, %rPos);
   return ( %newName );
}

//
//This function will move an AI player to the position of an object
//that the players LOS is hitting(terrain included). Must be `	within 50 units.
//
//
function AI::moveToLOS(%aiName, %commandIssuer) 
{
   %issuerRot = GameBase::getRotation(%commandIssuer);
   %playerObj = Client::getOwnedObject(%commandIssuer);
   %playerPos = GameBase::getPosition(%commandIssuer);
      
   //check within max dist
   if(GameBase::getLOSInfo(%playerObj, 100, %issuerRot))
   { 
      %newIssuedVec = $LOS::position;
	  %distance = Vector::getDistance(%playerPos, %newIssuedVec);
	  dbecho(2, "Command accepted, AI player(s) moving....");
	  dbecho(2, "distance to LOS: " @ %distance);
	  AI::DirectiveWaypoint( %aiName, %newIssuedVec, 1 );
   }
   else
      dbecho(2, "Distance to far.");
      
   dbecho(2, "LOS point: " @ $LOS::position);
}

//This function will move an AI player to a position directly in front of
//the player passed, at a distance that is specified.
function  AI::moveAhead(%aiName, %commandIssuer, %distance) 
{
   
   %issuerRot = GameBase::getRotation(%commandIssuer);
   %commPos  = GameBase::getPosition(%commandIssuer);
   dbecho(2, "Commanders Position: " @ %commPos);
   
   //get commanders x and y positions
   %comm_x = getWord(%commPos, 0);
   %comm_y = getWord(%commPos, 1);
   
   //get offset x and y positions
   %offSetPos = Vector::getFromRot(%issuerRot, %distance);
   %off_x = getWord(%offSetPos, 0);
   %off_y = getWord(%offSetPos, 1);
   
   //calc new position
   %new_x = %comm_x + %off_x;
   %new_y = %comm_y + %off_y;
   %newPos = %new_x  @ " " @ %new_y @ " 0";
  
   //move AI player
   dbecho(2, "AI moving to " @ %newPos);
   AI::DirectiveWaypoint(%aiName, %newPos, 1);
}  

//
// OK, this is the complete command callback - issued for any command sent
//    to an AI. 
//
function AI::onCommand ( %name, %commander, %command, %waypoint, %targetId, %cmdText, 
         %cmdStatus, %cmdSequence )
{
   %aiId = AI::getId( %name );
   %T = GameBase::getTeam( %aiId );
   %groupId = nameToID("MissionGroup\\Teams\\team" @ %T @ "\\AI\\" @ %name ); 
  	%nodeCount = Group::objectCount( %groupId );
   dbecho(2, "checking drone information...." @ " number of nodes: " @ %nodeCount);
   dbecho(2, "AI id: " @ %aiId @ " groupId: " @ %groupId);
   
   if($SinglePlayer || %nodeCount == 1)
   {
	   if( %command == 2 || %command == 1 )
	   {
	      // must convert waypoint location into world location.  waypoint location
	      //    is given in range [0-1023, 0-1023].  
	      %worldLoc = WaypointToWorld ( %waypoint );
	      AI::DirectiveWaypoint( %name, %worldLoc, 125 );
	      dbecho ( 2, %name @ " IS PROCEEDING TO LOCATION " @ %worldLoc );
	   }
	   dbecho( 2, "AI::OnCommand() issued to  " @ %name @ "  with parameters: " );
	   dbecho( 3, "Cmdr:        " @ %commander );
	   dbecho( 3, "Command:     " @ %command );
	   dbecho( 3, "Waypoint:    " @ %waypoint );
	   dbecho( 3, "TargetId:    " @ %targetId );
	   dbecho( 3, "cmdText:     " @ %cmdText );
	   dbecho( 3, "cmdStatus:   " @ %cmdStatus );
	   dbecho( 3, "cmdSequence: " @ %cmdSequence );
   }
   else
   	return;   
}


// Play the given wave file FROM %source to %DEST.  The wave name is JUST the basic wave
// name without voice base info (which it will grab for you from the source client Id).  
// Basically does some string fiddling for you.  
//
// Example:
//    Ai::soundHelper( 2051, 2049, cheer3 );
//
function Ai::soundHelper( %sourceId, %destId, %waveFileName )
{
   %wName = strcat( "~w", Client::getVoiceBase( %sourceId ) );
   %wName = strcat( %wName, ".w" );
   %wName = strcat( %wName, %waveFileName );
   %wName = strcat( %wName, ".wav" );
   
   dbecho( 2, "Trying to play " @ %wName );
   
   Client::sendMessage( %destId, 0, %wName );
}


// Default periodic callback.  [Note by default it isn't called unless a frequency 
//    is set up using AI::CallbackPeriodic().  Type in that command to see how 
//    it works].  
function AI::onPeriodic( %aiName )
{
   dbecho(2, "onPeriodic() called with " @ %aiName );
}


function AI::onDroneKilled(%aiName)
{
   if( ! $SinglePlayer )
   {
      %aiId = AI::getId(%aiName);
      %team = GameBase::getTeam(%aiId);
      dbecho(2, "AI Id: " @ %aiId);
      
      // Trying a little longer delay -
      schedule("AI::setupAI(" @ %aiName @ ", " @ %team @ ");", 8 );
   }
   else
   {
      // just in case:
      dbecho( 2, "Non training callback called from Training" );
   }
}


function AI::buildGraph(%argv)
{
	
   if(!%argv)
   {
	   echo("building AI Graph...");
	   $nodeGroup = nameToID("MissionGroup\\AIGraph");
	   %numNodes  = Group::ObjectCount($nodeGroup);
	   echo("nodeGroup: " @ %nodeGroup @ " number of Nodes: " @ %numNodes); 
   }
   else
   {
	   echo("rebuilding AI Graph...");
	   %numNodes  = Group::ObjectCount($nodeGroup);
   }
   
   for(%i = 0; %i < %numNodes; %i++)
   {
   	%node = Group::getObject($nodeGroup, %i);
      %nodePos = GameBase::getPosition(%node);
      %type = GameBase::getDataName(%node);
      %name = "Node " @ %i;
      Graph::AddNode(%nodePos, %name);
   }
   if(%numNodes > 0)	
   {   
      Graph::buildGraph();
      echo("Graph build complete.");
   }
   else
   	echo("No nodes to build graph.");
}


function AI::rebuildGraph()
{
	Graph::reset();
   AI::graphOff();
   focusServer();
   AI::buildGraph("true");
   focusClient();
   AI::GraphOn();
}

//these AI function callbacks can be very useful!
function AI::onTargetLOSAcquired(%aiName, %idNum)
{
}

function AI::onTargetDied(%aiName, %idNum)
{
}                                 

function AI::onTargetLOSLost(%aiName, %idNum)
{
}

function AI::onTargetLOSRegained(%aiName, %idNum)
{
}

//Render lines to show AI Graph
$AI::testGraph = 0;
function AI::GraphOn(){
   if( $AI::testGraph == 0 ){
   	$AI::testGraph = newObject( "graphRender", AI::GraphPathRender );
      echo("Graph render on");
   }
   else{
      echo("Graph render ALREADY on");
   }
}
function AI::GraphOff(){
   if( $AI::testGraph != 0 ){
   	deleteObject( $AI::testGraph );
      $AI::testGraph = 0;
   	echo("Graph render off");
   }
   else{
      echo("Graph render ALREADY off");
   }
}


function AI::testingCommander()
{
   %clientId = "2049";
   AI::helper("jettkiller", harmor, %clientId);
   %aiId = "2050";
   GameBase::setTeam(%aiId, 0);
   AI::callWithId(%aiId, Player::setItemCount, Mortar, 1);
	AI::callWithId(%aiId, Player::setItemCount, MortarAmmo, 10000);
   AI::callWithId(%aiId, Player::mountItem, mortar, 0);
   AI::DirectiveTargetLaser( %aiId, %clientId );
}I21<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<GgwwI(%Ceeeeeeeeeeegneeeeeeeeeeeeeeeeeeeeeeeeeeeeee=\PSM21%%%%%%%%%%%%%%wIndeeeeeeeeeeeg(CNuuuuuuuuuuuuneeeeeeeeeeeeeeeeeeedeeeeeeeew%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Igggggggggggggggggggggggggggggggggggggggdddddddunnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeld(nnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeuuuuuuue}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}J6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666['K888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888F2.............................................................
























WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\PSM=1CuTwI%%%%%%%%%%%%ld((((((((((((((nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeuuuuuuuuuuuuldggggggggggggggggggggggggggeeeeeeeennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneIhyyyyyyyyyyyyyyyyyyyyyNT(wwwwwwwwwwwwwduuuuuuuuuuuuuuuuunlllllllg%%%%%%%%%%%%%%%%%%%%%%%%%%eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeenddddddddddddduuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeellllllllllllllllllll"""""""""""""""""""""""""""""""""""""""""""2222222222222222222G+P.M\1SIhyN=T((((((((((((((((nwgggggggggggggggggggggggglddddddddddddddddddddddddddddddeeeeeeeeeeeeeeeeeeeeuuuuuuuuueeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeenl%uuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedddddddddddddddddddddddddddddeeeeeeeeeeeeeeITTTTTTTTTTTTTT"ffffffffffffffffffhylwCeunnnnnnnnnnd%((((((((((((((((((((((((((((((((((((((eeeeeeeeeeeeeeee                                                            ulddddddddddddddddddddddddneeeeeeee                                       ggggggggggggggggggeeeeeeeeeeeeeeeeeeeeeeeeeeee       ussssssssssssssstEEEEEEEEEEEEEEEEEEEEEEEEEEEEE$,
L!-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OOOOOOOOOOOOOOOOOOOOOOOOOFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
GW<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<2222222222"pPPPPPPPPPPPPPPPPPPPM+wN.\1ThIIIIIIIIIIIIIIffffffd%yyyyyyyyyyyyl gCSSSSSSSSSSSSSSSSSSSSSeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 nnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeedttttttttttttttttts(ue          nlllllllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeee                                                           wwwwwwwww%"pppppppppppppppdThggggggggggggggfIIIIII(ytnsssssssssssssueeeeeeee                                       lllllllllllllllllleeeeeeeeeeeeeeeeeeeeeeeeeeee                =ddddddnnnnnnnnnnnnnnnnnnnnnnnnt lssssssssseeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 uuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeen/)																										P,,,,,,,,,,,,,,,,,,,,,,ONNNNNNNNNNNNNNNNNN2222222222222222222222222222222CM+++++++++++++++++++%.\\\\\\\\fw"p=1Thg((((((((((((((((((((((((((((IIIIIIIIIIIIIIIIIIdlllllllllllle          utttttttttttttttttttttttttttttttttttttteeeeeeeeeeeeeeee                              sssssssssssssssssssssssssssnnnnnnlyudsssssssssssseeeeeeee                                       tttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeeee       lffffffffff(%w"""""""""""""pSSSSSSSSSSSSSShgTTTTTTunsyyyyyyyyyyyyyyy tdddddddddeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                        eeeeeeeeeeeeeeuuuuuuuuuuuuuuuuuusltne                     IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIeeeeeeeeeeeeeeee                              ddddddd(Z?޼^񹹹X׷Qʶ۴ӵ&#*H B3z````````````````````````````````````````````````_777777777777777777777777777777777777777]Vqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq>{9UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU44444444444444444444444444444444444444444444444444444444~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~YKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK}J666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666






















55555555555555555555555555555555555[@'''''''''''''''''''''''''''''$Esssssssssss	L!!!!!!!!!!!!!!!!!!!!!!!!-------------------------------------------------------------------------------------GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF/2<

























P+)ON=,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,WC..................MMMMMMMMMMMMMMMMMMMMMMMMMMMgf%wu"pyyyyyyyyyyyyyyhS\\\\\\ttttttttttttttttttttttttldneeeeeeee                                       ITTTTTTTTTTTTTTTTTTeeeeeeeeeeeeeeeeeeeeeeeeeeee                          tsssssssssssssssssuddddddddddddd               llllllllleeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 nnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeig%((((((((Ifw"tpyyyyyyyyyyyyyyyyyyyyyyyyhhhhhhdsssssssssssssss1ue          nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeee                              llllllllllllllllllllllllltdddddddddddddddddTinslueeeeeeee                                                                          eeeeeeeeeeeeeeeeeeeeeeeeeeee                                   ::::::::::::::::::::::2DDDDDDDDDDDDDDDDDDDDDDDDDD/+	n.P)OS=,,,,,,,,,,,,,,,,,,,,,,,,,,,%CNIIIIIIIIIIIIIIIIIIMw(pfg""""""""""dddddddddddTyhhhhhhhhhhhhhhhtttttttttttttttttliiiiiiiiiiiiis               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeelnnnnnnnnrdttttttttttto11111111111111111111111111111111111111111111111 eeeeeeeeeeuiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          sssssssssssssssssssssssssssssssssssssssssssssI%wwwwwwwwwwwwwwppppppppppppppppg(Tfh"llllllllltrodnnnnnnnnnnnnnnnnu\yeeeeeeeeeeeeee                             ssssssssssssssssssssssssssssssssssssieeeeeeee                                    uuuuuuuuuuuuuitrodnnnnnnnnnnnllllllllllllllllllllsssssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeee                                              eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeebRx;uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuk






















5555555555555555555558<$EL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!-------------------------2222222222222222222222222222222222222222GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGF:++++++++++++++++++++++DDDDDDDDDDDDDDDDDDDDDDDDDD)/	.,POSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS===========================
CCCCCCCCCCCwc1NIg%%%%%%%%%%%%%%phhhhhhhhhhhhhhhh(T\Mf ridtttttttttttttoooooooooooooooooooo"nnnnnnnnnnnnnnnnnnnnnnnnnnnnlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeesssssssssssssssssssssssssssssssssssssssssyyyyyyyyyyyedrrrrrrrrrrrrriutttttttttttttttttoooooooooooooooo          snnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeee                              lllllllywwwwwwwwwwwwgmmmmmmmmmmmmmmIh%(ppppppppppppppppppppppppppppppppppppppppppppppppTcfffffffffffffffffffdurrrrrrrrrrriiiiiistttttttttloeeeeeeee                                       nnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeee       saaaaaaaaaaaaaaaaaaaaauuuuuuuuuuuuuuuuuuuuuuud"rrrrrrlint               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 oooooooooooooooooooooooooooooooooooeeeeeeea+2)b:::::::::::::::::,DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD	./1OSPy=Wg\ClhwmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmNI%(cppppppppppppppppppppppppppppppssssssssssssssssssu"TTTTTTTTTTTTTTTTTTTTTTTTddddddnr eeeeeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          tttttttttttttttttttttttttttttttttnalllllllllffffffffffffffffffffffussssssssssssssssssodeeeeeeeeeeeeee                             trrrrrrrrrrrrrrrrrrrrrrrrrieeeeeeee                                    ahgoMywmccccccccccccccI%"(ppppppppppppppppniffffffffffffffffffffffffffffffffffffussssssssssssslllllldtttttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeee                    r               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeao           iuTnnnnnnnnnnnnnnnnndsssssssssssssssssrlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeetttttttttttttttttttttttttttttttttttttttttMA0q|j{VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV>3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK}J@666666666666666666666666666666666666666666666666666666666666666666666666666666xvvvvvvvvvvvvvvvvvvvvvvvvRk;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
<5E8[!$-LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLa:::::::::::::::::::::::::::::::::::::::::::::::::::::::GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG++++++++++++++++++++++++++)b2.,DDDDDDDDDDDDDDDDDSSSSSSSSSSSSSSSSSS																						\1O/hP===========================FWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWCCCCCCCCCCCCCCCCCCCdcgyw"mmmmmmmmmmmmmmIf%(pppppppppppppeuuuuuuuuuuunioTTTTTTTTTTTTTTTTTTTTTrrrrrrrrrrrrrrrrrrrrrrrrrrr          tsssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeee                              lllllllradddddddnuoooooooooooooooooooooooiiiiiitttttttttttttttttttttttlllllllllllleeeeeeee                                       sssssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeeee       acht"NgyfwmmmmmmmmmmmmmmTI%(rrrrrrrrrronnnnnnnnnnnnnuddddddddddddddddlisssssssssssssssp               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                              eeeeeeelattttttttttttttttttttodnruuuuuusssssssssss eeeeeeeeeeeeeeeeeeeeeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee                                                         ab:A0DDDDDDDDDDDDDDDDDDDDDDDDDD)+	.,2OSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSM\1111111111111111111111c/P"C=sfhN
gTywmmmmmmmmmmmmmmmmmmmmmmmmmmmmI%llllllllldddddddddddddrotnnnnnnnnnnnnnnnnnueeeeeeeeeeeeee                                            (((((((((((((((((((((((((((((((((((ieeeeeeee                                               asidddddddddddddrotnlllllluppppppppppppppppppppppppeeeeeeeeeeeeeeeeeeeeeeeeeee                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaf"nTchhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgywwwwwwwwwwwwwwwwmmmmmmmmmmmmmmIIIIIIIIIIII             iodsrrrrrrutttttttttttttttttttttttttttlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeep%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%uaneooooooooooooosiiiiiiiiiiiiddddddddddddddddrrrrrrrrrrrrrrrr          (tttttttttttttttttttttttttttttttttttttttttttteeeeeeeeeeeeee                              lllllllTkxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxRvEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE;-<5






























!$''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''La)))))))))))))))))))))))))GWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWb,A0DDDDDDDDDDDDDDDDDD:+	111111111111111111111111112OC.................Mf\SN/PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP"chhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh=gypwmmmmmmmmmmmmmmuuuuuuusooooooooooooooooooooooooniiiiii(Idddddddddlreeeeeeee                                       tttttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeeee       %aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasnouuuuuuuuuuuuuuuuuulitd               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeaaaaaaaaaaaaaaafllllllllllllllllT"cph
Fg(ywm%%%%%%%%%%%%%%%%%%%%%nnnnnnnnnnnnusssssssssssoooooottttttttttttt eeeeeeeeeeriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          dddddddddddddddddddddddddddddddddtalllllllllunnnnnnnnnnnnnnnnnnnnnnIssssssroeeeeeeeeeeeeee                             dddddddddddddddddddddddddddddddddddddieeeeeeee                                    aaaaaaaaaaaaaaaaaa)b,10DAC+	:\2OOOOOOOOOOOOOOOOOOOOOOOOOOPPPPPPPPPPPPPPPPPM...............SNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN/rpfT"(chhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh%gywtiunnnnnnnnnnnnnnnnnnnnnnImslllllloddddddddddddddddddddddddeeeeeeeeeeeeeeeeeeeeeeeeeee                                               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeesar niiiiiiiiiiiiuttttttttttttttttoooooooooooooooooooooooooooooooooooooooooolllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeedddddddddddddddddddddddddddddddddddddddddappppppppppppppppo(((((((((((((((fT%"chI=gyseeeeeeeeeeeentiruuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu          ddddddddddddddwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwweeeeeeeeeeeeee                              lllllllllllllllllllaooooooottttttttttttrnsiiiiiiduuuuuuuuullllllllllleeeeeeee                                       mmmmmmmmmmmmmmmmmmmmmmmmeeeeeeeeeeeeeeeeeeeeeeeeeeee       (|H*???????????????????????????????????????????????????????????????????????????zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz333333333333333333333333333333333333333B`_________________________________________________7]9U44444444444444444444444444444444444444444444444444444444q}{VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV>jkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~KRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRJ@8666666666666666666666666666666666666666666666666666666666666666x5EEEEEEEEEEEEEEEEEEEEEEEv$-<;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;!
WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'''''''''''''''''''''''''''''''''''aDLLLLLLLLLLLLLLLLLLLLLLLLL
GGGGGGGGGGGGGGGGGG	b,1O)ACM0:\\\\\\\\\\\\\\\\\\\++++++++++++++++++++++++++Pppppppppppppppppp22222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222SN.d%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fIT"cccccccccccccch=/ggggggggggggggggggggggrtssssssssssssonnnnnnlimyu               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                             eeeeeeeladdddddddsrotttttttttttttttttttttttttttttwn eeeeeeeeeeeeeeeeeeeeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuua%pw((((((((((((((((((((((((((((((fIT"cccccccccccccchhhhhhhhhhhhhhhhhhhhhhgmlllllllllosssssssssssssrdttttttttttttttttttttttttttteeeeeeeeeeeeee                             unnnnnnnnnnnnnnnnnnnnnnnnnieeeeeeee                                              ayiosssssssssssssrdtllllllllllllllllluuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeeeeeeeeeeee                    n               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaODDDDDDDDDDDDDDDDDD	M,1bbbbbbbbbbbbbbbbbbbAC))))))))))))))))):\0NNNNNNNNNNNNNNNNNNNNNNNNNNP+%2Fw=Stfp((((((((((((((((cccccccccccccccITg""""""""""""""hhhhhhhhhhh siroyyyyyyyyyyyyyyyyyyyyyy.............................dddddddddddddddddnlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuatersmiiiiiiiiiiioooooonnnnnnnnnnnnnnnnnnnnnnnnnnnn          uddddddddddddddddddddddddddddddddddddddddddddeeeeeeeeeeeeee                              lllllllafwnc%p(ggggggggggggggggggggggggggggggIyT"""""""""""""""""""""""""""""""mhrrrrrrrrrrrstiiiiiiuooooooooollllllllllllleeeeeeee                                       ddddddddddddddddddddddddeeeeeeeeeeeeeeeeeeeeeeeeeeee       uannnnnnnnnnnnnnnnnnnn/trrrrrrrrrrrrsssssslido               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                               eeeeeeeccccccccccccccccccccccccRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRk<5Ex!$-vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv;
WWWWWWWWWWWWWWWWWWWWWWWWWWW
a1[LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLOCCCCCCCCCCCCCCCCCC	M\DbbbbbbbbbbbbbbbbbbbP,)))))))))))))))))=A0Nffffffffffffffffffffffffff::::::::::::::::::::::2FG+lgw%py((((((((((((((((((((((((((((((mIT"uuuuuuuutttttttttttttttttttttt/SSSSSSSSSSSSSSnrrrrrrds eeeeeeeeeeeeeeeeeeeeeeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          ooooooooooooooooooooooooooooooooodalllllllllllllllllllltnnnnnnnnnnnuhhhhhhhhhhhhhhhhhhreeeeeeeeeeeeee                             osssssssssssssssssssssssssieeeeeeee                                    agfffffffffffffycw%mp((((((((((((((((...............ITdiiiiiiiiiiiitnnnnnnnnnnnuh"llllllrooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeee                    s               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaaaaaa tiiiiiiiiiiiiiiiiiiiiiidnnnnnnruuuuuuuuuuuuuuuuuslllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeoooooooooooooooooooooooooooooooooooooooooa\1OCP	MMMMMMMMMMMMMMMMMM=bbbbbbbbbbbbbbbbbbbDDDDDDDDDDDDDDDDDDDDDDDDDD))))))))))))))))),,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,0NAg::::::::::::::::::::::y/2rmfcw.+%p(hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhIIIIIIIIIIIIIITeeeeeeeeeeetdiiiiiiiiiiiiiiiiiiiiiiiiiiiiisnnnnnnnnnnnnnnnn          ouuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeee                              lllllllsarrrrrrrdddddddddddddddddddddddt"iiiiiioooooooooooooooooooolneeeeeeee                                       uuuuuuuuuuuuuuuuuuuuuuuueeeeeeeeeeeeeeeeeeeeeeeeeeee       amyoSgfchw%pppppppppppppp((((((((((((((((((((((((((((((ssssssssssssssssssssssd"IIIIIIIIIIIrttttttliuuuuuuuuuuuu               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeelaooooooooTTTTTTTTTTTTTrdssssssssssssssssut eeeeeeeeeeniiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee                                                     SV|3>}{qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYj888888888888888888888888888888KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKJJJJJJJJJJJJJJJJJJJJJJJ'@@@@@@@@@@@@@@@@@@@@@R<<<<<<<<<<<<<<<<<<<<Ek!5-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$v






















































;[6WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
aM\1OOOOOOOOOOOOOOOOOOOP	CCCCCCCCCCCCCCCCC=bbbbbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNNNNNNNNNN)D/////////////////////////////////////////////////////////////LLLLLLLLLLLLLLLLLLLLLLLLLF,mA:00000000000000000000002.uhygffffffffffffffcw%"p((((((((((((((((lllllllllrTTTTTTTTTTTTTTTsssssssssssssoddddddnnnnnnnnnnneeeeeeeeeeeeee                                        tttttttttttttttttttttttttieeeeeeee                                    nauirIsssssssssssssodlllllllllllllllllllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeeeeeeeeeeee                    t               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeahmdddddddddddddd+yg"fcwT%p(n IIIIIIIIIIIIIIIIiiiiiiiiiiiiirussssssssssssssssoooooooooooooooootlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeadeeeeeeeeeeeeeeeeeeeeeeeeeeeuinrrrrrrtssssssssssssssss                     ooooooooooooooooooooooooooooooooooooooooooooeeeeeeeeeeeeee                              llllllla	M\1bbbbbbbbbbbbbbbbbbbPO)))))))))))))))))=CGNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN0/SDh,AAAAAAAAAAAAAA2:t"m++++++++++++++++++++++yTgfcIw%pppppppppppppppppuuuuuuuuuuuuunnnnnnnnnnnnnnn(diiiiiiiiiiiiiiiiirrrrrrrrrlseeeeeeee                                       ooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee                  attttttttttnudddddddddddddddddddddddddddddddddddddddddddlior               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 ssssssssssssssssssssssssssssssssssseeeeeeea""""""""""""""lThm.Iygfffffffffffffffcw%%%%%%%%%%%%%%%%%%%dnnnnnnnnnnnuttttttttttttttttttoooooooooooooooop eeeeeeeeeesiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrroallllllllllllllllllldtnnnnnnnnnnnnuuuuuussssssssssssseeeeeeeeeeeeee                             r(((((((((((((((((((((((((ieeeeeeee                                    T<<<<<<<<<<<<<<<<<<<<<<<!!!!!!!!!!!!!!!!!!!!!RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRREkkkkkkkkkkkkkkkkkkkk
-x55555555555555555555555555555555555555555555555555555555555555555v$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;aPWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
	=\1bbbbbbbbbbbbbbbbbbbbbbbbbbMO)SSSSSSSSSSSSSSSSSSSCGL22222222222222222222222222222222220"/N+,ADsIIIIIIIIIIIIIIhmmmmmmmmmmmmmmm.:yggggggggggggggggfcwoiiiiiiiiiiidtnnnnnnnnnnnnullllllllllllllllllrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeee                    (%               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeuas dinnnnnnnnnnnotttttttttttttttttttttttttttttttttttttttttttttplllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrraI"""""""""""""""""""""""""""TTTTTTTTTTTTTThhhhhhhhhhhhhhhhmmmmmmmmmmmmmmmmmmmmmmy(gfcuendoisssssssssssssssspwtttttttttttttttt          rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeee                              lllllll%aaaaaaaaaaaaaaaaaaaonsduiiiiiirrrrrrrrrrrrrrrrrrrlteeeeeeee                                                                         eeeeeeeeeeeeeeeeeeeeeeeeeeee       aaaaaaaaaaaaaaaaaaaaaaaaaaP	=S1b\2O)M/CFFFFFFFFFFFFFFFFFFFAAAAAAAAAAAAAAAAAA00000000000000000IN+++++++++++++++.,rrrrrrrrrrrrrrrr"TTTTTTTTTTTTTT(hmmmmmmmmmmmmmmmmmmmmmmDpygf%ccccccccccsounnnnnnnnnnnnnddddddliiiiiiiiiiiiiiiiiiiiii               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 ttttttttttttttttttttttttttttttttttteeeeeeelarrrrrrrrusssssssssssssownnnnnnnnnnnnnnnnnd eeeeeeeeeetiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee                                                    aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa(I"Tpppppppppppppphm%:ygllllllllllllllllllllluwfsrooooootneeeeeeeeeeeeee                                       dddddddddddddddddddddddddieeeeeeee                                    taaaaaaaaaaaaiiiiiiiiiiiiiucsrollllllnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeee                    d               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee(²암Zɖ޼^񹹹XQʶ۴ҵ#&| *??????????????????????????????????????HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzB`_7]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]9KV3>}{qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<U44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYR'888888888888888888888888888888jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjk!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxEEEEEEEEEEEEEEEEEEEEEEEEv
--------------------;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;J@[555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555$abbbbbbbbbbbbbbbbbbbbbbbbbbbbbWGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG)	=SF
P\201M/.OOOOOOOOOOOOOOOOOOOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACCCCCCCCCCCCCCCCCCCCCCN+++++++++++++++++opppppppppppppppI"%TTTTTTTTTTTTTThwm:,yt uisssssssssssssssssssssssscggggggnrrrrrrrrrrrrrrrrrdlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeenaoesuuuuuuuuuuuuittttttttttttttttttdffffffffffffffff                    rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeee                              lllllllappppppppppppppppd%(((((((((((((((Iw"TTTTTTTTTTTTTTchmDnnnnnnnnnnnnnnnnnnstuoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiilfyeeeeeeee                                       rrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeeee                 addddddddddttttttttttttosnuuuuuulirrrrrrrrrrrrr               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 gggggggggggggggggggggggggggggggggggeeeeeeeaLbbbbbbbbbbbbbbbbbbbbbbbbbb)0=S	.\2PPPPPPPPPPPPPPPPPPM/1+++++++++++++++++++AOpCCCCCCCCCCCCCCCCCCCCCC%:Nlwwwwwwwwwwwwwwww(((((((((((((((cI"Tffffffffffffffhmmmmmmmmmmmmmmmmmmotnnnnnnnnnnnndssssssru eeeeeeeeeegDDDDDDDDDDDDDDDDDiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee                                                      ralllllllllnodtttttttttttttttttttttttttttyseeeeeeeeeeeeee                                         uuuuuuuuuuuuuuuuuuuuuuuuuieeeeeeee                                    aw%ypppppppppppppppp(((((((((((((((cI"Tffffffffffffffhmgrinodttttttttttttttttttttttllllllsssssssssssssssssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeee                    u               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeea, oitnrddddddsssssssssssssssssssssssssssulllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyEk!R-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx6v

















































;<<<<<<<<<<<<<<<<<<<<GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG5aS$$$$$$$$$$$$$$$$$$$$$$$$$$$$$FWLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL22222222222222222222222222)0/b	.A=PPPPPPPPPPPPPPPPPP:\1+wwwwwwwwwwwwwwwwwwwMDCCCCCCCCCCCCCCCCCCCCCCOsssssssssssssss%ppppppppppppppppT(cIm"fffffffffffffffffffffffffetori,Nhnnnnnnudddddddddddddddd                                                                           eeeeeeeeeeeeee                              llllllluasssssssrtgooooooooooooiiiiiiiiiiiiiiiiiinnnnnnnnnldeeeeeeee                                                                        eeeeeeeeeeeeeeeeeeeeeeeeeeee       aaaaaaaaaaaaaaawwwwwwwwwwwwwTy%pmmmmmmmmmmmmmmmm(cccccccccccccccccI"fuuuuuuuuuuggggggggggggggrrrrrrrrrrrrtsooooooliiiiiiiiiiin               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 dddddddddddddddddddddddddddddddddddeeeeeeelaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaahsrutttttttttttttttto eeeeeeeeeediiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnna/S
2A)00000000000000000000000000:	.bbbbbbbbbbbbbbbbbbbPPPPPPPPPPPPPPPPPP======================1+\\\\\\\\\\\\\\\MDT,CCCCCCCCCCCmwy%%%%%%%%%%%%%%%%%Opppppppppppppppp(gcI"lllllllllssssssssssssuhfffffffffffffrrrrrrdteeeeeeeeeeeeee                             noooooooooooooooooooooooooieeeeeeee                                    daaaaaaaaaaaissssssssssssuuuuuuuuuuuuuuuuuuuuuuuuuurlllllltnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeee                    o               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeamTrNNNNNNNNNNNNNNNwyg%pppppppppppppppph(cId            iiiiiiiiiiiiii"sssssssssssuuuuuutttttttttttttttttttttttttttttolllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnntareffffffffffffffffffffffidssssssouuuuuuuuuuuuuuuu          nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeee                              lllllllN}|KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK3>VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'8~~~~~~~~~~~~~~~~~~~~~jjjjjjjjjjjjjjjjjjjjjjjjjjjjE@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!!!!!!!!!!!!!!!!!!!!!!!!!-kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkR6Jx
















































v<<<<<<<<<<<<<<<<<<<<<<<<G;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$F5a0/S




























.A)WLLLLLLLLLLLLLLLLLL:																										+++++++++++++++++++Pb,,,,,,,,,,,,,,,,,,,,,,1=m\M2DCCCCCCCCCCCCCCCCCogTTTTTTTTTTTTTTTwhy%ppppppppppppppppppppppppppppp(ctttttttttttttttttfIddddddddddddriiiiiinssssssssslueeeeeeee                                                                          eeeeeeeeeeeeeeeeeeeeeeeeeeee       naoooooooooodddddddddddr"tttttttttttttttttliiiiiiiiiiiiis               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeagmlhOTTTTTTTTTTTTTTTTTTTTTTTTTTTTwy%fpppppppppppppppp(nnnnnnnnrdttttttttttto"ccccccccccccccccccccccccccccc eeeeeeeeeeuiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          sssssssssssssssssssssssssssssssssssssssssssssallllllllltrodnnnnnnnnnnnnnnnnuIeeeeeeeeeeeeee                             ssssssssssssssssssssssssssssssssssssieeeeeeee                                    a)0/S	.ANPPPPPPPPPPPPPPPPPP:::::::::::::::::::::::::::::::::::::::::::::::1++++++++++++++++++++++++++++++++++++++++++++2,,,,,,,,,,,,,,,,,,,,,,bg=\hCMuuuuuuuuuuuuuumODTfffffffffffffffwy"%ppppppppppppppppppppppppppppitrodnnnnnnnnnnnllllllI(sssssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeee                                              eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeau ridtttttttttttttoooooocnnnnnnnnnnnnnnnnnnnnnnnnnnnnlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeesssssssssssssssssssssssssssssssssssssssssaaaaaaaaaaaaaahcgmmmmmmmmmmmmmmmmmTfffffffffffffffwy"%ppppppppppppppppIIIIIIIIIIIedrrrrrrrrrrrrriutttttttttttttttttoooooooooooooooo          snnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeee                              lllllllllllllllllla(((((((((((((((((((durrrrrrrrrrriiiiiistttttttttloeeeeeeee                                       nnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeee       c-E[!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!RkG






















x$<<<<<<<<<<<<<<<<<<<<<<<<v















































































;aAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFW5):/S																			0NPPPPPPPPPPPPPPPPPPPPPP...........................................................................1CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC22222222222222,+O=\bsThgmyyyyyyyyyyyyyyyyyMffffffffffffffffffffffffffffffw"%%%%%%%%%%%%%%%%%%%%%uuuuuuuuuuuuuuuuuuuuuuud(prrrrrrlint               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                 oooooooooooooooooooooooooooooooooooeeeeeeelassssssssssssssssssuIIIIIIIIIIIIIIIIIIIIIIIIddddddnr eeeeeeeeeeoiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          tttttttttttttttttttttttttttttttttaTTTTTTTTTTTTTTnychggggggggggggggggmDf(((((((((((((((w"lllllllllI%%%%%%%%%%%%%%%%%%%%%%ussssssssssssssssssodeeeeeeeeeeeeee                             trrrrrrrrrrrrrrrrrrrrrrrrrieeeeeeee                                    oanippppppppppppppppppppppussssssssssssslllllldtttttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeee                    r               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeaaaaaaaaaaaaaaaaaaaA)::::::::::::::::::::::S	/CNP0,L1.\\\\\\\\\\\\\\\\\\\\\\\\\\222222222222222222T+Oyyyyyyyyyyyyyyyyy=========================================ch(gmDbIfffffffffffffffwo           iup"nnnnnnnnnnnnnnnnndsssssssssssssssssrlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeetttttttttttttttttttttttttttttttttttttttttdaaaaaaaaaaaaaeuuuuuuuuuuunio%%%%%%rrrrrrrrrrrrrrrrrrrrrrrrrrr          tsssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeee                              lllllllaaaaaaaaaaaaaaaayr(TTTTTTTTTTTTTTcIhgmpMfffffffffffffffdddddddnuoooooooooooooooooooooooiiiiiit%wwwwwwwwwlllllllllllleeeeeeee                                       sssssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeeee       tarrrrrrrrrronnnnnnnnnnnnnuddddddddddddddddlis"               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                                              eeeeeee(|||||||||||||||||||||||||||||||||||||||||||H****************************************************?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB`_7Y]9U}8888888888888888888888888888888888883>VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVqK---------------------------------------------------------------------------------------------------------------------------------------------------{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{@'~4j6666666666666666666666666666R[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[!EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEG
kkkkkkkkkkkkkkkkkkkk$<xW




























































va	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;FFFFFFFFFFFFFFFFFFFP)::::::::::::::::::::::1A/C2S0,,,,,,,,,,,,,,,,,N.\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\L5D+OOOOOOOOOOOOOOOOOOlIyTTTTTTTTTTTTTTpchg%mM=fttttttttttttttttttttodnruuuuuusssssssssss eeeeeeeeeeeeeeeeeeeeeiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeeeeeee          """""""""""""""""""""""""""""""""""""""""""""""sallllllllldddddddddddddrotnnnnnnnnnnnnnnnnnueeeeeeeeeeeeee                             wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwieeeeeeee                                    aIIIIIIIIIIIIIIIIIIIIIIIIIIIp(yT%%%%%%%%%%%%%%ch"gmbsidddddddddddddrotnlllllluwffffffffffffffffffffffffeeeeeeeeeeeeeeeeeeeeeeeeeee                                             eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeenaaaaaaaaaaaa             iodsrrrrrrutttttttttttttttttttttttttttlllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeee eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeea1																			P2::::::::::::::::::::::)))))))))))))))))/CAAAAAAAAAAAAAAAAAAAAAAAAAA0,SO.\NIIIIIIIIIIIIIIIIIIIIIIIIIIIIIDpM+u%%%%%%%%%%%%%%%%(y"TTTTTTTTTTTTTTcwhgmneooooooooooooosiiiiiiiiiiiiddddddddddddddddrrrrrrrrrrrrrrrr                        bbbbbbbbbbbbbbbbbbtttttttttttttttttttttttttttttttttttttttttttteeeeeeeeeeeeee                              lllllllllllllllllauuuuuuusooooooooooooooooooooooooniiiiiifdddddddddlreeeeeeee                                       tttttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeeee       a%pfIIIIIIIIIIIIIIII(y"TTTTTTTTTTTTTTcwhgmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmsnouuuuuuuuuuuuuuuuuulitd               eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee