exec("game.cs");
$MaxNumKills = 15;
//Deathmatch mission script -Aug. 25 1998

//calc scores upon fraging
function Game::clientKilled(%playerId, %killerId)
{
   if($teamplay)
   {
      if(%killerId == -1 || %playerId == -1)
      {
         return;
      }
      %kteam = Client::getTeam(%killerId);
      %pteam = Client::getTeam(%playerId);
      
      if(%kteam == %pteam)
         $teamScore[%kteam] = $teamScore[%kteam] - 1;
      else
         $teamScore[%kteam] = $teamScore[%kteam] - 1;
      
      DMTEAM::checkMissionObjectives();
   }
   else
      DM::checkMissionObjectives(%killerId);
   
}

function Game::playerSpawned(%pl, %clientId, %armor)
{	  
   // use this client's skin preference
   Client::setSkin(%clientId, $Client::info[%clientId, 0]);

   //spawn with only blaster and health kit
   Player::setArmor(%clientId,$ArmorType[Client::getGender(%clientId), NewArmor]);
   Player::setItemCount(%clientId,MineAmmo,3);
   Player::setItemCount(%clientId,RepairKit,20);
   Player::setItemCount(%clientId,Grenade,50);
   Player::setItemCount(%clientId,Beacon,50);
//------------------------------------------------
   Player::setItemCount(%clientId,GrazerCannon,1);
   Player::setItemCount(%clientId,HybridLaser,1);
   Player::setItemCount(%clientId,HybridRail,1);
   Player::setItemCount(%clientId,HybridRailAmmo,40);
   Player::setItemCount(%clientId,Destroyer,1);
   Player::setItemCount(%clientId,DestroyerAmmo,350);
   Player::setItemCount(%clientId,ARPG,1);
   Player::setItemCount(%clientId,ARPGAmmo,85);
   Player::setItemCount(%clientId,HybridChain,1);
   Player::setItemCount(%clientId,HybridChainAmmo,9999);
   Player::setItemCount(%clientId,AtomicBomb,1);
   Player::setItemCount(%clientId,AtomicBombAmmo,4);

   Player::setItemCount(%clientId,Salvo,1);
   Player::setItemCount(%clientId,SalvoAmmo,30);

   Player::setItemCount(%clientId,HybridMortar,1);
   Player::setItemCount(%clientId,HybridMortarAmmo,120);

   Player::setItemCount(%clientId,HybridCannon,1);
   Player::setItemCount(%clientId,HybridCannonAmmo,50);

   Player::setItemCount(%clientId,HybridRocketLauncher,1);
   Player::setItemCount(%clientId,HybridRocketLauncherAmmo,100);

   Player::setItemCount(%clientId,HybridQuadLauncher,1);
   Player::setItemCount(%clientId,HybridQuadAmmo,100);
//------------------------------------------------
   Player::setItemCount(%clientId,XTremePack,1);
//------------------------------------------------
   Player::mountItem(%pl,XTremePack,$BackpackSlot); 

	Player::useItem(%pl,Blaster);
   
   if($teamplay)
   {
      DMTEAM::checkMissionObjectives();
      DMTEAM::echoScores();
   }
}

//Player has a total of 10 seconds per life allowed outside designated mission area.
//After a player expends this 10 sec, the player is remotely killed.
//-lesson to be learned= stay in the mission area!
function Player::leaveMissionArea(%player)
{
   %cl = Player::getClient(%player);
	Client::sendMessage(%cl,1,"You have left the mission area.");
	%player.outArea=1;
	alertPlayer(%player, 3);
}

//checking for timeout of dieSeqCount
function Player::checkLMATimeout(%player, %seqCount)
{
   echo("checking player timeout " @ %player @ " " @ %seqCount);
   if(%player.dieSeqCount == %seqCount)
      remoteKill(Player::getClient(%player));
}

//called if player leaves mission area
function Player::enterMissionArea(%player)
{
   %player.outArea="";
   %player.dieSeqCount = 0;
   %player.timeLeft = %player.timeLeft - (getSimTime() - %player.leaveTime);
}
  
function alertPlayer(%player, %count)
{
	if(%player.outArea == 1) {
		%clientId = Player::getClient(%player);
	  	Client::sendMessage(%clientId,1,"~wLeftMissionArea.wav");
		if(%count > 1)
		   schedule("alertPlayer(" @ %player @ ", " @ %count - 1 @ ");",1.5,%clientId);
		else 
	   	schedule("leaveMissionAreaDamage(" @ %clientId @ ");",1,%clientId);
	}
}

function leaveMissionAreaDamage(%client)
{
	%player = Client::getOwnedObject(%client);
	if(%player.outArea == 1) {
		if(!Player::isDead(%player)) {
		  	Player::setDamageFlash(%client,0.1);
			GameBase::setDamageLevel(%player,GameBase::getDamageLevel(%player) + 0.5);
	   	schedule("leaveMissionAreaDamage(" @ %client @ ");",1);
		}
		else { 
			playNextAnim(%client);	
			Client::onKilled(%client, %client);
		}
	}
}

function Game::checkTimeLimit()
{
   // if no timeLimit set or timeLimit set to 0,
   // just reschedule the check for a minute hence
   $timeLimitReached = false;

   if(!$Server::timeLimit)
   {
      schedule("Game::checkTimeLimit();", 60);
      return;
   }
   %curTimeLeft = ($Server::timeLimit * 60) + $missionStartTime - getSimTime();
   if(%curTimeLeft <= 0)
   {
      $timeLimitReached = true;
      $timeReached = 1;
		DM::missionObjectives();
		Server::nextMission();
	}
   else
   {
      schedule("Game::checkTimeLimit();", 20);
      UpdateClientTimes(%curTimeLeft);
   }
}

function Vote::changeMission()
{
	$timeLimitReached = true;
   $timeReached = 1;
	DM::missionObjectives();
}
  
//---------------------------------------------------------------------------------------
//
//Free for all Deathmatch function definitions
//
//---------------------------------------------------------------------------------------
function DM::checkMissionObjectives(%playerId) 
{
   if(DM::missionObjectives(%playerId)) 
      schedule("nextMission();", 0);
	if($DMScoreLimit > 0)
		if((Player::getClient(%playerId)).scoreKills >= $DMScoreLimit) {
	      $timeLimitReached = true;
   	   $timeReached = 1;
			DM::missionObjectives();
			Server::nextMission();
		}
}

function DM::missionObjectives()
{
	%numClients = getNumClients();
	for(%i = 0 ; %i < %numClients ; %i++) 
		%clientList[%i] = getClientByIndex(%i);
	%doIt = 1;
	while(%doIt == 1) {
		%doIt = "";
		for(%i= 0 ; %i < %numClients; %i++) {
			if((%clientList[%i]).ratio < (%clientList[%i+1]).ratio) {
				%hold = %clientList[%i];
				%clientList[%i] = %clientList[%i+1];
				%clientList[%i+1]	= %hold;
				%doIt=1;
			}
		}
	}
   if(!$Server::timeLimit)
      %str = "<f1>   - No time limit on the game.";
   else if($timeLimitReached)
      %str = "<f1>   - Time limit reached.";
   else
      %str = "<f1>   - Time remaining: " @ floor($Server::timeLimit - (getSimTime() - $missionStartTime) / 60) @ " minutes.";
	for(%l = -1; %l < 1 ; %l++) {		
		%lineNum = 0;
		if($timeReached == "") {
	 	  	Team::setObjective(%l, %lineNum, "<jc><B0,0:deathmatch1.bmp><B0,0:deathmatch2.bmp>");
	  		Team::setObjective(%l, %lineNum++, "<f5>Mission Information:");
			Team::setObjective(%l, %lineNum++, "<f1>   - Mission Name: " @ $missionName); 
	      Team::setObjective(%l, %lineNum++, %str);
	      Team::setObjective(%l, %lineNum++, " ");
	 	  	Team::setObjective(%l, %lineNum++, "<f5>Mission Objectives:");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>   -Kill all other players!");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>   -Stay alive!");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>   -To have the highest Efficiency!");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>   	 -Efficiency is calculated once (Kills + Deaths) is greater than 4");
	 	  	Team::setObjective(%l, %lineNum++, " ");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>Remember to stay within the mission area, which is defined by the extents of your commander screen map."	@ 
	 	                                 " If you go outside of the mission area you will have 3 seconds to get back into the mission area, or you'll start taking damage!");
	 	  	Team::setObjective(%l, %lineNum++, " ");
	 	  	Team::setObjective(%l, %lineNum++, " ");
		  	Team::setObjective(%l, %lineNum++, "<f5>TOP PLAYERS ARE: " );
	 	  	Team::setObjective(%l, %lineNum++, " ");
	 	  	Team::setObjective(%l, %lineNum++, "<f1>Player Name<L30>Kills<L50>Deaths<L70>Efficiency");
	   }
	   else {
			Team::setObjective(%l, %lineNum++, "<f5>Mission Summary:");
	 	  	Team::setObjective(%l, %lineNum++, " " );
	 	  	Team::setObjective(%l, %lineNum++, "<f1>     - The Best Player(s): " );
			%i=0;
			%TopRatio="";
			while(%i < %numClients && %clientList[%i].ratio != 0 && (%TopRatio == "" || (%TopRatio ==  (%clientList[%i+1]).ratio && %TopRatio != 0) )) {
	 	  		Team::setObjective(%l, %lineNum++, "<L14><f5><Bskull_big.bmp>\n" @ Client::getName(%clientList[%i]) @ "<f1> with a ratio of <f5>" @ (%clientList[%i]).ratio @ ".0%");
				%TopRatio = (%clientList[%i]).ratio;
				%i++;
			}
			if(%i == 0) {
	 	  		Team::setObjective(%l, %lineNum++, "<L14><f1>NONE with a ratio greater than 0.0%");
			}
			Team::setObjective(%l, %lineNum++, " ");
	 	  	Team::setObjective(%l, %lineNum++, " ");
			Team::setObjective(%l, %lineNum++, "<f5>TOP PLAYERS ARE: " );
	 	  	Team::setObjective(%l, %lineNum++, " ");
			Team::setObjective(%l, %lineNum++, "<f1>Player Name<L30>Kills<L50>Deaths<L70>Efficiency");
		}
	   //print out top 5 scores
		%index = 0;
		while(%index < %numClients && %clientList[%index].ratio != 0 && (%index < 5 || (%clientList[%index].ratio == %lastRatio && %lastRatio != 0))) {
	  		%client = getClientByIndex(%count);
	  	   Team::setObjective(%l, %lineNum++,"<Bskull_small.bmp>" @ Client::getName(%clientList[%index]) @ " <L31>" @ (%clientList[%index]).scoreKills @ "<L53>" @ (%clientList[%index]).scoreDeaths @ "<L72>" @ (%clientList[%index]).ratio @ ".0%");
			%lastRatio = (%clientList[%index]).ratio;
			%index++;
		}  
		for(%s = %lineNum+1; %s < 30 ;%s++)
			Team::setObjective(%l, %s, " ");
	}
	$timeReached="";
}

//-----------------------------------------------------------------
//
//Team Deathmatch Function definitions
// 
//-----------------------------------------------------------------
function DMTEAM::echoScores()
{   
	 %score = getTeamName(0) @ ": " @ $teamScore[0];
	 
	 for(%i = 1; %i < $numTeams; %i = %i + 1)
        %score = %score @ ", " @ getTeamName(%i) @ ": " @ $teamScore[%i];
     
     MessageAll(0, %score);
     schedule("DMTEAM::echoScores();", 40);
}

function DMTEAM::checkMissionObjectives()
{
   for(%p = 0; %p < $numTeams; %p = %p + 1) 
   {
	  if(DMTEAM::teamMissionObjectives(%p))
	     schedule("Server::nextMission();", 0);
   }
}

function DMTEAM::teamMissionObjectives(%teamId)
{
   %numHighs = 0;
   %teamName = getTeamName(%teamId);
   %teamScore = $teamScore[%teamId];
   %highScore = 0;
  
   for(%t = 0; %t < $numTeams; %t = %t + 1)
   {
	   if(%teamScore > $teamScore[%t]) 
	   {
	      %highScore = %teamScore;
		  %numHighs = %numHighs + 1;
	   }
	   else if($teamScore[%t] > %highScore)
	   {
		  %highScore = $teamScore[%t];
		  %numHighs = %numHighs + 1;
	   }
   }

   if(%highScore == $ScoreLimit)
   {
       for(%r = 0; %r < $numTeams; %r = %r + 1)
       {
		  if(%teamScore == %highScore)
             Team::setObjective(%teamId, 2, "~f0Your team is victorious!");
          else if((%teamScore == %highScore) && (%numHighs > 1)) 
             Team::setObjective(%teamId, 2, "~f0Your team ended up tied for the lead!");
          else
             Team::setObjective(%teamId, 2, "~f0Your team lost!"); 
       }

       Team::setObjective(%teamId, 3, "\n");
       //print out all team scores
	   %lnum = 4;
	   for(%q = 0; %q < $numTeams; %q = %q + 1) 
	   {
       	  Team::setObjective(%teamId, %lnum, getTeamName(%q) @ ": " @ $teamScore[%q]);
		  %lnum = %lnum + 1;
       }
       return "True"; //change mission
   }
  
   Team::setObjective(%teamId, 3, "\n");
   Team::setObjective(%teamId, 4, "Mission Status:"); 													    
   
   
   if((%teamScore == %highScore) && (%highScore == 0))
      Team::setObjective(%teamId, 5, "~f0All teams tied at 0.");
   else if((%teamScore == %highScore) && (%numHighs > 1)) 
      Team::setObjective(%teamId, 5, "~f0Your team is Tied for the lead!");
   else	if((%teamScore == %highScore) && (%numHighs == 1))
      Team::setObjective(%teamId, 5, "~f0Your team is winning.");
   else
      Team::setObjective(%teamId, 5, "~f0Your team is losing.");
   
   
   Team::setObjective(%teamId, 6, "\n");
   Team::setObjective(%teamId, 7, "You must:");
   Team::setObjective(%teamId, 8, "-Kill all players on all other teams.");
   Team::setObjective(%teamId, 9, "-Stay alive!");
   Team::setObjective(%teamId, 10, "\n");
   Team::setObjective(%teamId, 11, "Remember to stay within the mission area, which is defined by the extents of your commander screen map."	@
                                  " If you go outside of the mission area you will have 10 seconds to get back into the mission area, or you will be killed!");
     							  
   Team::setObjective(%teamId, 12, "\n");
       //print out team scores
	   %lnum = 14;
	   Team::setObjective(%teamId, 13, "Team Scores");
	   for(%g = 0; %g < $numTeams; %g = %g + 1) 
	   {
       	  Team::setObjective(%teamId, %lnum, getTeamName(%g) @ ": " @ $teamScore[%g]);
		  %lnum = %lnum + 1;
       }

   return "False";
}												
function getEfficiencyRatio(%clientId)
{
	if((%clientId.scoreKills + %clientId.scoreDeaths) > 4) {
		%ratio = floor((%clientId.scoreKills/(%clientId.scoreKills + %clientId.scoreDeaths))*100);		
		return %ratio;
	}
	return "0";
}

function Game::refreshClientScore(%clientId)
{
	%clientId.ratio = getEfficiencyRatio(%clientId);
   if($teamplay)
      Client::setScore(%clientId, "%n\t%t\t" @ %clientId.score  @ "\t%p\t%l", %clientId.score);
   else
      Client::setScore(%clientId, "%n\t " @ %clientId.scoreKills @ "\t  " @ %clientId.scoreDeaths @ "\t  " @ %clientId.ratio @ ".0%\t%p\t %l", %clientId.ratio);
	DM::missionObjectives();
}


function Mission::init()
{
   setClientScoreHeading("Player Name\t\x78Team\t\xC8Score");

   $numTeams = getNumTeams();
   for(%i = 0; %i < $numTeams; %i++)
      $teamScore[%i] = 0;

   if($teamplay = !($numTeams == 1))
   {
      setTeamScoreHeading("Team Name\t\xC8Score");
      setClientScoreHeading("Player Name\t\x78Team\t\xC8Score");
   }
   else
   {
      $SensorNetworkEnabled = false;
      setTeamScoreHeading("");
      setClientScoreHeading("Player Name\t\x55Kills\t\x75Deaths\t\xA5Efficiency\t\xE3Ping\t\xFFPL");
   }
   $dieSeqCount = 0;
   //setup ai if any
   AI::setupAI();
	DM::missionObjectives();
}








































٨..................................................................................)))))))))))))))))))))))))))))))))))))))llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]@Ovvvvvvvvvvvvvvvvv||||||||||||||||||||||||||||||||||||||||||||RBBBBBBBBBBBBBBBBBBBB.EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<777777777777777777777777777777777777777777777lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll)))))))))))))))))))))))))))))))))))))))))))))l.(),"////////////////////////////////////////////////////////////////////////////////////////llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll)g%+N========DDDDDDDDDDDDDDDDDDDDDDDDDDDBvERRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRI<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<(.,""""""""""""""""""""""""""""""""""""""""""""""""""""""""llllllllllllllllllllllll///////////////////////////////////////////////////////////////////////////////())))))))g%0hhhhhhhhhhhhhhhlrrrrrrrrrrr,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,/................................""""""""""""""rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrelllllllllllllllllEG666666666666666666666666666666666666666666666''''''''''''''''''''''''''''2\*&888888888888888888888888888888888888888888888888KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKx000000000000000000000000000000000000000000![[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[|||||||||||||||||||||||||||||||||||||||||]9}@OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOONNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNND+B=---------------------------r((((((((((((((((((((((vgRRRRRRRRRRRRRRRRR<<<<<<<<<<<<<<<<<<<<))))))))),%/hhhhhhhl"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""IIIIIIIIeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeellllllllllllllllllllllllrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrre...............................g(0,ppppppppp/)"%.hllllllllllllllllllllllllllllllllleeeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrlllllllllllllllllllllllllllllllllleeD$wERNTM+B=-(111111111111111111111111111111111111111111111111111111111111111/7vvvvvvvvvvvvvvvvv<g.,p0r)""""""""llllllllllllllllllllllllllllllllllllllllllllllllllllllllll%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeelrrrrrrrrrrrnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeehhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh))))))))))))))))f///////////.1pg(,,,,,,,,,I0llllllllllllllllllleh"rrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnee           %oooooooonlllllllllllllllllllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeeeee rrrrrrrrrrrrrrrrrrrrrR:kGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG\\\\\\\\\\\\\\\\\\\\\\\\82)))))))))))))|FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFq~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~![[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx]D9999999999999999999999999999999w@OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO$(+ENTTTTTTTTTTTTTTTTTTTTTTTTTTTMB=================----------------------77777777777777777777777777777777777777777777777777777777777777777777777v%f/.1pggggggggggggggggggggggg,I<0hhhhhhhhhnnnnnnnnnnnroeeeeeeeeeeeeeeeeeeeeeeeeee                 llllllllllllllllllllleeeeeeeeeeeeeee nnnnnnnnr""""""""""""eeeeeeeeellllllllllllllllllllllllllllllleeeeeeeeo                                          /////////////(g%f)01p.rrrrrrrrrrrrrrrr,lneeeeeeeeo""""""""""""""""""""""""""""""""""""""""                                          eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeel orrrrrrrrrrrnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnee        hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNdkRD:wwwwwwwwwwwwww>>>>>>>>>>>>>>>+SSSSSSSSSSSSSSSSSS$pBETTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTM=================I------------------------------------------------------------------------/ofg0%()eeeeeeeeeeeeeeee1"..................llllllllllllllllllll h,rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrneeeeeeeeeeeeeeeeeeeeeeeeee                                     voooooooooooooooonllllllllllllllllllllleeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeerrrrrrrrrrrrrrrrrrrrr0dhhhhhhhhhhhhppppppppppppp/fg	nnnnnnnnnnnnnnnn(")%111111111111111111<.eeeeeeero                                                 eeeeeeelllllllllllllllllllll               rrrrrrrrnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn el,,,,,,,,,,,,,,,,,,,,,,,,,,,        ooooooooooooooooooooooooooooooooooeetCոԭ̴ʮ׶`^ZW󧧧J?ӿi¾ܩ#X 























































Q\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU__________________________________________________________________________________________________________________________________________________zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzVj{4
YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY3;;;;;;;;;;;;;;;;;;;;;966666666666666666666666666H*'&KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKGGGGGGGGGGGGGGGGGGGGGGGG82|FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDL5b!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[qxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]@NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNkR7O=wwwwwwwwwwwwww>>>>>>>>>>>>>>>+S:0TBBBBBBBBBBBBBBBBBBBBBBE$$$$$$$$$$$$$$$$$$$$$$$$$$$ppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppMMMMMMMMMMMMMMMMMIIIIIIIIIIIIIIIIIIII-ghhhhhhhhhhhhd"/fffffffffffff<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<(	n)%lrrrrrrr        ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeee ,111111111111111111111noitttttttttttttttttalllllllllllllll.reeeeeeeeeeeeeeeeeeeeeeeeee                                                     eeeeeeeeeeeeeeef0upg,,,,,,,,,,,,d"/hhhhhhhhhhhhhvts)((((((((((((((((	.%oinnnnnnnnnnnnnnnnnaaaaaaa            eeeeeeeeeeeeeeeeeeellllllllllllllllllllllllllleeeeeeeer                                          1tissssssssssooooooooooonnnnnnneeeeeeeeraaaaaaaaaaaaaaaaaaaaa                                                elllllllllllllllllllll$ADLLLLLLLLLLLLLLLLLL5bNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNkRpmmmmmmmmmmmmmm===============wS>T++++++++++++++++++++++:yBBBBBBBBBBBBBBBBBBBBBBBBBBBBBEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE<MIIIIIIIIIIIIIIIIIIII0uf1,,,,,,,,,,,,d"/hggggggggggggggggggggggggg).(v-	risttttttttooooooooooo       lnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeee       aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasssssssssslri%%%%%%%%toooooooeeeeeeeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaneeeeeeeeeeeeeeeeeeeeeeeeee  ucpppppppppppppppppppppppp0mh1,f."/dsgggggggggggggggglllllllllllllllllllllllllllllllllllllll)iiiiiiiiiitra%((((((((((((((((((((((noooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetlniiiiiiiiiissssssssraeeeeeeeeeeeeeeeee	                                                 eeeeeeeooooooooooooooooooooo                                              C;;;;;;;;;;;;;;;;;;;;;;;93333333333333333333333333333333333333333333333333P\





























4444444444444444444444444444444444444444444444444444444444444442GF8!|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<[xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx]@7ADLLLLLLLLLLLLLLLLLL5bNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNkR$0SSSSSSSSSSSSSSSTwwwwwwwwwwwwwwwwwwwwww>y+++++++++++++++++:::::::::::::::::::::::::::B=E/vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvOMIcpppppppppppppppppppppppput,h.1mfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"dg%%%%%%%%%%%%%%%%%%%%%%%%%%nillllllllsrrrrrrrrrrrrrrrrrrrrrrrrrr eoaaaaaaaaaaaaaaaaaaaaaaaaaaa        	))))))))))))))))))))))))))))))))))eeeeeeeeeeeeeeeeeeeeeitsnolllllll        (rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaa-0/cpppppppppppppppppppppppppppppppppp.,mhu1s%f"d	g((((((((((((((((itttttttttttttttttnoooooooooooooooaleeeeeeeeeeeeeeeeeeeeeeeeee                       rrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeetsa)iiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnn            eeeeeeeeeroooooooooooooooooooooooooooeeeeeeeel                                          RRRRRRRRRRRRRR<ADyyyyyyyyyyyyyyyyyy5bNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNkLvSSSSSSSSSSSSSSSTwwwwwwwwwwwwwwwwwwwwww>$0000000000000000000000000000000000000000000=:+BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEM-Imcp/%.,,,,,,,,,,,,,	u1htf"a(dissssssssss)grrrrrrrrrrrrrrrrreeeeeeeelnnnnnnnnnnnnnnnnnnnnn                                                eooooooooooooooooooooooooooooooalistttttttttttttttttttttttr       ooooooooooooooooooooooooooooooooooooooooooooeeeeeeeee       nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn10000000000000000000000000000000mcpppppppppp,%	./////////////s(uhf)"oliaaaaaaaattttttttttttttttdddddddeeeeeeeeeeeeeeeeeeee nrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeee  osiiiiiiiiiitlnaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaagggggggggggggggggggggeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY6{HHHHHHHHHHHHHHHHHHHHHHHHH******************************************************************************************************************************kkkkkkkkkkkkkkkkkkk&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&;'9CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCP3

















































\\\\\\\\\\\\\\\\\\\\\\\\
24FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF!GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG88888888888888888888888888888888888888888|qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq~~~~~~~~~~~~~~~~~~~~~~~~~~~~}KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK[xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx]@@@@@@@@@@@@@@<ADyyyyyyyyyyyyyyyyyy5bNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNRcccccccccccccccvwS>TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT=$+++++++++++++++++L:(-BEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE70000000000000000000000000000000Mm1o	,/%p.t)))))))))))))uhhhhhhhhhhhhhhhhfffffffffffiiiiiiiiiisssssssslneeeeeeera                                                 eeeeeeeg"""""""""""""""""""""                        trrrrrrrrrrrioooooooosllllllllllllllllllllllllll ednnnnnnnnnnnnnnnnnnnnnnnnnnn        aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeemc(////////////I0)	,1111111111111111p.%%%%%%%%%%%%%%%%%%%%%%urghitsssssssssssdfooooooo        alllllllllllllllllllllllllllllllllllllllllllllllllllllllleeeeeeeeeeeeeeeeeeee nnnnnnnnnnnnnnnnnnnnnsraittttttttttttttttttttttttttt"""""""""""""""noeeeeeeeeeeeeeeeeeeeeeeeeee                       llllllllllllllllllllleeeeeeeeeeeeeee-kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk<ADyyyyyyyyyyyyyyyyyy5bNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNIIIIIIIIIIIIIIIvwS>TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT=$+++++++++++++++++L:R....................Emc(////////////BOs,))))))))))))))))	01tgp%%%%%%%%%%%%%dunairrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr            eeeeeeeeel"hhhhhhhhhhhhhhhhhhhhhhhhhhheeeeeeeeo                                          ntissssssssssalrrrrrrreeeeeeeeooooooooooooooooooooooooooooooo                                                efffffffffffffffffffffg.mc(////////////nnnnnnnnnnnnnnnn,0)M										d1p%"""""""""""""oisttttttttal       furrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeee                                                           sssssssssshoinnnnnnnntaaaaaaaeeeeeeeeeeeeeeeeeeee           llllllllllllllllllllllllllllllllllllllllllreeeeeeeeeeeeeeeeeeeeeeeeee                                   ;;;;;;;;;;;;;;;;;;;9CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCP3

















































\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\F2!444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444Gq8888888888888888888888888888888|















































NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx]kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk-TADyyyyyyyyyyyyyyyyyy5b<:IIIIIIIIIIIIIIIvwS>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>.$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$===========================+/BLRRRRRRRRRRRRRRRRRRRRg0c(mdddddddddddddddd,,,,,,,,,,,,"ME	)s1ph%%%%%%%%%%%%%fiiiiiiiiiitooooooooooonnnnnnnnnnnnnnnnnnnnnnraaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeellllllllllllllllllllltsriiiiiiiiiiuuuuuuuuoooooooooooeeeeeeeln                                                 eeeeeeeaaaaaaaaaaaaaaaaaaaaa               	./g0c(t,d""""""""""""""""mmmmmmmmmmmmmmmmmmmmmhO@)1111111111111plrissssssssu%oooooooooooooooooooooooooo eaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa        nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneellllllllllitfrasssssss        nooooooooooooooooooooooooooooooooooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeee                               BBBBBBBBBBBBBBNkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk-TADyyyyyyyyyyyyyyyyyy5bccccccccccccccc:wI>v$SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS<=hM+LR./g0	l",md((((((((((((((((ffffffffffff77777777777777777777)1111111111111punitttttttttttttttttraaaaaaaaaaaaaaaaaaaaaaaaaseeeeeeeeeeeeeeeeeeeeeeeeee                       oooooooooooooooooooooeeeeeeeeeeeeeeetlllllllllllni%%%%%%%%%%%%%%%%%rrrrrrr            eeeeeeeeeoaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeees                                          0chm/g.f",	1((((((((((((((((dttttttttttttEEEEEEEEEEEp)illllllllllno%%%%%%%%%%%%%%%%%%%eeeeeeeesrrrrrrrrrrrrrrrrrrrrr                                                eaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasilttttttttno       auuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeeee       rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUQz________________________________VjYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY666666666666666666666666666666666666HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{&&&&&&&&&&&&&&&&&&&&&&&&&&5555555555555555555555555555555555~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'C;;;;;;;;;;;;;;;;;;;;;;;93333333333333333333333333333333333333333333333333P\
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!222222222222222222222222222222222222222224qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqG
8}|MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMO[xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxNkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk-TADyyyyyyyyyyyyyyyyyyBgwwwwwwwwwwwwwww>:$IIIIIIIIIIIIIIIIIvvvvvvvvvvvvvvvvvvvvvvvvvvvS<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb7]=+Lchm/0000000000,f1".	lp(dddddddddddd%ERasiiiiiiiiiiiiiiiiiitnnnnnnneeeeeeeeeeeeeeeeeeee roooooooooooooooooooooooooooooooooooooooooou)eeeeeeeeeeeeeeeeeeeeeeeeee  aliiiiiiiiiitsrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeeooooooooooooooooooooopggggggggggggggggchm/a1,.f0"t%	(duuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuiiiiiiiiiillllllllsreeeeeeeooooooooooo                                                 eeeeeeennnnnnnnnnnnnnnnnnnnn                        to)iaaaaaaaalssssssssssssssssssssssssss enrrrrrrrrrrrrrrrrrrrrrrrrrrr                                                   eeeeeeeeeeeeeeeeeee5MMMMMMMMMMMMMMNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN-TADyk@wwwwwwwwwwwwwww>:$IBg<<<<<<<<<<<<<<<<<<<<<<<<<<<bSvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvmEEEEEEEEEEEEEEEEEEEEEE=+p.chhhhhhhhhhhhhhhh%1,/u0"ffffffffff	(oooooooooooooditl))))))))))))naaaaaaa                  sssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeeeeeeeee rrrrrrrrrrrrrrrrrrrrrloooooooooooittttttttttttttttttttttttttttttttttttLnnnnnnnnnnnnnnnraeeeeeeeeeeeeeeeeeeeeeeeeee                       ssssssssssssssssssssseeeeeeeeeeeeeee"gmp.chl,%u1111111111111111/ttttttttttttt0f	)(rrrrrrrrrrrioooooooooooooooooRddddddd            eeeeeeeeesnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeea                                          rtillllllllllllllllllllsoooooooeeeeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa                                                ennnnnnnnnnnnnnnnnnnnnyCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC3;;;;;;;;;;;;;;;;;;;;;9\\\\\\\\\\\\\\\\\\\\\\\\\\\\\FP!







































































































































q22222222222222222222222222222224







































































GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG8EO||||||||||||||||||||||||||||||||||||||||||||||||K777777777777777777777777777777777777777777[x5MMMMMMMMMMMMMMNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN-TADDDDDDDDDDDDDDDDDDccccccccccccccc@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:wI><$bBvvvvvvvvvvvvvvvvvvvvvvvvvvvkSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS=gmp."ru,,,,,,,,,,,,,,,,%h1111111111)/0fR+	ailtttttttttttttttttts       nooooooooooooooooooooooooooooooooooeeeeeeeee                  (((((((((((((((((((((((((((((((((((((((((((llllllllllnairrrrrrrrttttttttttttttttteeeeeeeeeeeeeeeeeeee dssssssssssssssssssssssssssssssssssssssssssoeeeeeeeeeeeeeeeeeeeeeeeeee  .ccccccccccccccccccccccccccccmpg)u,"Lh1%l/0nnnnnnnnnnnnfiiiiiiiiiitad	rrrrrrrrrrrrrrrrrrrrrroooooooooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeessssssssssssssssssssstnoiiiiiiiiiilllllllla(eeeeeeesr                                                 eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee                                  yE5MMMMMMMMMMMMMMNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN-TADp:::::::::::::::I]<wb>v$kBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB1RSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSccccccccccccccccccccccccccccm.t,)L=ug"""""""""""""""""""""h%/d0soinnnnnnnnlaaaaaaaaaaaaaaaaaaaaaaaaaa eeeeeeeeeee(fffffffffffffffffffffffffff        rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreessssssssssitlooooooooooonnnnnnn        raaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeeeeeee 																																p1ccccccccccccccccccccccccccccms+,g).uld"h%(/ritttttttttttttttttooooooooooooooooooooooooo	0neeeeeeeeeeeeeeeeeeeeeeeeee                       aaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeetlfrisssssssssssssssssooooooo            eeeeeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeen                                          !Yj66666666666666666666666666666666HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH**************************************************************************************************************************&{~~~~~~~~~~~~~~~~~~~~~~~~~O}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC3;;;;;;;;;;;;;;;;;;;;;9\\\\\\\\\\\\\\\\\\\\\\\\\\\\\FPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP'555555555555555555555555555555555555555555555555555555555555555555555555555555555555qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
222222222222222222222222222222222444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
GA78||||||||||||||||||||||||||||||||||||||||||||||||@K[yEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN-TMR:::::::::::::::I]x<wDpkvvvvvvvvvvvvvvvvvv$>BBBBBBBBBBBBBBBBLLLLLLLLLLLLLLLLLLLLLLLLLLLSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSgccccccccccccc1d++++++++++++++++++++++,m(.u)t"hf%/	illllllllllrassssssseeeeeeeenooooooooooooooooooooo                                                eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetnil00000000ra                 sssssssssssssssssssssssssssssssssseeeeeeeee       oooooooooooooooooooooooooooooooooooooooooooupppppppppppppppppppppppppppgcccccccccccccccccccccc,d(=1mlf.)"/hhhhhhhhhhhnitttttttt0%rrrrrrreeeeeeeeeeeeeeeeeeee oaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaseeeeeeeeeeeeeeeeeeeeeeeeee            liiiiiiiiii	nottttttttttttttttttttttsrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeeaaaaaaaaaaaaaaaaaaaaaL5AyEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN-TcccccccccccccccRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR:wIk<<<<<<<<<<<<<<<<<<D>vM$f+BBBBBBBBBBBBBBBBBBBBBBBBBBBSpppppppppppppppppppppppppppguuuuuuuuuuu(,1ddddddddddddd=============================================================	m.)"/h0siiiiiiiiiillllllllnoeeeeeeeat                                                 eeeeeeerrrrrrrrrrrrrrrrrrrrr                                  asi%%%%%%%%lnnnnnnnnnnnnnnnnnnnnnnnnnn erooooooooooooooooooooooooooo        tttttttttttttttttttttttttttttttttteegcf111111111111111111111111111p	(,u""""""""""""""""""""""""""""""""""ddddddddddm.ah)iiiiiiiiiiilsr%///////        tnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeee ooooooooooooooooooooolatiiiiiiiiiiiiiiiiiiiiiiiiiiisrrrrrrrrrrrrrrro0eeeeeeeeeeeeeeeeeeeeeeeeee                       nnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeee-------------------OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOC;;;;;;;;;;;;;;;;;;;;;;;93333333333333333333333333333333333333333333333333P\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\Fq!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!






































































































































2
47777777777777777777777777777777777777777+@G8|]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]5AyEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL[[[[[[[[[[[[[[[wRk::::::::::::::::::I><MDTvvvvvvvvvvvvvvvvvvvvvv$BBBBBBBBBBBBBBBBBBBBBBBBBBBS=cf1111111111111111gl,	"(puuuuuuuuuuuhhhhhhhhhhhhhdm%.otiaaaaaaaaaaaaaaaaasssssss            eeeeeeeeenrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeee0)                                          oooooooooooilllllllllltnaaaaaaaeeeeeeee/sssssssssssssssssssss                                                errrrrrrrrrrrrrrrrrrrrhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhcf1111111111111111o",p	g((((((((((%uuuuuuuuuuuuud0m/.illlllllllllllllllltn       raaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeee       sssssssssssssssssssssssssssssssssssssssssssllllllllllr)ioooooooooooooooooottttttteeeeeeeeeeeeeeeeeeee snnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnaeeeeeeeeeeeeeeeeeeeeeeeeee                                        -+5AAAAAAAAAAAAAAAAAAEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNyyyyyyyyyyyyyyyyyyyyyyxxxxxxxxxxxxxxxwRk:LLLLLLLLLLLLM>T<ID1Sv$Bhpcfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff%",,,,,,,,,,,,,,,,0g(	luuuuuuuuuuuuur/diiiiiiiiiiiiiiiiiiii)msooooooooooooooooooooooattttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnraiiiiiiiiiillllllll.seeeeeeeno                                                 eeeeeeettttttttttttttttttttt               ((((((((((((1hpcfffffffffff,%0"=========================/g	u)))))))))))))nairrrrrrrrl.dddddddddddddddddddddddddd etsssssssssssssssssssssssssss        ooooooooooooooooooooooooooooooooooeennnnnnnnnniiiiiiiiiiilatrrrrrrr        ommmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmeeeeeeeeeeeeeeeeeeee sssssssssssssssssssss}@Շƈԭػ^ׯZW`J?߽ӿ¾#γ XzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzQYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYU6_VHj****************************************************************************************************************************&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{;O9CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCP3333333333333333333333333333333333333333333333333333333333333q\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\F
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!























72KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK4S]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]G88888888888888888888888888888888888888888888888888|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||'-+5AAAAAAAAAAAAAAAAAAEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNccccccccccccccccccccccccccccccccccccRxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx:wMkTLI>y</////////////////////////////////////////////////////////////Dv$$$$$$$$$$$$1hp(n0,=B%f"l))))))))))))))))g	.uoiiiiiiiiiiiiiiiiiiiiiiiiiiiatttttttttttttttsreeeeeeeeeeeeeeeeeeeeeeeeee                       mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmeeeeeeeeeeeeeeeeeeeeeeeeelsoinnnnnnnnnnnnnnnnnaaaaaaa            eeeeeeeeedttttttttttttttttttttttttttteeeeeeeer                                          pc///////////////////////////1hhhhhhhhhhhh)0,(.f"%%%%%%%%%%%%%%%%%%%%%%%%%%gsm	illllllllllodunnnnnnneeeeeeeeraaaaaaaaaaaaaaaaaaaaa                                                ettttttttttttttttttttttttttttttsrillllllllllllllllllooooooooooooo       tnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeee       aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaS-+5AAAAAAAAAAAAAAAAAAEEEEEEEEEEEEEEEEEEEEbbbbbbbbbbbbbbNhRRRRRRRRRRRRRRR::::::::::::::::::::::M[TwIkyLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL>"=<Dvc///////////////////////////$1pppppppppp,).000000000000(lmf%%%%%%%%%%%%%%%%dgtrissssssssssssssssssoooooooeeeeeeeeeeeeeeeeeeee aaaaaaaaaaaaa																																										neeeeeeeeeeeeeeeeeeeeeeeeee  tliiiiiiiiiiiiiiiiiiiirassssssssssssssssssssssnoooooooooooooooooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeeuuuuuuuuuuuuuuuuuuuuumh"c/B1t.,,,,,,,,,,,,)p00000000000d(f%%%%%%%%%%%%%%%%%%%%%%%%%%%%niiiiiiiiiillllllllraeeeeeeeugs                                                 eeeeeeeooooooooooooooooooooo                                  	nittttttttlrrrrrrrrrrrrrrrrrrrrrrrrrr eoaaaaaaaaaaaaaaaaaaaaaaaaaaa        ssssssssssssssssssssssssssssssssssee]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]];O9CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCP3333333333333333333333333333333333333333333333333333333333333q-






























































FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF!











































777777777777777777777777777777@@@@@@@@@@@@@@@@@@@@@@@@\2222222222222222222222222222222222222222222222222222222222222224444444444444444444444444444444444444444Gx8||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5AAAAAAAAAAAAAAAAAAEEEEEEEEEEEEEEEEEEEEb+=RRRRRRRRRRRRRRR::::::::::::::::::::::M[NhyIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIkwLB><Dvvvvvvvvvvvvvvvvvvvvvvvvvvvmmmmmmmmmmmmc/"d.,1111111111111p0))))))))))(f	%%%%%%%%%%%%%%%%uiiiiiiiiiiilnottttttt        srrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeee aaaaaaaaaaaaaaaaaaaaallllllllllsiiiiiiiiiiiggggggggnoooooooooooooooateeeeeeeeeeeeeeeeeeeeeeeeee                       rrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeee0h$mmmmmmmmmmmmc/l,ddddddddddddd."11111111111	p)((((((((((((((((fasiiiiiiiiiiiiiiiiig%nnnnnnn            eeeeeeeeeroooooooooooooooooooooooooooeeeeeeeet                                          aaaaaaaaaaailusrrrrrrrrrrrrrrrreeeeeeeetnnnnnnnnnnnnnnnnnnnnn                                                eoooooooooooooooooooooB------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5AAAAAAAAAAAAAAAAAAEEEEEEEEEEEEEEEEEEEEbccccccccccccccc======================RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR:yMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMNwI+k	vL><h$Dmmmmmmmmmmmm0aaaaaaaaaaaaa,"d/.u1p)((((((((((((((((fgtillllllllllllllllllsr       oooooooooooooooooooooooooooooooooooooooooooeeeeeeeee       nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnlaoti%%%%%%%%%%%%%%%%%%ssssssseeeeeeeeeeeeeeeeeeee nrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeeeeeeeeeeeeeeeeeeee             c	"""""""""""""""""""""""""""mhuuuuuuuuuuuuu,0(/.dl1pof)iaaaaaaaaaaatn%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeerrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrooooooooooialllllllltneeeeeeerg                                                 eeeeeeesssssssssssssssssssss                                                                H6*YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYj&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}]K{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOC;;;;;;;;;;;;;;;;;;;;;;;93333333333333333333333333333333333333333333333333P








































































qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
F7!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\vx24444444444444444444444444444444444444444[G8|------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5AAAAAAAAAAAAAAAAAAEBmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm=yRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR:wM+NbI.$kL>c	"""""""""""""""""""""""""""<<<<<<<<<<<<<<<<<<<<<<,u(((((((((((((h0af/d1%prrrrrrrrrriooooooooltttttttttttttttttttttttttt esnnnnnnnnnnnnnnnnnnnnnnnnnnn        g))))))))))))))))))))))))))))))))))eeraiiiiiiiiiiillllllllllsooooooo                       tttttttttttttttttttttttttttttttttttttttttttttttttttttttteeeeeeeeeeeeeeeeeeee nnnnnnnnnnnnnnnnnnnnnfm.c	"Dr(,huuuuuuuuuuuuuuuuuuuuuuuul%0/dg1111111111111111piiiiiiiiiiiaaaaaaaaaaaaaaaaasssssssssssssssnoeeeeeeeeeeeeeeeeeeeeeeeeee                       ttttttttttttttttttttteeeeeeeeeeeeeeeeeeeeeeeeeln)irrrrrrrraaaaaaaaaaaaaaaa            eeeeeeeeetssssssssssssssssssssssssssseeeeeeeeo                                          EEEEEEEEEEEEEEEEEEEEv----------------------------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$=yRBm+wbM:N"""""""""""""""""""""""""""IkLfhc	.%(,D>gggggggggggggggggggggggguuuuuuuuuuu0/nnnnnnnnnnnnnnnndila)1trrrrrrreeeeeeeeoooooooooooooooooooooooooooooo                                                esssssssssssssssssssssanoillllllllllllllllllpt       srrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrreeeeeeeee                                                                      m"fhc	a,%g(.<lllllllllllllllllllllllllllu0)/soinnnnnnnnnnnnnnnnnnpdddddddeeeeeeeeeeeeeeeeeeee          ttttttttttttttttttttttttttttttttttttttttttreeeeeeeeeeeeeeeeeeeeeeeeee  sliaaaaaaaaaaaoooooooooonnnnnnnnnnnnnnnnnnnnnnr111111111111111111111eeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeettttttttttttttttttttttttttttttttttttttOOOOOOOOOOOOOOOOOOOC]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]3;;;;;;;;;;;;;;;;;;;;;9




























































PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
q7777777777777777777777777777777@F\!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx[[[[[[[[[[[[[[[[[[[[[[[[2444444444444444444444444444444444444444444444444444444444444444444444444444444444G88888888888888888888v----------------------------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5AEccccccccccccccc$======================R'|+ybB:wwwwwwwwwwwwwwwwwMMMMMMMMMMMMMMMMDNIkm"fhhhhhhhhhhhhhsg,.%	((((((((((()<LLLLLLLLLLLLup0riallllllllooooooooooeeeeeeetn                                                 eeeeeee1/////////////////////               aaaaaaaaaaatrissssssssloooooooooooooooooooooooooo edddddddddddddddddddddddddddddddddddd        nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneehcccccccccccccccc."fm)g,,,,,,,,,,,,,p	(%a>>>>>>>>>>>>t1uiiiiiiiiiiilrd0sssssss        nooooooooooooooooooooooooooooooooooooooooooooooooooooooooeeeeeeeeeeeeeeeeeeee                              ltniiiiiiiiiiiaaaaaaaar////////////////////////seeeeeeeeeeeeeeeeeeeeeeeeee                       oooooooooooooooooooooeeeeeeeeeeeeeeeDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDv----------------------------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSST5Af===============R$++++++++++++++++++++++bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb:yyyyyyyyyyyyyyyyyBEw(<MNIcccccccccccccccc."hl,)pgmmmmmmmmmmmmmmmmmmmmmmm1	%>kdddddddddddddddddddddnittttttttarrrrrrr            eeeeeeeeeo/uuuuuuuuuuuuuuuuuuuuuuuuuuueeeeeeees                                                             ilanottttttteeeeeeeesrrrrrrrrrrrrrrrrrrrrr                                                e0000000000000000000001f(cccccccccccccccc.""""""""""p,m)hgaddddddddddddd	%/Lsillllllllllllllllllno       000000000000tttttttttttttttttttttttttttttttttteeeeeeeee       rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrlausiiiiiiiiiiiiiiiiiiiiiiiiiiinnnnnnneeeeeeeeeeeeeeeeeeee rooooooooooooooooooooooooooooooooooooooooooteeeeeeeeeeeeeeeeeeeeeeeeee                                  XzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzQHU_*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV6&Y~j}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[{{{{{{{{{{{{{{{{{{{{{{{{{OOOOOOOOOOOOOOOOOOOC]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]3;;;;;;;;;;;;;;;;;;;;;9








































































































































77777777777777777777777777777777777777777@q\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\Fx!PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555552'''''''''''''''''''''''''''''''''''''''''''''''''''''''''4444444444444444444444444444444444444444GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGDb----------------------------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSTv<===============R$++++++++++++++++++++++Afffffffffffffffff:Eyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy8B.>wMN1mcccccccccccccccc(dp,"/hg)lllllllllllll	u%LI0iaaaaaaaaaaasrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrtnnnnnnnnnnnnnnnnnnnnneeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeeeoooooooooooooooooooooooooooooooltiaaaaaaaaaaaaaaaaaaasreeeeeeeoooooooooo                                                 eeeeeeennnnnnnnnnnnnnnnnnnnn               gf.1mcccccccccccccccccccccccccc,d/p("auh)))))))))))))k	otilllllllllllllllllll%ssssssssssssssssssssssssss enrrrrrrrrrrrrrrrrrrrrrrrrrrr                                                  eeoaiiiiiiiiiii0tnlllllll                 sssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeeeeeeeeee rrrrrrrrrrrrrrrrrrrrr>>>>>>>>>>>>>>>>>>>>55555555555555555555555555555555555555555555Db----------------------------------------------------SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSTccccccccccccccc<$======================RRRRRRRRRRRRRRRRR+EA|:vyuLBwMf.1mgo/,(ddddddddddddddddp0"h)))))))))))))kN																					iiiiiiiiiiiaaaaaaaatnnnnnnnnnnnnnnnrleeeeeeeeeeeeeeeeeeeeeeeeee                       ssssssssssssssssssssseeeeeeeeeeeeeeeeeeeeeeeeeorrrrrrrrrri%%%%%%%%attttttt            eeeeeeeeesnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeel                                          mcu(.1f0/,ggggggggggggggggggggggggggggpddddddddddd"hr	)ioaaaaaaaaaas%IIIIIIIeeeeeeeelttttttttttttttttttttt                                                ennnnnnnnnnnnnnnnnnnnnarliooooooooooooooooooooooooooos       nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnneeeeeeeee       ttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt[]OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOC;;;;;;;;;;;;;;;;;;;;;;;93333333333333333333333333333333333333333333333333
777777777777777777777777777777777@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\qxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxPFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF!LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL24444444444444444444444444444444444444444444444444444444444455555555555555555555555555555555555555555555Db----------------------------------------------------S>1$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$<<<<<<<<<<<<<<<<<=ER|G+vAT:p