$GuiModeCommand    = 2;
$LastControlObject = 0;

function Observer::triggerDown(%client)
{
}

function Observer::orbitObjectDeleted(%cl)
{
}

function Observer::leaveMissionArea(%cl)
{
}

function Observer::enterMissionArea(%cl)
{
}

function Observer::triggerUp(%client)
{
   if(%client.observerMode == "dead")
   {
      if(%client.dieTime + $Server::respawnTime < getSimTime())
      {
         if(Game::playerSpawn(%client, true))
         {
            %client.observerMode = "";
            Observer::checkObserved(%client);
         }
      }
   }
   else if(%client.observerMode == "observerOrbit")
      Observer::nextObservable(%client);
   else if(%client.observerMode == "observerFly")
   {
      %camSpawn = Game::pickObserverSpawn(%client);
      Observer::setFlyMode(%client, GameBase::getPosition(%camSpawn), 
	      GameBase::getRotation(%camSpawn), true, true);
   }
   else if(%client.observerMode == "justJoined")
   {
      %client.observerMode = "";
      Game::playerSpawn(%client, false);
   }
   else if(%client.observerMode == "pregame" && $Server::TourneyMode)
   {
      if($CountdownStarted)
         return;

      if(%client.notready)
      {
         %client.notready = "";
         MessageAll(0, Client::getName(%client) @ " is READY.");
         if(%client.notreadyCount < 3)
            bottomprint(%client, "<f1><jc>Waiting for match start (FIRE if not ready).", 0);
         else 
            bottomprint(%client, "<f1><jc>Waiting for match start.", 0);
      }
      else
      {
         %client.notreadyCount++;
         if(%client.notreadyCount < 4)
         {
            %client.notready = true;
            MessageAll(0, Client::getName(%client) @ " is NOT READY.");
            bottomprint(%client, "<f1><jc>Press FIRE when ready.", 0);
         }
         return;
      }
      Game::CheckTourneyMatchStart();
   }
}

function Observer::jump(%client)
{
   if(%client.observerMode == "observerFly")
   {
      %client.observerMode = "observerOrbit";
      %client.observerTarget = %client;
      Observer::nextObservable(%client);
   }
   else if(%client.observerMode == "observerOrbit")
   {
      %client.observerTarget = "";
      %client.observerMode = "observerFly";

      %camSpawn = Game::pickObserverSpawn(%client);
      Observer::setFlyMode(%client, GameBase::getPosition(%camSpawn), 
	      GameBase::getRotation(%camSpawn), true, true);
   }
}

function Observer::isObserver(%clientId)
{
   return %clientId.observerMode == "observerOrbit" || %clientId.observerMode == "observerFly";
}

function Observer::enterObserverMode(%clientId)
{
   if(%clientId.observerMode == "observerOrbit" || %clientId.observerMode == "observerFly")
      return false;
   Client::clearItemShopping(%clientId);
   %player = Client::getOwnedObject(%clientId);
   if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) {
		playNextAnim(%clientId);
	   Player::kill(%clientId);
	}
   Client::setOwnedObject(%clientId, -1);
   Client::setControlObject(%clientId, Client::getObserverCamera(%clientId));
   %clientId.observerMode = "observerOrbit";
   GameBase::setTeam(%clientId, -1);
   Observer::jump(%clientId);
   remotePlayMode(%clientId);
   return true;
}

function Observer::checkObserved(%client)
{
   // this function loops through all the clients and checks
   // if anyone was observing %client... if so, it updates that
   // observation to reflect the new %client owned object.

   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      if(%cl.observerTarget == %client)
      {
         if(%cl.observerMode == "observerOrbit")
      	   Observer::setOrbitObject(%cl, %client, 5, 5, 5);
         else if(%cl.observerMode == "commander")
   		   Observer::setOrbitObject(%cl, %client, -3, -3, -3);
      }
   }
}

function Observer::setTargetClient(%client, %target)
{
   if(%client.observerMode != "observerOrbit")
      return false;
   %owned = Client::getOwnedObject(%target);
   if(%owned == -1)
      return false;
	Observer::setOrbitObject(%client, %target, 5, 5, 5);
   bottomprint(%client, "<jc>Observing " @ Client::getName(%target), 5);
   %client.observerTarget = %target;
   return true;
}

function Observer::nextObservable(%client)
{
   %lastObserved = %client.observerTarget;
   %nextObserved = Client::getNext(%lastObserved);
   %ct = 128;  // just in case
   while(%ct--)
   {
      if(%nextObserved == -1)
      {
         %nextObserved = Client::getFirst();
         continue;
      }
      %owned = Client::getOwnedObject(%nextObserved);
      if(%nextObserved == %lastObserved && %owned == -1)
      {
         Observer::jump(%client);
         return;
      }
      if(%owned == -1)
      {
         %nextObserved = Client::getNext(%nextObserved);
         continue;
      }
      Observer::setTargetClient(%client, %nextObserved);
      return;
   }
   Observer::jump(%client);
}

function Observer::prevObservable(%client)
{
}

function remoteSCOM(%clientId, %observeId)
{
   if (%observeId != -1)
   {
      if (Client::getTeam(%clientId) == Client::getTeam(%observeId) &&
         (%clientId.observerMode == "" || %clientId.observerMode == "commander") && Client::getGuiMode(%clientId) == $GuiModeCommand)
      {
         Client::limitCommandBandwidth(%clientId, true);
         if(%clientId.observerMode != "commander")
         {
            %clientId.observerMode = "commander";
	         %clientId.lastControlObject = Client::getControlObject(%clientId);
         }
	      Client::setControlObject(%clientId, Client::getObserverCamera(%clientId));
		   Observer::setOrbitObject(%clientId, %observeId, -3, -3, -3);
         %clientId.observerTarget = %observeId;
         Observer::setDamageObject(%clientId, %clientId);
      }
   }
   else
   {
      Client::limitCommandBandwidth(%clientId, false);
      if(%clientId.observerMode == "commander")
      {
         Client::setControlObject(%clientId, %clientId.lastControlObject);
		   %clientId.lastControlObject = "";
         %clientId.observerMode = "";
         %clientId.observerTarget = "";
	   }
   }
}get = "";
	   }
    coz~q<XR}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}`_^]\[ZVQKH00000000000000000000000000000000000000000000000000000?976*'#YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY@J{WNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN4444444444444444444444444444444444444444444444444444444444444444444444444444444444444++++++++++++++++++++++++++++++++++++++++++++UL185 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx%%%%%%%%%%%%%%%%vPPPPPPPFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFllllllllllllllllllllllllllllllllll,wwwwwww%hgCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCGllllllllllllllllllllllllllllll<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<0M:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNjA+=I1-,,,,,,,,,,,,,,,,,,vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFggggggggggggggggggggggw%GPhCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCl                              llllllllllllllllllllll                                                n,"pppppppppppppppppppppppggggggggggggggggggwuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuC%%%%%%%%%%%%l                   eeeeeeeeeeeeeeeehhhhhhh                                         eeeeeeeeeeeeeeeeeeeeeeeeeeeeeenl             ees	
$y
DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD|E2;/kYB@J{Wb&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&333333333333333333333333333333333333>4444444444444444444444444444444444444444444444444444444444444444444444444444444444444}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}UL!888888888888888888888888888888888)<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<0M:1RNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNjA+=,,,,,,,,,,,,,,,,,,,,,,,,,vIF-gGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG5"ppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppwwwwwwwwwwwwwwwwuuuuuuuuuuuuuuuuuuuuuuCCCCCCCCCCCCrrrrrrrrrrrrrrrrrrrrrrrr%%%%%%%%%%%lllllllllllll                   ennnnnnn             hslrrrrrrreeeeeeennnnnnnnnnnnnnnnnnnnnnn                 eeeeeeeeeeg,,,,,,,,,,,,,,,,,,,,,,,,,dPPPPPPPPPPPPPPPPPc""""""""""""""""pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppwuuuuuuuuuuuuuuuuuuuuuuhCollllllllllllnsssssssssssssr                       eeeeeeeeeee               %%%%%%%%lllllllllnooooooooooooooooooooooooooooooeeeeeeeeeeesssssss            eeeeeeerraiTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT(.SO$bf																																	
y


























D)<11111111111111111111111111111111110Mj:RNvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvA+G=IFgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg-Px,cdddddddddddddddddddddddddddddddddddddddddddddddddddddd""""""""""""""""""""""""puuuuuuuuuuuuuuuuuuhw%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lllllllllnoooooooooooooooooooooooooooooooooo                 ees                       raaaaaaaaiiiiiiiiiCollllllllllllnesssssssssssss                     eeeeeeeeeeeeeeeee                                                ggggggggggggggggggggggggggggggggggggggggmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmcd,hhhhhhhhhhhhhhhhhhhhhhh"""""""""""""""""rpuuuuuuuu%%%%%%%%%%%%%%%%%%%%%%%%%%aoiiiiiiiiiiiiCwsllllllllllleeeeeeeeeeeeeeeeennnnnnnnnnnnn                 eeeeeeeeeeeeeeeeetorrrrrrrrrrrrasiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiil                       en                             z~qX`_^]\[ZVQKH?976*'#{{{{{{{{{{{{{{{{{{{{{{{{{{{{ |E2;/kY!@JBW&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&333333333333333333333333333333333333>4444444444444444444444444444444444444444444444444444444444444444444444444444444444444}((((((((((((((((((((((((((((((((((((((((((((UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT.SO$bf1	
y


























D)v<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<0Mj:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNA+G=IIIIIIIIIIIIIIIIIIIIIIIIIPFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF------------------------gggggggggggggggggggggggggmhhhhhhhhhhhhhhcdp,,,,,,,,,,,,,,,,,,,,,,,"CCCCCCCCCCCCCCCCCu%%%%%%%%%%%%%%oooooooooooooooooootsrrrrrrrrrrraaaaaaaaaaaaaiiiiiiiennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn            eeeeeeellllllllllllllloooooooooooooooooootsrrrrrrrrrrraaaaaaaaaaaaain                 eew                                                                                     ccccccccccccccccccccccccgx88888888888888888888888hhhhhhhhhhhhhhmup,dl"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCtorrrrrrrrrrrrasiiiiiiiiiiiew%%%%%%%%%%%%%                     ennnnnnn              tlrrrrrrrrraoiiiiiiiiiiiiiiiiiiiiiiiiiiiiissssssssssseeeeeeennnnnnnnnnnnnnnnnnnnnnn                 ee1(TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTv.SO$bfffffffffffffffffffffffffffffffffffffffffffffffffffffff
y


























D)	PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP0Mj:R<<<<<<<<<<++++++++++++++++++++++++++++++++++++++++=ANGggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggIIIIIIIIIIIIIIcccccccccccccccccccccccccccccccccccccc,,,,,,,,,,,,,,,,,,,,,,,h5FFFFFFFFFFFFFFFFFFFFFFupmmmmmmmmd"twCrrrrrraliiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiionnnnnnnnnnnnnnnnnnnnnnnns                       eeeeeeeeeee               rtaaaaaaaaiiiiii%lnnnnnnnnnnnnnnnnnnnnnoooooooeeeeeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeesssssssssssssssssgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg,chhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhp-duwmmmmmmmmmmmmmmmmmm"rtaaaaaaaaiiiiii%Clnnnnnnnnnnnnnnnnnnnnnooooooooooo                 eeeeeeeeeeeee                       tssssssssrrrrrraliiiiiiiiiiiiiiiiiiiiiiiiioneeeeeeeeeeeeeeeeeeeeeeee                     eeeeeeeeeeeeeeeee                                                                         {{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{|E2;/kY!@JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW&433333333333333333333333333>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>B}f1(TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTxU)v.SO$bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR
y


























DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP0Mj:														=+NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN<A,,,,,,,,,,,,,,,,g5LGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGdhhhhhhhhhhhhhhhccccccccccccccccccp-IIIIIIIIIIIIIIIIIIIIIIItuwwwwwwww%mmmmmmslrrrrrrrrraoiiiiiiiiiiiiiiiiiiiiiiiiiiii"""""""""""eeeeeeeeeeeeeeeeennnnnnnnnnnnn                 eeeeeeeeeeeeeeltttttttttsorrrrrrrrrrrraaaaaaaaaaaiiiiiiiiiiiiiC                       en                        ,,,,,,,,,,,,,,,,ggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggFdhhhhhhhhhhhhhhhhhhhhhhhhh%%%%%%%%%%%%%%%%%%pcccccccccccccccccccccccccccculllllllllllllllllwwwwwwwwwwwwwwwwottttttttttttsssssssssssrrrrrrrrrrrrraaaaaaaeniiiiiii            eeeeeeeCm"lllllllllllllllllllllottttttttttttsssssssssssrrrrrrrrrrrrran                 eei                       bf1(TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTD)v.SO$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR
y


























































88888888888888888888888888888888888888888888888PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP0MjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjN=<+																																																																								,-AhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhgpFGdddddddddddddddddddddddddddddd%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"""""""""""""""""""""""uccccccwCCCCCCCCltttttttttsorrrrrrrrrrrraaaaaaaaaaaeiiiiiiiiiiiii                     ennnnnnn              tmslrrrrrrrrraoiiiiiiiiiiiiiiiiiiiiiieeeeeeennnnnnnnnnnnnnnnnnnnnnn                 eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee,dhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhpIguuuuuuuuuuuuuuuuu%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"twwwwwwwwwwwwwwwwwwwwwwwssssssrmcaliiiiiiiiinoooooooooooooooooooooooo                       eeeeeeeeeee               strrrrrrrraaaaaaiCnllllllllllllllllllllllllllleeeeeeeeeeeooooooo            eeeeeeeeeeeeeeeeeeeeeeeeeeeeez~qXH`_^]\[ZVQK?96*7#'|@                            {{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{42;/kY!ExxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW&J111111111111111111111111111111111111111111111111111111111111111111111B>33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333bf5}vTTTTTTTTTTTTTTTTTTTT($D)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))SO...........................:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRPy

j8UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU<0MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-N========================================+										FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFdddddddddddddddddddddddddddddddddddddd,,,,,,,,,,,,,,,,,,hIAAAAAAAAAAAAAAAAup%gggggggggggggggggggggggggggggggggggggggggwwwwwwwwwwwwwwm"strrrrrrrraaaaaaiCCCCCCCCCCCCCCCCCCCCCCCnlllllllllllllllllllllllllllllll                 eeo                       tttttttttttttttttttssssssrcaliiiiiiiiineooooooooooooo                     eeeeeeeeeeeeeeeee                                                 duuuuuuuuuuuuuuu,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,GGGGGGGGGGGGGGGGhm%gptttttttttttttttttwwwwwwwwCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCc"slrrrrrrrrraoiiiiiiiiiiieeeeeeeeeeeeeeeeennnnnnnnnnnnn                 eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeetllllllllllllllllllllsorrrrrrrrrrraaaaaaaaaaaaai                       en               OOOOOOOOOOOOOOOOOOOOOOOOOOOOOObf1vTTTTTTTTTTTTTTTTTTTT
$D)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))S(MMMMMMMMMMMMMMMMMMMMMMMMMMM:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRPy.FjLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL<0





















=-+NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN,,,,,,,,,,,,,,,,,,,,,,,,,,,I																uuuuuuuuuuuuuuudgggggggggggggggggggggggggGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGCm%hhhhhhpppppppppppppppppppppppppppppppppppppppwwwwwwwwwwwwwwclllllllllllllllltoooooooooooooooooooooosssssssssssssrrrrrrrenaaaaaaa            eeeeeeeiiiiiii"lllllllllllllllltoooooooooooooooooooooosssssssssssssrn                 eea                                     ,,,,,,,,,,,,,,,,,,,,,,,,,,,AAAAAAAAAAAAAAAAuuuuuuuuuuuuuuuuuuuuuu%gggggggggggggggggggggggggdddddddddddddddddddddddCmmmmmmmmmmmmmmmmmmmmmmmmihp"""""""""""""""""wwwwwwwwwwwwwwwwwwwwwwwwwwtllllllllllllllllllllsorrrrrrrrrrreaaaaaaaaaaaaa                     ennnnnnn         itcccccccccccccccccslrrrrrrrrraoooooooooooeeeeeeennnnnnnnnnnnnnnnnnnnnnn                 ee5|@@@@@@@@@@@@@@@@@@@@@@@@@@@@{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{42;/kY!TWx&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&BJ33333333333333333333333333E>SOOOOOOOOOOOOOOOOOOOOOOOOOOOOOObf1v888888888888888888888888888888888888888888888888888888888888y
$D))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))0MMMMMMMMMMMMMMMMMMMMMMMMMMM:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRP(IFjL}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}<..................+==================================-
Nuuuuuuuuuuuuuuu,GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGA																									m%gggggggggggggggggggggg"""""""""""""""""""""""Cdddddddddddddddddddddddddddddddhtwppppppppppppiscccccccccccccccccrrrrrralnnnnnnnnnnnnnnnnnnnnno                       eeeeeeeeeee                          tssssssssriaaaaaaaaaaaaaannnnnnnnnnnnnnnnnnllllllleeeeeeeeeeeeeeeeeeeeeeeee            eeeeeeeoo,uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuummmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmgggggggggg"%CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCwdchhhhhhhhhhhhtssssssssriaaaaaaaaaaaaaapnnnnnnnnnnnnnnnnnnlllllllllll                 eeeeeeeeee                       toooooooooooooooooooisssssssssssssssssrrrrrralneeeeeeeeeeeeeeeeeeeee                     eeeeeeeeeeeeeeeee                                      SOOOOOOOOOOOOOOOOOOOOOOOOOOOOOObf1vPy
$D)))))))))))))))))))))))))))))T<0MMMMMMMMMMMMMMMMMMMMMMMMMMM:RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRGIFjUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU((((((((((((((((((((((((((((((((((((((((((((((((((((((((((+
=.-m,uAN""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""gggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggcCCCCCCCCCCCCCCCCCCCCCC%tttttttttttttttttttttttwwwwwwwwwwwwwwwwwwwwwdiooooooooooooooooohhhhhhhhhhhhhhhhhslrrrrrrrrraaaaaaaaaaaeeeeeeeeeeeeeeeeennnnnnnnnnnnn                 eeiiiiiiiipttttttollllllllllllllllllllsssssssssssrrrrrrrrrrrrra                       en                                m,uuuuuuuuuu""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""ggggggggggggggggggggggggggggcC	i%%%%%%%%%%%%%%%%%%%%%%%pwdddddddddddddddddddddddddddddltttttttttoooooooooooooooooooooooooooooooooosssssssenrrrrrrr            eeeeeeeaaihhhhhhhhhhhhhltttttttttoooooooooooooooooooooooooooooooooosn                 eer                       z~qXH`_^]\[ZVQK?96*Y#'78|@@@@@@@@@@@@@@@@@@@@@@@@@@@@{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{42;/k51 W&xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB333333333333333333333333333333333333EJ!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!SOOOOOOOOOOOOOOOOOOOOOOOOOOOOOObfL>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>Py
$D)vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<0MMMMMMMMMMMMMMMMMMMMMMMMMMM:RTAGIFjUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU,

































.+(=================================mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm-gggggggggg"uCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCppppppppppppppccccccccccccccca	N%hhhhhhhhhhhhhhhhhhhhhhhwddddddddittttttollllllllllllllllllllssssssssssserrrrrrrrrrrrr                     ennnnnnn         atttttttttttttttttoiiiiiiiiiiiiiiiiislrrrrrrrrrrrrrrrrrrreeeeeeennnnnnnnnnnnnnnnnnnnnnn                 ee"""""""""""""""""""""""""""""""""mmmmmmmmmmmmmmmmmmmmmmmmgggggggggg,cCCCCCCCCCCCCCCCCCCCCCCuhppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppptw%oaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasirrrrrrnlllllllllllllllllllll                       eeeeeeeeeee               otttttttttttttttttttsardniiiiiiiiiiiiiiiiiiiiiiiieeeeeeeeeeelllllll            eeeeeeeeeeeeeeeeeeeeeeefffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSyyyyyyyyyyyyyyyyyyyyyyyyyyyyyybO)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))P10$D
RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR<vIIIIIIIIIIIIIIIIIIIIIIIIIII:MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMAGT.j}FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF




















































"+((((((((((((((((((	================================================mcgggggggggggggggggggggg,hCCCCCCCCCCCCCCuuuuuuuuuuuuuuupwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww-otttttttttttttttttttsard%niiiiiiiiiiiiiiiiiiiiiiiiiiii                 eel                       ttttttttttttttttoaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaasirrrrrrnelllllllllllll                     eeeeeeeeeeeeeeeee  cccccccccccccccccc""""""""""""""""""""""""hhhhhhhhhhmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm,gggggggggggggggggggggggggggggguCtpwwwwwwwwdddddddddddddddddddddddddaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaNoiiiiiiiiiiiiiiiiislrrrrrrrrrrreeeeeeeeeeeeeeeeennnnnnnnnnnnn                 eeaaaaaaaa%tiiiiiiiiiiiiiiollllllllllllllllllllllsssssssssssssr                       en               LY8|@@@@@@@@@@@@@@@@@@@@@@@@@@@@{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{42;/kb&WBx333333333333333333333333333333333333333333EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!5JDfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffSyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyUUUUUUUUUUUUUUUUUUUUUUUUUU:)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))P10$O}>RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR<vIIIIIIIIIIIIIIIIIIIIIIIIIII
																																															AGT.jM"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""+
FFFFFFFFFFFFFFFFFFFFmcccccccccccccccccccccccccccccccccccc(,hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuddddddddddddddddddddddddddddddgaCp%wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwiiiiiiiiiiiiitlllllllllllllllllllooooooooooooooooooooooooooooooensssssss            eeeeeeerraN=iiiiiiiiiiiiitllllllllllllllllllloooooooooooooooooooooooon                 ees                                mccccccccccccccccccccccccccccccccccccccc,h""""""""""""""uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu%ddddddddddddddddddddddddddddddddrgC-pwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwatiiiiiiiiiiiiiiollllllllllllllllllllllesssssssssssss                     ennnnnnn         rtttttttttttttttttttttttttttttttaoiiiiiiiiiiiiiiiiisllllllllllleeeeeeennnnnnnnnnnnnnnnnnnnnnn            