//-------------------------------------------------------------------------- 
//-------------------------------------------------------------------------- 

//-------------------------------------------------------------------------- 
// Default sensor methods

function Sensor::onActivate(%this)
{
	if(GameBase::isPowered(%this)) {
		GameBase::playSequence(%this,0,"power");
	}
}

function Sensor::onDeactivate(%this)
{
	GameBase::pauseSequence(%this,0);
}

function Sensor::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
	}
	GameBase::setActive(%this,%power);
}

function Sensor::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.03;				  
		GameBase::setRechargeRate(%this,10);
		GameBase::setActive(%this,true);
	}
}

function Sensor::onDisabled(%this)
{
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Sensor::onDeactivate(%this);
}

function Sensor::onDestroyed(%this)
{
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Sensor::onDeactivate(%this);
	%sensorName = GameBase::getDataName(%this);
	if(%sensorName == DeployableSensorJammer) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableSensorJammerPack"]--;
	else if(%sensorName == DeployableMotionSensor) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "MotionSensorPack"]--;
	else if(%sensorName == DeployablePulseSensor) 
   	$TeamItemCount[GameBase::getTeam(%this) @ "PulseSensorPack"]--;
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100);
}

function Sensor::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
	%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name != DeployableMotionSensor && %name != DeployablePulseSensor && %name != DeployableSensorJammer )				
	  		%TDS = $Server::TeamDamageScale;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
}


//------------------------------------------------------------------------

SensorData PulseSensor
{
   description = "Large Pulse Sensor";
   shapeFile = "radar";
//   explosionId = DebrisExp;
   maxDamage = 1.5;
   range = 600;
   dopplerVelocity = 0;
   castLOS = true;
   supression = false;
	visibleToSensor = true;
	sequenceSound[0] = { "power", SoundSensorPower };
	mapFilter = 4;
	mapIcon = "M_Radar";
	debrisId = flashDebrisLarge;
   shieldShapeName = "shield_medium";
	maxEnergy = 100;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = LargeShockwave;
};


//------------------------------------------------------------------------

SensorData MediumPulseSensor
{
   description = "Medium Pulse Sensor";
   shapeFile = "radar";
//   explosionId = DebrisExp;
   maxDamage = 1.0;
   range = 250;
   dopplerVelocity = 0;
   castLOS = true;
   supression = false;
	visibleToSensor = true;
	sequenceSound[0] = { "power", SoundSensorPower };
	mapFilter = 4;
	mapIcon = "M_Radar";
	debrisId = flashDebrisLarge;
   shieldShapeName = "shield_medium";
	maxEnergy = 100;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
};


//------------------------------------------------------------------------

SensorData DeployableMotionSensor
{
   description = "Motion Sensor";
	className = "DeployableSensor";
	shapeFile = "sensor_small";
	shadowDetailMask = 16;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
//   explosionId = DebrisExp;
	damageLevel = {0.8, 1.0};
	maxDamage = 0.4;
	debrisId = defaultDebrisSmall;
	range = 50;
	dopplerVelocity = 1;
   castLOS = false;
   supression = false;
	supressable = false;
	pinger = false;
	mapFilter = 4;
	mapIcon = "M_motionSensor";
	damageSkinData = "objectDamageSkins";
};


SensorData DeployablePulseSensor
{
	description = "Remote Pulse Sensor";
	className = "DeployableSensor";
	shapeFile = "radar_small";
	shadowDetailMask = 4;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	damageLevel = {0.8, 1.0};
	maxDamage = 1.0;
//   explosionId = DebrisExp;
	debrisId = flashDebrisSmall;
	range = 200;
	castLOS = true;
	supression = false;
	mapFilter = 4;
	mapIcon = "M_Radar";
};


SensorData DeployableSensorJammer
{
	description = "Remote Sensor Jammer";
	className = "DeployableSensor";
	shapeFile = "sensor_jammer";
	shadowDetailMask = 4;
	visibleToSensor = true;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	damageLevel = {0.8, 1.0};
	maxDamage = 0.5;
//	explosionId = DebrisExp;
	debrisId = defaultDebrisSmall;
	range = 80;
	castLOS = true;
	supression = true;
	mapFilter = 4;
	mapIcon = "M_sensorJammer";
};



function DeployableSensor::onAdd(%this)
{
	schedule("DeployableSensor::deploy(" @ %this @ ");",1,%this);
}

function DeployableSensor::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableSensor::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
	GameBase::playSequence(%this,0,"power");
}

//------------------------------------------------------------------------


pp`ggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg$a,%tBaj"ӻc0a!Ũ%AAAAAA<@*oPrsӻc0mdaableMotionSensor && %name != DeployablePulseSensor ppppppppppppqxbo.ppapapapam";
	maxEnergy = 100;
	damageSkinDa􋉉0.is,0,"power");
}

%wzv------lmv------lggggggggggggggggggggggggggggggggggggggggggg$apapamv------l\ageSkۺ$apapa5555eMotpapaunctioGctioGctioGctioGctioG.ZUpQYXaMKKKKKKKKKKKKKKKKKKKKKaKKKKKKKMotionSensor
{
   description = "Motion Sennnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn>onnnnn.ZUW?,i-----____________9999---lƴJZU5nnnn>onnnnn.ZUW?,iorh+'mor && e = "DeployableSensor";
	shap^#H0t$mv------l\ageSkdttionSensor
{
   description = "Motio1quence(%this,0,"power");
}

//--//'mor &e%.Vmor &e%.Vmk~e%|mmmapFilter = 4;
	mapIquenrI= ccddddddddddddddddddd2vDpcccccccccccccccccccccccccddilxLwwwwwwwwwwwwwwwwwwwwwwwwww1111111111111111111111111111111EbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbmrIPPPPPPPPPPPPPPPPPPPPPPPPPPR222222222222222222222222222222222222222_DT5pppppppppppppppppppppppppccilmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrdvvvvvvvvvvvvvvvvvvvvvvvvvppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppphD	cilmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrdaaaaaaaaaaaaaaaaaaav1111111aaaaaaaipmcccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccllllllllllllllllllllllllllllllllllllllllllllllllllllrddddddaaaaaaaaaaaaaaaaaaaooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooou}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}f)M%"{BBBBBBBBBBBBBBBBBBBBBBBJq4[@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG&&&&&&&&&&&&&&&&&&&&&&&&666666666666666666666666666666666666666666666666666666666666666666666!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!8VEEEEEEEEEEEEEEEEEEE(k$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$**************************************************************************************2xLwwwwwwwwwwwwwwwwwwwwwwwwwwwwww3bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb..........................IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIPDTRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiimvhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhpppppppppppppppppppppppppppppppppppppppp;_	cdllllllllllllaaaaaaaarrrrrrrrrrrrrrrrrimooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo1tdpaaaaaaaaaaaaarclllllleaaaaaaaaaaaaaaaaaaaD%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"u.5SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSmmmmmmmmmmmvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvi1hodddddddddrtlppppppeeeeeeeaaaaaaaacccccccccccceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee	mdirolllllllllaaaaaaacttttttttttttttttteaaaaaaaaaaaaapps::::::::::::::::::::::::::::=y/EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEf$)))))))))))))))))))(2kMMMMMMMMMMMMMMMMMMMMMMMMMMMM
xLLLLLLLLLLLLLLLLLLLLLLLLLLw
bTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII7PRRRRRRRRRRRRRRRRRRRRRR%nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnDuuuuuuuuuuuu555555555555555555"""""""""""""""""...........S11111111111111111111111111111111111111111111111111111111111111111111111111	vmdirolllllllllcccccceaaaaaaaaaaaaaaaaaaatttttteeeeeeeaassssssssssssssssssssssssssssssssssssssssssssssssssssssssssssspm ihodddddddddrrrrrrrtlllllllllllleeeeeeaaaaaaaccccccccccccccccccccccccccccccccccccccccccccccc,0%_nDuuuuuuuuuuuuuuuuuuuuuu"""""""""""""""""	.S11111111111111111111111111111111111111111111111111111111111111111111msipo         hhhhhhhhhhhhhhtdeeeeeaaaaaaaaaaaaacrlllllleeeeeaaaaaaaaaaaaaaaaaaammmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmiiiiiiiiossssssssspt cvlddddddeeeeeeeeeeeaaaaaaaarrrrrreeeeeeeeeeeeeeeO`ýFӻʬŨ<􋉉僂z\맺CNZUQYXˇK>W?9ڴ+'^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{j------------------------------A#H~~~~~~~~~~~~~~~~~~~~~~~~| }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}BBBBBBBBBBBBBBBBBBBBBBBJq4444444444444444444444444444444444444444@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG&[666666666666666666666666666666666666666666666666666666666666666666666!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!8888888888888888888888888gggggggggggggggggggggggggggggggggggggggggggggg********************************************************************************************************************************************************************VMMMMMMMMMMMMMMMMMMMMMMMMMMMM=y/EEEEEEEEEEEEEEEEEEEEEEEEEEEEE:
$)))))))))))))))))))(2kfRRRRRRRRRRRRRRRR
xLLLLLLLLLLLLLLLLLLLLLLLLLLwwwwwwwwwwwww0IT7333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD,5P"______________________n%SSSSSSSSSSSSSSSSSSSSSSummmmmmmmmmmmmmmmm	ih.ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooootscpl aaaaaaarv111111111111eeeeeeaaaaaaadddddddddddddddddoiiiiiiiiimtttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttcccccccclsrpeeeeeaaaaaaaaaaaaad                   eeeeeaaaaaaaaaaaaaaaaaaanDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD,,,,,,,,,,,,""""""""""""""""""0hSSSSSSSSSSS%ouuuuuuuuuuuuuuuuuuuuuuuuuv	ticmlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllrrrrrrrrdssssssssssssss.ppppppeeeeeeeeeeeaaaaaaaa      eeeeeeeeeeeeeeetttttttttcolirmddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd11111111aaaaaaa sssssssssssseeeeeeaaaaaaapppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppgggggggggggggggggggggggggggggggggggggkMMMMMMMMMMMMMMMMMMMMMMMMMMMM=y/EEEEEEEEEEw
$)))))))))))))))))))(2:5RRRRRRRRRRRRRRRR
xLLLLLLLLLLLLLLLLLLLLLLLLLLfffffffffffffffffffffffffffffff;IbTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTP_Dnnnnnnnnnnnnnnnnnnnnnn",vhS0t%ucccccccccccccccccccccccccccccclllllllllrodi1	m                                                             eeeeeaaaaaaaaaaaaappppppppsssssseeeeeaaaaaaaaaaaaaaaaaaalcrtddddddddd.o ipmsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeee""""""""""""""""""""""""""""""""""""""""""""""""""""DSSSSSSSSSSSSSSSSSSSSSSnnnnnnnnnnnnnnvh,l0%r1udc.................t         posiaaaaaaaaaaaaaammmmmmmmmmmmeeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaadr	l cptssssssssssssssssoeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaimmmmmmeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaA{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{j-}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}BBBBBBBBBBBBBBBBBBBBBBBJqgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggG@]&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666[444444444444444444444EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE!8*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV2kMMMMMMMMMMMMMMMMMMMMMMMMMMMM=y//////////////////////////////////////////////////////////////w
$)))))))))))))))))))(((((((((((((((((((((((((((5RRRRRRRRRRRRRRRR
xL::::::::::::::::::::::;IbTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTffffffffffff""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""PhSSSSSSSSSSSD11111111111111vnd,0	%u. rplscccccccctttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttmooooooeeeeeeeeeeeaaaaaaaaiiiiiieeeeeeeeeeeeeee dpppppppppppppppppsrrrrrrrrlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllcmtaaaaaaaiiiiiiiiiiiiiiiiiiiieeeeeeaaaaaaaoooooooooooooooooooooooooooooooooooooo"""""""""""""""""""""""""""""""vhS_	11111111111111D n,pu0sdddddddddddddddddddddddd%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rmliceeeeeaaaaaaaaaaaaaotttttttttttttteeeeeaaaaaaaaaaaaaaaaaaaspppppppp                                                             dm.irolllllllllcccccceeeeeeeeeeeaaaaaaaatttttteeeeeeeeeeeeeee/EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE(2kMMMMMMMMMMMMMMMMMMMMMMMMMMMM=ygLLLLLLLLLLLLLLLLLLLLLLLLLLw
$))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))5RRRRRRRRRRRRRRRR
xxxxxxxxxx"IIIIIIIIIIIIIIIIIIIIIIT3:bSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSvhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhu	1_fsDnnnnnnnnnnnnnnnnnnnnnnnn,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,pm ido.000000000raaaaaaatlllllllllllleeeeeeaaaaaaaccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccmsipo         dt%eeeeeaaaaaaaaaaaaacrlllllleeeeeaaaaaaaaaaaaaaaaaaahSSSSSSSSSSSSSSSSSSSSSS11111111111111v"""""""""""""""""u																																																																																											PDm.niiiiiiiiossssssssspt cdl%,,,,,,eeeeeeeeeeeaaaaaaaarrrrrreeeeeeeeeeeeeeeimooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooootscpl aaaaaaarddddddddddddeeeeeeaaaaaaa00000000000000000O`ýFӻʬŨ<􋉉襥僂z\CNZUQYXˇK­W?9ڴ+'>#Hɢ~ ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||^A{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{j-}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}BBBBBBBBBBBBBBBBBBBBBBBJ7GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG&@6]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]444444444444444444444444444444444444444444444q[yVVVVVVVVVVVVVVVVVVVVV!888888888888888888888888888888888888888888888888888888*****************************************************************/E;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;(2kMMMMMMMMMMMMMMMMMMMMMMMMMMMM=========================xLLLLLLLLLLLLLLLLLLLLLLLLLLw
$)ggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg5RRRRRRRRRRRRRRRR














































TI:::::::::::::::::::::::::::::::333333333333333333333333333vhS_b	1111111111111111111111111.................u"iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiPPPPPPPPPPPPPo%DDDDDDDDDmtttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttcccccccclsrpeeeeeaaaaaaaaaaaaa0n ddddddeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaoticmlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllrrrrrrrr,sdppppppeeeeeeeeeeeaaaaaaaa      eeeeeeeeeeeeeeeeeeeeeeeeeeeevhSu	11111111111%...................................."""""""""""""""""""""""""""""""t0fcolirm,DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDddddddddaaaaaaa sssssssssssseeeeeeaaaaaaapppppppppppppppppctlllllllllronidm                                                             eeeeeaaaaaaaaaaaaappppppppsssssseeeeeaaaaaaaaaaaaaaaaaaa=y/E)))))))))))))))))))(2kMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
xLLLLLLLLLLLLLLLLLLLLLLLLLLw
$$$$$$$$$$$$$$$$$$$$$$$$$_________________________________________________________________________________________5RRRRRRRRRRRRRRRRgh:TTTTTTTTTTIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII11111111111111vPu	S0%...........cccccccccccc"l,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,rtnfbbbbbbbbbdo ipmsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssseeeeeeeeeeeaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeerlDcdt         posiaaaaaaaaaaaaaammmmmmmmmmmmeeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa	11111111111111v.................uh,0%SrrrrrrrrrrrrrrrrrrrrrrD"""""""""""""""""""""""""""""""ndl cptssssssssssssssssoeeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaimmmmmmeeeeeaaaaaaaaaaaaaaaaaaadr             plscccccccctttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttmooooooeeeeeeeeeeeaaaaaaaaiiiiiieeeeeeeeeeeeeeeVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVA{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{j-}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}BBBBBBBBBBBBBBBBBBBBBBBJ/G&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666@4]qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq[[[[[[[[[[[[[[[[[[[[[!;8********************=y3333333333333333333333333333333333333333333333$)))))))))))))))))))(2kMEEEEEEEEEEEEEEEE
xLLLLLLLLLLLLLLLLLLLLLLLLLLw




























P_________________________________________________________________________________________5RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR:::::::::::::::::::::::::::::::::::::TgIu	1ffffffffffffffffffffff%.................vD,0hdSSSSSSSSSSS                                          prsssssssssssss""""""""lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllcmtaaaaaaaiiiiiiiiiiiiiiiiiiiieeeeeeaaaaaaaooooooooooooooooop sddddddddrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrnmliceeeeeaaaaaaaaaaaaaotttttttttttttteeeeeaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaau	10%............................................D,vphSsbbbbbbbbbbbbbbbbbb                                                             dmrinnnnnnnnnnnnolllllllllcccccceeeeeeeeeeeaaaaaaaatttttteeeeeeeeeeeeeeeeeeeeeessssssssssssssssssssssssssssssssssssssssssssssssssssssssssssspm idorrrrrrrrr"aaaaaaatlllllllllllleeeeeeaaaaaaacccccccccccccccccMMMMMMMMMMMMMMMMMMMMMMMMMMMM=y
$)))))))))))))))))))(2k/RRRRRRRRRRRRRRRR
xLLLLLLLLLLLLLLLLLLLLLLLLLLwEfP_________________________________________________________________________________________55555555555555555555555555555																																														g:::::::::::::::::::::::::T.................uuuuuuuuuuuuuI,0%1bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbDDDDDDDDDDDDDDDDDDDDDvhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhnSmsipo         dtreeeeeaaaaaaaaaaaaac"""""""""""lllllleeeeeaaaaaaaaaaaaaaaaaaammmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmiiiiiiiiossssssssspt cdlrrrrrreeeeeeeeeeeaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeee%.................uD,0	nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn1mmmmmmmmmmmmmmvi"hooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooootscpl aaaaaaaaaaaaaaaaaaSddddddddddddeeeeeeaaaaaaarrrrrrrrrrrrrrrrroiiiiiiiiimtttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttcccccccclssssssssssspeeeeeaaaaaaaaaaaaar ddddddeeeeeaaaaaaaaaaaaaaaaaaaO`ýFӻʬŦ<􋉉僂z\'CNZUQYXˇK7W?9ڴ+#H ~|^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^>A{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{j-}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}BV=&6GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG4444444444444444444444444444444444444444q@]JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJk;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;[[[[[[[[[[[[[[[[[[[[[3!8*MMMMMMMMMMMMMMMMMMMMMMMMMMMMw
$)))))))))))))))))))(2y5RRRRRRRRRRRRRRRR
xLLLLLLLLLLLLLLLLLLLLLLLLLL/////////////fP_________________________________________________________________________________________EEEEEEEEEEEEEEEEEgggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg:0%.bTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTD,u"nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnI	o111111111111111111111111111111111vticmlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllhhhhhhhhrsdppppppeeeeeeeeeeeaaaaaaaa      eeeeeeeeeeeeeeetttttttttcoliSmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrddddddddaaaaaaa sssssssssssseeeeeeaaaaaaappppppppppppppppp,0%....................................................DDDDDDDDDDDDDDDDDDDDDDDDDDDD"nut	1cccccccccccccccccccccccclllllllllSvoridm                                                             eeeeeaaaaaaaaaaaaappppppppsssssseeeeeaaaaaaaaaaaaaaaaaaalchtrrrrrrrrrdo ipmssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssee