function Generator::deployShape(%player,%item)
{
	%team = GameBase::getTeam(%player);
	%client = Player::getClient(%player);

	if($TeamItemCount[%team @ %item] >= $TeamItemMax[%item] && !$build)
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %descr);
		return false;
	}
	if(!GameBase::getLOSInfo(%player,5)) 
	{
		Client::sendMessage(%client,0,"Deploy position out of range");
		return false;
	}
	%obj = getObjectType($los::object);
	if(%obj != "SimTerrain" && %obj != "InteriorShape") 
	{
		Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		return false;
	}

// check if object is in motion, for dropships and jail cell -plasmatic
	%obj = $los::object;
	if(%obj.inmotion == true)	 
	{ 
		Client::sendMessage(%client,0,"Deploy area crappy, cannot deploy.");
		return false;
	}
		
	
	if(Vector::dot($los::normal,"0 0 1") <= 0.7)
	{
		Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
		return false;
	}
	if(!checkDeployArea(%client,$los::position)) 
	{
		Client::sendMessage(%client,0,"Cannot deploy here");
		return false;
	}
	
	%obj = newObject("Portable Generator","StaticShape","PortableGenerator",true);
	NukeList(%obj);
	if($debug) Echo($Ver,"|Created New Object :",%obj," ","Portable Generator");

	//GameBase::playSequence(%obj,1,"deploy");
	//GameBase::SetActive(%obj,false);
	
	//Generator::CreateSimGroup(%team);
	//addToSet("MissionCleanup/Powered"@%team,%group);
	
	GameBase::setTeam(%obj,%team);
	//addToSet("MissionCleanup", %obj);
	
	GameBase::setPosition(%obj,$los::position);
	GameBase::setRotation(%obj,GameBase::getRotation(%player));
	Gamebase::setMapName(%obj,"Portable Generator");
	Client::sendMessage(%client,0,"Portable Generator deployed");
	
	// Attempt to connect to other nearby generators
	%set = newObject("set",SimSet);
	%pos = GameBase::getPosition(%obj);
	%num = containerBoxFillSet(%set,$StaticObjectType,%pos,200,200,200,100);
	echo("Number of Objects Found = " @ %num);
	if(%num > 0)
	{
		echo("Scanning " @ %num @ " items");
		for( %i = 0; %i < %num; %i++ )
		{
			%target = Group::getObject(%set,%i);
			if(%obj != %target)
			{
				%targetTeam = GameBase::getTeam(%target);
				%name = GameBase::getDataName(%target);
				echo("name = " @ %name);
				if(%team == %targetTeam)
				{
					if(%name.className == Generator)
					{
						%group = getGroup(%target);
						echo("Found Generator : Group " @ %group @ " Placing Unit in Group");
						addToSet(%group,%obj);
						%gen = true;
						break;
					}
				}
			}
		}
		
	}
	if(!%gen)
	{
		echo("Creating new power grid");
		%group = Generator::CreateSimGroup(%team);
		addToSet(%group,%obj);
		echo("rescanning local area for objects in need of power");
		echo("Scanning " @ %num @ " items");
		for( %i = 0; %i < %num; %i++ )
		{
			%target = Group::getObject(%set,%i);
			if(%obj != %target)
			{
				%targetTeam = GameBase::getTeam(%target);
				%name = GameBase::getDataName(%target);
				echo("name = " @ %name);
				if(%team == %targetTeam)
				{
					if(%name.className == "MobileStation")
					{
						%targetGroup = getGroup(%target);
						if(GameBase::getDataName(%targetGroup) == "MissionCleanup")
						{
							echo("Found Station, Placing Unit in Gen Group");
							addToSet(%group,%target);
						}
					}
				}
			}
		}
		
		//%group = Generator::CreateSimGroup(%team);
		//addToSet(%group, %obj);
	}
	deleteObject(%set);

	playSound(SoundCreateItem,$los::position);
	$TeamItemCount[%team @ %item]++;
	return true;
}

function Generator::CreateSimGroup(%team)
{
	%teleset = nameToID("MissionCleanup/PoweredA"@%team);
	if(%teleset == -1)
	{	
		%group = newObject("PoweredA"@%team,SimGroup);
		addToSet("MissionCleanup",%group);
		return %group;
	}
	%teleset = nameToID("MissionCleanup/PoweredB"@%team);
	if(%teleset == -1)
	{	
		%group = newObject("PoweredB"@%team,SimGroup);
		addToSet("MissionCleanup",%group);
		return %group;
	}
	%teleset = nameToID("MissionCleanup/PoweredC"@%team);
	if(%teleset == -1)
	{	
		%group = newObject("PoweredC"@%team,SimGroup);
		addToSet("MissionCleanup",%group);
		return %group;
	}
	%teleset = nameToID("MissionCleanup/PoweredD"@%team);
	if(%teleset == -1)
	{	
		%group = newObject("PoweredD"@%team,SimGroup);
		addToSet("MissionCleanup",%group);
		return %group;
	}
}

function Station::FindPower(%obj)
{
	%set = newObject("set",SimSet);
	%pos = GameBase::getPosition(%obj);
	%team = GameBase::getTeam(%obj);
	%num = containerBoxFillSet(%set,$StaticObjectType,%pos,200,200,200,100);
	echo("Number of Objects Found = " @ %num);
	if(%num > 0)
	{
		echo("Scanning " @ %num @ " items");
		for( %i = 0; %i < %num; %i++ )
		{
			%target = Group::getObject(%set,%i);
			%targetTeam = GameBase::getTeam(%target);
			%name = GameBase::getDataName(%target);
			echo("name = " @ %name);
			if(%team == %targetTeam)
			{
				if(%name.className == Generator)
				{
					if(GameBase::getDamageState(%target) == "Enabled")
					{
						Client::sendMessage(%client,1,"Main Power connection found..connecting");
						%group = getGroup(%target);
						echo("Found Generator : Group " @ %group @ " Placing Unit in Group");
						addToSet(%group,%obj);
						%damaged = false;
						%gen = true;
						break;
					}
					else
					{
						echo("Found Damaged Generator, Attempting to Route to Working Gen");
						%damaged = true;
						%targetDamaged = %target;
					}
				}
			}
		}
		if(%damaged)
		{
			%name =	GameBase::getDataName(%targetDamaged);
			echo("name = " @ %name);
			echo("No Working Gens Found, Routing to Damaged Gen");
			%group = getGroup(%targetDamaged);
			echo("Found Generator : Group " @ %group @ " Placing Unit in Group");
			addToSet(%group,%obj);
			%gen = true;
		}
		
	}
	deleteObject(%set);
	if(!%gen)
	{
		echo("no nearby gens, adding to generic power grid, will wait for port gen");
		addToSet("MissionCleanup",%obj);
	}

}



function ConnectGenerator(%this,%client)
{	
	if($TracePwr) 
		echo("Connect this ",%this," Generator to Power Grid (Client = ",%client,")");
	if(%this.isBusy)
		return;
	%name=GameBase::GetMapName(%this);
	if(!%name)
		%name=GameBase::GetDataName(%this);

	if(GameBase::getDamageState(%this)!="Enabled")
	{	
		echo("Backup Generator ",%this," is disabled!!");
		TeamMessages(0,%team,%name@" DIS-ABLED Unable to come ON Line..."); //~wAAODSFX50.wav
		return;
	}

	%range = %this.pRange;
	ItemBusy(%this);
	%team = GameBase::getTeam(%this);
	echo("Connecting Generator for Team ",%team);
	echo("Connecting Generator for Client ", %client); //$User[%client]);
	
	if(%this.pset)
	{	
		// Generator has a powerset....refresh it
		%pset=%this.pset;
		if($tracePwr) 
			echo("Generator ",%this," has a power set (",%pset,") ....Refreshing");
	}
	else	// Generator does not have a powerset Create one & refresh it
	{	
		%pset=MakePowerSet(%this);
		%this.powerset=getGroup(%this);
		removeFromSet(%this.powerset,%this);
		addtoSet(%pset,%this);
		%this.pset=%pset;
	}
	// Scan for Items to Power
	%set = newObject("set",SimSet);
	%pos =	GameBase::getPosition(%this);
	%tnum = containerBoxFillSet(%set,$StaticObjectType | $StaticShapeType ,%pos,%range,%range,%range,0);
	%td=0;
	if(%tnum>0)
	{	
		// There are Items within scan range
		if($tracePwr) 
			echo($Ver,"| Generator Checking ",%tnum," items");
		for(%i=0;%i<%tnum;%i++)
		{	
			%tgt=Group::getObject(%set,%i);
			%tgtTeam=GameBase::getTeam(%tgt);
			if(PowerReq(%tgt))							// Does Item Require Power then check otherwise don't Bother
			{	
				if(%team==%tgtTeam)						// Is it of the Same Team
				{	
					if(!GameBase::isPowered(%tgt))				// Has NO Power so Connect to it!
					{	
						%td+=3;						// Time to hookup = 3 Sec
						if(%tgt.powerSet=="")				// This Item has Not Been previously Connected to a Portable Generator
						{	
							%tgt.powerSet=getGroup(%tgt);		// If it Had Power Remeber where it Was from
						}
						if($tracePwr) 
							echo($Ver,"|Item Has No Power - Removing from Old group ",%tgt.powerSet," adding to ",%pset);
						schedule("PowerSet("@%this@","@%tgt@");",%td);
					}
				}
			}			
		}
	}
	deleteObject(%set);
	schedule("ItemNotBusy("@%this@");",%td);
	if(%td==0)
	{	
		if(%client)
			Client::SendMessage(%client,1,"Unable to connect to any Unpowered Items\nOn Standby");
		return (false);
	}
	else
		TeamMessages(0,%team,%name@" coming ON Line..."); //~wAAODSFX50.wav
	return (true);
}

function DisconnectGenerator(%this)	
{	if($TracePwr) 
		echo("Disconnecting this ",%this," Generator from Power Grid");
	//	Use when Packing up a Power Generator
	//	& End of Mission 
	//	Unhooks everything
	ItemBusy(%this);
	%pset=%this.pset;
	%name=GameBase::GetMapName(%this);
	if(!%name)
		%name=GameBase::GetDataName(%this);
	%team = GameBase::getTeam(%this);
	%tnum = Group::objectCount(%pset);
	TeamMessages(1,%team,%name@" Going OFF Line..."); //~wAAODSFX50.wav
	%td=0;
	if(%tnum>0)
	{	for(%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject(%pset,0);
			%td+=2;
			schedule("PowerReset("@%this@","@%tgt@");",%td);
		}
	}
	%td+=1;
	schedule("deleteObject("@%pset@");",%td);
	schedule("ItemNotBusy("@%this@");",%td,%this);
	return (%td);
}


function PowerReq(%this)
{	
	%name=GameBase::GetDataName(%this);
	if(%this.powerReq==1) 
		return true;
	else if(%this.powerReq==false) 
		return false;
	else if(%name.classname == "Turret" || %name.classname == "Station" || %name=="PulseSensor" )
		return (true);
	else
		return (false);
}

function RecheckGrid(%this)
{	if($TracePwr) echo("RE-Connect this ",%this," Generator to Power Grid ");
	// Call When Main Power Source has come back online after a failure
	%mset=getGroup(%this);
	%team=GameBase::getTeam(%this);
	//echo ("Team Gen Set: ", $GenSet[%team]);
	%tnum = Group::objectCount($GenSet[%team]);
	//echo ("Team Gen Set Object Count ", %tnum);
	if($tracePwr) 
		echo($ver,"| Main Gen ",%this," Back on line .. re-routing power from ",%tnum," alternate Generators for Team ",%team);
	if(%tnum>0)
	{	for(%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject($GenSet[%team],%i);
			%num = Group::objectCount(%tgt.pset);
			if(%num>1)	// If it has more than one object the unit is powering something
			{	for(%j=0;%j<%num;%j++)
				{	%tgt2=Group::getObject(%tgt.pset,%j);
					if(%tgt2.powerset==%mset)	// Object belong in the Power Set for %this which was just restored
					{	removeFromSet(%tgt.pset,%tgt2);
						addToSet(%mset,%tgt2);
						%j--;
						%num--;
					}
				}
			}
		}
	}
}

function EngageBackupPower(%this)
{	if($tracePwr) 
		echo("Engage Backup Power for this ",%this," Generator (It has Been Destroyed or Disabled)");
	%NumFF=0;
	// Call When Main Power has Experienced a failure
	// Check Main Generator Group... If Multiple generators Then Dont Engage Backup
	%Mainset=getGroup(%this);
	%MainNum = Group::objectCount(%MainSet);
	if($tracePwr) 
		echo("Generator Group = ",%MainSet," Number of Items in Group ",%MainNum);
	for(%i=0;%i<%MainNum;%i++)
	{	%tgt=Group::getObject(%MainSet,%i);
		%name = GameBase::getDataName(%tgt);
		%type = GetObjectType(%tgt);
		// if(%name=="" && %type == SimGroup) %name="DoorGroup";
		if($tracePwr) echo("Checking Item ",%tgt," Item is: ",%Name," Class = ",%name.className," type ",%type);
		if(%name == "Generator" || %name == "SolarPanel" || %name == "PortGenerator")
		{	%result=GameBase::getDamageState(%tgt);
			if(%result==Enabled) %NotReq=True;
		}
		else if(%name=="DoorGroup" || %name.classname == "ForceDoor" || %name.classname == "Door" || %name.classname == "ForceField")
		{	if($TracePwr) 
				echo("Re-Routing ForceField Power for ",%name," Id# ",%tgt);
			%ForceField[%NumFF]=%tgt;
			%NumFF++;
		}
		if(%NotReq==true) 
			%i=%MainNum;
	}

	if(%NotReq) return;
	%team=GameBase::getTeam(%this);
	%tnum = Group::objectCount($GenSet[%team]);
	if($tracePwr) echo($ver,"| Main Gen ",%this," FAILURE .. ",%tnum," alternate Generators re-checking Grid ",%team);
	%td=0;
	if(%tnum>0)
	{	for(%i=0;%i<%tnum;%i++)
		{	%td+=2;
			%tgt=Group::getObject($GenSet[%team],%i);
			// ForceField Reconnect Routine
			// First Active Generator Gets the ForceFields
			%result=GameBase::getDamageState(%tgt);
			if(GameBase::getDamageState(%tgt) == "Enabled")
			{	for(%j=0;%j<%NumFF;%j++)
				{	%ff=%ForceField[%j];
					%ff.powerSet=getGroup(%ff); // Remember where it Was from
					PowerSet(%tgt,%ff);
					//schedule("PowerSet("@%tgt@","@%ff@");",5,%ff);
					if($tracePwr) 
						echo($ver,"| Routing Power for ",%ff," Forcefield to ",GetGroup(%tgt));
				}
			}
			schedule("ConnectGenerator("@%tgt@", false);",%td);
		}
	}
}

function MakePowerSet(%this)
{	%SetName ="PG"@%this;
	%pset= newObject(%SetName,SimGroup);
	addToSet("MissionCleanup", %pset);
	if($tracePwr) echo("Created NEW power set (",%pset,") for Generator ",%this);
	return(%pset);
}

function Powerset(%gen,%object)
{	%gname=GameBase::GetMapName(%gen);
	if(!%gname)
		%gname=GameBase::GetDataName(%gen);
	%pset=%gen.pset;
	%mname = GameBase::getMapName(%object);
	if(%mname=="")
		%mname = GameBase::getDataName(%object);
	%team=GameBase::getTeam(%gen);
	TeamMessages(0,%team,"Power for "@%mname@" routed to :"@%gname@""); //~wAAODSFX52.wav
	%OldSet=getGroup(%object);
	RemoveFromSet(%OldSet,%object);
	%res=AddToSet(%pset,%object);
	if($tracePwr) echo("Power for "@%object@" routed to power group "@%pset@" generator "@%gen@" for Team ",%team);
}

function Powerreset(%gen,%object)
{	%gname=GameBase::GetMapName(%gen);
	if(!%gname)
		%gname=GameBase::GetDataName(%gen);
	%pset=%gen.pset;
	%mname = GameBase::getMapName(%object);
	if(%mname=="")
		%mname = GameBase::getDataName(%object);
	%team=GameBase::getTeam(%gen);
	if(%object.powerReq!=2)
		TeamMessages(0,%team,"Power for "@%mname@" disconnected from "@%gname@"");
	removeFromSet(%pset,%object);
	%res=addToSet(%object.powerSet,%object);
	if($tracePwr) echo("Power for ",%object," set to orignal group ",%object.powerSet," from  generator ",%gen," for Team ",%team);
}

function PowerItem(%this,%range,%client)
{	if($TracePwr) echo($ver,"|Looking for POWER for ",%this," in a ",%range," meter area");
	//** Search Area within specified range
	//** If a Main Generator exists Draw power from that
	//** If a portable generator exists Place %this into the power set for it..
	%numGen=0;
	%team = GameBase::getTeam(%this);
	%set = newObject("set",SimSet);
	%pos =	GameBase::getPosition(%this);
	%tnum = containerBoxFillSet(%set, $StaticObjectType ,%pos,%range,%range,%range,0);
	echo(" Number of Objects Found = ",%tnum);
	if(%tnum>0)
	{	// There are Items within scan range
		if($trace) echo($Ver,"|Scanning ",%tnum," items");
		for(%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject(%set,%i);
			%tgtTeam=GameBase::getTeam(%tgt);
			%name = GameBase::getDataName(%tgt);
			if(%team==%tgtTeam)	
			{	if(%name == "Generator" || %name == "SolarPanel" || %name == "PortGenerator")
				{	%nset=getGroup(%tgt);
					if(GameBase::getDamageState(%tgt) == "Enabled")
					{	Client::sendMessage(%client,1,"Main Power connection found..connecting"); //~wAAODSFX16.wav
						if($tracePwr) echo($Ver,"| Found MAIN Generator : Group ",%nset," Placing Unit in Group");
						// %power=true;
						if(%nset)
						{	addToSet(%nset,%this);
							%this.powerset=%nset;
							%i=%tnum;
						}
						%numGen++;
					}
					else if(%nset) %this.powerset=%nset;	// Route Main Connection to Main Power Group...

				}
				else if(%name == "MobileGen" || %name == "PortableSolar" || %name == "PowerNode")
				{	if($tracePwr) echo($Ver,"|Found an alternate Power Source.. if needed ",%tgt);
					%Pgen=%tgt;
				}
			}
		}
	}
	deleteObject(%set);
	if(%numGen==0) // If there are No Main Generators to connect to... then
	{	if(%Pgen) // If there is a portable Power Source connect to it
		{	if($trace) echo($Ver,"|Found a Secondary power Generator ",%PGen," Connecting to it");
			Client::sendMessage(%client,1,"Secondary Power connection found..connecting");
			%result=GameBase::getDamageState(%Pgen);	// Check state of Generator
			%nset=getGroup(%Pgen);
			if(%nset)
				addToSet(%nset,%this);
			//if(%result==Enabled)
				// %power=true;
			//else
				// %power=false;
			// GameBase::virtual(%this,"onPower",%power,%Pgen);
			return (true);
		}
		else
		{	Client::sendMessage(%client,1,"Unable to obtain Power!! Too far from any power generators!!~Werror_message.wav");
			return (false);
		}
	}
	return (true);
}

function ItemBusy(%this)
{	%this.isbusy=true;
}

function ItemNotBusy(%this)
{	%this.isbusy=false;
}
