exec("comchat.cs");
$SensorNetworkEnabled = true;

$GuiModePlay = 1;
$GuiModeCommand = 2;
$GuiModeVictory = 3;
$GuiModeInventory = 4;
$GuiModeObjectives = 5;
$GuiModeLobby = 6;


//  Global Variables

//---------------------------------------------------------------------------------
// Energy each team is given at beginning of game
//---------------------------------------------------------------------------------
$DefaultTeamEnergy = "Infinite";

//---------------------------------------------------------------------------------
// Team Energy variables
//---------------------------------------------------------------------------------
$TeamEnergy[-1] = $DefaultTeamEnergy; 
$TeamEnergy[0]  = $DefaultTeamEnergy; 
$TeamEnergy[1]  = $DefaultTeamEnergy; 
$TeamEnergy[2]  = $DefaultTeamEnergy; 
$TeamEnergy[3]  = $DefaultTeamEnergy; 
$TeamEnergy[4]  = $DefaultTeamEnergy; 
$TeamEnergy[5]  = $DefaultTeamEnergy; 
$TeamEnergy[6]  = $DefaultTeamEnergy; 				
$TeamEnergy[7]  = $DefaultTeamEnergy; 

//---------------------------------------------------------------------------------
// Time in sec player must wait before he can throw a Grenade or Mine after leaving
//	a station.
//---------------------------------------------------------------------------------
$WaitThrowTime = 2;

//---------------------------------------------------------------------------------
// If 1 then Team Spending Ignored -- Team Energy is set to $MaxTeamEnergy every
// 	$secTeamEnergy.
//---------------------------------------------------------------------------------
$TeamEnergyCheat = 0;

//---------------------------------------------------------------------------------
// MAX amount team energy can reach
//---------------------------------------------------------------------------------
$MaxTeamEnergy = 700000;

//---------------------------------------------------------------------------------
//  Time player has to put flag in flagstand before it gets returned to its last
//  location. 
//---------------------------------------------------------------------------------
$flagToStandTime = 180;	  

//---------------------------------------------------------------------------------
// Amount to inc team energy every ($secTeamEnergy) seconds
//---------------------------------------------------------------------------------
$incTeamEnergy = 700;

//---------------------------------------------------------------------------------
// (Rate is sec's) Set how often TeamEnergy is incremented
//---------------------------------------------------------------------------------
$secTeamEnergy = 30;

//---------------------------------------------------------------------------------
// (Rate is sec's) Items respwan
//---------------------------------------------------------------------------------
$ItemRespawnTime = 30;

//---------------------------------------------------------------------------------
//Amount of Energy remote stations start out with
//---------------------------------------------------------------------------------
$RemoteAmmoEnergy = 2500; 
$RemoteInvEnergy = 3000;

//---------------------------------------------------------------------------------
// TEAM ENERGY -  Warn team when teammate has spent x amount - Warn team that 
//				  energy level is low when it reaches x amount 
//---------------------------------------------------------------------------------
$TeammateSpending = -4000;  //Set = to 0 if don't want the warning message
$WarnEnergyLow = 4000;	    //Set = to 0 if don't want the warning message

//---------------------------------------------------------------------------------
// Amount added to TeamEnergy when a player joins a team
//---------------------------------------------------------------------------------
$InitialPlayerEnergy = 5000;

//---------------------------------------------------------------------------------
// REMOTE TURRET
//---------------------------------------------------------------------------------
$MaxNumTurretsInBox = 2;     //Number of remote turrets allowed in the area
$TurretBoxMaxLength = 50;    //Define Max Length of the area
$TurretBoxMaxWidth =  50;    //Define Max Width of the area
$TurretBoxMaxHeight = 25;    //Define Max Height of the area

$TurretBoxMinLength = 10;	  //Define Min Length from another turret
$TurretBoxMinWidth =  10;	  //Define Min Width from another turret
$TurretBoxMinHeight = 10;    //Define Min Height from another turret

//---------------------------------------------------------------------------------
//	Object Types	
//---------------------------------------------------------------------------------
$SimTerrainObjectType    = 1 << 1;
$SimInteriorObjectType   = 1 << 2;
$SimPlayerObjectType     = 1 << 7;

$MineObjectType		    = 1 << 26;	
$MoveableObjectType	    = 1 << 22;
$VehicleObjectType	 	 = 1 << 29;  
$StaticObjectType			 = 1 << 23;	   
$ItemObjectType			 = 1 << 21;	  

//---------------------------------------------------------------------------------
// CHEATS
//---------------------------------------------------------------------------------
$ServerCheats = 0;
$TestCheats = 0;

//---------------------------------------------------------------------------------
//Respawn automatically after X sec's -  If 0..no respawn
//---------------------------------------------------------------------------------
$AutoRespawn = 0;

//---------------------------------------------------------------------------------
// Player death messages - %1 = killer's name, %2 = victim's name
//       %3 = killer's gender pronoun (his/her), %4 = victim's gender pronoun
//---------------------------------------------------------------------------------
$deathMsg[$LandingDamageType, 0] = "%1 falls to %2 death.";
 $deathMsg[$LandingDamageType, 1] = "%1 go splat.";
 $deathMsg[$LandingDamageType, 2] = "%1 makes quite an impact on the ground.";
 $deathMsg[$LandingDamageType, 3] = "%1 fall down go boom.";
 $deathMsg[$ImpactDamageType, 0] = "%1 makes quite an impact on %2.";
 $deathMsg[$ImpactDamageType, 1] = "%2 becomes the victim of a fly-by from %1.";
 $deathMsg[$ImpactDamageType, 2] = "%2 leaves a nasty dent in %1's fender.";
 $deathMsg[$ImpactDamageType, 3] = "%1 says, 'Hey %2, you scratched my paint job!'";
 $deathMsg[$BulletDamageType, 0] = "%2 got regulated by %1.";
 $deathMsg[$BulletDamageType, 1] = "%1 gives %2 an overdose of lead.";
 $deathMsg[$BulletDamageType, 2] = "%1 gave %2 a hole in %4 head that wasn't there before.";
 $deathMsg[$BulletDamageType, 3] = "%1 guns down %2.";
 $deathMsg[$EnergyDamageType, 0] = "%2 dies of poison.";
 $deathMsg[$EnergyDamageType, 1] = "%2 gets a lethal injection.";
 $deathMsg[$EnergyDamageType, 2] = "%2  is injected with a deadly virus.";
 $deathMsg[$EnergyDamageType, 3] = "%2 could not find the vaccine in time.";

 $deathMsg[$SuperEnergyDamageType, 0] = "%2 dies of poison.";
 $deathMsg[$SuperEnergyDamageType, 1] = "%2 gets a lethal injection.";
 $deathMsg[$SuperEnergyDamageType, 2] = "%2 falls victim to a deadly virus.";
 $deathMsg[$SuperEnergyDamageType, 3] = "%2 could not find the vaccine in time.";

$deathMsg[$ShotgunDamageType, 0] = "%2 caught %1's shotgun blast.";
$deathMsg[$ShotgunDamageType, 1] = "%1 filled %2 full of shotgun shells.";
$deathMsg[$ShotgunDamageType, 2] = "%2 went down after %1's vicious shotgun assault.";
$deathMsg[$ShotgunDamageType, 3] = "%2 was caught by %1 and his smoking barrell.";
$deathMsg[$MExplosionDamageType, 0] = "%2 got blown to bits from %1's rocket turret.";
$deathMsg[$MExplosionDamageType, 1] = "%1's rocket turret blew the hell out of %2.";
$deathMsg[$MExplosionDamageType, 2] = "%2 swallows a rocket from %1's turret.";
$deathMsg[$MExplosionDamageType, 3] = "%2 gets friendly with a rocket from %1's turret.";

$deathMsg[$AAExplosionDamageType, 0] = "%2 got blown to bits from %1's AA turret.";
$deathMsg[$AAExplosionDamageType, 1] = "%1's AA turret blew the hell out of %2.";
$deathMsg[$AAExplosionDamageType, 2] = "%1's AA turret explodes %2 into oblivion.";
$deathMsg[$AAExplosionDamageType, 3] = "%2 explodes courtesy of %1's AA turret.";

$deathMsg[$TeleFragDamageType, 0] = "%2 was reduced to %4 component atoms."; 
$deathMsg[$TeleFragDamageType, 1] = "%2 gets vaporized by a teleporter."; 
$deathMsg[$TeleFragDamageType, 2] = "%2 falls victim to a teleporter malfunction."; 
$deathMsg[$TeleFragDamageType, 3] = "%2 gets telefragged."; 

$deathMsg[38, 0] = "%2 gets struck by lightning."; 
$deathMsg[38, 1] = "%2 gets charred by a lightning bolt."; 
$deathMsg[38, 2] = "A lightning bolt blasts %2."; 
$deathMsg[38, 3] = "Lightning strikes %2."; 

$deathMsg[$LaserEDamageType, 0] = "%2 gets a laser blast to the brain.";
$deathMsg[$LaserEDamageType, 1] = "%2 gets sliced in half by a laser tagged.";
$deathMsg[$LaserEDamageType, 2] = "%2 gets a laser enema.";
$deathMsg[$LaserEDamageType, 3] = "%2 is assasinated by a laser turret.";
$deathMsg[$ElectricityEDamageType, 0] = "%2 gets blasted by %1's sector turret.";
$deathMsg[$ElectricityEDamageType, 1] = "%1's sector turret takes down %2.";
$deathMsg[$ElectricityEDamageType, 2] = "%1's sector turret gives %2 110 volts.";
$deathMsg[$ElectricityEDamageType, 3] = "%2 gets %4 teeth kicked in by %1's sector turret.";
$deathMsg[$ElectricityTEDamageType, 0] = "%2 gets a shocking experience from %1's ELF turret.";
$deathMsg[$ElectricityTEDamageType, 1] = "%1's ELF turret fried %2's brains.";
$deathMsg[$ElectricityTEDamageType, 2] = "%1's ELF turret gives %2 110 volts.";
$deathMsg[$ElectricityTEDamageType, 3] = "%2 brains got turned to mush by %1's ELF turret.";
$deathMsg[$BurnEDamageType, 0] = "%2 bursts into flames courtesy of %1's turret.";
$deathMsg[$BurnEDamageType, 1] = "%1's flame turret asks %2 'Hey need a light?'.";
$deathMsg[$BurnEDamageType, 2] = "%2 gets reduced to ash by %1's flame turret.";
$deathMsg[$BurnEDamageType, 3] = "%2 gets burnt to a crisp by %1's flame turret.";
$deathMsg[$PDamageType, 0] = "%2 gets blasted by %1's plasma turret.";
$deathMsg[$PDamageType, 1] = "%2 gets killed by %1's plasma turret.";
$deathMsg[$PDamageType, 2] = "%1's plasma turret takes out %2.";
$deathMsg[$PDamageType, 3] = "%2 gets shot down by %1's plasma turret.";
 $deathMsg[$PlasmaDamageType, 0] = "%2 bursts into flames courtesy of %1.";
 $deathMsg[$PlasmaDamageType, 1] = "%1 lites %2 up.";
 $deathMsg[$PlasmaDamageType, 2] = "%1 asks %2, 'Need a light?'";
 $deathMsg[$PlasmaDamageType, 3] = "%2 gets bLaZeD compliments of %1.";
 $deathMsg[$BioDamageType, 0] = "%2 becomes a BioHaZarD because of %1.";
 $deathMsg[$BioDamageType, 1] = "%1 unleashes biohazardous materials on %2.";
 $deathMsg[$BioDamageType, 2] = "%2 plays catch with %1's BioHaZarD weapon.";
 $deathMsg[$BioDamageType, 3] = "%2 becomes intoxicated by %1.";
 $deathMsg[$ExplosionDamageType, 0] = "%2 gets blown by %1.";
 $deathMsg[$ExplosionDamageType, 1] = "%2 goes boom because of %1.";
 $deathMsg[$ExplosionDamageType, 2] = "%2 'Sploded' cuz of %1.";
 $deathMsg[$ExplosionDamageType, 3] = "%1 blows %2's mind.";
 $deathMsg[$ShrapnelDamageType, 0] = "%1 blows %2 up real real good.";
 $deathMsg[$ShrapnelDamageType, 1] = "%2 gets a taste of %1's explosive temper.";
 $deathMsg[$ShrapnelDamageType, 2] = "%1 gives %2 a fatal concussion.";
 $deathMsg[$ShrapnelDamageType, 3] = "%2 never saw it coming from %1.";
 $deathMsg[$LaserDamageType, 0] = "%1 adds %2 to %3 list of fallen targets.";
 $deathMsg[$LaserDamageType, 1] = "%1 fells %2 with a sniper shot.";
 $deathMsg[$LaserDamageType, 2] = "%2 was assassinated by %1.";
 $deathMsg[$LaserDamageType, 3] = "%2 stayed in %1's crosshairs for too long.";
 $deathMsg[$RepDamageType, 0] = "%1 teaches %2 to bow to the repairman.";
 $deathMsg[$RepDamageType, 1] = "%2 catches %1's repair bomb.";
 $deathMsg[$RepDamageType, 2] = "%2 was disabled by %1.";
 $deathMsg[$RepDamageType, 3] = "%2 stayed in %1's explosion radius.";
 $deathMsg[$tranqDamageType, 0] = "%1 tranquilizes %2.";
 $deathMsg[$tranqDamageType, 1] = "%1 calms %2 down.";
 $deathMsg[$tranqDamageType, 2] = "%2 injected by %1.";
 $deathMsg[$tranqDamageType, 3] = "%2 goes night night because of %1's tranquilizer.";
 $deathMsg[$MortarDamageType, 0] = "%1 makes %2 go boom.";
 $deathMsg[$MortarDamageType, 1] = "%1 blows the hell out of %2.";
 $deathMsg[$MortarDamageType, 2] = "%1 placed the explosives where %2 could find them.";
 $deathMsg[$MortarDamageType, 3] = "%1's mortar takes out %2.";
 $deathMsg[$BlasterDamageType, 0] = "%2 gets capped by %1.";
 $deathMsg[$BlasterDamageType, 1] = "%2 succumbs to %1's rain of blaster fire.";
 $deathMsg[$BlasterDamageType, 2] = "%1's punks %2 ghetto style.";
 $deathMsg[$BlasterDamageType, 3] = "%2 meets %1's master blaster.";
 $deathMsg[$ElectricityDamageType, 0] = "%2 gets 110 volts from %1.";
 $deathMsg[$ElectricityDamageType, 1] = "%1 gives %2 a jolt.";
 $deathMsg[$ElectricityDamageType, 2] = "%2 gets a real shock out of meeting %1.";
 $deathMsg[$ElectricityDamageType, 3] = "%1 fried %2's circuits.";
 $deathMsg[$EMPDamageType, 0] = "%2 was killed by %1's EMP Blast.";
 $deathMsg[$EMPDamageType, 1] = "%2 got a shock from %1's EMP Blast.";
 $deathMsg[$EMPDamageType, 2] = "%2 was killed by %1's EMP blast radius.";
 $deathMsg[$EMPDamageType, 3] = "%2 was killed by %1's EMP shock.";
 $deathMsg[$CrushDamageType, 0] = "%2 didn't stay away from the moving parts.";
 $deathMsg[$CrushDamageType, 1] = "%2 is now a pancake.";
 $deathMsg[$CrushDamageType, 2] = "%2 gets smushed flat.";
 $deathMsg[$CrushDamageType, 3] = "%2 gets caught in the machinery.";
 $deathMsg[$DebrisDamageType, 0] = "%2 is a victim among the wreckage.";
 $deathMsg[$DebrisDamageType, 1] = "%2 is killed by debris.";
 $deathMsg[$DebrisDamageType, 2] = "%2 becomes a victim of collateral damage.";
 $deathMsg[$DebrisDamageType, 3] = "%2 got too close to the exploding stuff.";
 $deathMsg[$DDamageType, 0] = "%2 is a victim among the wreckage.";
 $deathMsg[$DDamageType, 1] = "%2 is killed by debris.";
 $deathMsg[$DDamageType, 2] = "%2 becomes a victim of collateral damage.";
 $deathMsg[$DDamageType, 3] = "%2 got too close to the exploding stuff.";
$deathMsg[$MissileRamDamageType, 0] = "%1 drives a missile right up %2's ass."; 
$deathMsg[$MissileRamDamageType, 1] = "%2 swallows a missile piloted by %1."; 
$deathMsg[$MissileRamDamageType, 2] = "%2 gets hit with %1's guided missile."; 
$deathMsg[$MissileRamDamageType, 3] = "%1 flies a missile down %2's throat.";
 $deathMsg[$MissileDamageType, 0] = "%2 gets blown apart.";
 $deathMsg[$MissileDamageType, 1] = "%2 gets shot down.";
 $deathMsg[$MissileDamageType, 2] = "%2 gets real friendly with a rocket.";
 $deathMsg[$MissileDamageType, 3] = "%2 feels the burn from a warhead.";
$deathMsg[$RailDamageType, 0] = "%2 took %1's rail for later use.";
$deathMsg[$RailDamageType, 1] = "%1 railed %2.";
$deathMsg[$RailDamageType, 2] = "%1 blew a hole right through %2.";
$deathMsg[$RailDamageType, 3] = "%2 was killed by %1's rail.";
$deathMsg[$BurnDamageType, 0] = "%2 gets charbroiled.";
$deathMsg[$BurnDamageType, 1] = "%2 gets burnt to a crisp.";
$deathMsg[$BurnDamageType, 2] = "%2 gets lit up.";
$deathMsg[$BurnDamageType, 3] = "%2 was reduced to ash.";
$deathMsg[$MineDamageType, 0] = "%1 blows %2 up real good with %3 mine.";
$deathMsg[$MineDamageType, 1] = "%1 gives %2 a piece of %3 mine.";
$deathMsg[$MineDamageType, 2] = "%1 reminds %2 a mine is a terrible thing to waste.";
$deathMsg[$MineDamageType, 3] = "%2 is blown to bits by %1's mine.";
$deathMsg[$OMineDamageType, 0] = "%2 gets blown up real good with a mine.";
$deathMsg[$OMineDamageType, 1] = "%2 figured out how mines work.";
$deathMsg[$OMineDamageType, 2] = "%2 stepped on a mine.";
$deathMsg[$OMineDamageType, 3] = "%2 is blown to bits by a mine.";
 $deathMsg[$FlashDamageType, 0] = "%1's EMP turret blows %2 away.";
 $deathMsg[$FlashDamageType, 1] = "%2 gets blown away by %1's EMP turret.";
 $deathMsg[$FlashDamageType, 2] = "%1's turret gives %2 a fatal EMP.";
 $deathMsg[$FlashDamageType, 3] = "%2 succumbs to %1's EMP turret.";
 $deathMsg[$SniperDamageType, 0] = "%1 adds %2 to %3 list of fallen targets.";
 $deathMsg[$SniperDamageType, 1] = "%1 assasinates %2 with a sniper shot.";
 $deathMsg[$SniperDamageType, 2] = "%2 was assassinated by %1.";
 $deathMsg[$SniperDamageType, 3] = "%2 stayed in %1's crosshairs for too long.";
$deathMsg[$TracDamageType, 0] = "%2 gets ripped apart.";
 $deathMsg[$TracDamageType, 1] = "%2 gets torn into pieces.";
 $deathMsg[$TracDamageType, 2] = "%2 gets pulled apart.";
 $deathMsg[$TracDamageType, 3] = "%2 gets pulled apart.";

$deathMsg[-5,0] = "%2 takes %4 own life.";
$deathMsg[-5,1] = "%2 leaps off the edge.";
$deathMsg[-5,2] = "%2 follows %4 friends off the bridge.";
$deathMsg[-5,3] = "%2 cuts the rope.";

$deathMsg[-2,0] = "%1 takes %2 own life.";
$deathMsg[-2,1] = "%1 pulls the trigger.";
$deathMsg[-2,2] = "%1 kills %2 own soopid self.";
$deathMsg[-2,3] = "%1 decided to see what the end of the gunbarrel tasted like.";

$numDeathMsgs = 4;


//---------------------------------------------------------------------------------

$spawnBuyList[0] = MedicArmor;
$spawnBuyList[1] = Replauncher;
$spawnBuyList[2] = Chaingun;
$spawnBuyList[3] = RepairPack;
$spawnBuyList[4] = RepairKit;
$spawnBuyList[5] = "";

function remotePlayMode(%clientId)
{
   if(!%clientId.guiLock)
   {
      remoteSCOM(%clientId, -1);
      Client::setGuiMode(%clientId, $GuiModePlay);
   }
}

function remoteCommandMode(%clientId)
{
   // can't switch to command mode while a server menu is up
   if(!%clientId.guiLock)
   {
      remoteSCOM(%clientId, -1);  // force the bandwidth to be full command
		if(%clientId.observerMode != "pregame")
		   checkControlUnmount(%clientId);
		Client::setGuiMode(%clientId, $GuiModeCommand);
   }
}

function remoteInventoryMode(%clientId)
{
   if(!%clientId.guiLock && !Observer::isObserver(%clientId))
   {
      remoteSCOM(%clientId, -1);
      Client::setGuiMode(%clientId, $GuiModeInventory);
   }
}

function remoteObjectivesMode(%clientId)
{
   if(!%clientId.guiLock)
   {
      remoteSCOM(%clientId, -1);
      Client::setGuiMode(%clientId, $GuiModeObjectives);
   }
}

function remoteScoresOn(%clientId)
{
   if(!%clientId.menuMode)
      Game::menuRequest(%clientId);
}

function remoteScoresOff(%clientId)
{
   Client::cancelMenu(%clientId);
}

function remoteToggleCommandMode(%clientId)
{
	if (Client::getGuiMode(%clientId) != $GuiModeCommand)
		remoteCommandMode(%clientId);
	else
		remotePlayMode(%clientId);
}

function remoteToggleInventoryMode(%clientId)
{
	if (Client::getGuiMode(%clientId) != $GuiModeInventory)
		remoteInventoryMode(%clientId);
	else
		remotePlayMode(%clientId);
}

function remoteToggleObjectivesMode(%clientId)
{
	if (Client::getGuiMode(%clientId) != $GuiModeObjectives)
		remoteObjectivesMode(%clientId);
	else
		remotePlayMode(%clientId);
}

function Time::getMinutes(%simTime)
{
   return floor(%simTime / 60);
}

function Time::getSeconds(%simTime)
{
   return %simTime % 60;
}

function Game::pickRandomSpawn(%team)
{
   %group = nameToID("MissionGroup/Teams/team" @ %team @ "/DropPoints/Random");
   %count = Group::objectCount(%group);
   if(!%count)
      return -1;
  	%spawnIdx = floor(getRandom() * (%count - 0.1));
  	%value = %count;
	for(%i = %spawnIdx; %i < %value; %i++) {
		%set = newObject("set",SimSet);
		%obj = Group::getObject(%group, %i);
		if(containerBoxFillSet(%set,$SimPlayerObjectType|$VehicleObjectType,GameBase::getPosition(%obj),2,2,4,0) == 0) {
			deleteObject(%set);
			return %obj;		
		}
		if(%i == %count - 1) {
			%i = -1;
			%value = %spawnIdx;
		}
		deleteObject(%set);
	}
   return false;
}

function Game::pickStartSpawn(%team)
{
   %group = nameToID("MissionGroup\\Teams\\team" @ %team @ "\\DropPoints\\Start");
   %count = Group::objectCount(%group);
   if(!%count)
      return -1;

   %spawnIdx = $lastTeamSpawn[%team] + 1;
   if(%spawnIdx >= %count)
      %spawnIdx = 0;
   $lastTeamSpawn[%team] = %spawnIdx;
   return Group::getObject(%group, %spawnIdx);
}

function Game::pickTeamSpawn(%team, %respawn)
{
   if(%respawn)
      return Game::pickRandomSpawn(%team);
   else
   {
      %spawn = Game::pickStartSpawn(%team);
      if(%spawn == -1)
         return Game::pickRandomSpawn(%team);
      return %spawn;
   }
}

function Game::pickObserverSpawn(%client)
{
   %group = nameToID("MissionGroup\\ObserverDropPoints");
   %count = Group::objectCount(%group);
   if(%group == -1 || !%count)
      %group = nameToID("MissionGroup\\Teams\\team" @ Client::getTeam(%client) @ "\\DropPoints\\Random");
   %count = Group::objectCount(%group);
   if(%group == -1 || !%count)
      %group = nameToID("MissionGroup\\Teams\\team0\\DropPoints\\Random");
   %count = Group::objectCount(%group);
   if(%group == -1 || !%count)
      return -1;
   %spawnIdx = %client.lastObserverSpawn + 1;
   if(%spawnIdx >= %count)
      %spawnIdx = 0;
   %client.lastObserverSpawn = %spawnIdx;
	return Group::getObject(%group, %spawnIdx);
}

function UpdateClientTimes(%time)
{
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
      remoteEval(%cl, "setTime", -%time);
}

function Game::notifyMatchStart(%time)
{
   messageAll(0, "Match starts in " @ %time @ " seconds.");
   UpdateClientTimes(%time);
}

function Game::startMatch()
{
   $matchStarted = true;
   $missionStartTime = getSimTime();
   messageAll(0, "Match started.");
	Game::resetScores();	

   %numTeams = getNumTeams();
   for(%i = 0; %i < %numTeams; %i = %i + 1) {
		if($TeamEnergy[%i] != "Infinite")
			schedule("replenishTeamEnergy(" @ %i @ ");", $secTeamEnergy);
	}

   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
		if(%cl.observerMode == "pregame")
      {
         %cl.observerMode = "";
         Client::setControlObject(%cl, Client::getOwnedObject(%cl));
      }
   	Game::refreshClientScore(%cl);
	}
   Game::checkTimeLimit();
}

function Game::pickPlayerSpawn(%clientId, %respawn)
{
   return Game::pickTeamSpawn(Client::getTeam(%clientId), %respawn);
}

function Game::playerSpawn(%clientId, %respawn)
{
   if(!$ghosting)
      return false;

	Client::clearItemShopping(%clientId);
   %spawnMarker = Game::pickPlayerSpawn(%clientId, %respawn);
   if(!%respawn)
   {
      // initial drop
      Centerprint(%clientId, "<jc><f0> Blur of Insanity Mod By SipHoN :   <f1> www.haLoMaTriX.com   \n<f0> Mission :  <f1> " @ $missionName @ " \n<f0> Choose a Class... <f1> And whip some ass....", 15);
   }
	if(%spawnMarker) {   
		%clientId.guiLock = "";
	 	%clientId.dead = "";
	   if(%spawnMarker == -1)
	   {
	      %spawnPos = "0 0 300";
	      %spawnRot = "0 0 0";
	   }
	   else
	   {
	      %spawnPos = GameBase::getPosition(%spawnMarker);
	      %spawnRot = GameBase::getRotation(%spawnMarker);
	   }

		if(!String::ICompare(Client::getGender(%clientId), "Male"))
	      %armor = "larmor";
	   else
	      %armor = "lfemale";

	   %pl = spawnPlayer(%armor, %spawnPos, %spawnRot);
	   echo("SPAWN: cl:" @ %clientId @ " pl:" @ %pl @ " marker:" @ %spawnMarker @ " armor:" @ %armor);
	   if(%pl != -1)
	   {
	      GameBase::setTeam(%pl, Client::getTeam(%clientId));
	      Client::setOwnedObject(%clientId, %pl);
	      Game::playerSpawned(%pl, %clientId, %armor, %respawn);
	      
	      if($matchStarted)
	         Client::setControlObject(%clientId, %pl);
	      else
	      {
	         %clientId.observerMode = "pregame";
	         Client::setControlObject(%clientId, Client::getObserverCamera(%clientId));
	         Observer::setOrbitObject(%clientId, %pl, 3, 3, 3);
	      }
	   }
      return true;
	}
	else {
		Client::sendMessage(%clientId,0,"Sorry No Respawn Positions Are Empty - Try again later ");
      return false;
	}
}

function Game::playerSpawned(%pl, %clientId, %armor)
{						  
	%clientId.spawn= 1;
	%max = getNumItems();
   for(%i = 0; (%item = $spawnBuyList[%i]) != ""; %i++)
   {
		buyItem(%clientId,%item);	
		if(%item.className == Weapon) 
			%clientId.spawnWeapon = %item;
	}
	%clientId.spawn= "";
	if(%clientId.spawnWeapon != "") {
		Player::useItem(%pl,%clientId.spawnWeapon);	
   	%clientId.spawnWeapon="";
	}
} 

function Game::autoRespawn(%client)
{
	if(%client.dead == 1)
		Game::playerSpawn(%client, "true");
}

function onServerGhostAlwaysDone()
{
}

function Game::initialMissionDrop(%clientId)
{
	Client::setGuiMode(%clientId, $GuiModePlay);

   if($Server::TourneyMode)
      GameBase::setTeam(%clientId, -1);
   else
   {
      if(%clientId.observerMode == "observerFly" || %clientId.observerMode == "observerOrbit")
      {
	      %clientId.observerMode = "observerOrbit";
	      %clientId.guiLock = "";
         Observer::jump(%clientId);
         return;
      }
      %numTeams = getNumTeams();
      %curTeam = Client::getTeam(%clientId);

      if(%curTeam >= %numTeams || (%curTeam == -1 && (%numTeams < 2 || $Server::AutoAssignTeams)) )
         Game::assignClientTeam(%clientId);
   }    
	Client::setControlObject(%clientId, Client::getObserverCamera(%clientId));
   %camSpawn = Game::pickObserverSpawn(%clientId);
   Observer::setFlyMode(%clientId, GameBase::getPosition(%camSpawn), 
	   GameBase::getRotation(%camSpawn), true, true);

   if(Client::getTeam(%clientId) == -1)
   {
      %clientId.observerMode = "pickingTeam";

      if($Server::TourneyMode && ($matchStarted || $matchStarting))
      {
         %clientId.observerMode = "observerFly";
         return;
      }
      else if($Server::TourneyMode)
      {
         if($Server::TeamDamageScale)
            %td = "ENABLED";
         else
            %td = "DISABLED";
         bottomprint(%clientId, "<jc><f1>Server is running in Competition Mode\nPick a team.\nTeam damage is " @ %td, 0);
      }
      Client::buildMenu(%clientId, "Pick a team:", "InitialPickTeam");
      Client::addMenuItem(%clientId, "0Observe", -2);
      Client::addMenuItem(%clientId, "1Automatic", -1);
      for(%i = 0; %i < getNumTeams(); %i = %i + 1)
         Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
      %clientId.justConnected = "";
   }
   else 
   {
      Client::setSkin(%clientId, $Server::teamSkin[Client::getTeam(%clientId)]);
      if(%clientId.justConnected)
      {
         centerprint(%clientId, $Server::JoinMOTD, 0);
         %clientId.observerMode = "justJoined";
         %clientId.justConnected = "";
      }
      else if(%clientId.observerMode == "justJoined")
      {
         centerprint(%clientId, "");
         %clientId.observerMode = "";
         Game::playerSpawn(%clientId, false);
      }
      else
         Game::playerSpawn(%clientId, false);
	}
	if($TeamEnergy[Client::getTeam(%clientId)] != "Infinite")
		$TeamEnergy[Client::getTeam(%clientId)] += $InitialPlayerEnergy;
	%clientId.teamEnergy = 0;
}

function processMenuInitialPickTeam(%clientId, %team)
{
   if($Server::TourneyMode && $matchStarted)
      %team = -2;

   if(%team == -2)
   {
      Observer::enterObserverMode(%clientId);
   }
   if(%team == -1)
   {
      Game::assignClientTeam(%clientId);
      %team = Client::getTeam(%clientId);
   }
   if(%team != -2)
   {
      GameBase::setTeam(%clientId, %team);
		if($TeamEnergy[%team] != "Infinite")
			$TeamEnergy[%team] += $InitialPlayerEnergy;
      %clientId.teamEnergy = 0;
      Client::setControlObject(%clientId, -1);
      Game::playerSpawn(%clientId, false);
   }
   if($Server::TourneyMode && !$CountdownStarted)
   {
      if(%team != -2)
      {
         bottomprint(%clientId, "<f1><jc>Press FIRE when ready.", 0);
         %clientId.notready = true;
         %clientId.notreadyCount = "";
      }
      else
      {
         bottomprint(%clientId, "", 0);
         %clientId.notready = "";
         %clientId.notreadyCount = "";
      }
   }
}

function Game::ForceTourneyMatchStart()
{
   %playerCount = 0;
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      if(%cl.observerMode == "pregame")
         %playerCount++;
   }
   if(%playerCount == 0)
      return;

   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      if(%cl.observerMode == "pickingTeam")   
         processMenuInitialPickTeam(%cl, -2); // throw these guys into observer
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
      {
         %cl.notready = "";
         %cl.notreadyCount = "";
         bottomprint(%cl, "", 0);
      }
   }
   Server::Countdown(30);
}

function Game::CheckTourneyMatchStart()
{
   if($CountdownStarted || $matchStarted)
      return;
   
   // loop through all the clients and see if any are still notready
   %playerCount = 0;
   %notReadyCount = 0;

   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      if(%cl.observerMode == "pickingTeam")
      {
         %notReady[%notReadyCount] = %cl;
         %notReadyCount++;
      }   
      else if(%cl.observerMode == "pregame")
      {
         if(%cl.notready)
         {
            %notReady[%notReadyCount] = %cl;
            %notReadyCount++;
         }
         else
            %playerCount++;
      }
   }
   if(%notReadyCount)
   {
      if(%notReadyCount == 1)
         MessageAll(0, Client::getName(%notReady[0]) @ " is holding things up!");
      else if(%notReadyCount < 4)
      {
         for(%i = 0; %i < %notReadyCount - 2; %i++)
            %str = Client::getName(%notReady[%i]) @ ", " @ %str;

         %str = %str @ Client::getName(%notReady[%i]) @ " and " @ Client::getName(%notReady[%i+1]) 
                     @ " are holding things up!";
         MessageAll(0, %str);
      }
      return;
   }

   if(%playerCount != 0)
   {
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
      {
         %cl.notready = "";
         %cl.notreadyCount = "";
         bottomprint(%cl, "", 0);
      }
      Server::Countdown(30);
   }
}


function Game::checkTimeLimit()
{
   // if no timeLimit set or timeLimit set to 0,
   // just reschedule the check for a minute hence
   $timeLimitReached = false;

   if(!$Server::timeLimit)
   {
      schedule("Game::checkTimeLimit();", 60);
      return;
   }
   %curTimeLeft = ($Server::timeLimit * 60) + $missionStartTime - getSimTime();
   if(%curTimeLeft <= 0 && $matchStarted)
   {
      echo("GAME: Timelimit reached.");
      $timeLimitReached = true;
      Server::nextMission();
   }
   else
   {
      schedule("Game::checkTimeLimit();", 20);
      UpdateClientTimes(%curTimeLeft);
   }
}

function Game::resetScores(%client)
{
	if(%client == "") {
	   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl)) {
	      %cl.scoreKills = 0;
   	   %cl.scoreDeaths = 0;
			%cl.ratio = 0;
      	%cl.score = 0;
		}
	}
	else {
      %client.scoreKills = 0;
  	   %client.scoreDeaths = 0;
		%client.ratio = 0;
     	%client.score = 0;
	}
}

function remoteSetArmor(%player, %armorType)
{
	if ($ServerCheats) {
		checkMax(Player::getClient(%player),%armorType);
	   Player::setArmor(%player, %armorType);
	}
	else if($TestCheats) {
	   Player::setArmor(%player, %armorType);
	}
}


function Game::onPlayerConnected(%playerId)
{
   %playerId.scoreKills = 0;
   %playerId.scoreDeaths = 0;
	%playerId.score = 0;
   %playerId.justConnected = true;
   $menuMode[%playerId] = "None";
   Game::refreshClientScore(%playerId);
}

function Game::assignClientTeam(%playerId)
{
   if($teamplay)
   {
      %name = Client::getName(%playerId);
      %numTeams = getNumTeams();
      if($teamPreset[%name] != "")
      {
         if($teamPreset[%name] < %numTeams)
         {
            GameBase::setTeam(%playerId, $teamPreset[%name]);
            echo(Client::getName(%playerId), " was preset to team ", $teamPreset[%name]);
            return;
         }            
      }
      %numPlayers = getNumClients();
      for(%i = 0; %i < %numTeams; %i = %i + 1)
         %numTeamPlayers[%i] = 0;

      for(%i = 0; %i < %numPlayers; %i = %i + 1)
      {
         %pl = getClientByIndex(%i);
         if(%pl != %playerId)
         {
            %team = Client::getTeam(%pl);
            %numTeamPlayers[%team] = %numTeamPlayers[%team] + 1;
         }
      }
      %leastPlayers = %numTeamPlayers[0];
      %leastTeam = 0;
      for(%i = 1; %i < %numTeams; %i = %i + 1)
      {
         if( (%numTeamPlayers[%i] < %leastPlayers) || 
            ( (%numTeamPlayers[%i] == %leastPlayers) && 
            ($teamScore[%i] < $teamScore[%leastTeam] ) ))
         {
            %leastTeam = %i;
            %leastPlayers = %numTeamPlayers;
         }
      }
      GameBase::setTeam(%playerId, %leastTeam);
      echo(Client::getName(%playerId), " was automatically assigned to team ", %leastTeam);
   }
   else
   {
      GameBase::setTeam(%playerId, 0);
   }
}

function Client::onKilled(%playerId, %killerId, %damageType)
{
   echo("GAME: kill " @ %killerId @ " " @ %playerId @ " " @ %damageType);
   %playerId.guiLock = true;
   Client::setGuiMode(%playerId, $GuiModePlay);
	if(!String::ICompare(Client::getGender(%playerId), "Male"))
   {
      %playerGender = "his";
   }
	else
	{
		%playerGender = "her";
	}
	%ridx = floor(getRandom() * ($numDeathMsgs - 0.01));
	%victimName = Client::getName(%playerId);


   if(!%killerId)
   {
      messageAll(0, strcat(%victimName, " dies."), $DeathMessageMask);
      %playerId.scoreDeaths++;
  }
   else if(%killerId == %playerId)
   {
	  %oopsMsg = sprintf($deathMsg[-2, %ridx], %victimName, %playerGender);
      messageAll(0, %oopsMsg, $DeathMessageMask);
      %playerId.scoreDeaths++;
      %playerId.score--;
      Game::refreshClientScore(%playerId);
   }
   else
   {
		if(!String::ICompare(Client::getGender(%killerId), "Male"))
		{
			%killerGender = "his";
		}
		else
		{
			%killerGender = "her";
		}
      if($teamplay && (Client::getTeam(%killerId) == Client::getTeam(%playerId)))
      {
		if(%damageType != $MineDamageType) 
	    	messageAll(0, strcat(Client::getName(%killerId), 
   	        " mows down ", %killerGender, " teammate, ", %victimName), $DeathMessageMask);
		else 
	         messageAll(0, strcat(Client::getName(%killerId), 
   	     	" killed ", %killerGender, " teammate, ", %victimName ," with a mine."), $DeathMessageMask);
		 %killerId.scoreDeaths++;
       %killerId.score--;
       Game::refreshClientScore(%killerId);
      }
      else
      {
	     %obitMsg = sprintf($deathMsg[%damageType, %ridx], Client::getName(%killerId),
	       %victimName, %killerGender, %playerGender);
         messageAll(0, %obitMsg, $DeathMessageMask);
         %killerId.scoreKills++;
         %playerId.scoreDeaths++;  // test play mode
         %killerId.score++;
         Game::refreshClientScore(%killerId);
         Game::refreshClientScore(%playerId);
      }
   }
   Game::clientKilled(%playerId, %killerId);
}

function Game::clientKilled(%playerId, %killerId)
{
   // do nothing
}

function Client::leaveGame(%clientId)
{
   // do nothing
}

function Player::enterMissionArea(%player)
{
   echo("Player " @ %player @ " entered arena proximity.");
}

function Player::leaveMissionArea(%player)
{
   echo("Player " @ %player @ " left arena proximity.");
}

function GameBase::getHeatFactor(%this)
{
   return 0.0;
}

